/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import oracle.sysman.oii.oiig.OiigAuthDetails;
import oracle.sysman.oii.oiig.OiigConfigAttrs;
import oracle.sysman.oii.oiig.OiigInvUploadAttrs;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigServerConfig
implements OixwIXmlWriter {
    private String m_url = null;
    private String m_name = null;
    private OiigAuthDetails m_authDets = null;
    private OiigInvUploadAttrs m_uploadAttrs = null;
    private OiigConfigAttrs m_confAttrs = null;
    public static final String CONFIG_TAG = "ServerConfig";
    private static final String URL_ATTR = "URL";
    private static final String NAME_ATTR = "Name";

    public OiigServerConfig(String url, String name) {
        this.m_url = url;
        this.m_name = name;
        this.m_confAttrs = new OiigConfigAttrs();
    }

    public OiigServerConfig(OixpIElement el) {
        this(el.getAttribValue(URL_ATTR), el.getAttribValue(NAME_ATTR));
    }

    public String getURL() {
        return this.m_url;
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setAuthDets(OiigAuthDetails authDets) {
        this.m_authDets = authDets;
    }

    public void setUploadAttrs(OiigInvUploadAttrs uploadAttrs) {
        this.m_uploadAttrs = uploadAttrs;
    }

    public void setConfAttrs(OiigConfigAttrs confAttrs) {
        this.m_confAttrs = confAttrs;
    }

    public OiigAuthDetails getAuthDets() {
        return this.m_authDets;
    }

    public OiigInvUploadAttrs getUploadAttrs() {
        return this.m_uploadAttrs;
    }

    public OiigConfigAttrs getConfAttrs() {
        return this.m_confAttrs;
    }

    public void setConfAttr(String name, String value) {
        this.m_confAttrs.setAttribute(name, value);
    }

    public String getConfAttr(String name) {
        return this.m_confAttrs.getAttribute(name);
    }

    public Enumeration getConfAttrNames() {
        return this.m_confAttrs.getAttrNames();
    }

    public String toString() {
        return "[ServerConfig : " + this.m_url + ", " + this.m_name + ", " + this.m_authDets + ", " + this.m_uploadAttrs + ", " + this.m_confAttrs + "] \n";
    }

    public boolean equals(OiigServerConfig config) {
        return this.m_url.equals(config.getURL()) && this.m_name.equals(config.getName());
    }

    public boolean equals(String url) {
        return this.m_url.equals(url);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OiigServerConfig) {
                return this.equals((OiigServerConfig)obj);
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
        }
        return super.equals(obj);
    }

    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<ServerConfig URL=\"" + OixwXmlWriterOps.encodeSplChars(this.m_url) + "\" " + NAME_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_name) + "\">");
        if (this.m_authDets != null) {
            this.m_authDets.writeXmlForm(pw);
        }
        if (this.m_uploadAttrs != null) {
            this.m_uploadAttrs.writeXmlForm(pw);
        }
        this.m_confAttrs.writeXmlForm(pw);
        pw.println("</ServerConfig>");
    }
}

