/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigConfigsXmlHandler;
import oracle.sysman.oii.oiig.OiigServerConfig;
import oracle.sysman.oii.oiig.OiigStgAreaInfo;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserCreationException;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigSourceConfigs
implements OixwIXmlWriter {
    private static final int DEF_MAX_STGS = 5;
    private static final int DEF_MAX_SVRS = 5;
    private Vector m_stgAreas = new Vector();
    private Vector m_serverConfigs = new Vector();
    private String m_persistLoc = null;
    public static final String MAIN_TAG = "SourceConfigs";
    public static final String STG_AREAS_TAG = "StagingAreas";
    public static final String SVR_CFGS_TAG = "ServerConfigs";
    public static final String LOC_UNDER_ORAINV = "oui";
    public static final String FILENAME = "srcs.lst";
    private int m_maxStgs = 5;
    private int m_maxSvrs = 5;

    public OiigSourceConfigs() {
    }

    public OiigSourceConfigs(OixpIElement el) {
        this();
    }

    public void setPersistLoc(String persistLoc) {
        this.m_persistLoc = persistLoc;
    }

    public String getPersistLoc() {
        return this.m_persistLoc;
    }

    public void setMaxStgs(int maxStgs) {
        this.m_maxStgs = maxStgs;
    }

    public int getMaxStgs() {
        return this.m_maxStgs;
    }

    public void setMaxSvrs(int maxSvrs) {
        this.m_maxSvrs = maxSvrs;
    }

    public int getMaxSvrs() {
        return this.m_maxSvrs;
    }

    public void addStgArea(OiigStgAreaInfo stgAreaInfo) {
        if (this.m_stgAreas.size() < this.m_maxStgs - 1) {
            this.m_stgAreas.addElement(stgAreaInfo);
        }
    }

    public OiigStgAreaInfo getStgArea(String url) {
        OiigStgAreaInfo stgArea = null;
        int index = -1;
        index = OiixVectorOps.vectIndexOf(this.m_stgAreas, (Object)url);
        if (index != -1) {
            stgArea = (OiigStgAreaInfo)this.m_stgAreas.elementAt(index);
        }
        return stgArea;
    }

    public void insertStgArea(OiigStgAreaInfo stgAreaInfo) {
        int index = -1;
        index = OiixVectorOps.vectIndexOf(this.m_stgAreas, (Object)stgAreaInfo.getURL());
        if (index != -1) {
            this.m_stgAreas.removeElementAt(index);
        }
        this.m_stgAreas.insertElementAt(stgAreaInfo, 0);
        int numStgs = this.m_stgAreas.size();
        for (int i = 0; i < numStgs - this.m_maxStgs; ++i) {
            this.m_stgAreas.removeElementAt(this.m_maxStgs);
        }
    }

    public Vector getStgAreaURLs() {
        Vector<String> stgURLs = new Vector<String>();
        int numStgAreas = this.m_stgAreas.size();
        for (int i = 0; i < numStgAreas; ++i) {
            OiigStgAreaInfo stgArea = (OiigStgAreaInfo)this.m_stgAreas.elementAt(i);
            stgURLs.addElement(stgArea.getURL());
        }
        return stgURLs;
    }

    public Vector getStgAreas() {
        return this.m_stgAreas;
    }

    public void addSvrConfig(OiigServerConfig svrConfig) {
        if (this.m_serverConfigs.size() < this.m_maxSvrs - 1) {
            this.m_serverConfigs.addElement(svrConfig);
        }
    }

    public OiigServerConfig getSvrConfig(String url) {
        OiigServerConfig svrCfg = null;
        int index = -1;
        index = OiixVectorOps.vectIndexOf(this.m_serverConfigs, (Object)url);
        if (index != -1) {
            svrCfg = (OiigServerConfig)this.m_serverConfigs.elementAt(index);
        }
        return svrCfg;
    }

    public void insertSvrConfig(OiigServerConfig svrConfig) {
        int index = -1;
        index = OiixVectorOps.vectIndexOf(this.m_serverConfigs, (Object)svrConfig.getURL());
        if (index != -1) {
            this.m_serverConfigs.removeElementAt(index);
        }
        this.m_serverConfigs.insertElementAt(svrConfig, 0);
        int numSvrs = this.m_serverConfigs.size();
        for (int i = 0; i < numSvrs - this.m_maxSvrs; ++i) {
            this.m_serverConfigs.removeElementAt(this.m_maxSvrs);
        }
    }

    public void removeSvrConfig(OiigServerConfig svrConfig) {
        this.m_serverConfigs.removeElement(svrConfig);
    }

    public Vector getPubSvrURLs() {
        Vector<String> svrURLs = new Vector<String>();
        int numSvrCfgs = this.m_serverConfigs.size();
        for (int i = 0; i < numSvrCfgs; ++i) {
            OiigServerConfig svrCfg = (OiigServerConfig)this.m_serverConfigs.elementAt(i);
            svrURLs.addElement(svrCfg.getURL());
        }
        return svrURLs;
    }

    public Vector getSvrConfigs() {
        return this.m_serverConfigs;
    }

    public void clearLists() {
        this.m_serverConfigs.removeAllElements();
        this.m_stgAreas.removeAllElements();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SourceConfigs :: \n");
        sbuf.append("Staging Areas :: \n");
        sbuf.append(OiixVectorOps.objToString(this.m_stgAreas)).append("\n");
        sbuf.append("Server Configs :: \n");
        sbuf.append(OiixVectorOps.objToString(this.m_serverConfigs)).append("\n");
        return sbuf.toString();
    }

    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println(OixsXMLOps.createXMLDirective(true));
        pw.println(OixsXMLOps.getStandardHeader());
        pw.println("<SourceConfigs>");
        pw.println("<StagingAreas>");
        OixwXmlWriterOps.writeXmlForm(this.m_stgAreas, pw);
        pw.println("</StagingAreas>");
        pw.println("<ServerConfigs>");
        OixwXmlWriterOps.writeXmlForm(this.m_serverConfigs, pw);
        pw.println("</ServerConfigs>");
        pw.println("</SourceConfigs>");
    }

    public String calcFileLoc(String invDir) {
        String stdPath = OiixPathOps.getStandardForm(invDir);
        stdPath = OiixPathOps.concatPath(stdPath, "oui/srcs.lst");
        return OiixPathOps.getNativeForm(stdPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadFromFile() throws IOException {
        FileInputStream fis = null;
        try {
            try {
                OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
                fis = new FileInputStream(this.m_persistLoc);
                parser.setInputStream(fis);
                parser.setHandler(new OiigConfigsXmlHandler(this));
                this.clearLists();
                parser.readXML();
            }
            catch (OixpXmlParserCreationException xpce) {
                xpce.printStackTrace();
                throw new IOException(xpce.getMessage());
            }
            Object var4_4 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveToFile() throws IOException {
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            File perFile = new File(this.m_persistLoc);
            File parDir = new File(perFile.getParent());
            if (!parDir.exists()) {
                OiixFileOps.mkdirs(parDir);
            }
            fos = new FileOutputStream(this.m_persistLoc);
            pw = new PrintWriter(fos, true);
            this.writeXmlForm(pw);
            Object var6_5 = null;
            if (pw != null) {
                pw.close();
            }
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (pw != null) {
                pw.close();
            }
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        fos.close();
    }
}

