/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiigXmlOps {
    public static int[] parseIntArrFromString(String str) {
        Vector<String> els = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(str);
        while (stok.hasMoreTokens()) {
            els.addElement(stok.nextToken());
        }
        int numEls = els.size();
        int[] retArr = new int[numEls];
        for (int i = 0; i < numEls; ++i) {
            String el = (String)els.elementAt(i);
            retArr[i] = Integer.parseInt(el);
        }
        return retArr;
    }

    public static long[] parseLongArrFromString(String str) {
        Vector<String> els = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(str);
        while (stok.hasMoreTokens()) {
            els.addElement(stok.nextToken());
        }
        int numEls = els.size();
        long[] retArr = new long[numEls];
        for (int i = 0; i < numEls; ++i) {
            String el = (String)els.elementAt(i);
            retArr[i] = Long.parseLong(el);
        }
        return retArr;
    }

    public static Vector parseIntVectFromString(String str) {
        return OiixVectorOps.intArr2Vect(OiigXmlOps.parseIntArrFromString(str));
    }

    public static Vector parseLongVectFromString(String str) {
        return OiixVectorOps.arrayToVect(OiigXmlOps.parseLongArrFromString(str));
    }

    public static String stringWithNumArr(Object numArr) {
        StringBuffer sbuf = new StringBuffer();
        int numNumbers = 0;
        if (numArr != null && numArr.getClass().isArray()) {
            numNumbers = Array.getLength(numArr);
        }
        for (int i = 0; i < numNumbers; ++i) {
            sbuf.append(Array.get(numArr, i)).append(' ');
        }
        return sbuf.toString();
    }

    public static String stringWithNumVect(Vector numVect) {
        StringBuffer sbuf = new StringBuffer();
        int numNumbers = numVect != null ? numVect.size() : 0;
        for (int i = 0; i < numNumbers; ++i) {
            sbuf.append(numVect.elementAt(i)).append(' ');
        }
        return sbuf.toString();
    }
}

