/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiiiApplyUpdates {
    public static String fs = File.separator;
    public static String PATCH_BASE_FILE = "pbfile.txt";
    private OiicPullSession m_Session;
    private static final String OPATCH_DIR = "OPatch";

    public OiiiApplyUpdates(OiicISession session) {
        this.m_Session = (OiicPullSession)session;
    }

    public void storeLocationInHashMap(String Loc, HashMap bid_location) {
        File dir;
        if (Loc != null && (dir = new File(Loc)).isDirectory() && !dir.getName().startsWith(".ade_path")) {
            String[] fileList = dir.list();
            String fileName = null;
            for (int i = 0; i < fileList.length; ++i) {
                fileName = fileList[i];
                String filePath = dir.getAbsolutePath() + fs + fileName;
                File f = new File(filePath);
                if (!f.isDirectory() || f.getName().startsWith(".ade_path")) continue;
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".ade_path");
                    }
                };
                String[] fullPath = f.list(filter);
                int numberOfFilesAndDirs = 0;
                if (fullPath != null) {
                    numberOfFilesAndDirs = fullPath.length;
                }
                ArrayList<String> locationList = new ArrayList<String>();
                for (int k = 0; k < numberOfFilesAndDirs; ++k) {
                    String val = f.getAbsolutePath() + fs + fullPath[k];
                    if (!new File(val).isDirectory()) continue;
                    locationList.add(val);
                }
                if (!bid_location.containsKey(fileName)) continue;
                bid_location.put(fileName, locationList);
            }
        }
    }

    public static String getLatestUpdatesLoc(String dest, String type) {
        String destDir = "";
        String LATEST_UPDATES = "LatestUpdates";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, type);
        destDir = dest != null && dest.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(dest, concatPath);
        return destDir;
    }

    public Object getSessionValue(String varName) {
        if (this.m_Session != null) {
            return this.m_Session.getSessionVarValue(varName);
        }
        return null;
    }

    public boolean applyOneOffs(String ohome, ArrayList bid) {
        return this.applyOneOffs("", "", ohome, bid);
    }

    public boolean applyOneOffs(String ohome, ArrayList bid, String[] args) {
        return this.applyOneOffs("", "", ohome, bid, args);
    }

    public boolean applyOneOffs(String CPULoc, String OneOffLoc, String ohome, ArrayList bid) {
        return this.applyOneOffs(CPULoc, OneOffLoc, ohome, bid, null);
    }

    public boolean applyOneOffs(String CPULoc, String OneOffLoc, String ohome, ArrayList bid, String[] args) {
        String defOPatchLoc = ohome + fs + OPATCH_DIR;
        return this.applyOneOffs(CPULoc, OneOffLoc, ohome, bid, args, defOPatchLoc);
    }

    public boolean applyOneOffs(String CPULoc, String OneOffLoc, String ohome, ArrayList bid, String[] args, String OPatchLoc) {
        OiiolTextLogger.setEnabled(true);
        HashMap bid_location = new HashMap();
        if (bid == null) {
            return false;
        }
        CPULoc = OiiiApplyUpdates.getLatestUpdatesLoc(CPULoc, "CPUs");
        OneOffLoc = OiiiApplyUpdates.getLatestUpdatesLoc(OneOffLoc, "OneOffs");
        ArrayList bids = (ArrayList)bid.clone();
        for (int i = 0; i < bids.size(); ++i) {
            OiiiPatchMetadata pm = (OiiiPatchMetadata)bids.get(i);
            Integer intObj = new Integer(pm.getPatchBugNumber());
            bid_location.put(intObj.toString(), null);
        }
        this.storeLocationInHashMap(CPULoc, bid_location);
        this.storeLocationInHashMap(OneOffLoc, bid_location);
        new OiipgPropertyLoader();
        String ptrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        String OPatchApply = "apply -invPtrLoc " + ptrLoc;
        String OPatchExe = "opatch";
        String nodearg = "-local";
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                OPatchExe = "opatch";
                OPatchApply = "util napply -invPtrLoc " + ptrLoc;
                break;
            }
            case -3: {
                OPatchExe = "opatch.bat";
                OPatchApply = "util napply";
                break;
            }
        }
        Set s = bid_location.keySet();
        Iterator i = s.iterator();
        String patchBaseFile = " ";
        BufferedWriter out = null;
        try {
            String scratchLoc = System.getProperty("oracle.installer.scratchPath");
            if (!new File(scratchLoc).exists()) {
                new File(scratchLoc).mkdirs();
            }
            patchBaseFile = scratchLoc + fs + PATCH_BASE_FILE;
            out = new BufferedWriter(new FileWriter(patchBaseFile));
            while (i.hasNext()) {
                String key = (String)i.next();
                ArrayList oneoffs_dir = (ArrayList)bid_location.get(key);
                if (oneoffs_dir == null) continue;
                for (int k = 0; k < oneoffs_dir.size(); ++k) {
                    out.write(oneoffs_dir.get(k).toString() + "\n");
                }
            }
            out.close();
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
        String[] remote_nodes = (String[])this.getSessionValue("REMOTE_NODES");
        nodearg = remote_nodes != null && remote_nodes.length > 0 ? "-all_nodes" : "-local";
        String cmd = OPatchLoc + fs + OPatchExe + "  " + OPatchApply + " " + "-silent" + " " + nodearg + " " + "-oh " + ohome + " " + "-phBaseFile" + " " + patchBaseFile;
        int idx = 0;
        while (args != null && idx < args.length) {
            cmd = cmd + " " + args[idx++];
        }
        Runtime rt = Runtime.getRuntime();
        String opatchcall = null;
        int exitVal = -1;
        try {
            if (-3 == curPlatGroup) {
                String scratchLoc = System.getProperty("oracle.installer.scratchPath");
                opatchcall = scratchLoc + fs + "opatchcall.bat";
                cmd = "call " + cmd;
                cmd = cmd + "\r\nexit %ERRORLEVEL%";
                BufferedWriter outStream = new BufferedWriter(new FileWriter(opatchcall));
                outStream.write(cmd);
                outStream.close();
                cmd = opatchcall;
            }
            Process proc = rt.exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
            errorGobbler.start();
            outputGobbler.start();
            exitVal = proc.waitFor();
        }
        catch (InterruptedException e) {
            OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
        }
        if (-3 == curPlatGroup) {
            File opatchFile = new File(opatchcall);
            opatchFile.delete();
        }
        return exitVal == 0;
    }

    public static boolean updateOPatch(String ohome, String downloadLoc, int OPatchBugID) {
        try {
            String oPatchDownloadLoc = OiiiApplyUpdates.getLatestUpdatesLoc(downloadLoc, "Shiphome");
            oPatchDownloadLoc = OiixPathOps.concatPath(oPatchDownloadLoc + File.separator + OPatchBugID, OPATCH_DIR);
            String dest = OiixPathOps.concatPath(ohome, OPATCH_DIR);
            boolean backup = false;
            boolean changePermissions = false;
            OiixFileOps.copyDirWithPermissions(new File(oPatchDownloadLoc), new File(dest), backup, changePermissions);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
        return true;
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    OiiolTextLogger.appendText(line);
                }
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendText(ioe.getMessage(), OiiolTextLogger.LOG_TRACE);
            }
        }
    }
}

