/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersioned;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public abstract class OiiiAreaInventory
implements Serializable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = 6791025927501753035L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private Vector m_compOHsList = new Vector();
    private Vector[] m_libsInfo;
    private transient boolean m_storedInInv = false;
    protected transient OiiiTargetAreaControl m_areaControl = null;
    private static Vector s_curPlats = null;

    public void dispose() {
        this.m_compOHsList.removeAllElements();
        this.m_libsInfo = null;
    }

    public OiiiAreaInventory() {
        this.m_compOHsList.addElement(new OiiiInvHomeInfo(0, new Vector()));
        this.m_libsInfo = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            this.m_libsInfo[i] = new Vector();
        }
    }

    public OiiiAreaInventory(OiivVerIndObjectRep viObj) {
        this();
        int ohInd;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("OiiiInstallInventory.wasCreatedInThisSession() will return false", OiiolTextLogger.LOG_DETAILED);
        }
        this.m_storedInInv = true;
        Vector compOHsList = (Vector)viObj.getObjectForName("compOHsList");
        int numOHLists = compOHsList.size();
        for (ohInd = 1; ohInd < numOHLists; ++ohInd) {
            this.addNewCompsList();
        }
        for (ohInd = 0; ohInd < numOHLists; ++ohInd) {
            Vector compsInfo = (Vector)compOHsList.elementAt(ohInd);
            Vector verDepCompsInfo = OiivVerIndObjectRep.getVerDepFormOfVect(compsInfo);
            verDepCompsInfo = this.getCorrectedInvList(verDepCompsInfo, null);
            this.setAllCompsVect(ohInd, verDepCompsInfo);
        }
        Vector[] libsInfo = (Vector[])viObj.getObjectForName("libsInfo");
        for (int libType = 0; libType < 3; ++libType) {
            Vector libsInfoForType = libsInfo[libType];
            Vector verDepLibsInfoForType = OiivVerIndObjectRep.getVerDepFormOfVect(libsInfoForType);
            this.setAllLibsInfoForType(libType, verDepLibsInfoForType);
        }
    }

    protected Vector getCompOHsList() {
        return this.m_compOHsList;
    }

    protected Vector getCompOHListElement(int ohIndex) {
        OiiiInvHomeInfo oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohIndex);
        if (oihi != null) {
            return oihi.getCompsVect();
        }
        return null;
    }

    protected OiiiInvHomeInfo getCompOHListInfo(int ohIndex) {
        try {
            OiiiInvHomeInfo oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohIndex);
            return oihi;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Hashtable getCompOHUnknownElementsTable(int ohIndex) {
        OiiiInvHomeInfo oihi = null;
        try {
            oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oihi != null) {
            return oihi.getUnknownCompElementsTable();
        }
        return null;
    }

    protected Hashtable getCompOHUnknownLibElementsTable(int ohIndex) {
        OiiiInvHomeInfo oihi = null;
        try {
            oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oihi != null) {
            return oihi.getUnknownLibElementsTable();
        }
        return null;
    }

    public void disposeHomeInvInfo(int[] idx) {
        int iSize = this.m_compOHsList.size();
        OiiiInvHomeInfo oihi = null;
        for (int i = 0; i < iSize; ++i) {
            try {
                oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(i);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (oihi == null) continue;
            int homeIndex = oihi.getHomeIndex();
            boolean bDispose = true;
            for (int j = 0; j < idx.length; ++j) {
                if (homeIndex != idx[j]) continue;
                bDispose = false;
                break;
            }
            if (!bDispose) continue;
            oihi.dispose();
        }
    }

    protected void setupRefsForVect(int ohIndex) {
    }

    public void setAreaControl(OiiiTargetAreaControl tac) {
        this.m_areaControl = tac;
    }

    public OiiiTargetAreaControl getAreaControl() {
        return this.m_areaControl;
    }

    public void setAllCompsVect(int ohInd, Vector compsVect) {
        OiiiInvHomeInfo oihi;
        if (this.m_compOHsList.size() <= ohInd) {
            this.m_compOHsList.setSize(ohInd + 1);
        }
        if ((oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohInd)) == null) {
            oihi = new OiiiInvHomeInfo(ohInd, compsVect);
            this.m_compOHsList.setElementAt(oihi, ohInd);
        } else {
            oihi.setCompsVect(compsVect);
        }
    }

    protected void setInvHomeInfo(int ohInd, OiiiInvHomeInfo oihi) {
        if (this.m_compOHsList.size() <= ohInd) {
            this.m_compOHsList.setSize(ohInd + 1);
        }
        this.m_compOHsList.setElementAt(oihi, ohInd);
    }

    void setAllCompsLibsInfo(int ohInd, OiiiLibrariesInfo libsInfo) {
        OiiiInvHomeInfo oihi;
        if (this.m_compOHsList.size() <= ohInd) {
            this.m_compOHsList.setSize(ohInd + 1);
        }
        if ((oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohInd)) == null) {
            oihi = new OiiiInvHomeInfo(ohInd);
            oihi.setLibsInfo(libsInfo);
            this.m_compOHsList.setElementAt(oihi, ohInd);
        } else {
            oihi.setLibsInfo(libsInfo);
        }
    }

    protected void setAllCompsUnknownElementsTable(int ohInd, Hashtable tagstable) {
        OiiiInvHomeInfo oihi;
        if (this.m_compOHsList.size() <= ohInd) {
            this.m_compOHsList.setSize(ohInd + 1);
        }
        if ((oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohInd)) == null) {
            oihi = new OiiiInvHomeInfo(ohInd, tagstable);
            this.m_compOHsList.setElementAt(oihi, ohInd);
        } else {
            oihi.setUnknownCompElementsTable(tagstable);
        }
    }

    protected void setAllCompsUnknownLibElementsTable(int ohInd, Hashtable tagstable) {
        OiiiInvHomeInfo oihi;
        if (this.m_compOHsList.size() <= ohInd) {
            this.m_compOHsList.setSize(ohInd + 1);
        }
        if ((oihi = (OiiiInvHomeInfo)this.m_compOHsList.elementAt(ohInd)) == null) {
            oihi = new OiiiInvHomeInfo(ohInd);
            oihi.setUnknownLibElementsTable(tagstable);
            this.m_compOHsList.setElementAt(oihi, ohInd);
        } else {
            oihi.setUnknownLibElementsTable(tagstable);
        }
    }

    protected void setAllLibsInfoForType(int libType, Vector libsVect) {
        this.m_libsInfo[libType] = libsVect;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        Vector<Vector> compOHsList = new Vector<Vector>();
        int numOHsList = this.m_compOHsList.size();
        for (int ohInd = 0; ohInd < numOHsList; ++ohInd) {
            Vector verDepCompsList = this.getCompOHListElement(ohInd);
            Vector verIndCompsList = OiivVerIndObjectRep.getVerIndepFormOfVect(verDepCompsList);
            compOHsList.addElement(verIndCompsList);
        }
        retRep.addNVPair("compOHsList", compOHsList);
        Vector[] libsInfo = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            libsInfo[i] = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_libsInfo[i]);
        }
        retRep.addNVPair("libsInfo", libsInfo);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public boolean compareKeyValue(String key, Object value) {
        return key.equals("compOHsList") || key.equals("libsInfo");
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        return this.mergeVerIndRep(vIndObj, new Vector(0));
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj, Vector oracleHomes) {
        OiivVerIndObjectRep retRep = vIndObj;
        Vector compOHsList = (Vector)vIndObj.getObjectForName("compOHsList");
        Vector[] libsInfo = (Vector[])vIndObj.getObjectForName("libsInfo");
        if (libsInfo == null) {
            libsInfo = new Vector[3];
            for (int i = 0; i < 3; ++i) {
                libsInfo[i] = new Vector();
            }
        }
        int numAreaOHs = this.getNumOHs();
        int numOHLists = compOHsList.size();
        for (int i = 0; i < numAreaOHs - numOHLists; ++i) {
            compOHsList.addElement(new Vector());
        }
        for (int idx = -1; idx < oracleHomes.size(); ++idx) {
            int ohInd = -1;
            if (idx == -1) {
                ohInd = 0;
            } else {
                OiiiOracleHomeInfo oracleHomeInfo = (OiiiOracleHomeInfo)oracleHomes.elementAt(idx);
                if (oracleHomeInfo != null && !oracleHomeInfo.isDirty()) continue;
                ohInd = oracleHomeInfo.getIndex();
            }
            if (ohInd >= compOHsList.size()) continue;
            Vector storedCompsInfo = (Vector)compOHsList.elementAt(ohInd);
            Vector currentCompsInfo = this.getCompOHListElement(ohInd);
            String[] keys = new String[]{"cid"};
            if (!currentCompsInfo.isEmpty()) {
                OiiiCompInvEntry cie = (OiiiCompInvEntry)currentCompsInfo.firstElement();
                keys = cie.getPrimaryKeyParts();
            }
            OiivVerIndObjectRep.mergeVDVectIntoVIVect(currentCompsInfo, storedCompsInfo, keys);
        }
        for (int libType = 0; libType < 3; ++libType) {
            Vector storedLibsInfo = libsInfo[libType];
            Vector currentLibsInfo = this.getAllLibsVect(libType);
            OiivVerIndObjectRep.mergeVDVectIntoVIVect(currentLibsInfo, storedLibsInfo, "lid");
        }
        retRep.setNVPair("compOHsList", compOHsList);
        retRep.setNVPair("libsInfo", libsInfo);
        return retRep;
    }

    public void saveInventory(OiivVerIndObjectRep inv, Vector vdOracleHomes, Vector dirtyHomesIndexes) throws IOException, OiifbCancelException {
    }

    public Vector getCorrectedInvList(Vector vCompsList, Vector vPatchesInfo) {
        Vector<OiiiCompInvEntry> vCorrected = new Vector<OiiiCompInvEntry>();
        if (vCompsList != null) {
            OiiiCompInvEntry oEntry;
            int i;
            int nSize = vCompsList.size();
            for (i = 0; i < nSize; ++i) {
                OiiiCompInvEntry newEntry = oEntry = (OiiiCompInvEntry)vCompsList.elementAt(i);
                OiiiCompInstallID id = oEntry.getCompInstallID();
                if (oEntry instanceof OiiiInstallCompInvEntry) {
                    int nIndex;
                    if ((id.getCompType() == 2 || id.getCompType() == 4) && (nIndex = OiixVectorOps.vectIndexOf(vPatchesInfo, (Object)id)) != -1) {
                        OiiiCompInvEntry oPatchEntry = (OiiiCompInvEntry)vPatchesInfo.elementAt(nIndex);
                        switch (id.getCompType()) {
                            case 2: {
                                newEntry = new OiiiInstallPatchInvEntry(oPatchEntry.getVerIndObject());
                                break;
                            }
                            case 4: {
                                newEntry = new OiiiInstallPatchSetInvEntry(oPatchEntry.getVerIndObject());
                            }
                        }
                    }
                } else if (id.getCompType() == 2) {
                    newEntry = new OiiiStagePatchInvEntry(oEntry.getVerIndObject());
                }
                newEntry.setVerIndObject(null);
                oEntry.setVerIndObject(null);
                vCorrected.addElement(newEntry);
            }
            nSize = vCorrected.size();
            for (i = 0; i < nSize; ++i) {
                oEntry = (OiiiCompInvEntry)vCorrected.elementAt(i);
                if (oEntry instanceof OiiiInstallCompInvEntry) {
                    oEntry.optimizePlatList();
                }
                oEntry.optimizeLangList();
            }
        }
        return vCorrected;
    }

    public int addNewCompsList() {
        int numLists = this.m_compOHsList.size();
        this.m_compOHsList.addElement(new OiiiInvHomeInfo(numLists, new Vector()));
        return numLists;
    }

    int getNumOHs() {
        return this.m_compOHsList.size();
    }

    public void addCompInvEntry(OiiiCompInvEntry cie, int ohIndex) {
        Vector compsInfo;
        int nIndex;
        OiiiCompInstallID cid = cie.getCompInstallID();
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        if ((nIndex = (compsInfo = this.getCompOHListElement(ohIndex)).indexOf(cie)) == -1) {
            compsInfo.addElement(cie);
        } else {
            compsInfo.setElementAt(cie, nIndex);
        }
    }

    public Vector getAllCompsVect(int ohIndex) {
        return this.getCompOHListElement(ohIndex);
    }

    public Enumeration getAllComps(int ohIndex) {
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        return compsInfo.elements();
    }

    public Vector getAllCompsVect(int ohIndex, int plat) {
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        Vector<OiiiCompInvEntry> selComps = new Vector<OiiiCompInvEntry>();
        int numComps = compsInfo.size();
        for (int i = 0; i < numComps; ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)compsInfo.elementAt(i);
            if (!cie.isSupportedOnPlat(plat)) continue;
            selComps.addElement(cie);
        }
        return selComps;
    }

    public OiiiInstallCompInvEntry findCompInRange(int ohIndex, String name, String startVersion, String endVersion) {
        OiiiInstallCompInvEntry invEntry = this.findCompInRangeImpl(ohIndex, name, startVersion, endVersion);
        if (invEntry == null) {
            return this.findCompInRangeImpl(0, name, startVersion, endVersion);
        }
        return invEntry;
    }

    private OiiiInstallCompInvEntry findCompInRangeImpl(int ohIndex, String name, String startVersion, String endVersion) {
        OiiiVersion greatestVal;
        OiiiVersion lowestVal;
        OiiiVersion version;
        OiiiCompInstallID compID;
        OiiiInstallCompInvEntry comp;
        Enumeration e = this.getAllComps(ohIndex);
        while (e.hasMoreElements()) {
            comp = (OiiiInstallCompInvEntry)e.nextElement();
            compID = comp.getCompInstallID();
            if (!compID.getName().equals(name)) continue;
            if (startVersion == null) {
                return comp;
            }
            version = compID.getVersion();
            lowestVal = new OiiiVersion(startVersion);
            greatestVal = new OiiiVersion(endVersion);
            if (version.equals(lowestVal) || version.equals(greatestVal)) {
                return comp;
            }
            if (!version.laterThan(lowestVal) || !greatestVal.laterThan(version)) continue;
            return comp;
        }
        e = this.getAllComps(ohIndex);
        while (e.hasMoreElements()) {
            comp = (OiiiInstallCompInvEntry)e.nextElement();
            compID = comp.getCompInstallID();
            if (!compID.getName().equals(name)) continue;
            if (startVersion == null) {
                return comp;
            }
            version = compID.getVersion();
            lowestVal = new OiiiVersion(startVersion);
            greatestVal = new OiiiVersion(endVersion);
            if (!greatestVal.laterThan(compID.getReplaceVersion()) && !greatestVal.equals(compID.getReplaceVersion()) || !version.laterThan(greatestVal)) continue;
            return comp;
        }
        return null;
    }

    public Enumeration getAllComps(int ohIndex, int plat) {
        Vector selComps = this.getAllCompsVect(ohIndex, plat);
        return selComps.elements();
    }

    public OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid, int ohIndex) {
        return this.getCompInvEntry(cid, ohIndex, OiiiAreaInventory.getCurPlatVect());
    }

    public OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid, int ohIndex, Vector plats) {
        return this.getCompInvEntry(cid, ohIndex, plats, true);
    }

    public OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid, int ohIndex, Vector plats, boolean bIgnoreBuild) {
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        Vector invObjs = this.getVectElements(compsInfo, cid);
        return this.findEntryWithPlats(invObjs, plats);
    }

    public OiiiCompIdOhPair getCompatCompInvEntryInAnyHome(OiiiCompInstallID cid, int nPlatform) {
        int nSize = this.m_compOHsList.size();
        OiiiCompIdOhPair oOhId = null;
        for (int ohIndex = 0; ohIndex < nSize; ++ohIndex) {
            Vector vComps = this.getReplaceCompEntries(cid, ohIndex, nPlatform);
            if (vComps.size() > 0) {
                OiiiCompInvEntry inv = (OiiiCompInvEntry)vComps.elementAt(0);
                oOhId = new OiiiCompIdOhPair(inv.getCompInstallID(), ohIndex);
                break;
            }
            vComps = this.getCompatCompEntries2(cid, ohIndex);
            if (vComps.size() <= 0) continue;
            OiiiCompInvEntry inv = (OiiiCompInvEntry)vComps.elementAt(0);
            oOhId = new OiiiCompIdOhPair(inv.getCompInstallID(), ohIndex);
            break;
        }
        return oOhId;
    }

    public OiiiCompInvEntry getCompatCompEntry(OiiiCompInstallID cid, int ohIndex, int nPlatform) {
        return this.getCompatCompEntry(cid, ohIndex, nPlatform, true);
    }

    public OiiiCompInvEntry getCompatCompEntry(OiiiCompInstallID cid, int ohIndex, int nPlatform, boolean bIgnoreBuild) {
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = null;
        compsInfo = nPlatform == 0 ? this.getAllCompsVect(ohIndex) : this.getAllCompsVect(ohIndex, nPlatform);
        OiiiCompInvEntry oEntry = null;
        int nSize = compsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInvEntry curEntry = (OiiiCompInvEntry)compsInfo.elementAt(i);
            OiiiCompInstallID curID = curEntry.getCompInstallID();
            if (!curID.equalsNoPlat(cid, nPlatform, bIgnoreBuild)) continue;
            oEntry = curEntry;
            break;
        }
        if (oEntry == null) {
            OiiiVersion maxVer = null;
            OiiiCompInvEntry maxVerEntry = null;
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInvEntry curEntry = (OiiiCompInvEntry)compsInfo.elementAt(i);
                OiiiCompInstallID curID = curEntry.getCompInstallID();
                if (!curID.isCompatible(cid, bIgnoreBuild)) continue;
                OiiiVersion curVer = curID.getVersion();
                if (maxVer != null && !curVer.laterThan(maxVer, bIgnoreBuild)) continue;
                maxVer = curVer;
                maxVerEntry = curEntry;
            }
            oEntry = maxVerEntry;
        }
        return oEntry;
    }

    public OiiiCompInvEntry getCompatCompEntry(OiiiCompInstallID cid, int ohIndex, int nPlatform, boolean bIgnoreBuild, boolean bCompatPatch) {
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = null;
        compsInfo = nPlatform == 0 ? this.getAllCompsVect(ohIndex) : this.getAllCompsVect(ohIndex, nPlatform);
        OiiiCompInvEntry oEntry = null;
        int nSize = compsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInvEntry curEntry = (OiiiCompInvEntry)compsInfo.elementAt(i);
            OiiiCompInstallID curID = curEntry.getCompInstallID();
            if (!curID.equalsNoPlat(cid, nPlatform, bIgnoreBuild)) continue;
            oEntry = curEntry;
            break;
        }
        if (oEntry == null) {
            OiiiVersion maxVer = null;
            OiiiCompInvEntry maxVerEntry = null;
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInvEntry curEntry = (OiiiCompInvEntry)compsInfo.elementAt(i);
                OiiiCompInstallID curID = curEntry.getCompInstallID();
                boolean bCompat = false;
                bCompat = curID.getCompType() == 2 ? ((OiiiPatchInstallID)curID).isCompatible(cid, bIgnoreBuild, true) : curID.isCompatible(cid, bIgnoreBuild);
                if (!bCompat) continue;
                OiiiVersion curVer = curID.getVersion();
                if (maxVer != null && !curVer.laterThan(maxVer, bIgnoreBuild)) continue;
                maxVer = curVer;
                maxVerEntry = curEntry;
            }
            oEntry = maxVerEntry;
        }
        return oEntry;
    }

    public OiiiCompInvEntry getCompatCompEntry(OiiiCompInstallID cid, int ohIndex) {
        return this.getCompatCompEntry(cid, ohIndex, OiixPlatform.getCurrentPlatform());
    }

    public Vector getCompatCompEntries(OiiiCompInstallID cid) {
        return this.getCompatCompEntries(cid, 0);
    }

    public Vector getCompatCompEntries(OiiiCompInstallID cid, int ohIndex) {
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        Vector<OiiiCompInvEntry> oEntries = new Vector<OiiiCompInvEntry>();
        Enumeration enum_1 = compsInfo.elements();
        while (enum_1.hasMoreElements()) {
            OiiiCompInvEntry curEntry = (OiiiCompInvEntry)enum_1.nextElement();
            OiiiCompInstallID curID = curEntry.getCompInstallID();
            if (!curID.equalsWithPlatInt(cid)) continue;
            oEntries.addElement(curEntry);
        }
        return oEntries;
    }

    public Vector getCompatCompEntries2(OiiiCompInstallID cid, int ohIndex) {
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        Vector<OiiiCompInvEntry> oEntries = new Vector<OiiiCompInvEntry>();
        Enumeration enum_1 = compsInfo.elements();
        while (enum_1.hasMoreElements()) {
            OiiiCompInvEntry curEntry = (OiiiCompInvEntry)enum_1.nextElement();
            OiiiCompInstallID curID = curEntry.getCompInstallID();
            if (!curID.isCompatible(cid)) continue;
            oEntries.addElement(curEntry);
        }
        return oEntries;
    }

    public OiiiCompInvEntry getReplaceCompEntry(OiiiCompInstallID cid, int ohIndex) {
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        OiiiVersion maxVer = null;
        OiiiCompInvEntry maxVerEntry = null;
        int nSize = compsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInvEntry curEntry = (OiiiCompInvEntry)compsInfo.elementAt(i);
            OiiiCompInstallID curID = curEntry.getCompInstallID();
            if (!cid.isCompatible(curID)) continue;
            OiiiVersion curVer = curID.getVersion();
            if (maxVer != null && !curVer.laterThan(maxVer)) continue;
            maxVer = curVer;
            maxVerEntry = curEntry;
        }
        return maxVerEntry;
    }

    public Vector getReplaceCompEntries(OiiiCompInstallID cid, int ohIndex, int nPlatform) {
        Vector<OiiiCompInvEntry> vComps = new Vector<OiiiCompInvEntry>();
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        int nSize = compsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInvEntry curEntry = (OiiiCompInvEntry)compsInfo.elementAt(i);
            OiiiCompInstallID curID = curEntry.getCompInstallID();
            if (!cid.canReplace(curID, nPlatform)) continue;
            vComps.addElement(curEntry);
        }
        return vComps;
    }

    public Vector getReplaceCompEntries(OiiiCompInstallID cid, int ohIndex) {
        return this.getReplaceCompEntries(cid, ohIndex, OiixPlatform.getCurrentPlatform());
    }

    public void removeCompInvEntry(OiiiCompInstallID cid, int ohIndex) {
        this.removeCompInvEntry(cid, ohIndex, OiiiAreaInventory.getCurPlatVect());
    }

    public void removeCompInvEntry(OiiiCompInstallID cid, int ohIndex, Vector plats) {
        Vector compsInfo;
        Vector invObjs;
        OiiiCompInvEntry cie;
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        if ((cie = this.findEntryWithPlats(invObjs = this.getVectElements(compsInfo = this.getAllCompsVect(ohIndex), cid), plats)) != null) {
            compsInfo.removeElement(cie);
        }
    }

    public Vector getCompInvEntries(String compName, int ohIndex) {
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        return this.getInvEntries(compsInfo, compName);
    }

    public Vector getCompInvEntries(String compName, OiiiVersion version, int ohIndex) {
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        return this.getInvEntries(compsInfo, compName, version);
    }

    public Vector getTopLevelComps(int ohIndex) {
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        Vector<OiiiCompInstallID> retVect = new Vector<OiiiCompInstallID>();
        Enumeration allComps = this.getAllComps(ohIndex);
        while (allComps.hasMoreElements()) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)allComps.nextElement();
            if (!cie.isTopLevel()) continue;
            retVect.addElement(cie.getCompInstallID());
        }
        return retVect;
    }

    public Vector getTopLevelComps(int ohIndex, int plat) {
        Vector compsInfo = this.getAllCompsVect(ohIndex);
        Vector<OiiiCompInstallID> retVect = new Vector<OiiiCompInstallID>();
        Enumeration allComps = this.getAllComps(ohIndex, plat);
        while (allComps.hasMoreElements()) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)allComps.nextElement();
            if (!cie.isTopLevel()) continue;
            retVect.addElement(cie.getCompInstallID());
        }
        return retVect;
    }

    public Vector getCurrentEntryDeps(OiiiCompInstallID cid, int ohIndex) {
        OiiiCompInvEntry cie = this.getCompInvEntry(cid, ohIndex);
        if (cie == null && ohIndex != 0 && cid.isNOHComp()) {
            cie = this.getCompInvEntry(cid, 0);
        }
        if (cie == null) {
            cie = this.getCompatCompEntry(cid, ohIndex);
        }
        Vector<OiiiCompIdOhPair> curDeps = new Vector<OiiiCompIdOhPair>();
        if (cie == null) {
            return curDeps;
        }
        Vector storedDeps = cie.getDependees();
        Enumeration deps = storedDeps.elements();
        while (deps.hasMoreElements()) {
            int depOhIndex;
            OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)deps.nextElement();
            OiiiCompInstallID depID = depIdOh.getCompID();
            OiiiCompInvEntry dcie = this.getCompatCompEntry(depID, depOhIndex = depIdOh.getOHIndex());
            if (dcie == null && ohIndex != 0 && depID.isNOHComp()) {
                dcie = this.getCompatCompEntry(depID, 0);
            }
            if (dcie == null) continue;
            curDeps.addElement(new OiiiCompIdOhPair(dcie.getCompInstallID(), depOhIndex));
        }
        return curDeps;
    }

    public void addCompInvEntry(OiiiCompInvEntry cie) {
        this.addCompInvEntry(cie, 0);
    }

    public Enumeration getAllComps() {
        return this.getAllComps(0);
    }

    public OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid) {
        return this.getCompInvEntry(cid, 0);
    }

    public OiiiCompInvEntry getCompatCompEntry(OiiiCompInstallID cid) {
        return this.getCompatCompEntry(cid, 0);
    }

    public OiiiCompInvEntry getReplaceCompEntry(OiiiCompInstallID cid) {
        return this.getReplaceCompEntry(cid, 0);
    }

    public void removeCompInvEntry(OiiiCompInstallID cid) {
        this.removeCompInvEntry(cid, 0);
    }

    public Vector getCompInvEntries(String compName) {
        return this.getCompInvEntries(compName, 0);
    }

    public Vector getCompInvEntries(String compName, OiiiVersion version) {
        return this.getCompInvEntries(compName, version, 0);
    }

    public Vector getTopLevelComps() {
        return this.getTopLevelComps(0);
    }

    public Vector getCurrentEntryDeps(OiiiCompInstallID cid) {
        return this.getCurrentEntryDeps(cid, 0);
    }

    public void addLibInvEntry(OiiiLibInvEntry lie, int libType) {
        if (this.m_libsInfo[libType].indexOf(lie) == -1) {
            this.m_libsInfo[libType].addElement(lie);
        }
    }

    public Vector getAllLibsVect(int libType) {
        return this.m_libsInfo[libType];
    }

    public Enumeration getAllLibs(int libType) {
        return this.getAllLibsVect(libType).elements();
    }

    public OiiiLibInvEntry getLibInvEntry(OiiiLibraryID lid, int libType) {
        return (OiiiLibInvEntry)this.getVectElement(this.m_libsInfo[libType], lid);
    }

    public void removeLibInvEntry(OiiiLibraryID lid, int libType) {
        Vector libVect = this.m_libsInfo[libType];
        int pos = OiixVectorOps.vectIndexOf(libVect, (Object)lid);
        if (pos != -1) {
            libVect.removeElementAt(pos);
        }
    }

    public Vector getLibInvEntries(String name, int libType) {
        return this.getInvEntries(this.m_libsInfo[libType], name);
    }

    public Vector getLibInvEntries(String name, OiiiVersion version, int libType) {
        return this.getInvEntries(this.m_libsInfo[libType], name, version);
    }

    public OiiiLibInvEntry getCompatLibEntry(OiiiLibraryID lid, int libType) {
        return this.getCompatLibEntry(lid, libType, null);
    }

    public OiiiLibInvEntry getCompatLibEntry(OiiiLibraryID lid, int libType, OiiiVersion runningInstVer) {
        return this.getCompatibleLibEntry(this.m_libsInfo[libType], lid, runningInstVer);
    }

    protected OiiiLibInvEntry getCompatibleLibEntry(Vector entries, OiiiLibraryID lid, OiiiVersion runningInstVer) {
        OiiiVersion maxVer = null;
        OiiiLibInvEntry maxVerEntry = null;
        Enumeration enum_1 = entries.elements();
        while (enum_1.hasMoreElements()) {
            OiiiLibInvEntry curEntry = (OiiiLibInvEntry)enum_1.nextElement();
            if (!curEntry.isCompatible(lid)) continue;
            OiiiVersion curVer = curEntry.getVersion();
            if (runningInstVer != null && !this.isInstVerCompatible(curEntry.getLibraryID().getInstVer(), runningInstVer) || maxVer != null && !curVer.laterThan(maxVer)) continue;
            maxVer = curVer;
            maxVerEntry = curEntry;
        }
        return maxVerEntry;
    }

    private boolean isInstVerCompatible(OiiiVersion libInstVer, OiiiVersion runningInstVer) {
        if (libInstVer.equals(runningInstVer)) {
            return true;
        }
        return !libInstVer.laterThan(runningInstVer);
    }

    private Vector getInvEntries(Vector invSet, String name) {
        int pos = -1;
        Vector retEntries = new Vector();
        while ((pos = OiixVectorOps.vectIndexOf(invSet, (Object)name, pos + 1)) != -1) {
            retEntries.addElement(invSet.elementAt(pos));
        }
        return retEntries;
    }

    private Vector getInvEntries(Vector invSet, String name, OiiiVersion version) {
        int pos = -1;
        Vector<OiiiVersioned> retEntries = new Vector<OiiiVersioned>();
        while ((pos = OiixVectorOps.vectIndexOf(invSet, (Object)name, pos + 1)) != -1) {
            Object vectObj = invSet.elementAt(pos);
            OiiiVersioned vEl = (OiiiVersioned)vectObj;
            if (!vEl.getVersion().equals(version)) continue;
            retEntries.addElement(vEl);
        }
        return retEntries;
    }

    public String toString() {
        return "Comps :: [" + OiixVectorOps.objToString(this.m_compOHsList) + "], ActionLibs :: [" + OiixVectorOps.objToString(this.m_libsInfo[0]) + "], QueryLibs :: [" + OiixVectorOps.objToString(this.m_libsInfo[1]) + "], DialogLibs :: [" + OiixVectorOps.objToString(this.m_libsInfo[2]) + "]";
    }

    private Object getVectElement(Vector vect, Object obj) {
        Object retObj = null;
        int pos = OiixVectorOps.vectIndexOf(vect, obj);
        if (pos != -1) {
            retObj = vect.elementAt(pos);
        }
        return retObj;
    }

    private Vector getVectElements(Vector vect, Object obj) {
        Vector retVect = new Vector();
        int pos = -1;
        while ((pos = OiixVectorOps.vectIndexOf(vect, obj, pos + 1)) != -1) {
            retVect.addElement(vect.elementAt(pos));
        }
        return retVect;
    }

    private OiiiCompInvEntry findEntryWithPlats(Vector invObjs, Vector plats) {
        OiiiCompInvEntry retEntry = null;
        int numObjs = invObjs.size();
        for (int i = 0; i < numObjs; ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)invObjs.elementAt(i);
            if (cie.getCompInstallID().getCompType() == 4) {
                retEntry = cie;
                break;
            }
            if (!OiixVectorOps.vectorSubset(plats, cie.getPlatforms())) continue;
            retEntry = cie;
            break;
        }
        return retEntry;
    }

    public static Vector getCurPlatVect() {
        if (s_curPlats == null) {
            s_curPlats = new Vector();
            s_curPlats.addElement(new Integer(OiixPlatform.getCurrentPlatform()));
        }
        return s_curPlats;
    }
}

