/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetBugList;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiiBugListValidate {
    public static boolean bStandAlone = false;
    private static final String s_buglistXML = "buglist.xml";
    private static final int S_TOO_LONG = 120;
    private static Vector v_removes = new Vector();

    public static Vector getOneoffRemoves() {
        return v_removes;
    }

    public static void setOneoffRemoves(Vector oneOffRemoves) {
        v_removes = oneOffRemoves;
    }

    public static boolean validate(OiiodDepEngine de, int idx, OiiiInstallInventory inventory, Boolean suppress) {
        Vector pset = new Vector();
        Vector patches = null;
        Vector B = null;
        Vector<OiiiOneoffInstallID> oneOffIDs = new Vector<OiiiOneoffInstallID>();
        String msg = null;
        String fileName = null;
        String patchset_name = null;
        String filePath = null;
        boolean bError = false;
        if (de != null) {
            pset = de.getSelectedPatchSets();
            if (pset != null && pset.size() == 1) {
                OiiiPatchSetInstallID psid = (OiiiPatchSetInstallID)pset.elementAt(0);
                fileName = psid.getName() + "_" + psid.getVersion().getVerString() + "_" + s_buglistXML;
                patchset_name = psid.getName();
                patches = de.getContainedPatches(psid);
            } else {
                return false;
            }
        }
        if (patches.size() == 0) {
            return false;
        }
        String psBugList = System.getProperty("oracle.installer.patchsetBugListFile");
        if (psBugList != null) {
            filePath = psBugList;
            fileName = new File(filePath).getName();
        } else {
            String tempLoc = System.getProperty("oracle.installer.scratchPath");
            String parDir = OiixPathOps.concatPath(tempLoc, "buglist");
            filePath = OiixPathOps.concatPath(parDir, fileName);
        }
        if (!new File(filePath).exists()) {
            boolean bGUI;
            Object[] arg = new Object[]{fileName, patchset_name};
            String displayWarning = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING_PS_BUGLIST_XML_NOT_FOUND", arg);
            boolean bl = bGUI = !OiicPullSession.isSilentMode();
            if (bGUI) {
                int userChoice = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), displayWarning, 30, 3, 1, 10);
                bError = userChoice == 2;
            } else {
                displayWarning = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING_PS_BUGLIST_XML_NOT_FOUND_SILENT", arg);
                System.out.println(displayWarning);
            }
            OiiolTextLogger.appendText(displayWarning);
            return bError;
        }
        Vector vDeinstallOneOffOhList = OiiiBugListValidate.getOneoffRemoves();
        int iSize = vDeinstallOneOffOhList.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)vDeinstallOneOffOhList.elementAt(i);
            oneOffIDs.addElement(oPair.getOneoffID());
        }
        OiiiPatchSetBugList ps = new OiiiPatchSetBugList(filePath, patches);
        ps.readPSXML();
        B = ps.getBugList();
        msg = ps.performChecks(B, oneOffIDs, idx, inventory);
        if (msg != null) {
            Object[] arg = new Object[]{patchset_name, msg};
            String msgToLog = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_PS_BUGLIST", arg);
            OiiolTextLogger.appendText(msgToLog);
            if (bStandAlone) {
                System.out.println(msgToLog);
                return false;
            }
            if (!suppress.booleanValue()) {
                boolean bGUI;
                if (msg.length() > 120) {
                    String logLoc = OiiolTextLogger.getCurLogFileName();
                    Object[] loc = new Object[]{logLoc};
                    arg[1] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REFER_LOG", loc);
                }
                String displayWarning = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING_PS_BUGLIST", arg);
                boolean bl = bGUI = !OiicPullSession.isSilentMode();
                if (bGUI) {
                    int userChoice = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), displayWarning, 30, 3, 1, 10);
                    bError = userChoice == 2;
                } else {
                    String displayError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_PS_BUGLIST", arg);
                    System.out.println(displayError);
                    bError = true;
                }
            }
        }
        return bError;
    }
}

