/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiiCdLabel {
    public static final String LABEL_FILENAME = "disk.label";
    public static final String SECTION_NAME = "General";
    public static final String LABEL_NAME = "Label";
    public static final String NUMBER_NAME = "Number";
    public static final String SIZE_NAME = "Size";
    public static final String RESERVED_SIZE_NAME = "ReservedSize";
    public static final String BOOTSTRAP_COMP = "BootstrapComp";
    private String m_sLabel;
    private int m_iNumber = 1;
    private float m_fSize = 0.0f;
    private float m_fResSize = 0.0f;
    private String m_sBootStrapComp = "";

    public String getLabel() {
        return this.m_sLabel;
    }

    public int getNumber() {
        return this.m_iNumber;
    }

    public float getSize() {
        return this.m_fSize;
    }

    public String getBootStrapComp() {
        return this.m_sBootStrapComp;
    }

    public float getReservedSize() {
        return this.m_fResSize;
    }

    private String getProfileString(OiixIniFile labelFile, String varName) throws IOException {
        String value = labelFile.getProfileString(SECTION_NAME, varName, "");
        if (value.length() == 0) {
            value = null;
        }
        return value;
    }

    private String getTempLoc() {
        return System.getProperty("oracle.installer.scratchPath");
    }

    public void readLabelFile(String location) throws NumberFormatException, IOException {
        location = OiixPathOps.getStandardForm(location);
        location = OiixPathOps.concatPath(location, LABEL_FILENAME);
        String srcLoc = OiixPathOps.getParentDir(location);
        String srcOff = OiixPathOps.getFileName(location);
        if (srcLoc == null) {
            srcLoc = System.getProperty("user.dir");
        }
        String fileName = location;
        if (this.getTempLoc() != null) {
            OiiofFileLoader fileLoader = OiiofFileLoaderFactory.createFileLoader(srcLoc, this.getTempLoc());
            try {
                fileName = fileLoader.getLocalCopy(srcOff);
            }
            catch (OiifbCancelException io) {
                throw new IOException(io.getMessage());
            }
        }
        OiixIniFile labelFile = new OiixIniFile(fileName);
        this.m_sLabel = this.getProfileString(labelFile, LABEL_NAME);
        if (this.m_sLabel == null) {
            this.m_sLabel = "";
        }
        String numStr = this.getProfileString(labelFile, NUMBER_NAME);
        boolean num = false;
        if (numStr != null) {
            try {
                this.m_iNumber = Integer.parseInt(numStr, 10);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(OiixResourceBundle.getString("S_INVALID_CD_NUMBER"));
            }
        } else {
            throw new NumberFormatException(OiixResourceBundle.getString("S_NO_CD_NUMBER"));
        }
        numStr = this.getProfileString(labelFile, SIZE_NAME);
        if (numStr != null) {
            try {
                this.m_fSize = new Float(numStr).floatValue();
            }
            catch (NumberFormatException nfe) {
                this.m_fSize = 0.0f;
            }
        }
        if ((numStr = this.getProfileString(labelFile, RESERVED_SIZE_NAME)) != null) {
            try {
                this.m_fResSize = new Float(numStr).floatValue();
            }
            catch (NumberFormatException nfe) {
                this.m_fResSize = 0.0f;
            }
        }
        this.m_sBootStrapComp = this.getProfileString(labelFile, BOOTSTRAP_COMP);
    }

    public void setLabel(String label) {
        this.m_sLabel = label;
    }

    public void setDiskNumber(int num) {
        this.m_iNumber = num;
    }

    public void setSize(float size) {
        this.m_fSize = size;
    }

    public void setReservedSize(float resSize) {
        this.m_fResSize = resSize;
    }

    public void setBootStrapComp(String bootstrapComp) {
        this.m_sBootStrapComp = bootstrapComp;
    }

    public void writeLabelFile(String location) throws IOException {
        OiixIniFile labelFile = new OiixIniFile(OiixPathOps.concatPath(location, LABEL_FILENAME));
        labelFile.setProfileString(SECTION_NAME, LABEL_NAME, this.m_sLabel);
        labelFile.setProfileString(SECTION_NAME, NUMBER_NAME, Integer.toString(this.m_iNumber));
        labelFile.setProfileString(SECTION_NAME, SIZE_NAME, Float.toString(this.m_fSize));
        labelFile.setProfileString(SECTION_NAME, RESERVED_SIZE_NAME, Float.toString(this.m_fResSize));
        labelFile.setProfileString(SECTION_NAME, BOOTSTRAP_COMP, this.m_sBootStrapComp);
        labelFile.writeIniFile();
    }

    public boolean equals(String label, int num) {
        if (label == null) {
            return false;
        }
        if (Boolean.getBoolean("oracle.installer.ignoreDiskLabel")) {
            OiiolTextLogger.appendText("Ignoring mismatch in Disk Label.Proceeding with install", OiiolTextLogger.LOG_BASIC);
            return num == this.m_iNumber;
        }
        return label.equalsIgnoreCase(this.m_sLabel) && num == this.m_iNumber;
    }
}

