/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public abstract class OiiiCloneVars
implements OixsXMLizable {
    protected HashSet m_vars = new HashSet(10, 2.0f);

    public void addVariable(OiisVariable oVar) {
        this.m_vars.add(oVar);
    }

    public HashSet getVars() {
        return this.m_vars;
    }

    public boolean removeVariable(OiisVariable var) {
        return this.m_vars.remove(var);
    }

    public boolean isEmpty() {
        return this.m_vars.isEmpty();
    }

    public Iterator iterator() {
        return this.getComputeAtCloneVars().iterator();
    }

    public Iterator iteratorForAllVars() {
        return this.m_vars.iterator();
    }

    public HashSet getComputeAtCloneVars() {
        HashSet<OiisVariable> hVars = new HashSet<OiisVariable>(this.m_vars.size());
        Iterator itr = this.iteratorForAllVars();
        while (itr.hasNext()) {
            OiisVariable oVar = (OiisVariable)itr.next();
            if (!oVar.isComputeAtClone() || !oVar.isValueSetByUser() && !oVar.isValueFromCloneXML()) continue;
            hVars.add(oVar);
        }
        return hVars;
    }

    public HashSet getInterviewVars() {
        HashSet<OiisVariable> hVars = new HashSet<OiisVariable>(this.m_vars.size());
        Iterator itr = this.iteratorForAllVars();
        while (itr.hasNext()) {
            OiisVariable oVar = (OiisVariable)itr.next();
            if (!oVar.isValueSetByUser()) continue;
            hVars.add(oVar);
        }
        return hVars;
    }

    public OiisVariable getVariable(String sVarName) {
        OiisVariable retVar = null;
        Iterator itr = this.iteratorForAllVars();
        while (itr.hasNext()) {
            OiisVariable oVar = (OiisVariable)itr.next();
            if (!oVar.getName().equals(sVarName)) continue;
            retVar = oVar;
            break;
        }
        return retVar;
    }

    public Object getVariableValue(String sVarName) {
        Object retVal = null;
        OiisVariable oVar = this.getVariable(sVarName);
        if (oVar == null) {
            return null;
        }
        return oVar.getValue();
    }

    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    public void writeXML(PrintWriter out) throws IOException {
        XMLElement elem = this.toXML();
        if (elem != null) {
            elem.print(out);
        }
    }

    private XMLElement buildDOMTree() {
        if (this.m_vars.isEmpty()) {
            return null;
        }
        XMLElement elemOwner = this.getVarOwnerElement();
        Iterator iter = this.m_vars.iterator();
        while (iter.hasNext()) {
            OiisVariable oVar = (OiisVariable)iter.next();
            if (!oVar.isValueSet()) continue;
            int nType = oVar.getType();
            if (nType == -1) {
                // empty if block
            }
            XMLElement elemVar = new XMLElement("VAR");
            elemVar.setAttribute("NAME", oVar.getName());
            elemVar.setAttribute("TYPE", OiisVariable.getTypeString(oVar.getType()));
            if (oVar.isSecure()) {
                elemVar.setAttribute("SECURE", "T");
            } else {
                String sVal = oVar.getValueAsString();
                if (oVar.getType() == OiisVariable.STRINGLIST) {
                    sVal = "{" + sVal + "}";
                }
                elemVar.setAttribute("VAL", sVal);
            }
            if (oVar.isComputeAtClone()) {
                elemVar.setAttribute("COMPUTE_AT_CLONE", "T");
            } else {
                elemVar.setAttribute("COMPUTE_AT_CLONE", "F");
            }
            if (oVar.isValueSetByUser() || oVar.isValueFromCloneXML() && oVar.getUserInputFromCloneXML()) {
                elemVar.setAttribute("USER_INPUT", "T");
            } else {
                elemVar.setAttribute("USER_INPUT", "F");
            }
            HashMap hmCloneDescs = oVar.getAllDescriptionTranslations();
            Iterator iterDesc = hmCloneDescs.entrySet().iterator();
            while (iterDesc.hasNext()) {
                Map.Entry entry = iterDesc.next();
                String sDesc = (String)entry.getValue();
                if (sDesc == null || sDesc.length() == 0) continue;
                XMLElement elemDesc = new XMLElement("DESC");
                elemDesc.setAttribute("LANG", ((Locale)entry.getKey()).getLanguage());
                elemDesc.addText(sDesc);
                elemVar.appendChild((Node)elemDesc);
            }
            elemOwner.appendChild((Node)elemVar);
        }
        return elemOwner;
    }

    protected abstract XMLElement getVarOwnerElement();
}

