/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.ArrayList;
import java.util.Locale;
import oracle.sysman.oii.oiii.OiiiCloneInfo;
import oracle.sysman.oii.oiii.OiiiCompCloneVars;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiSessionCloneVars;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiis.OiisDataTypeDetails;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiCloneXMLHandler
extends OixsDefaultHandler {
    private OiiiCompCloneVars m_curCompCloneVars;
    private ArrayList m_cloneVars;
    private OiiiSessionCloneVars m_sessionCloneVars;
    private ArrayList m_extDeps;
    private OiisVariable m_curVar;
    private OiiiCloneInfo m_cloneInfo;
    private boolean m_bProcessingSessionVars;

    protected OixsElementHandler createElementHandlers() {
        OixsElementHandler handlerCloneInfo = new OixsElementHandler("CLONE_INFO");
        OiiiSessionVarsElementHandler handlerSessionVarInfo = new OiiiSessionVarsElementHandler("SESSION_VARS_INFO");
        OixsElementHandler handlerCompVarInfo = new OixsElementHandler("COMP_VAR_INFO");
        OiiiCompElementHandler handlerComp = new OiiiCompElementHandler("COMP");
        OiiiPatchElementHandler handlerPatch = new OiiiPatchElementHandler("PATCH");
        OiiiVarElementHandler handlerVar = new OiiiVarElementHandler("VAR");
        OiiiDescElementHandler handlerDesc = new OiiiDescElementHandler("DESC");
        OixsElementHandler handlerExtDepInfo = new OixsElementHandler("EXT_DEP_INFO");
        OiiiDepElementHandler handlerDep = new OiiiDepElementHandler("DEP");
        handlerCloneInfo.addChildHandler("COMP_VAR_INFO", handlerCompVarInfo);
        handlerCompVarInfo.addChildHandler("COMP", handlerComp);
        handlerCompVarInfo.addChildHandler("PATCH", handlerPatch);
        handlerVar.addChildHandler("DESC", handlerDesc);
        handlerComp.addChildHandler("VAR", handlerVar);
        handlerPatch.addChildHandler("VAR", handlerVar);
        handlerSessionVarInfo.addChildHandler("VAR", handlerVar);
        handlerCloneInfo.addChildHandler("SESSION_VARS_INFO", handlerSessionVarInfo);
        handlerCloneInfo.addChildHandler("EXT_DEP_INFO", handlerExtDepInfo);
        handlerExtDepInfo.addChildHandler("DEP", handlerDep);
        return handlerCloneInfo;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.m_cloneVars = new ArrayList();
        this.m_extDeps = new ArrayList();
    }

    public void endDocument() throws SAXException {
        this.m_cloneVars.trimToSize();
        this.m_cloneInfo = new OiiiCloneInfo(this.m_cloneVars, this.m_extDeps, this.m_sessionCloneVars);
        super.endDocument();
    }

    public ArrayList getCloneVars() {
        return this.m_cloneVars;
    }

    public ArrayList getExternalDependees() {
        return this.m_extDeps;
    }

    public OiiiCloneInfo getCloneInfo() {
        return this.m_cloneInfo;
    }

    public OiiiSessionCloneVars getSessionCloneVars() {
        return this.m_sessionCloneVars;
    }

    private class OiiiSessionVarsElementHandler
    extends OixsElementHandler {
        public OiiiSessionVarsElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            OiiiCloneXMLHandler.this.m_sessionCloneVars = new OiiiSessionCloneVars();
            OiiiCloneXMLHandler.this.m_bProcessingSessionVars = true;
        }

        public void onEnd(String name) {
            OiiiCloneXMLHandler.this.m_bProcessingSessionVars = false;
        }
    }

    private class OiiiDepElementHandler
    extends OixsElementHandler {
        public OiiiDepElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            OiiiCompInstallID cid = new OiiiCompInstallID(sName, new OiiiVersion(sVer), OiixPlatform.getCurrentPlatformVector());
            int homeIndex = 0;
            String sHomeIndex = atts.getValue("HOME_IDX");
            if (sHomeIndex != null) {
                try {
                    homeIndex = Integer.parseInt(sHomeIndex);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Invalid home index: " + sHomeIndex);
                    nfe.printStackTrace();
                }
            }
            if (homeIndex == 0) {
                cid.setHomeType(0);
            }
            OiiiCompIdOhPair depIdOh = new OiiiCompIdOhPair(cid, homeIndex);
            OiiiCloneXMLHandler.this.m_extDeps.add(depIdOh);
        }
    }

    private class OiiiDescElementHandler
    extends OixsTextElementHandler {
        private String m_sLang;

        public OiiiDescElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_sLang = atts.getValue("LANG");
            if (this.m_sLang == null) {
                this.m_sLang = OiixLanguage.ENGLISH.getLanguage();
            }
        }

        public void onEnd(String name) {
            super.onEnd(name);
            String sDesc = this.getText();
            OiiiCloneXMLHandler.this.m_curVar.setCloneDescription(sDesc, new Locale(this.m_sLang, ""));
        }
    }

    private class OiiiPatchElementHandler
    extends OixsElementHandler {
        public OiiiPatchElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sBaseVer = atts.getValue("BASE_VER");
            OiiiCompInstallID base_cid = new OiiiCompInstallID(sName, new OiiiVersion(sBaseVer), OiixPlatform.getCurrentPlatformVector());
            base_cid = OiiiCompIDPool.getInstance().get(base_cid);
            OiiiPatchInstallID pid = new OiiiPatchInstallID(base_cid, new OiiiVersion(sVer), OiixPlatform.getCurrentPlatformVector());
            OiiiCloneXMLHandler.this.m_curCompCloneVars = new OiiiCompCloneVars(pid);
        }

        public void onEnd(String name) {
            OiiiCloneXMLHandler.this.m_cloneVars.add(OiiiCloneXMLHandler.this.m_curCompCloneVars);
            OiiiCloneXMLHandler.this.m_curCompCloneVars = null;
        }
    }

    private class OiiiCompElementHandler
    extends OixsElementHandler {
        public OiiiCompElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            OiiiCompInstallID cid = new OiiiCompInstallID(sName, new OiiiVersion(sVer), OiixPlatform.getCurrentPlatformVector());
            cid = OiiiCompIDPool.getInstance().get(cid);
            OiiiCloneXMLHandler.this.m_curCompCloneVars = new OiiiCompCloneVars(cid);
        }

        public void onEnd(String name) {
            OiiiCloneXMLHandler.this.m_cloneVars.add(OiiiCloneXMLHandler.this.m_curCompCloneVars);
            OiiiCloneXMLHandler.this.m_curCompCloneVars = null;
        }
    }

    private class OiiiVarElementHandler
    extends OixsElementHandler {
        private OiisVariable m_oVar;

        public OiiiVarElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            String sSecure;
            String sName = atts.getValue("NAME");
            this.m_oVar = new OiisVariable(null, sName);
            String sType = atts.getValue("TYPE");
            OiisDataTypeDetails type = OiisDataTypes.findTypeWithName(sType);
            int nTypeID = type.getID();
            this.m_oVar.setType(nTypeID);
            String sClone = atts.getValue("COMPUTE_AT_CLONE");
            if (sClone == null || sClone.length() == 0 || sClone.equals("T")) {
                this.m_oVar.setComputeAtClone(true);
            }
            if ((sSecure = atts.getValue("SECURE")) != null && sSecure.equalsIgnoreCase("T")) {
                this.m_oVar.setSecure(true);
            } else {
                String sVal = atts.getValue("VAL");
                Object oVal = OiisDataTypes.getValueObject(sVal, sType);
                try {
                    this.m_oVar.setVariableValue(oVal);
                }
                catch (OiisVarSettingException vse) {
                    vse.printStackTrace();
                }
            }
            String sUserInput = atts.getValue("USER_INPUT");
            boolean bUserInput = sUserInput != null && sUserInput.equalsIgnoreCase("T");
            this.m_oVar.setSecureVariableTypeFromCloneXML(bUserInput);
            OiiiCloneXMLHandler.this.m_curVar = this.m_oVar;
        }

        public void onEnd(String name) {
            if (OiiiCloneXMLHandler.this.m_bProcessingSessionVars) {
                OiiiCloneXMLHandler.this.m_sessionCloneVars.addVariable(this.m_oVar);
            } else {
                OiiiCloneXMLHandler.this.m_curCompCloneVars.addVariable(this.m_oVar);
            }
            OiiiCloneXMLHandler.this.m_curVar = null;
        }
    }
}

