/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiii.OiiiCompsXMLHandler;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoXMLReader;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiii.OiiiRemoteInventoryXMLHandler;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiClusterInstallInventory {
    private HashMap m_remoteNodeInvRead = null;
    private HashMap m_oInvLocNoHomesAttached = null;
    private HashMap m_oHomesAttached = null;

    public OiiiClusterInstallInventory(String[] remoteNodes) {
        try {
            this.initialize(remoteNodes);
        }
        catch (OiiiInstallInventoryReadException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    public OiiiClusterInstallInventory() {
    }

    public HashMap getInventoryLocsRemote() {
        return this.m_oInvLocNoHomesAttached;
    }

    public HashMap getRemoteHomesAttached() {
        return this.m_oHomesAttached;
    }

    private void initialize(String[] remoteNodes) throws OiipgRemoteOpsException, OiiiInstallInventoryReadException, IOException {
        if (remoteNodes != null && remoteNodes.length > 0) {
            for (int i = 0; i < remoteNodes.length; ++i) {
                this.initialize(remoteNodes[i]);
            }
        }
    }

    private void initialize(String remoteNode) throws OiipgRemoteOpsException, OiiiInstallInventoryReadException, IOException {
        String invLoc = null;
        String invFileLoc = null;
        String invFileLocOnLocal = null;
        invLoc = OiipgClusterInvSetup.getInventoryLocationOnNode(remoteNode);
        OiiolTextLogger.appendText("Location of invPtr on remote node " + remoteNode + " is " + invLoc, OiiolTextLogger.LOG_TRACE);
        if (invLoc == null || invLoc == "") {
            OiiolTextLogger.appendText("No central inventory available on remote node " + remoteNode);
            return;
        }
        invFileLoc = OiixPathOps.getStandardForm(invLoc);
        invFileLoc = OiixPathOps.directorify(invFileLoc);
        invFileLoc = invFileLoc + "ContentsXML" + '/' + "inventory.xml";
        OiiolTextLogger.appendText("Location of inventory.xml on remote node " + remoteNode + " is " + invFileLoc, OiiolTextLogger.LOG_TRACE);
        if (OiipgClusterOps.fileExistsOnNode(remoteNode, invFileLoc)) {
            invFileLocOnLocal = this.generateInvFileLocOnLocal(remoteNode);
            OiipgClusterOps.transferFileFromNode(remoteNode, invFileLoc, invFileLocOnLocal);
            if (!this.readHomes(invFileLocOnLocal, remoteNode)) {
                if (this.m_oInvLocNoHomesAttached == null) {
                    this.m_oInvLocNoHomesAttached = new HashMap();
                }
                this.m_oInvLocNoHomesAttached.put(remoteNode, invLoc);
            }
        } else {
            if (this.m_oInvLocNoHomesAttached == null) {
                this.m_oInvLocNoHomesAttached = new HashMap();
            }
            this.m_oInvLocNoHomesAttached.put(remoteNode, invLoc);
        }
        if (this.m_remoteNodeInvRead == null) {
            this.m_remoteNodeInvRead = new HashMap();
        }
        this.m_remoteNodeInvRead.put(remoteNode, new Boolean(true));
    }

    private String generateInvFileLocOnLocal(String node) {
        String invFileLocOnLocal = System.getProperty("oracle.installer.scratchPath");
        invFileLocOnLocal = OiixPathOps.getStandardForm(invFileLocOnLocal);
        invFileLocOnLocal = OiixPathOps.directorify(invFileLocOnLocal);
        invFileLocOnLocal = OiixPathOps.getNativeForm(invFileLocOnLocal + "inventory.xml");
        invFileLocOnLocal = invFileLocOnLocal + "." + node;
        return invFileLocOnLocal;
    }

    private boolean readHomes(String sFile, String remoteNode) throws OiiiInstallInventoryReadException, IOException {
        try {
            FileReader fReader = new FileReader(sFile);
            BufferedReader bReader = new BufferedReader(fReader);
            Parser parser = OixsXMLOps.createSAXParser();
            OiiiRemoteInventoryXMLHandler handler = null;
            try {
                handler = new OiiiRemoteInventoryXMLHandler();
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new OiiiInstallInventoryReadException(e, e.getMessage());
            }
            bReader.close();
            fReader.close();
            OiiiVersion minVer = handler.getMinOUIVersion();
            if (minVer.laterThan(OiicInstVersion.getInstallerVersion())) {
                String sMsg = OiixResourceBundle.getString("S_ERR_INVENTORY_VERSION");
                sMsg = MessageFormat.format(sMsg, minVer.getVerString());
                throw new OiiiInstallInventoryReadException(sMsg);
            }
            Vector homesAttached = handler.getAllHomes();
            if (homesAttached != null && homesAttached.size() > 0) {
                if (this.m_oHomesAttached == null) {
                    this.m_oHomesAttached = new HashMap();
                }
                this.m_oHomesAttached.put(remoteNode, homesAttached);
            }
            return handler.isAttached();
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_HOMELIST_ERROR"));
            return false;
        }
    }

    public List getHomes(String nodeName) {
        boolean bRead = false;
        if (this.m_remoteNodeInvRead != null && this.m_remoteNodeInvRead.get(nodeName) != null) {
            bRead = (Boolean)this.m_remoteNodeInvRead.get(nodeName);
        }
        if (!bRead) {
            try {
                this.initialize(nodeName);
            }
            catch (OiiiInstallInventoryReadException e) {
                e.printStackTrace();
                OiiolTextLogger.appendException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                OiiolTextLogger.appendException(e);
            }
            catch (OiipgRemoteOpsException e) {
                e.printStackTrace();
                OiiolTextLogger.appendException(e);
            }
        }
        Vector remoteHomesAttached = null;
        if (this.m_oHomesAttached != null) {
            remoteHomesAttached = (Vector)this.m_oHomesAttached.get(nodeName);
        }
        if (remoteHomesAttached != null) {
            Vector<String> homeLocs = new Vector<String>();
            for (int i = 0; i < remoteHomesAttached.size(); ++i) {
                OiiiRemoteHome remoteHome = (OiiiRemoteHome)remoteHomesAttached.elementAt(i);
                if (remoteHome.getLocation() == null) continue;
                homeLocs.add(remoteHome.getLocation());
            }
            return homeLocs;
        }
        return null;
    }

    public OiiiRemoteHome getRemoteHome(String nodeName, String homeLoc) {
        OiiiRemoteHome remoteHome = null;
        Vector vRemoteHomes = null;
        List remoteHomes = this.getHomes(nodeName);
        if (remoteHomes.indexOf(homeLoc) < 0) {
            return null;
        }
        if (this.m_oHomesAttached != null && (vRemoteHomes = (Vector)this.m_oHomesAttached.get(nodeName)) != null && vRemoteHomes.size() > 0) {
            for (int i = 0; !(i >= vRemoteHomes.size() || (remoteHome = (OiiiRemoteHome)vRemoteHomes.elementAt(i)) != null && remoteHome.getLocation().equals(homeLoc)); ++i) {
            }
        }
        if (remoteHome != null) {
            if (!remoteHome.isHomePropsRead()) {
                this.readOracleHomeProperties(nodeName, homeLoc, remoteHome);
            }
            if (!remoteHome.isCompsRead()) {
                this.readComps(nodeName, homeLoc, remoteHome);
            }
        }
        return remoteHome;
    }

    private void readOracleHomeProperties(String remoteNode, String homeLoc, OiiiRemoteHome remoteHome) {
        String localOHPropsFile = null;
        String remoteOHPropsFile = homeLoc;
        remoteOHPropsFile = OiixPathOps.concatPath(remoteOHPropsFile, "inventory");
        remoteOHPropsFile = OiixPathOps.concatPath(remoteOHPropsFile, "ContentsXML");
        remoteOHPropsFile = OiixPathOps.getStandardForm(remoteOHPropsFile);
        remoteOHPropsFile = OiixPathOps.directorify(remoteOHPropsFile);
        remoteOHPropsFile = OiixPathOps.getNativeForm(remoteOHPropsFile + "oraclehomeproperties.xml");
        try {
            if (OiipgClusterOps.fileExistsOnNode(remoteNode, remoteOHPropsFile)) {
                localOHPropsFile = this.generateOHPropLocOnLocal(remoteNode, remoteHome.getName());
                OiipgClusterOps.transferFileFromNode(remoteNode, remoteOHPropsFile, localOHPropsFile);
                OiiiOracleHomeInfoXMLReader OHInfoReader = OiiiOracleHomeInfoXMLReader.getOHInfoXMLReader();
                OHInfoReader.updateHomeProperties(remoteHome, localOHPropsFile);
                remoteHome.setHomePropsRead(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void readComps(String remoteNode, String homeLoc, OiiiRemoteHome remoteHome) {
        block6: {
            String localCompsFile = null;
            String remoteCompsFile = homeLoc;
            remoteCompsFile = OiixPathOps.concatPath(remoteCompsFile, "inventory");
            remoteCompsFile = OiixPathOps.concatPath(remoteCompsFile, "ContentsXML");
            remoteCompsFile = OiixPathOps.getStandardForm(remoteCompsFile);
            remoteCompsFile = OiixPathOps.directorify(remoteCompsFile);
            remoteCompsFile = OiixPathOps.getNativeForm(remoteCompsFile + "comps.xml");
            try {
                if (!OiipgClusterOps.fileExistsOnNode(remoteNode, remoteCompsFile)) break block6;
                localCompsFile = this.generateCompsLocOnLocal(remoteNode, remoteHome.getName());
                OiipgClusterOps.transferFileFromNode(remoteNode, remoteCompsFile, localCompsFile);
                int homeIndex = remoteHome.getIndex();
                int homeType = remoteHome.getHomeType();
                int platform = OiixPlatform.getCurrentPlatform();
                OiiiCompsXMLHandler handler = null;
                FileReader fReader = null;
                BufferedReader bReader = null;
                try {
                    Parser parser = OixsXMLOps.createSAXParser();
                    handler = new OiiiCompsXMLHandler(homeIndex, homeType, platform);
                    handler.setUseCompIdPool(false);
                    parser.setDocumentHandler(handler);
                    parser.setErrorHandler(handler);
                    try {
                        fReader = new FileReader(localCompsFile);
                        bReader = new BufferedReader(fReader);
                    }
                    catch (FileNotFoundException e) {
                        Object[] sArgs = new String[]{localCompsFile};
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
                    }
                    parser.parse(new InputSource(bReader));
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
                bReader.close();
                fReader.close();
                remoteHome.setInvInfo(handler.getComps());
                remoteHome.setCompsRead(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String generateOHPropLocOnLocal(String node, String homeName) {
        String ohPropLoc = System.getProperty("oracle.installer.scratchPath");
        ohPropLoc = OiixPathOps.getStandardForm(ohPropLoc);
        ohPropLoc = OiixPathOps.directorify(ohPropLoc);
        ohPropLoc = OiixPathOps.getNativeForm(ohPropLoc + "oraclehomeproperties.xml");
        ohPropLoc = ohPropLoc + "." + node + "." + homeName;
        return ohPropLoc;
    }

    private String generateCompsLocOnLocal(String node, String homeName) {
        String compsLoc = System.getProperty("oracle.installer.scratchPath");
        compsLoc = OiixPathOps.getStandardForm(compsLoc);
        compsLoc = OiixPathOps.directorify(compsLoc);
        compsLoc = OiixPathOps.getNativeForm(compsLoc + "comps.xml");
        compsLoc = compsLoc + "." + node + "." + homeName;
        return compsLoc;
    }
}

