/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.BitSet;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;

class OiiiCommonXMLHandlers {
    private OiiiCommonXMLHandlers() {
    }

    static class OiiiStageInfoElementHandler
    extends OixsElementHandler {
        private OiiiVersion m_stageVersion;

        public OiiiStageInfoElementHandler() {
            super("STG_INFO");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_stageVersion = null;
            String sVer = atts.getValue("OSP_VER");
            if (sVer != null) {
                this.m_stageVersion = new OiiiVersion(sVer);
            }
        }

        OiiiVersion getStageVersion() {
            return this.m_stageVersion;
        }
    }

    static class OiiiInstTypeElementHandler
    extends OixsElementHandler {
        private String m_sName;
        private OiisDeps m_oDeps;

        OiiiInstTypeElementHandler() {
            super("INST_TYPE");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_sName = atts.getValue("NAME");
            String sNameID = atts.getValue("NAME_ID");
            String sDescID = atts.getValue("DESC_ID");
            OiisDepMode depMode = new OiisDepMode(this.m_sName, sNameID, null);
            depMode.setDescription(sDescID);
            Vector<OiisDepMode> vDepModes = new Vector<OiisDepMode>(1);
            vDepModes.add(depMode);
            this.m_oDeps.setDepModes(vDepModes);
        }

        void setDeps(OiisDeps oDeps) {
            this.m_oDeps = oDeps;
        }

        String getInstallTypeName() {
            return this.m_sName;
        }
    }

    static class OiiiDestElementHandler
    extends OixsElementHandler {
        private OiisDestinationIndexMapping m_destIndexMap;

        OiiiDestElementHandler() {
            super("DST");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sDestList = atts.getValue("LIST");
            StringTokenizer st = new StringTokenizer(sDestList, " ");
            while (st.hasMoreTokens()) {
                String sDest = st.nextToken();
                this.m_destIndexMap.addDestination(sDest);
            }
            this.m_destIndexMap.commitInserts();
        }

        void setDestIndexMapping(OiisDestinationIndexMapping destIndexMap) {
            this.m_destIndexMap = destIndexMap;
        }
    }

    static class OiiiDestIndexMapElementHandler
    extends OixsElementHandler {
        private OiisDestinationIndexMapping m_destIndexMap;
        private OiiiDestElementHandler m_handlerDest = new OiiiDestElementHandler();

        OiiiDestIndexMapElementHandler() {
            super("DST_IDX_MAP");
            this.addChildHandler("DST", this.m_handlerDest);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_handlerDest.setDestIndexMapping(this.m_destIndexMap);
        }

        OiisDestinationIndexMapping getDestIndexMapping() {
            return this.m_destIndexMap;
        }

        void setDestIndexMapping(OiisDestinationIndexMapping destIndexMap) {
            this.m_destIndexMap = destIndexMap;
        }
    }

    static class OiiiPlatElementHandler
    extends OixsElementHandler {
        private OiisPlatIndexMapping m_platIndexMap;

        OiiiPlatElementHandler() {
            super("PLAT");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sList = atts.getValue("LIST");
            if (sList != null) {
                this.m_platIndexMap.addPlats(OiilXMLHelper.getIntArrFromString(sList, " "));
            }
        }

        void setPlatIndexMapping(OiisPlatIndexMapping platIndexMap) {
            this.m_platIndexMap = platIndexMap;
        }
    }

    static class OiiiPlatSetElementHandler
    extends OixsElementHandler {
        private OiisPlatIndexMapping m_platIndexMap;

        OiiiPlatSetElementHandler() {
            super("PLATSET");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sIdx = atts.getValue("IDX");
            String sBitSet = atts.getValue("BITSET");
            BitSet bs = OiilXMLHelper.getBitSetFromString(sBitSet);
            this.m_platIndexMap.addPlatSet(bs);
        }

        void setPlatIndexMapping(OiisPlatIndexMapping platIndexMap) {
            this.m_platIndexMap = platIndexMap;
        }
    }

    static class OiiiPlatIndexMapElementHandler
    extends OixsElementHandler {
        private OiisPlatIndexMapping m_platIndexMap;
        private OiiiPlatSetElementHandler m_handlerPlatSet = new OiiiPlatSetElementHandler();
        private OiiiPlatElementHandler m_handlerPlat;

        OiiiPlatIndexMapElementHandler() {
            super("PLAT_IDX_MAP");
            this.addChildHandler("PLATSET", this.m_handlerPlatSet);
            this.m_handlerPlat = new OiiiPlatElementHandler();
            this.addChildHandler("PLAT", this.m_handlerPlat);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_handlerPlatSet.setPlatIndexMapping(this.m_platIndexMap);
            this.m_handlerPlat.setPlatIndexMapping(this.m_platIndexMap);
        }

        OiisPlatIndexMapping getPlatIndexMapping() {
            return this.m_platIndexMap;
        }

        void setPlatIndexMapping(OiisPlatIndexMapping platIndexMap) {
            this.m_platIndexMap = platIndexMap;
        }
    }

    static class OiiiLangElementHandler
    extends OixsElementHandler {
        private OiisLangIndexMapping m_langIndexMap;

        OiiiLangElementHandler() {
            super("LANG");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sList = atts.getValue("LIST");
            if (sList != null) {
                Vector vLangs = OiixLanguage.strToVect(sList);
                Locale[] langs = new Locale[vLangs.size()];
                for (int i = 0; i < vLangs.size(); ++i) {
                    langs[i] = (Locale)vLangs.elementAt(i);
                }
                this.m_langIndexMap.addLangs(langs);
            }
        }

        void setLangIndexMapping(OiisLangIndexMapping langIndexMap) {
            this.m_langIndexMap = langIndexMap;
        }
    }

    static class OiiiLangSetElementHandler
    extends OixsElementHandler {
        private OiisLangIndexMapping m_langIndexMap;

        OiiiLangSetElementHandler() {
            super("LANGSET");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sIdx = atts.getValue("IDX");
            String sBitSet = atts.getValue("BITSET");
            BitSet bs = OiilXMLHelper.getBitSetFromString(sBitSet);
            this.m_langIndexMap.addLangSet(bs);
        }

        void setLangIndexMapping(OiisLangIndexMapping langIndexMap) {
            this.m_langIndexMap = langIndexMap;
        }
    }

    static class OiiiLangIndexMapElementHandler
    extends OixsElementHandler {
        private OiisLangIndexMapping m_langIndexMap;
        private OiiiLangSetElementHandler m_handlerLangSet = new OiiiLangSetElementHandler();
        private OiiiLangElementHandler m_handlerLang;

        OiiiLangIndexMapElementHandler() {
            super("LANG_IDX_MAP");
            this.addChildHandler("LANGSET", this.m_handlerLangSet);
            this.m_handlerLang = new OiiiLangElementHandler();
            this.addChildHandler("LANG", this.m_handlerLang);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_handlerLangSet.setLangIndexMapping(this.m_langIndexMap);
            this.m_handlerLang.setLangIndexMapping(this.m_langIndexMap);
        }

        OiisLangIndexMapping getLangIndexMapping() {
            return this.m_langIndexMap;
        }

        void setLangIndexMapping(OiisLangIndexMapping langIndexMap) {
            this.m_langIndexMap = langIndexMap;
        }
    }

    static class OiiiProdHomeElementHandler
    extends OixsElementHandler {
        private boolean m_bProdHomeDefined;

        OiiiProdHomeElementHandler() {
            super("PROD_HOME");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sDefined = atts.getValue("DEF");
            if (sDefined != null && sDefined.equalsIgnoreCase("T")) {
                this.m_bProdHomeDefined = true;
            }
        }

        boolean isProdHomeDefined() {
            return this.m_bProdHomeDefined;
        }
    }

    static class OiiiPreReqElementHandler
    extends OixsElementHandler {
        private boolean m_bPreReqDefined;

        OiiiPreReqElementHandler() {
            super("PRE_REQ");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sDefined = atts.getValue("DEF");
            if (sDefined != null && sDefined.equalsIgnoreCase("T")) {
                this.m_bPreReqDefined = true;
            }
        }

        boolean isPreReqDefined() {
            return this.m_bPreReqDefined;
        }
    }

    static class OiiiBookElementHandler
    extends OixsElementHandler {
        String m_sBookName;

        OiiiBookElementHandler() {
            super("BOOK");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_sBookName = atts.getValue("NAME");
            if (this.m_sBookName == null) {
                this.m_sBookName = "";
            }
        }

        String getBookName() {
            return this.m_sBookName;
        }
    }

    static class OiiiInfoElementHandler
    extends OixsElementHandler {
        private Properties m_properties;

        public OiiiInfoElementHandler() {
            super("INFO");
        }

        public void setProperties(Properties properties) {
            this.m_properties = properties;
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sName = atts.getValue("NAME");
            String sValue = atts.getValue("VAL");
            if (sName != null && sValue != null) {
                this.m_properties.setProperty(sName, sValue);
            }
        }
    }

    static class OiiiCompJarInfoElementHandler
    extends OixsElementHandler {
        OiisCompJarInfo m_compJarInfo;
        OiiiInfoElementHandler m_handlerInfo = new OiiiInfoElementHandler();

        public OiiiCompJarInfoElementHandler() {
            super("CMP_JAR_INFO");
            this.addChildHandler("INFO", this.m_handlerInfo);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_compJarInfo = new OiisCompJarInfo();
            this.m_handlerInfo.setProperties(this.m_compJarInfo.getProperties());
        }

        public OiisCompJarInfo getCompJarInfo() {
            return this.m_compJarInfo;
        }
    }

    static class OiiiLocInfoElementHandler
    extends OixsElementHandler {
        private String m_sJarLoc;
        private String m_sJarName;

        public OiiiLocInfoElementHandler() {
            super("LOC_INFO");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_sJarLoc = atts.getValue("INST_DFN_LOC");
            this.m_sJarName = atts.getValue("JAR_NAME");
        }

        public void onEnd(String name) {
        }

        public String getJarLoc() {
            return this.m_sJarLoc;
        }

        public String getJarName() {
            return this.m_sJarName;
        }
    }
}

