/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiClusterException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiCompositeHomeInventory;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiFileMapInventory;
import oracle.sysman.oii.oiii.OiiiHomeInvDetails;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReader;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallSerializedReader;
import oracle.sysman.oii.oiii.OiiiInstallXMLReader;
import oracle.sysman.oii.oiii.OiiiInstallXMLWriter;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryEnvUpdater;
import oracle.sysman.oii.oiii.OiiiInventoryException;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiObjectInputStream;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceStageProvider;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiTargetAreaMap;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolConfigLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolInstallLog;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLConfigLog;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLInstallLog;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceVariants;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiCompositeAreaControl
extends OiiiTargetAreaControl {
    public static final String PLATFORM_FILE_NAME = "install.platform";
    public static final String SECTION_NAME = "Platform";
    public static final String VARIABLE_NAME = "ID";
    public static final int INV_FILE_SIZE = 102400;
    public static final int INV_PLATFORM_FILE_SIZE = 1024;
    protected static OiiiTargetAreaControl s_invAreaControl;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    public static final String INSTALL_INV_FILENAME = "install.inventory";
    public static final String OHOME_FILENAME = "OracleHomesList";
    public static final String COMPS_LIST_FILENAME = "CompsList";
    public static final String PATCHES_LIST_FILENAME = "PatchesList";
    public static final String LIBS_FILENAME = "LibsList";
    public static final String INSTALLOG_FILENAME = "install.log";
    public static final String COMPCONTEXT_FILENAME = "context.ser";
    public static final String CONFIGLOG_FILENAME = "config.log";
    public static final String RESOURCES_DIR = "resources";
    private static final String FILE_EXTENSION = ".ser";
    private static final String INV_LOC = "Contents";
    private static final String LOGS_DIR = "logs";
    private static final String LOCKS_DIR = "locks";
    private static final String CLUSTER_DIR = "cluster";
    public static final String INVENTORY_DIR = "inventory";
    public static final String INVENTORY_BACKUP_DIR = "backup";
    public static final String XML_INSTALLLOG_FILENAME = "installlog.xml";
    public static final String XML_INVENTORY_FILENAME = "inventory.xml";
    private static final String XML_FILE_EXTENSION = "xml";
    public static final String XML_CONTENTS_DIR = "ContentsXML";
    public static final String XML_MAKE_DIR = "make";
    public static final String XML_COMPS_FILENAME = "comps.xml";
    public static final String XML_COMPS_NEW_FILENAME = "comps.new.xml";
    public static final String XML_COMPS_BACKUP_FILENAME = "comps.xml.bak";
    static final String XML_LIBS_FILENAME = "libs.xml";
    public static final String XML_OHINFO_FILENAME = "oraclehomeproperties.xml";
    private static final String XML_ACTIONS_DIR = "Actions21";
    private static final String XML_DIALOGS_DIR = "Dialogs21";
    private static final String XML_QUERIES_DIR = "Queries21";
    public static final String XML_COMPCONTEXT_FILENAME = "context.xml";
    public static final String XML_CONFIGLOG_FILENAME = "configlog.xml";
    public static final String XML_CONFIGTOOLS_FILENAME = "configtools.xml";
    public static final String XML_HOME_CENTRAL_INVENTORY = "central_inventory";
    public static final String XML_IP1_INSTALL_LOG_FILENAME = "installIP1Log.xml";
    public static final String XML_IP2_INSTALL_LOG_FILENAME = "installIP2Log.xml";
    public static final String XML_LINK_INSTALL_LOG_FILENAME = "installLinkLog.xml";
    public static final String XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX = "installLangAddonLog";
    public static final char XML_LANGADDON_INSTALL_LOG_FILENAME_SEPARATOR = '_';
    public static final String OH_LOG_DIR = "cfgtoollogs";
    public static final String CFGFW_LOG_DIR = "cfgfw";
    static final String XML_COMPONENTS_DIR = "Components21";
    static final String XML_PATCHES_DIR = "Patches21";
    static final String XML_PATCHSETS_DIR = "PatchSets21";
    static final String ONEOFFS_BINARY_FILENAME = "oneoffs";
    static final String ONEOFFS_BINARY_EXT = ".oo";
    static final String XML_ONEOFFS_DIR = "oneoffs";
    public static final String SCRIPTS_DIR = "Scripts";
    static final String PREREQS_DIR = "prereqs";
    static final String TEMPLATES_DIR = "Templates";
    static final String REMOVED_FILES_DIR = "RemovedFiles";
    public static final String COMPUTE_AT_CLONE_VARS_LIST = "computeAtCloneVars.txt";
    public static final String EXECUTE_TOOLS_AT_CLONE_LIST = "executeToolsAtClone.txt";
    public static final String CLONE_DIR = "Clone";
    private static final String CLONE_FILENAME = "clone.xml";
    private static final String ROOTSH_FILENAME = "root.sh";
    private static final String ORAINST_FILENAME = "oraInst.loc";
    private static final String GLOBALCONTEXT_FILENAME = "install/chainedInstall/globalcontext.xml";
    private static final String CONFIG_XML_DIR_RLT_PATH = "inventory/ContentsXML/ConfigXML/";
    private static final String OUI_CONFIG_VARIABLES_XML_FILE_NAME = "OuiConfigVariables";
    private static final String ADD_LANGUAGE_AGGREGATE_NAME = "AddLanguage";
    private static final String ENV_VARS_PROPERTIES_FILENAME = "envVars.properties";
    private static final String ENV_VARS_PROPERTIES_FILE_RLT_LOC = "install/";
    public static final int ACCESSLEVEL_READ = 0;
    public static final int ACCESSLEVEL_READWRITE = 1;
    private int m_nAccessLevel = 1;
    private static OiiiCompositeAreaControl s_instAreaControl;
    private transient OiiiInventoryEnvUpdater m_invEnvUpdater = null;
    private transient boolean m_bPartialLoad = false;
    private OiixSet m_synchLibIDs = null;
    private OiiiFileMapInventory m_fileMapInv = null;
    private OiiiSourceStageProvider m_sourceStageProvider = null;
    private boolean m_bDeinstallMode = false;
    private boolean m_bSaveCloneXMLInfo = false;

    private OiiiCompositeAreaControl(String installRoot) throws IOException {
        super(installRoot);
    }

    public void loadInstallInventory() throws IOException {
        OiiiCompositeHomeInventory installInv = this.initInstallInv();
        if (installInv != null) {
            installInv.setAreaControl(this);
            this.setAreaInventory(installInv);
            if (this.xmlInventoryExists() && !this.isReadOnlySession()) {
                try {
                    this.synchInstallInventory();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (OiifbCancelException oiifbCancelException) {
                    // empty catch block
                }
            }
        }
    }

    public void loadCompositeHomeInventory() throws IOException {
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        if (installInv != null) {
            // empty if block
        }
    }

    public Object loadObject(String fileName) {
        String path = this.genFileInvLoc(fileName + FILE_EXTENSION);
        FileInputStream fis = null;
        OiiiObjectInputStream ois = null;
        try {
            fis = new FileInputStream(path);
            ois = new OiiiObjectInputStream(fis);
            Object obj = ois.readObject();
            fis.close();
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    private OiiiCompositeHomeInventory loadPartialInstallInv() throws IOException {
        OiiiCompositeHomeInventory inv = new OiiiCompositeHomeInventory(this);
        this.setAreaInventory(inv);
        inv.readHomes();
        inv.initPartialLoad(inv.getHomes().size());
        return inv;
    }

    private boolean shouldPartialLoad() {
        return true;
    }

    private OiiiCompositeHomeInventory initInstallInv() throws IOException {
        if (!OiiiCompositeAreaControl.readPlatformFile(this.getAreaRoot())) {
            return null;
        }
        OiiiCompositeHomeInventory insInv = null;
        if (this.shouldPartialLoad()) {
            this.m_bPartialLoad = true;
            return this.loadPartialInstallInv();
        }
        String invPath = this.genFileSysLoc(INSTALL_INV_FILENAME);
        try {
            int i;
            FileInputStream fis = new FileInputStream(invPath);
            OiiiObjectInputStream ois = new OiiiObjectInputStream(fis);
            Object obj = ois.readObject();
            if (obj instanceof OiivVerIndObjectRep) {
                OiivVerIndObjectRep verIndInsInv = (OiivVerIndObjectRep)obj;
                insInv = (OiiiCompositeHomeInventory)verIndInsInv.getVerDepVersion();
                OiixDebug.printTime("OiiiCompositeAreaControl", "After conversion  ");
            } else if (obj instanceof OiiiCompositeHomeInventory) {
                insInv = (OiiiCompositeHomeInventory)obj;
            } else {
                throw new IOException(OiixResourceBundle.getString("S_UNKNOWN_CLASS"));
            }
            ois.close();
            fis.close();
            Vector oraHomesInfo = insInv.getHomes();
            int numHomes = oraHomesInfo.size();
            int[] homeInds = new int[numHomes + 1];
            homeInds[0] = 0;
            for (i = 0; i < numHomes; ++i) {
                homeInds[i + 1] = ((OiiiOracleHomeInfo)oraHomesInfo.elementAt(i)).getIndex();
            }
            for (i = 0; i <= numHomes; ++i) {
                int oh = homeInds[i];
                Enumeration en = insInv.getAllComps(oh);
                while (en.hasMoreElements()) {
                    OiiiInstallCompInvEntry ice = (OiiiInstallCompInvEntry)en.nextElement();
                    ice.setAreaControl(this);
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                e.printStackTrace();
            }
            insInv = new OiiiCompositeHomeInventory();
        }
        return insInv;
    }

    private void initFileMapInventory() {
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        if (installInv != null) {
            this.m_fileMapInv = new OiiiFileMapInventory(installInv.getHomes(), this.getAreaRoot());
        }
    }

    public OiiiFileMapInventory getFileMapInventory() {
        return this.m_fileMapInv;
    }

    public OiivVerIndObjectRep getVerIndInv() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getInstallInventory().getClass().getName());
        OiivVerIndObjectRep viHomes = (OiivVerIndObjectRep)this.loadObject(OHOME_FILENAME);
        Vector oracleHomes = new Vector();
        if (viHomes != null) {
            oracleHomes = (Vector)viHomes.getObjectForName("oracleHomes");
        }
        Vector<Vector> compOHsList = new Vector<Vector>();
        int numOHsList = oracleHomes.size() + 1;
        compOHsList.setSize(numOHsList);
        Vector inMemoryOracleHomes = this.getInstallInventory().getHomes();
        for (int ohInd = 0; ohInd < numOHsList; ++ohInd) {
            if (ohInd != 0) {
                int idx = OiixVectorOps.vectIndexOf(inMemoryOracleHomes, (Object)new Integer(ohInd));
                OiiiOracleHomeInfo oracleHomeInfo = null;
                if (idx != -1) {
                    oracleHomeInfo = (OiiiOracleHomeInfo)inMemoryOracleHomes.elementAt(idx);
                }
                if (oracleHomeInfo != null && !oracleHomeInfo.isDirty()) continue;
            }
            OiivVerIndObjectRep compsInfoObj = (OiivVerIndObjectRep)this.loadObject(COMPS_LIST_FILENAME + ohInd);
            Vector viCompsInfo = new Vector();
            if (compsInfoObj != null) {
                viCompsInfo = (Vector)compsInfoObj.getObjectForName("compsInfo");
            }
            OiivVerIndObjectRep patchesInfoObj = (OiivVerIndObjectRep)this.loadObject(PATCHES_LIST_FILENAME + ohInd);
            Vector vipatchesInfo = new Vector();
            if (patchesInfoObj != null) {
                vipatchesInfo = (Vector)patchesInfoObj.getObjectForName("compsInfo");
            }
            Vector compsInfo = OiivVerIndObjectRep.getVerDepFormOfVect(viCompsInfo);
            Vector patchesInfo = OiivVerIndObjectRep.getVerDepFormOfVect(vipatchesInfo);
            int nSize = compsInfo.size();
            for (int i = 0; i < nSize; ++i) {
                int nIndex;
                OiiiCompInvEntry entry = (OiiiCompInvEntry)compsInfo.elementAt(i);
                OiiiCompInstallID id = entry.getCompInstallID();
                if (id.getCompType() != 2 && id.getCompType() != 4 || (nIndex = OiixVectorOps.vectIndexOf(patchesInfo, (Object)id)) == -1) continue;
                viCompsInfo.setElementAt(vipatchesInfo.elementAt(nIndex), i);
            }
            compOHsList.setElementAt(viCompsInfo, ohInd);
        }
        retRep.addNVPair("compOHsList", compOHsList);
        Vector[] libsInfo = (Vector[])this.loadObject(LIBS_FILENAME);
        retRep.addNVPair("libsInfo", libsInfo);
        retRep.addNVPair("oracleHomes", oracleHomes);
        return retRep;
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ce) {
        PropertyResourceBundle rb = null;
        if (ce instanceof OiiiInstallCompInvEntry) {
            OiiiInstallCompInvEntry ice = (OiiiInstallCompInvEntry)ce;
            String resourceBaseXML = null;
            String sXMLInvLoc = ice.getLocationInXMLInventory();
            if (sXMLInvLoc != null) {
                resourceBaseXML = OiixPathOps.concatPath(this.getInventoryLocForHome(ice.getOHIndex()), sXMLInvLoc);
                resourceBaseXML = OiixPathOps.concatPath(resourceBaseXML, RESOURCES_DIR);
                resourceBaseXML = OiixPathOps.concatPath(resourceBaseXML, "CompID");
            }
            String resourceBase = this.genLogLoc(OiixPathOps.concatPath(ice.getLocation(), "resources/CompID"));
            boolean foundResource = false;
            Enumeration vars = OiixResourceVariants.genResourceVariants();
            while (!foundResource && vars.hasMoreElements()) {
                String sVariant = (String)vars.nextElement();
                String resLoc = null;
                String natResLoc = null;
                boolean bCheckXMLLoc = resourceBaseXML != null;
                boolean bCheckBinLoc = true;
                if (bCheckXMLLoc) {
                    resLoc = resourceBaseXML + sVariant + ".properties";
                    natResLoc = OiixPathOps.getNativeForm(resLoc);
                    foundResource = new File(natResLoc).exists();
                    boolean bl = bCheckBinLoc = !foundResource;
                }
                if (bCheckBinLoc) {
                    resLoc = resourceBase + sVariant + ".properties";
                    natResLoc = OiixPathOps.getNativeForm(resLoc);
                    if (!new File(natResLoc).exists()) continue;
                    foundResource = true;
                }
                try {
                    FileInputStream is = new FileInputStream(natResLoc);
                    rb = new PropertyResourceBundle(is);
                    is.close();
                }
                catch (Exception exp) {
                    System.out.println("Cannot load resource for " + ice);
                    exp.printStackTrace();
                }
            }
        }
        return rb;
    }

    public OiiiCompositeHomeInventory getInstallInventory() {
        return (OiiiCompositeHomeInventory)this.getAreaInventory();
    }

    public static OiiiTargetAreaControl getInventoryAreaControl() {
        return s_invAreaControl;
    }

    public void propagateInventoryToNodes(String oracleHome, String[] nodeList) throws OiiiClusterException {
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        if (installInv != null) {
            installInv.propagateInventoryToNodes(oracleHome, nodeList);
        }
    }

    public void saveInstallInventory() throws IOException, OiifbCancelException {
        this.saveInstallInventory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveInstallInventory(String[] nodeList) throws IOException, OiifbCancelException {
        OiivVerIndObjectRep verIndInstInv;
        OiiiCompositeHomeInventory installInv;
        String invPath;
        block16: {
            OiiolTextLogger.appendText("Saving the install inventory which has the access of " + this.m_nAccessLevel);
            if (this.m_nAccessLevel < 1) {
                throw new IOException("Current access level does not allow writing to the inventory");
            }
            invPath = this.genFileSysLoc(INSTALL_INV_FILENAME);
            File oldInventoryFile = new File(invPath = OiixPathOps.getNativeForm(invPath));
            if (oldInventoryFile.exists()) {
                oldInventoryFile.delete();
            }
            installInv = null;
            verIndInstInv = null;
            if (this.m_bPartialLoad) {
                verIndInstInv = this.getVerIndInv();
            } else {
                FileInputStream fis;
                block17: {
                    fis = null;
                    ObjectInputStream ois = null;
                    try {
                        Object var10_11;
                        block15: {
                            try {
                                fis = new FileInputStream(invPath);
                                ois = new OiiiObjectInputStream(fis);
                                Object obj = ois.readObject();
                                if (!(obj instanceof OiivVerIndObjectRep)) break block15;
                                verIndInstInv = (OiivVerIndObjectRep)obj;
                            }
                            catch (Exception e) {
                                var10_11 = null;
                                if (ois != null) {
                                    ois.close();
                                }
                                if (fis != null) {
                                    fis.close();
                                }
                                break block16;
                            }
                        }
                        var10_11 = null;
                        if (ois == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        if (ois != null) {
                            ois.close();
                        }
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
        }
        installInv = this.getInstallInventory();
        verIndInstInv = verIndInstInv == null ? installInv.getVerIndRep() : installInv.mergeVerIndRep(verIndInstInv);
        this.writeInstallInv(verIndInstInv, nodeList);
        String fName = INSTALL_INV_FILENAME;
        int index = invPath.indexOf(fName);
        String invPathLoc = invPath.substring(0, invPath.length() - fName.length());
        OiiiCompositeAreaControl.writePlatformFile(invPathLoc);
        if (this.m_invEnvUpdater != null) {
            this.m_invEnvUpdater.updateEnv(installInv);
        }
        installInv.logInvToLogFile();
        Vector oracleHomes = installInv.getHomes();
        if (oracleHomes == null) return;
        int n = oracleHomes.size();
        int nSize = n;
        int i = 0;
        while (i < nSize) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)oracleHomes.elementAt(i);
            ohi.setDirty(false);
            ++i;
        }
        return;
    }

    private void writeInstallInv(OiivVerIndObjectRep installInv, String[] nodeList) throws IOException, OiifbCancelException {
        boolean bSupportBinaryInv;
        OiiiCompositeHomeInventory verDepInstallInv = this.getInstallInventory();
        String sContentsDir = this.genFileSysLoc(INV_LOC);
        File f = new File(sContentsDir);
        boolean bSaveRequired = true;
        if (!f.exists() && (bSupportBinaryInv = Boolean.getBoolean("oracle.installer.supportBinaryInventory"))) {
            OiixFileOps.mkdirs(f);
            if (!f.exists()) {
                String sMsg = OiixResourceBundle.getString("S_INV_SETUP_ERR");
                throw new IOException(sMsg);
            }
        }
        this.updateHomes(verDepInstallInv);
        while (bSaveRequired) {
            try {
                verDepInstallInv.saveInventory(installInv, nodeList);
                bSaveRequired = false;
            }
            catch (IOException e) {
                if (!OiipgFileSystem.isSpaceAvailable(409600L, sContentsDir)) {
                    try {
                        OiixFileOps.validateDiskSpace(409600L, sContentsDir, false, true);
                    }
                    catch (OiifbCancelException e1) {
                        // empty catch block
                    }
                    bSaveRequired = true;
                    continue;
                }
                throw e;
            }
        }
    }

    private void updateHomes(OiiiCompositeHomeInventory instInv) {
        Vector vHomes = instInv.getAllOUIHomes();
        Vector<OiiiOracleHomeInfo> vUpdatedHomes = new Vector<OiiiOracleHomeInfo>(vHomes.size());
        for (int i = 0; i < vHomes.size(); ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            try {
                if (homeInfo.isRemoved()) {
                    OiipgOracleHomes.removeHome(homeInfo.getLocation(), homeInfo.getName());
                    continue;
                }
                vUpdatedHomes.add(homeInfo);
                if (homeInfo.isRenamed()) {
                    OiipgOracleHomes.updateHomeName(homeInfo.getOldName(), homeInfo.getLocation(), homeInfo.getName());
                    homeInfo.setRenamed(false);
                    continue;
                }
                if (!homeInfo.isMoved()) continue;
                OiipgOracleHomes.updateHomePath(homeInfo.getName(), homeInfo.getLocation());
                homeInfo.setMoved(false);
                continue;
            }
            catch (OiilNativeException ne) {
                ne.printStackTrace();
            }
        }
        instInv.setHomes(vUpdatedHomes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeObjToFile(String fileName, Object obj) throws IOException, OiifbCancelException {
        fileName = this.genFileInvLoc(fileName + FILE_EXTENSION);
        boolean bSaveRequired = true;
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        while (bSaveRequired) {
            Object var9_8;
            try {
                try {
                    fos = new FileOutputStream(fileName);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(obj);
                    oos.flush();
                    bSaveRequired = false;
                }
                catch (IOException e) {
                    if (OiipgFileSystem.isSpaceAvailable(102400L, fileName)) {
                        throw e;
                    }
                    try {
                        OiixFileOps.validateDiskSpace(102400L, fileName, false, true);
                    }
                    catch (OiifbCancelException e1) {
                        // empty catch block
                    }
                    bSaveRequired = true;
                    var9_8 = null;
                    if (oos == null) continue;
                    oos.close();
                    continue;
                }
                var9_8 = null;
                if (oos == null) continue;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                if (oos != null) {
                    oos.close();
                }
                throw throwable;
            }
            oos.close();
        }
        return;
    }

    public void setInvEnvUpdater(OiiiInventoryEnvUpdater invEnvUpdater) {
        this.m_invEnvUpdater = invEnvUpdater;
    }

    OiiiStageInventory getSourceStageInventory() {
        OiiiStageInventory stageInv = null;
        if (this.m_sourceStageProvider != null) {
            stageInv = this.m_sourceStageProvider.getStageInventory();
        }
        return stageInv;
    }

    public void setSourceStageProvider(OiiiSourceStageProvider stageProvider) {
        this.m_sourceStageProvider = stageProvider;
    }

    String getAvailableInstallJarName(int homeIndex, int startIndex) {
        String sScriptsLoc = this.getScriptsLoc(homeIndex);
        String sInstall = "install";
        String sDotJar = ".jar";
        String sRetVal = null;
        boolean bFound = false;
        int index = startIndex;
        while (!bFound) {
            String sCurName = sInstall + index + sDotJar;
            String sLoc = OiixPathOps.concatPath(sScriptsLoc, sCurName);
            File f = new File(sLoc = OiixPathOps.getNativeForm(sLoc));
            if (f.exists()) {
                ++index;
                continue;
            }
            sRetVal = sCurName;
            bFound = true;
        }
        return sRetVal;
    }

    public static OiiiCompositeAreaControl getInstallAreaControl() {
        return s_instAreaControl;
    }

    public static void dispose() {
        s_instAreaControl = null;
    }

    private void setAccessLevel(int nAccessLevel) {
        if (nAccessLevel != 0 && nAccessLevel != 1) {
            throw new IllegalArgumentException("Invalid access level: " + nAccessLevel);
        }
        this.m_nAccessLevel = nAccessLevel;
    }

    public int getAccessLevel() {
        return this.m_nAccessLevel;
    }

    public boolean isReadOnlySession() {
        return this.getAccessLevel() == 0;
    }

    public String getLogsLoc() {
        return this.genLogLoc(LOGS_DIR);
    }

    public String getLocksDir() {
        return OiixPathOps.concatPath(this.getAreaRoot(), LOCKS_DIR);
    }

    public static void setInventoryAreaControl(OiiiTargetAreaControl invAreaCtrl) {
        s_invAreaControl = invAreaCtrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initAreaControl(int nAccessLevel) throws IOException, OiiiInventoryDoesNotExistException {
        File oInvDir;
        String locationFileLoc;
        String sInvLoc = null;
        try {
            String invLoc;
            sInvLoc = Boolean.getBoolean("oracle.installer.attachHome") || Boolean.getBoolean("oracle.installer.removeHome") || Boolean.getBoolean("oracle.installer.updateNodeList") ? ((locationFileLoc = System.getProperty("oracle.installer.inventory_location")) != null ? locationFileLoc : new OiipgPropertyLoader().getLocationFileLoc()) : ((invLoc = System.getProperty("oracle.installer.custom_inventory")) != null && invLoc != "" ? invLoc : new OiipgPropertyLoader().getLocationFileLoc());
        }
        catch (IOException e) {
            // empty catch block
        }
        if (sInvLoc == null) {
            if (!(Boolean.getBoolean("oracle.installer.attachHome") || Boolean.getBoolean("oracle.installer.removeHome") || Boolean.getBoolean("oracle.installer.updateNodeList"))) {
                new OiipgPropertyLoader();
                String ptrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
                throw new OiiiInventoryDoesNotExistException(OiixResourceBundle.getString("S_ERROR_INVENTORY_PTR_NOT_EXIST", new String[]{ptrLoc}));
            }
            locationFileLoc = System.getProperty("oracle.installer.inventory_location");
            sInvLoc = locationFileLoc != null ? locationFileLoc : new OiipgBootstrap().getDefaultLocationFileLoc();
            try {
                OiiiCompositeAreaControl.createInventory(sInvLoc, null);
            }
            catch (IOException e) {
            }
            catch (OiiiInventoryException oie) {}
        } else if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
            try {
                OiiiCompositeAreaControl.createInventory(sInvLoc, null);
            }
            catch (IOException e) {
            }
            catch (OiiiInventoryException oie) {
                // empty catch block
            }
        }
        if (!(oInvDir = new File(sInvLoc)).exists() && nAccessLevel == 0) {
            throw new OiiiInventoryDoesNotExistException(OiixResourceBundle.getString("S_ERROR_INVENTORY_LOC_NOT_EXIST", new String[]{sInvLoc}));
        }
        if (oInvDir.exists() && (!oInvDir.canRead() || oInvDir.list() == null)) {
            String sMsg = OiixResourceBundle.getString("S_ERR_INV_LOC_NOT_READABLE");
            Object[] arg = new String[]{sInvLoc};
            sMsg = MessageFormat.format(sMsg, arg);
            throw new OiiiInstallInventoryReadException(sMsg);
        }
        OiiiCompositeAreaControl.initAreaControl(sInvLoc, nAccessLevel);
    }

    public static void initAreaControl(String invLoc) throws IOException {
        OiiiCompositeAreaControl.initAreaControl(invLoc, 1);
    }

    public static void initAreaControl(String invLoc, int nAccessLevel) throws IOException {
        OiiiCompositeAreaControl.initAreaControl(invLoc, nAccessLevel, false);
    }

    public static void initAreaControl(String invLoc, int nAccessLevel, boolean bcreateDirectories) throws IOException {
        try {
            OiiiCompositeAreaControl retval = null;
            try {
                File inFile = new File(invLoc);
                if (bcreateDirectories && !inFile.exists()) {
                    OiixFileOps.mkdirs(inFile);
                }
                retval = new OiiiCompositeAreaControl(invLoc);
                retval.setAccessLevel(nAccessLevel);
                OiiolTextLogger.appendText("Install area Control created with access level  " + nAccessLevel);
                s_instAreaControl = retval;
                retval.loadInstallInventory();
                retval.loadCompositeHomeInventory();
                retval.initFileMapInventory();
            }
            catch (OiiiInstallInventoryReadException e) {
                throw e;
            }
            catch (IOException ioe) {
                retval = null;
            }
            if (retval != null) {
                // empty if block
            }
            OiiiCompositeAreaControl.setInventoryAreaControl(retval);
            s_instAreaControl = retval;
            if (OiiiCompositeAreaControl.getInstallAreaControl().getInstallInventory() != null) {
                OiiiCompositeAreaControl.assignOracleHomeNames();
            }
        }
        catch (OiiiInstallInventoryReadException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void assignOracleHomeNames() {
        String[] homeNames = null;
        try {
            homeNames = OiipgOracleHomes.getAllOracleHomeNames();
        }
        catch (OiilNativeException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int runningCount = 1;
        Vector homes = OiiiCompositeAreaControl.getInstallAreaControl().getInstallInventory().getHomes();
        int nHomes = homes != null ? homes.size() : 0;
        for (int i = 0; i < nHomes; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
            String name = homeInfo.getName();
            if (name != null && !name.equals("")) continue;
            do {
                name = "ORACLE_HOME" + runningCount;
                ++runningCount;
            } while (OiiiCompositeAreaControl.isDuplicateName(name, homeNames));
            homeInfo.setName(name);
        }
    }

    private static boolean isDuplicateName(String name, String[] homeNames) {
        if (homeNames == null) {
            return false;
        }
        for (int i = 0; i < homeNames.length; ++i) {
            if (!homeNames[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void writeOHInvLoc(String sOHLoc) {
        block10: {
            if (!OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                return;
            }
            String sInvPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            if (sInvPtrLoc == null) {
                return;
            }
            try {
                String fLoc = OiixPathOps.concatPath(sOHLoc, ORAINST_FILENAME);
                if (OiipgFileSystem.equalPathStrs(sInvPtrLoc, fLoc)) break block10;
                File fInvPtrLocFile = new File(sInvPtrLoc);
                String inventoryLoc = System.getProperty("oracle.installer.custom_inventory");
                if (fInvPtrLocFile.exists() && (inventoryLoc == null || inventoryLoc == "")) {
                    OiixFileOps.copyFile(sInvPtrLoc, fLoc, true, false, false, true, "0640", null, null, null, false);
                    break block10;
                }
                String invLoc = OiiiCompositeAreaControl.getInstallAreaControl().genFileSysLoc(ORAINST_FILENAME);
                OiipgBootstrap bs = new OiipgBootstrap();
                if (new File(invLoc).exists()) {
                    OiixFileOps.copyFile(invLoc, fLoc, true, false, false, true, "0640", null, null, null, false);
                } else {
                    String sDefInvLoc = OiiiCompositeAreaControl.getDefaultInventoryLocation();
                    try {
                        bs.updateInventoryLoc(null, sDefInvLoc, null);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    bs.modifyUnixInstallFile(sDefInvLoc, fLoc);
                }
                if (!Boolean.getBoolean("oracle.installer.attachHome")) {
                    return;
                }
                Object[] objectArray = new String[1];
                objectArray[0] = OiipgBootstrap.S_UNIX_ROOT_SCRIPT_NAME;
                Object[] argV = objectArray;
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_BS_EXEC_ROOTSH_ATTACHHOME", argV);
                OiiolTextLogger.writeMessageToConsole(sMsg);
                OiiolTextLogger.appendText(sMsg);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void writeOraInstLocFile(String sOHLoc, String sInvLoc) throws IOException {
        String fLoc = OiixPathOps.concatPath(sOHLoc, ORAINST_FILENAME);
        FileOutputStream fOut = new FileOutputStream(fLoc);
        Properties propsout = new Properties();
        propsout.put("inventory_loc", sInvLoc);
        propsout.save(fOut, null);
        fOut.close();
    }

    public static boolean writePlatformFile(String location) {
        String fLoc = OiixPathOps.concatPath(location, PLATFORM_FILE_NAME);
        Integer platId = new Integer(OiixPlatform.getCurrentPlatform());
        boolean bSaveRequired = true;
        OiixIniFile iFile = new OiixIniFile(fLoc);
        iFile.setProfileString(SECTION_NAME, VARIABLE_NAME, platId.toString());
        while (bSaveRequired) {
            try {
                iFile.writeIniFile();
                bSaveRequired = false;
            }
            catch (IOException e) {
                if (!OiipgFileSystem.isSpaceAvailable(1024L, location)) {
                    try {
                        OiixFileOps.validateDiskSpace(1024L, location, false, true);
                    }
                    catch (OiifbCancelException e1) {
                        // empty catch block
                    }
                    bSaveRequired = true;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean readPlatformFile(String location) {
        String fLoc = OiixPathOps.concatPath(location, PLATFORM_FILE_NAME);
        Integer platId = new Integer(OiixPlatform.getCurrentPlatform());
        try {
            OiixIniFile iFile = new OiixIniFile(fLoc);
            String defValue = "";
            String pID = iFile.getProfileString(SECTION_NAME, VARIABLE_NAME, defValue);
            if (OiipgPropertyLoader.getWOW64()) {
                return true;
            }
            if (!pID.equalsIgnoreCase(platId.toString())) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeInvDetails(int homeIndex) throws IOException {
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        String outFile = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), "invDetails.properties");
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(outFile);
                invDetails.write(fos);
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var7_6 = null;
                fos.close();
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    public String genFileInvLoc(String relLoc) {
        String sPath = this.genFileSysLoc(INV_LOC);
        return OiixPathOps.concatPath(sPath, relLoc);
    }

    public String getXMLCompRelativeLoc(OiiiCompInstallID cid, int homeIndex) {
        String sXMLLoc = this.getXMLCollectionDir(cid.getCompType()) + "/" + cid.getName() + "/" + cid.getVersion() + "/";
        return sXMLLoc;
    }

    public String getXMLCompFullLoc(OiiiCompInstallID cid, int homeIndex) {
        String sLoc = this.getXMLCompRelativeLoc(cid, homeIndex);
        sLoc = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), sLoc);
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getXMLOneoffsLoc(int homeIndex) {
        String sLoc = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), "oneoffs");
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getOHInventoryLoc(String homeLoc) {
        String standardOHPath = OiixPathOps.getStandardForm(homeLoc);
        standardOHPath = OiixPathOps.directorify(standardOHPath);
        String invDir = OiixPathOps.concatPath(standardOHPath, INVENTORY_DIR);
        return OiixPathOps.getNativeForm(invDir);
    }

    public String getXMLHomeLogsDir(int homeIndex) {
        String sLoc = this.getInstallInventory().getHomeLocation(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, OH_LOG_DIR);
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getOHClusterLoc(String homeLoc) {
        String homeLocStandard = OiixPathOps.getStandardForm(homeLoc);
        homeLocStandard = OiixPathOps.directorify(homeLocStandard);
        String clusterLocStandard = homeLocStandard + INVENTORY_DIR + '/' + CLUSTER_DIR;
        return OiixPathOps.getNativeForm(clusterLocStandard);
    }

    public String getOHClusterLoc(int homeIndex) {
        String sLoc = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), CLUSTER_DIR);
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getXMLOneoffFullLoc(OiiiOneoffInstallID oid, int homeIndex) {
        String sLoc = "oneoffs";
        sLoc = OiixPathOps.concatPath(sLoc, oid.getID());
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getXMLLibRelativeLoc(OiiiLibraryID lid, int type, int homeIndex) {
        String sDir = "";
        switch (type) {
            case 0: {
                sDir = XML_ACTIONS_DIR;
                break;
            }
            case 1: {
                sDir = XML_QUERIES_DIR;
                break;
            }
            case 2: {
                sDir = XML_DIALOGS_DIR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown library type: " + type);
            }
        }
        String sXMLLoc = sDir + "/" + lid.getName() + "/" + lid.getVersion() + "/";
        return sXMLLoc;
    }

    private String getXMLCollectionDir(int compType) {
        switch (compType) {
            case 1: {
                return XML_COMPONENTS_DIR;
            }
            case 2: {
                return XML_PATCHES_DIR;
            }
            case 4: {
                return XML_PATCHSETS_DIR;
            }
        }
        throw new IllegalArgumentException("Unknown component type: " + compType);
    }

    public String getOracleHomesFileLoc() {
        return this.genFileInvLoc("OracleHomesList.ser");
    }

    public String getInventoryFileLoc(String invLoc) {
        if (invLoc == null) {
            return this.getInventoryFileLoc();
        }
        String invFileLoc = OiixPathOps.getStandardForm(invLoc);
        invFileLoc = OiixPathOps.directorify(invFileLoc);
        invFileLoc = invFileLoc + XML_CONTENTS_DIR + '/' + XML_INVENTORY_FILENAME;
        return invFileLoc;
    }

    public String getInventoryFileLoc() {
        String sFileName = XML_INVENTORY_FILENAME;
        String sPath = this.getContentsDir(0);
        return OiixPathOps.concatPath(sPath, sFileName);
    }

    String getContentsDir(int homeIndex) {
        String sPath = "";
        if (homeIndex == 0) {
            sPath = this.genFileSysLoc(XML_CONTENTS_DIR);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(homeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, XML_CONTENTS_DIR);
            sPath = OiixPathOps.directorify(sPath);
        }
        return sPath;
    }

    public String getXMLCompsFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getCompsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String getXMLCompsFileLoc(String sHomeLoc) {
        block11: {
            sLoc = OiixPathOps.concatPath(sHomeLoc, "inventory");
            sDetailsLoc = OiixPathOps.concatPath(sLoc, "invDetails.properties");
            sDetailsLoc = OiixPathOps.getNativeForm(sDetailsLoc);
            invDetails = null;
            fis = null;
            try {
                fis = new FileInputStream(sDetailsLoc);
                invDetails = OiiiHomeInvDetails.load(fis);
                var7_5 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var6_12) {
                var7_7 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var6_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (IOException e) {
                    invDetails = OiiiHomeInvDetails.getDefault();
                    var7_6 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        sLoc = OiixPathOps.concatPath(sLoc, "ContentsXML");
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getCompsFileName());
        return sLoc;
    }

    public static String getConfigToolLogsLoc(String sHomeLoc) {
        String sConfigToolLogsLoc = OiixPathOps.concatPath(sHomeLoc, OH_LOG_DIR);
        String sCfggwLogsLoc = OiixPathOps.concatPath(sConfigToolLogsLoc, CFGFW_LOG_DIR);
        return sCfggwLogsLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String getOHPropertiesFileLoc(String sHomeLoc) {
        block11: {
            sOHPropertiesFileLoc = null;
            sLoc = OiixPathOps.concatPath(sHomeLoc, "inventory");
            sDetailsLoc = OiixPathOps.concatPath(sLoc, "invDetails.properties");
            sDetailsLoc = OiixPathOps.getNativeForm(sDetailsLoc);
            invDetails = null;
            fis = null;
            try {
                fis = new FileInputStream(sDetailsLoc);
                invDetails = OiiiHomeInvDetails.load(fis);
                var8_6 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var7_13) {
                var8_8 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var7_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (IOException e) {
                    invDetails = OiiiHomeInvDetails.getDefault();
                    var8_7 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        sOHPropertiesFileLoc = OiiiCompositeAreaControl.getContentsDirForHome(sHomeLoc);
        sOHPropertiesFileLoc = OiixPathOps.concatPath(sOHPropertiesFileLoc, invDetails.getOHPropsFileName());
        return sOHPropertiesFileLoc;
    }

    public String getOHPropertiesFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getOHPropsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    public String getCHPropertiesFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getOHPropsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    private static String getContentsDirForHome(String sHomeLoc) {
        String sContentsXMLLoc = null;
        sContentsXMLLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        sContentsXMLLoc = OiixPathOps.concatPath(sContentsXMLLoc, XML_CONTENTS_DIR);
        sContentsXMLLoc = OiixPathOps.directorify(sContentsXMLLoc);
        return sContentsXMLLoc;
    }

    public static String getMakeDirForHome(String sHomeLoc) {
        String sMakeXMLLoc = null;
        sMakeXMLLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        sMakeXMLLoc = OiixPathOps.concatPath(sMakeXMLLoc, XML_MAKE_DIR);
        sMakeXMLLoc = OiixPathOps.directorify(sMakeXMLLoc);
        return sMakeXMLLoc;
    }

    public String getSerializedCompsFileLoc(int homeIndex) {
        String sLoc = COMPS_LIST_FILENAME + homeIndex + FILE_EXTENSION;
        sLoc = this.genFileInvLoc(sLoc);
        return sLoc;
    }

    public String getXMLLibsFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getLibsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    public String getSerializedLibsFileLoc() {
        return this.genFileInvLoc("LibsList.ser");
    }

    String getCloneFileLoc(int homeIndex) {
        String sLoc = this.getInventoryLocForHome(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_FILENAME);
        return sLoc;
    }

    String getCloneFileLoc(String sHomeLoc) {
        String sLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_FILENAME);
        return sLoc;
    }

    public String getPrereqsLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), PREREQS_DIR);
    }

    public String getScriptsLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), SCRIPTS_DIR);
    }

    String getComputeAtCloneFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getScriptsLoc(homeIndex), COMPUTE_AT_CLONE_VARS_LIST);
    }

    public String getExecuteToolsAtCloneFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getScriptsLoc(homeIndex), EXECUTE_TOOLS_AT_CLONE_LIST);
    }

    public String getTemplatesLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), TEMPLATES_DIR);
    }

    public String getRemovedFilesLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), REMOVED_FILES_DIR);
    }

    String getInvDetailsFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), "invDetails.properties");
    }

    String getStageInventoryFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getScriptsLoc(homeIndex), "products.xml");
    }

    public void setDeinstallMode(boolean mode) {
        this.m_bDeinstallMode = mode;
    }

    public boolean isDeinstallMode() {
        return this.m_bDeinstallMode;
    }

    public void setSaveCloneXMLInfo(boolean bSaveCloneXMLInfo) {
        this.m_bSaveCloneXMLInfo = bSaveCloneXMLInfo;
    }

    public boolean canSaveCloneXMLInfo() {
        return this.m_bSaveCloneXMLInfo;
    }

    public OiiiInstallInventoryReader getReaderForHome(int homeIndex) {
        OiiiInstallInventoryReader reader = null;
        reader = this.compsOutOfSynch(homeIndex) ? OiiiInstallSerializedReader.getReader() : OiiiInstallXMLReader.getReader();
        return reader;
    }

    public OiiiInstallInventoryReader getReaderForOracleHomes() {
        OiiiInstallInventoryReader reader = null;
        reader = this.homesOutOfSynch() ? OiiiInstallSerializedReader.getReader() : OiiiInstallXMLReader.getReader();
        return reader;
    }

    public void synchInstallInventory() throws IOException, OiifbCancelException {
        boolean bSupportBinaryInv = Boolean.getBoolean("oracle.installer.supportBinaryInventory");
        if (!bSupportBinaryInv) {
            return;
        }
        this.synchHomes();
        OiiiCompositeHomeInventory inventory = this.getInstallInventory();
        Vector homes = inventory.getHomes();
        for (int i = 0; i < homes.size(); ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
            int homeIndex = homeInfo.getIndex();
            this.synchComps(homeIndex);
        }
        this.synchComps(0);
    }

    private void synchHomes() throws IOException {
        if (!this.homesOutOfSynch()) {
            return;
        }
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_SYNCH_HOMES"));
        Vector homes = this.getInstallInventory().getHomes();
        if (homes == null) {
            homes = OiiiInstallSerializedReader.getReader().readHomes();
        }
        this.getInstallInventory().setHomes(homes);
        OiiiInstallXMLWriter.getWriter().writeHomes();
    }

    private void synchComps(int homeIndex) throws IOException, OiifbCancelException {
        OiiiCompositeHomeInventory inventory;
        if (!this.compsOutOfSynch(homeIndex)) {
            return;
        }
        Vector serializedComps = null;
        try {
            OiiiInvHomeInfo oihi = OiiiInstallSerializedReader.getReader().readComps(homeIndex);
            serializedComps = oihi.getCompsVect();
        }
        catch (IOException e) {
            serializedComps = new Vector();
        }
        if (serializedComps == null || serializedComps.isEmpty()) {
            return;
        }
        try {
            this.m_synchLibIDs = new OiixSet("oracle.sysman.oii.oiii.OiiiLibraryID");
        }
        catch (OiixInvalidDataException e) {
            e.printStackTrace();
            this.m_synchLibIDs = null;
        }
        String sLogMsg = OiixResourceBundle.getString("S_SYNCH_COMPS");
        String sHomeName = null;
        if (homeIndex == 0) {
            sHomeName = OiixResourceBundle.getString("S_INDEP_PRODS_LABEL");
        } else {
            OiiiOracleHomeInfo homeInfo = this.getInstallInventory().getHomeInfo(homeIndex);
            sHomeName = homeInfo.getName();
            String sHomeLoc = homeInfo.getLocation();
            try {
                OiipgFileSystem.checkWritablePath(sHomeLoc);
                OiipgFileSystem.checkWritablePath(this.getContentsDir(homeIndex));
            }
            catch (OiipgPathException e) {
                String sMsg = OiixResourceBundle.getString("S_ERROR_SYNCH_PERMISSION");
                sMsg = MessageFormat.format(sMsg, sHomeName, sHomeLoc);
                OiiolTextLogger.appendText(sMsg);
                return;
            }
        }
        Object[] homeName = new String[]{sHomeName};
        sLogMsg = MessageFormat.format(sLogMsg, homeName);
        OiiolTextLogger.appendText(sLogMsg);
        sLogMsg = OiixResourceBundle.getString("S_SYNCH_COMP");
        MessageFormat logMsgFormat = new MessageFormat(sLogMsg);
        Vector xmlComps = null;
        Vector mergedComps = new Vector();
        try {
            OiiiInvHomeInfo xmlOihi = OiiiInstallXMLReader.getReader().readComps(homeIndex);
            xmlComps = xmlOihi.getCompsVect();
        }
        catch (IOException e) {
            xmlComps = new Vector();
        }
        if (serializedComps.size() == 0 && xmlComps.size() == 0 && homeIndex != 0) {
            inventory = this.getInstallInventory();
            inventory.setAllCompsVect(homeIndex, new Vector());
            return;
        }
        this.syncCompsImpl(serializedComps, xmlComps, mergedComps, homeIndex);
        inventory = this.getInstallInventory();
        inventory.setAllCompsVect(homeIndex, mergedComps);
        inventory.setupRefsForVect(homeIndex);
        OiiiInstallXMLWriter.getWriter().writeComps(homeIndex);
        sLogMsg = OiixResourceBundle.getString("S_SYNCH_LIBS");
        sLogMsg = MessageFormat.format(sLogMsg, homeName);
        OiiolTextLogger.appendText(sLogMsg);
        this.synchLibs(homeIndex);
        OiiiTargetAreaMap tam = new OiiiTargetAreaMap();
        tam.removeExtraCompDirsForHome(homeIndex);
    }

    private void syncCompsImpl(Vector serializedComps, Vector xmlComps, Vector mergedComps, int homeIndex) throws IOException, OiifbCancelException {
        String sLogMsg = OiixResourceBundle.getString("S_SYNCH_COMP");
        MessageFormat logMsgFormat = new MessageFormat(sLogMsg);
        for (int i = 0; i < serializedComps.size(); ++i) {
            OiiiInstallCompInvEntry serInvEntry = (OiiiInstallCompInvEntry)serializedComps.elementAt(i);
            serInvEntry.setAreaControl(this);
            OiiiInstallCompInvEntry xmlInvEntry = null;
            int idx = OiixVectorOps.vectIndexOf(xmlComps, (Object)serInvEntry.getCompInstallID());
            if (idx != -1) {
                xmlInvEntry = (OiiiInstallCompInvEntry)xmlComps.elementAt(idx);
                xmlInvEntry.setReferencers(serInvEntry.getReferencers());
                xmlInvEntry.setDependees(serInvEntry.getDependees());
                xmlInvEntry.setLocation(serInvEntry.getLocation());
                if (serInvEntry instanceof OiiiInstallPatchSetInvEntry && xmlInvEntry instanceof OiiiInstallPatchSetInvEntry) {
                    Vector patches = ((OiiiInstallPatchSetInvEntry)serInvEntry).getPatches();
                    ((OiiiInstallPatchSetInvEntry)xmlInvEntry).setPatches(patches);
                }
            } else {
                xmlInvEntry = (OiiiInstallCompInvEntry)serInvEntry.clone();
                xmlInvEntry.setLocationInXMLInventory(this.getXMLCompRelativeLoc(xmlInvEntry.getCompInstallID(), homeIndex));
                xmlInvEntry.setName(serInvEntry.getName());
                sLogMsg = logMsgFormat.format(new String[]{xmlInvEntry.getFullDisplayName()});
                OiiolTextLogger.appendText(sLogMsg, 1);
                this.synchComp(xmlInvEntry, homeIndex);
            }
            xmlInvEntry.setAreaControl(this);
            xmlInvEntry.setOHIndex(homeIndex);
            mergedComps.addElement(xmlInvEntry);
        }
    }

    private void synchComp(OiiiInstallCompInvEntry invEntry, int homeIndex) throws IOException, OiifbCancelException {
        try {
            String sSourceResDir;
            File fSourceResDir;
            String sSerLoc = invEntry.getLocation();
            sSerLoc = OiixPathOps.concatPath(this.getAreaRoot(), sSerLoc);
            String sXMLLoc = this.getInventoryLocForHome(homeIndex);
            sXMLLoc = OiixPathOps.concatPath(sXMLLoc, invEntry.getLocationInXMLInventory());
            String sSource = OiixPathOps.concatPath(sSerLoc, INSTALLOG_FILENAME);
            String sDest = OiixPathOps.concatPath(sXMLLoc, XML_INSTALLLOG_FILENAME);
            this.convertBinaryLogToXMLLog(sSource, sDest);
            String sBinaryContextFile = this.getContextLoc(invEntry.getLocation());
            String sXMLContextFile = this.getXMLContextLoc(homeIndex, invEntry.getLocationInXMLInventory());
            sBinaryContextFile = OiixPathOps.getNativeForm(sBinaryContextFile);
            sXMLContextFile = OiixPathOps.getNativeForm(sXMLContextFile);
            this.convertBinaryContextFileToXML(sBinaryContextFile, sXMLContextFile);
            String sBinaryConfigLogFile = this.getConfigLogLoc(invEntry.getLocation());
            sBinaryConfigLogFile = OiixPathOps.getNativeForm(sBinaryConfigLogFile);
            if (new File(sBinaryConfigLogFile).exists()) {
                String sXMLConfigLogFile = this.getXMLConfigLogLoc(homeIndex, invEntry.getLocationInXMLInventory());
                sXMLConfigLogFile = OiixPathOps.getNativeForm(sXMLConfigLogFile);
                this.convertBinaryConfigLogToXML(sBinaryConfigLogFile, sXMLConfigLogFile);
            }
            if ((fSourceResDir = new File(sSourceResDir = OiixPathOps.concatPath(sSerLoc, RESOURCES_DIR))).exists()) {
                String sDestResDir = OiixPathOps.concatPath(sXMLLoc, RESOURCES_DIR);
                File fDestResDir = new File(OiixPathOps.getNativeForm(sDestResDir));
                OiixFileOps.mkdirs(fDestResDir);
                String[] resourceFiles = fSourceResDir.list();
                if (resourceFiles != null) {
                    for (int i = 0; i < resourceFiles.length; ++i) {
                        sSource = OiixPathOps.concatPath(sSourceResDir, resourceFiles[i]);
                        File fSource = new File(sSource = OiixPathOps.getNativeForm(sSource));
                        if (fSource.isDirectory()) continue;
                        sDest = OiixPathOps.concatPath(sDestResDir, resourceFiles[i]);
                        sDest = OiixPathOps.getNativeForm(sDest);
                        OiixFileOps.copyFile(sSource, sDest, true, false);
                    }
                }
            }
        }
        catch (IOException ioe) {
            String sComponent = invEntry.getFullDisplayName();
            Object[] sArgs = new String[]{sComponent, ioe.getMessage()};
            String sErrLogMsg = OiixResourceBundle.getString("S_ERROR_SYNCH_COMP", sArgs);
            OiiolTextLogger.appendText(sErrLogMsg);
        }
    }

    private void convertBinaryLogToXMLLog(String srcFile, String destFile) throws IOException {
        OiiolInstallLog binaryLog = new OiiolInstallLog(srcFile);
        OiiolXMLInstallLog xmlLog = new OiiolXMLInstallLog(destFile);
        xmlLog.startWrite();
        Enumeration en = binaryLog.getEntries();
        while (en.hasMoreElements()) {
            OiiolActionLogEntry oEntry = (OiiolActionLogEntry)en.nextElement();
            if (oEntry.getDeinstallFlag()) {
                xmlLog.addEntry(oEntry);
            }
            try {
                this.m_synchLibIDs.addElement(oEntry.getLibraryID());
            }
            catch (OiixInvalidDataException e) {
                e.printStackTrace();
            }
        }
        xmlLog.close();
    }

    private void convertBinaryContextFileToXML(String sBinaryFile, String sXMLFile) throws IOException {
        OiisCompContext oCompContext = new OiisCompContext();
        try {
            oCompContext.readContext(sBinaryFile);
        }
        catch (OiisVarSettingException ve) {
            ve.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        oCompContext.writeXMLContext(sXMLFile);
    }

    private void convertBinaryConfigLogToXML(String sBinaryFile, String sXMLFile) throws IOException {
        OiiolXMLConfigLog oXMLLog = new OiiolXMLConfigLog(sXMLFile);
        Vector vConfigEntries = OiiolConfigLogManipulator.readComponentToolEntries(sBinaryFile);
        oXMLLog.writeConfigLog(vConfigEntries);
    }

    private OiiiLibrariesInfo getXMLLibsInfo(int homeIndex) {
        OiiiLibrariesInfo libInfo = null;
        try {
            Vector[] xmlLibs = OiiiInstallXMLReader.getReader().readLibs(homeIndex);
            libInfo = new OiiiLibrariesInfo(xmlLibs);
        }
        catch (IOException ioe) {
            libInfo = new OiiiLibrariesInfo();
        }
        return libInfo;
    }

    private OiiiLibrariesInfo getSerializedLibsInfo() {
        int homeIndex = 0;
        OiiiLibrariesInfo libInfo = null;
        try {
            Vector[] serializedLibs = OiiiInstallSerializedReader.getReader().readLibs(homeIndex);
            libInfo = new OiiiLibrariesInfo(serializedLibs);
        }
        catch (IOException ioe) {
            libInfo = new OiiiLibrariesInfo();
        }
        return libInfo;
    }

    private void synchLibs(int homeIndex) throws IOException, OiifbCancelException {
        OiiiCompositeHomeInventory inventory = this.getInstallInventory();
        String sHomeInvDir = this.getInventoryLocForHome(homeIndex);
        OiiiLibrariesInfo xmlLibsInfo = this.getXMLLibsInfo(homeIndex);
        Vector vLibIDs = this.m_synchLibIDs.elementsVect();
        OiiiLibrariesInfo serLibsInfo = this.getSerializedLibsInfo();
        int libType = 0;
        String sLogMsg = OiixResourceBundle.getString("S_SYNCH_LIB");
        MessageFormat logMsgFormat = new MessageFormat(sLogMsg);
        for (int i = 0; i < vLibIDs.size(); ++i) {
            OiiiVersion runningInstVer;
            OiiiLibInvEntry serInvEntry;
            OiiiLibraryID lid = (OiiiLibraryID)vLibIDs.elementAt(i);
            lid.optimizePlatList();
            OiiiLibInvEntry xmlInvEntry = xmlLibsInfo.getLibInvEntry(lid, libType);
            if (xmlInvEntry != null || (serInvEntry = serLibsInfo.getCompatLibInvEntry(lid, libType, runningInstVer = OiicInstVersion.getInstallerVersion())) == null) continue;
            OiiiLibraryID foundID = serInvEntry.getLibraryID();
            String[] sLibName = new String[]{serInvEntry.getDisplayName()};
            sLogMsg = logMsgFormat.format(sLibName);
            OiiolTextLogger.appendText(sLogMsg, 1);
            String sSourceLoc = serInvEntry.getLocation();
            sSourceLoc = this.genLibLoc(sSourceLoc);
            String sRelativeDest = this.getXMLLibRelativeLoc(foundID, libType, homeIndex);
            sRelativeDest = OiixPathOps.concatPath(sRelativeDest, OiixPathOps.getFileName(sSourceLoc));
            String sDestLoc = OiixPathOps.concatPath(sHomeInvDir, sRelativeDest);
            OiixFileOps.copyFile(sSourceLoc, sDestLoc, true, true);
            xmlInvEntry = new OiiiLibInvEntry(foundID, sRelativeDest);
            xmlLibsInfo.addLibInvEntry(xmlInvEntry, libType);
        }
        inventory.setAllCompsLibsInfo(homeIndex, xmlLibsInfo);
        this.m_synchLibIDs = null;
        OiiiInstallXMLWriter.getWriter().writeLibs(homeIndex);
    }

    private boolean compsOutOfSynch(int homeIndex) {
        boolean bSupportBinaryInv = Boolean.getBoolean("oracle.installer.supportBinaryInventory");
        if (!bSupportBinaryInv) {
            return false;
        }
        File fSerializedCompsFile = new File(this.getSerializedCompsFileLoc(homeIndex));
        boolean bBin = fSerializedCompsFile.exists();
        boolean bHomeCheck = this.canHomeBeSynched(homeIndex);
        if (bBin && bHomeCheck) {
            OiiolTextLogger.appendText("Only Binary inventory exists for the Home :" + homeIndex);
        }
        return bBin && bHomeCheck;
    }

    private boolean canHomeBeSynched(int homeIndex) {
        File fXMLCompsFile = new File(this.getXMLCompsFileLoc(homeIndex));
        boolean bXML = fXMLCompsFile.exists();
        if (bXML) {
            return false;
        }
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        String sHome = null;
        sHome = homeIndex == 0 ? this.getAreaRoot() : this.getInstallInventory().getHomeLocation(homeIndex);
        if (sHome == null) {
            return false;
        }
        File fHome = new File(sHome);
        if (!fHome.exists()) {
            return false;
        }
        String[] list = fHome.list();
        return list != null && list.length != 0;
    }

    private boolean homesOutOfSynch() {
        boolean bSupportBinaryInv = Boolean.getBoolean("oracle.installer.supportBinaryInventory");
        if (!bSupportBinaryInv) {
            return false;
        }
        String sXMLFile = this.getInventoryFileLoc();
        File fXMLFile = new File(sXMLFile);
        String sBinaryFile = this.getOracleHomesFileLoc();
        File fBinaryFile = new File(sBinaryFile);
        return fBinaryFile.lastModified() > fXMLFile.lastModified();
    }

    public String getContextLoc(String sCompLoc) {
        String sContextLoc = OiixPathOps.concatPath(this.getAreaRoot(), sCompLoc);
        return OiixPathOps.concatPath(sContextLoc, COMPCONTEXT_FILENAME);
    }

    public String getConfigLogLoc(String sCompLoc) {
        String sConfigLogLoc = OiixPathOps.concatPath(this.getAreaRoot(), sCompLoc);
        return OiixPathOps.concatPath(sConfigLogLoc, CONFIGLOG_FILENAME);
    }

    public String getBinaryLogLoc(String compLoc) {
        String sLogLoc = OiixPathOps.concatPath(this.getAreaRoot(), compLoc);
        return OiixPathOps.concatPath(sLogLoc, INSTALLOG_FILENAME);
    }

    public String getXMLLogLoc(int homeIndex, String compLoc) {
        return this.getXMLInvFileLoc(homeIndex, compLoc, XML_INSTALLLOG_FILENAME);
    }

    public String getXMLLogLoc(int homeIndex, String compLoc, int phase) {
        String sFileName = null;
        switch (phase) {
            case 1: {
                sFileName = XML_IP1_INSTALL_LOG_FILENAME;
                break;
            }
            case 8: {
                sFileName = XML_IP2_INSTALL_LOG_FILENAME;
                break;
            }
            case 2: {
                sFileName = XML_LINK_INSTALL_LOG_FILENAME;
            }
        }
        return this.getXMLInvFileLoc(homeIndex, compLoc, sFileName);
    }

    public String getLangAddonXMLLogLoc(int nHomeIndex, String sCompLoc) {
        String sFileName = null;
        String sPath = "";
        if (nHomeIndex == 0) {
            sPath = this.genLogLoc(sCompLoc);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(nHomeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, sCompLoc);
        }
        File installLogParentDir = new File(sPath);
        sFileName = this.getLogFileForLangAddonInstall(installLogParentDir);
        sPath = OiixPathOps.directorify(sPath);
        sPath = OiixPathOps.concatPath(sPath, sFileName);
        return sPath;
    }

    private String getLogFileForLangAddonInstall(File directoryLocation) {
        File[] allLogFiles = directoryLocation.listFiles();
        int maxSequence = 0;
        int currentSequence = 0;
        for (int i = 0; i < allLogFiles.length; ++i) {
            String logFileName = allLogFiles[i].getName();
            if (logFileName.indexOf(XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) continue;
            String sequenceString = logFileName.substring(logFileName.lastIndexOf(95) + 1, logFileName.indexOf(46));
            try {
                currentSequence = Integer.decode(sequenceString);
                if (currentSequence <= maxSequence) continue;
                maxSequence = currentSequence;
                continue;
            }
            catch (NumberFormatException nfe) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                OiiolTextLogger.appendText("Invalid lang addon log file name encountered" + nfe.getMessage(), OiiolTextLogger.LOG_DETAILED);
            }
        }
        String newInstallLogFile = "installLangAddonLog_" + (maxSequence + 1) + ".xml";
        return newInstallLogFile;
    }

    public String[] getLangAddonXMLLogLocationsForDeinstall(int nHomeIndex, String sCompLoc) {
        Object sFileName = null;
        String sPath = "";
        if (nHomeIndex == 0) {
            sPath = this.genLogLoc(sCompLoc);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(nHomeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, sCompLoc);
        }
        File installLogParentDir = new File(sPath);
        String[] fNames = this.getLangAddonLogFilesForDeinstall(installLogParentDir);
        String[] logFilesWithPath = null;
        if (fNames == null) {
            return null;
        }
        logFilesWithPath = new String[fNames.length];
        for (int i = 0; i < logFilesWithPath.length; ++i) {
            sPath = OiixPathOps.directorify(sPath);
            logFilesWithPath[i] = OiixPathOps.concatPath(sPath, fNames[i]);
        }
        return logFilesWithPath;
    }

    public String[] getLangAddonLogFilesForDeinstall(File directoryLocation) {
        File[] allLogFiles = directoryLocation.listFiles();
        if (allLogFiles == null) {
            return null;
        }
        Vector<String> langAddonLogFiles = new Vector<String>();
        boolean j = false;
        for (int i = 0; i < allLogFiles.length; ++i) {
            String logFileName = allLogFiles[i].getName();
            if (logFileName.indexOf(XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) continue;
            langAddonLogFiles.add(logFileName);
        }
        String[] langAddonLogFilesArray = null;
        if (langAddonLogFiles.size() > 0) {
            String[] dummy = new String[1];
            langAddonLogFilesArray = langAddonLogFiles.toArray(dummy);
            Arrays.sort(langAddonLogFilesArray, new LangAddonLogFileComparator());
        }
        return langAddonLogFilesArray;
    }

    public String getXMLContextLoc(int homeIndex, String compLoc) {
        return this.getXMLInvFileLoc(homeIndex, compLoc, XML_COMPCONTEXT_FILENAME);
    }

    public String getXMLConfigLogLoc(int homeIndex, String compLoc) {
        return this.getXMLInvFileLoc(homeIndex, compLoc, XML_CONFIGLOG_FILENAME);
    }

    public String getXMLConfigToolsLoc(int homeIndex) {
        String contentDir = this.getContentsDir(homeIndex);
        return OiixPathOps.concatPath(contentDir, XML_CONFIGTOOLS_FILENAME);
    }

    public String getXMLConfigFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getConfigToolsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    private String getXMLInvFileLoc(int nHomeIndex, String sCompLoc, String sFileName) {
        String sPath = "";
        if (nHomeIndex == 0) {
            sCompLoc = OiixPathOps.concatPath(sCompLoc, sFileName);
            sPath = this.genLogLoc(sCompLoc);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(nHomeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, sCompLoc);
            sPath = OiixPathOps.directorify(sPath);
            sPath = OiixPathOps.concatPath(sPath, sFileName);
        }
        return sPath;
    }

    public String getInventoryLocForHome(int homeIndex) {
        String sLoc = null;
        if (homeIndex == 0) {
            sLoc = this.getAreaRoot();
        } else {
            sLoc = this.getInstallInventory().getHomeLocation(homeIndex);
            sLoc = OiixPathOps.concatPath(sLoc, INVENTORY_DIR);
        }
        return sLoc;
    }

    private boolean xmlInventoryExists() {
        String sInvFileLoc = this.getInventoryFileLoc();
        File fInvFile = new File(sInvFileLoc);
        return fInvFile.exists();
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sFilePath, OiiiCompInstallID cid) {
        return null;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sParentPath, String sChildPath, OiiiCompInstallID cid) {
        return null;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sFilePath, OiiiOneoffInstallID oid) throws OiiiOneoffException {
        return null;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sParentPath, String sChildPath, OiiiOneoffInstallID oid) throws OiiiOneoffException {
        return null;
    }

    public void deregisterFile(String sHomePath, String sFilePath, OiiiCompInstallID cid) {
    }

    public void deregisterFile(String sHomePath, String sFilePath, OiiiOneoffInstallID oid) {
    }

    public void deregisterFile(String sHomePath, String sParentPath, String sChildPath, OiiiCompInstallID cid) {
    }

    public void deregisterFile(String sHomePath, String sParentPath, String sChildPath, OiiiOneoffInstallID oid) {
    }

    public Vector getReferencerComponentsForFile(String sHomePath, String sFilePath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry fileEntry = fileMap.getFileEntry(sFilePath);
            vComps = fileEntry.getReferencerComponents();
        }
        return vComps;
    }

    public Vector getReferencerOneoffsForFile(String sHomePath, String sFilePath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry fileEntry = fileMap.getFileEntry(sFilePath);
            vComps = fileEntry.getReferencerOneoffs();
        }
        return vComps;
    }

    public Vector getReferencerComponentsForFile(String sHomePath, String sParentPath, String sChildPath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry parentEntry = fileMap.getFileEntry(sParentPath);
            OiiiFileMapFileEntry childEntry = parentEntry.getFileEntry(sChildPath);
            vComps = childEntry.getReferencerComponents();
        }
        return vComps;
    }

    public Vector getReferencerOneoffsForFile(String sHomePath, String sParentPath, String sChildPath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry parentEntry = fileMap.getFileEntry(sParentPath);
            OiiiFileMapFileEntry childEntry = parentEntry.getFileEntry(sChildPath);
            vComps = childEntry.getReferencerComponents();
        }
        return vComps;
    }

    void cleanupHomeDir(OiiiOracleHomeInfo homeInfo) throws IOException {
        int nHomeIndex = homeInfo.getIndex();
        String sHomeLoc = this.getInstallInventory().getHomeLocation(nHomeIndex);
        File ohFile = new File(sHomeLoc);
        if (!ohFile.exists()) {
            return;
        }
        String sInvLoc = this.getInventoryLocForHome(nHomeIndex);
        OiixFileOps.cleanupdelete(new File(sInvLoc));
        String sCfgToolsLogDir = this.getXMLHomeLogsDir(nHomeIndex);
        OiixFileOps.cleanupdelete(new File(sCfgToolsLogDir));
        String sRootSHLoc = OiixPathOps.concatPath(sHomeLoc, ROOTSH_FILENAME);
        File fRootSH = new File(sRootSHLoc);
        fRootSH.delete();
        String sOraInstLoc = OiixPathOps.concatPath(sHomeLoc, ORAINST_FILENAME);
        File fOraInst = new File(sOraInstLoc);
        fOraInst.delete();
        String sGlobalContextLoc = OiixPathOps.concatPath(sHomeLoc, GLOBALCONTEXT_FILENAME);
        File fGlobalContext = new File(sGlobalContextLoc);
        fGlobalContext.delete();
        OiixFileOps.deleteParentDirs(sGlobalContextLoc);
        String sPlatFileLoc = OiixPathOps.concatPath(homeInfo.getLocation(), PLATFORM_FILE_NAME);
        File f = new File(sPlatFileLoc);
        if (!f.exists() || f.delete()) {
            f = new File(homeInfo.getLocation());
            f.delete();
        }
    }

    public OiiiFileMapFileEntry getFileMapFileEntry(String sHomePath, String sFilePath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        OiiiFileMapFileEntry fileEntry = null;
        if (fileMap != null) {
            fileEntry = fileMap.getFileEntry(sFilePath);
        }
        return fileEntry;
    }

    public void loadFiles(String sHomePath, String sDirPath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        if (fileMap != null) {
            fileMap.loadFileMapDir(sDirPath);
        }
    }

    public void loadFiles(String sHomePath, String sDirPath, String sChildFile) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        if (fileMap != null) {
            fileMap.loadFileMapDir(sDirPath, sChildFile);
        }
    }

    private static boolean hasWritePermissions(String sLoc) {
        try {
            OiipgFileSystem.checkWritablePath(sLoc);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static boolean isValidInventory(String sInvLoc) {
        return OiiiCompositeAreaControl.readPlatformFile(sInvLoc);
    }

    private static boolean writeInventoryPlatformFile(String sInvLoc) {
        File f = new File(sInvLoc);
        OiixFileOps.mkdirs(f);
        return OiiiCompositeAreaControl.writePlatformFile(sInvLoc);
    }

    public static void createInventory(String sInvLoc, String sGroup) throws OiiiInventoryException, IOException {
        OiipgBootstrap pg;
        if (sInvLoc == null) {
            sInvLoc = OiiiCompositeAreaControl.getDefaultInventoryLocation();
        }
        if (!(pg = new OiipgBootstrap()).isCleanMachine()) {
            Object[] args = new Object[]{sInvLoc};
            String sErrorString = OiixResourceBundle.getString("S_INV_CREATE_API_ERR", args);
            throw new OiiiInventoryException(sErrorString, 1);
        }
        String errString = null;
        if (OiiiCompositeAreaControl.hasWritePermissions(sInvLoc)) {
            if (!OiiiCompositeAreaControl.isValidInventory(sInvLoc)) {
                errString = OiixResourceBundle.getString("S_INV_LOC_PLATFORM_ERR");
                throw new OiiiInventoryException(errString, 3);
            }
        } else {
            Object[] args = new Object[]{sInvLoc};
            errString = OiixResourceBundle.getString("S_INV_LOC_RECOV_ERR", args);
            throw new OiiiInventoryException(errString, 2);
        }
        OiiiCompositeAreaControl.writeInventoryPlatformFile(sInvLoc);
        pg.updateInventoryLoc(null, sInvLoc, sGroup);
    }

    public void createCompositeHomeInventory(String sInvLoc) throws OiiiInventoryException, IOException {
        if (sInvLoc == null) {
            Object[] args = new Object[]{sInvLoc};
            String sErrorString = OiixResourceBundle.getString("S_INV_CREATE_API_ERR", args);
            throw new OiiiInventoryException(sErrorString, 4);
        }
        OiiiCompositeHomeInventory instInv = this.getInstallInventory();
        OiiiOracleHomeInfo homeInfo = instInv.getCompositeHomeWithLocation(sInvLoc);
        if (homeInfo != null) {
            Object[] args = new Object[]{sInvLoc};
            String sErrorString = OiixResourceBundle.getString("S_INV_CREATE_API_ERR", args);
            throw new OiiiInventoryException(sErrorString, 1);
        }
        String errString = null;
        if (!OiiiCompositeAreaControl.hasWritePermissions(sInvLoc)) {
            Object[] args = new Object[]{sInvLoc};
            errString = OiixResourceBundle.getString("S_INV_LOC_RECOV_ERR", args);
            throw new OiiiInventoryException(errString, 2);
        }
    }

    public static boolean isCleanMachine() {
        return new OiipgBootstrap().isCleanMachine();
    }

    private static String getDefaultInventoryLocation() {
        String locationFileLoc = new OiipgBootstrap().getDefaultLocationFileLoc();
        try {
            locationFileLoc = OiixPathOps.getUnexpandedCanonicalPath(locationFileLoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locationFileLoc;
    }

    public static String getConfigXMLDirRltPath() {
        return CONFIG_XML_DIR_RLT_PATH;
    }

    public static String getOuiConfigVariablesXMLFileName() {
        return OUI_CONFIG_VARIABLES_XML_FILE_NAME;
    }

    public static String getAddLanguageAggregateName() {
        return ADD_LANGUAGE_AGGREGATE_NAME;
    }

    public static String getEnvVarsPropertiesFileName() {
        return ENV_VARS_PROPERTIES_FILENAME;
    }

    public static String getEnvVarsPropertiesFileRltLoc() {
        return ENV_VARS_PROPERTIES_FILE_RLT_LOC;
    }

    public static void main(String[] args) {
    }

    static {
        s_instAreaControl = null;
    }

    private class LangAddonLogFileComparator
    implements Comparator {
        private LangAddonLogFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            String logFileName1 = (String)o1;
            String logFileName2 = (String)o2;
            String sequenceString1 = "";
            String sequenceString2 = "";
            int value1 = -3;
            int value2 = -4;
            if (logFileName1.indexOf(OiiiCompositeAreaControl.XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) {
                throw new ClassCastException("Invalid log file name :" + logFileName1);
            }
            sequenceString1 = logFileName1.substring(logFileName1.lastIndexOf(95) + 1, logFileName1.indexOf(46));
            if (logFileName2.indexOf(OiiiCompositeAreaControl.XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) {
                throw new ClassCastException("Invalid log file name" + logFileName2);
            }
            sequenceString2 = logFileName2.substring(logFileName2.lastIndexOf(95) + 1, logFileName2.indexOf(46));
            try {
                value1 = Integer.decode(sequenceString1);
                value2 = Integer.decode(sequenceString2);
            }
            catch (NumberFormatException nfe) {
                throw new ClassCastException("Invalid sequence number in log file " + nfe.getMessage());
            }
            return value1 > value2 ? -1 : (value1 == value2 ? 0 : 1);
        }
    }
}

