/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCommonXMLHandlers;
import oracle.sysman.oii.oiii.OiiiCompBaseElementHandler;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetElementHandler;
import oracle.sysman.oii.oiii.OiiiInstallOneoffElementHandler;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiCompsXMLHandler
extends OixsDefaultHandler {
    private Vector m_comps;
    private int m_nHomeIndex;
    private int m_nHomeType;
    private int m_nCompHomeType;
    private int m_nPlatform;
    private Vector m_vInvPlat;
    private boolean m_bInTopLevelList;
    private OixsElementHandler m_handlerPrdList;
    private OixsElementHandler m_handlerTLList;
    private OixsElementHandler m_handlerCompList;
    private OiiiInstallOneoffElementHandler m_handlerOneoffList;
    private OiiiInstallMiniPatchsetElementHandler m_handlerMiniPatchsetList;
    private boolean m_bUseCompIdPool = true;

    public OiiiCompsXMLHandler(int homeIndex, int homeType, int nPlatform) throws SAXException {
        this.m_nHomeIndex = homeIndex;
        this.m_nHomeType = homeType;
        this.m_nPlatform = nPlatform;
        this.m_vInvPlat = new Vector(1);
        this.m_vInvPlat.addElement(new Integer(this.m_nPlatform));
        switch (homeType) {
            case 2: {
                this.m_nCompHomeType = 0;
                break;
            }
            case 1: {
                this.m_nCompHomeType = 3;
                break;
            }
            case 0: {
                this.m_nCompHomeType = 2;
            }
        }
        if (this.m_handlerOneoffList != null) {
            this.m_handlerOneoffList.setInventoryPlatform(this.m_nPlatform);
            this.m_handlerOneoffList.setHomeIndex(this.m_nHomeIndex);
            this.m_handlerOneoffList.setCompHomeType(this.m_nCompHomeType);
        }
        if (this.m_handlerMiniPatchsetList != null) {
            this.m_handlerMiniPatchsetList.setInventoryPlatform(this.m_nPlatform);
            this.m_handlerMiniPatchsetList.setHomeIndex(this.m_nHomeIndex);
            this.m_handlerMiniPatchsetList.setCompHomeType(this.m_nCompHomeType);
        }
    }

    public void startDocument() throws SAXException {
        this.m_comps = new Vector();
    }

    public OiiiInvHomeInfo getComps() {
        OiiiInvHomeInfo oihi = new OiiiInvHomeInfo(this.m_nHomeIndex, this.m_comps);
        oihi.setUnknownCompElementsTable(this.getElementsTable());
        oihi.setOneoffsVect(this.m_handlerOneoffList.getOneoffs());
        oihi.setMiniPatchsetsVect(this.m_handlerMiniPatchsetList.getMiniPatchsets());
        return oihi;
    }

    public Hashtable getElementsTable() {
        Hashtable<String, XMLElement> ht = new Hashtable<String, XMLElement>();
        XMLElement elPrdList = this.m_handlerPrdList.getUnknownXMLElement();
        XMLElement elTLList = this.m_handlerTLList.getUnknownXMLElement();
        XMLElement elCompList = this.m_handlerCompList.getUnknownXMLElement();
        XMLElement elOneoffList = this.m_handlerOneoffList.getUnknownXMLElement();
        XMLElement elMiniPatchsetList = this.m_handlerMiniPatchsetList.getUnknownXMLElement();
        if (!OixsXMLOps.isEmpty(elPrdList)) {
            ht.put("PRD_LIST", elPrdList);
        }
        if (!OixsXMLOps.isEmpty(elTLList)) {
            ht.put("TL_LIST", elTLList);
        }
        if (!OixsXMLOps.isEmpty(elCompList)) {
            ht.put("COMP_LIST", elCompList);
        }
        if (!OixsXMLOps.isEmpty(elOneoffList)) {
            ht.put("ONEOFF_LIST", elOneoffList);
        }
        if (!OixsXMLOps.isEmpty(elMiniPatchsetList)) {
            ht.put("PATCHSET_UPDATE_LIST", elMiniPatchsetList);
        }
        return ht;
    }

    protected OixsElementHandler createElementHandlers() {
        this.m_handlerPrdList = new OixsElementHandler("PRD_LIST");
        this.m_handlerTLList = new OixsElementHandler("TL_LIST"){

            public void onStart(String name, AttributeList atts) {
                OiiiCompsXMLHandler.this.m_bInTopLevelList = true;
            }

            public void onEnd(String name) {
                OiiiCompsXMLHandler.this.m_bInTopLevelList = false;
            }
        };
        this.m_handlerCompList = new OixsElementHandler("COMP_LIST");
        OiiiInstallCompElementHandler handlerInstallComp = new OiiiInstallCompElementHandler("COMP");
        OiiiInstallPatchSetElementHandler handlerInstallPatchSet = new OiiiInstallPatchSetElementHandler();
        OiiiInstallPatchElementHandler handlerInstallPatch = new OiiiInstallPatchElementHandler();
        this.m_handlerOneoffList = new OiiiInstallOneoffElementHandler("ONEOFF_LIST");
        this.m_handlerOneoffList.setInventoryPlatform(this.m_nPlatform);
        this.m_handlerOneoffList.setHomeIndex(this.m_nHomeIndex);
        this.m_handlerMiniPatchsetList = new OiiiInstallMiniPatchsetElementHandler("PATCHSET_UPDATE_LIST");
        this.m_handlerMiniPatchsetList.setInventoryPlatform(this.m_nPlatform);
        this.m_handlerMiniPatchsetList.setHomeIndex(this.m_nHomeIndex);
        this.m_handlerTLList.addChildHandler("COMP", handlerInstallComp);
        this.m_handlerTLList.addChildHandler("PATCHSET", handlerInstallPatchSet);
        this.m_handlerCompList.addChildHandler("COMP", handlerInstallComp);
        this.m_handlerCompList.addChildHandler("PATCH", handlerInstallPatch);
        this.m_handlerPrdList.addChildHandler("TL_LIST", this.m_handlerTLList);
        this.m_handlerPrdList.addChildHandler("COMP_LIST", this.m_handlerCompList);
        this.m_handlerPrdList.addChildHandler("ONEOFF_LIST", this.m_handlerOneoffList);
        this.m_handlerPrdList.addChildHandler("PATCHSET_UPDATE_LIST", this.m_handlerMiniPatchsetList);
        return this.m_handlerPrdList;
    }

    private OiiiCompIdOhPair createCompIdOhPair(AttributeList atts) {
        String sName = atts.getValue("NAME");
        OiiiVersion version = new OiiiVersion(atts.getValue("VER"));
        String sHomeIndex = atts.getValue("HOME_IDX");
        int nHomeIndex = this.m_nHomeIndex;
        try {
            nHomeIndex = Integer.parseInt(sHomeIndex);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        OiiiCompInstallID cid = new OiiiCompInstallID(sName, version, this.getInventoryPlatform());
        if (nHomeIndex == 0) {
            cid.setHomeType(0);
        } else {
            cid.setHomeType(2);
            if (this.m_nHomeIndex != 0) {
                nHomeIndex = this.m_nHomeIndex;
            }
        }
        if (this.m_bUseCompIdPool) {
            cid = OiiiCompIDPool.getInstance().get(cid);
        }
        OiiiCompIdOhPair dependee = new OiiiCompIdOhPair(cid, nHomeIndex);
        String sDepType = atts.getValue("TYPE");
        if (sDepType == null) {
            sDepType = "";
        }
        if (sDepType.equalsIgnoreCase("O")) {
            dependee.setDepType(0);
        } else if (sDepType.equalsIgnoreCase("M")) {
            dependee.setDepType(1);
        }
        String sDepGroup = atts.getValue("DEP_GRP_NAME");
        dependee.setDepGroup(sDepGroup);
        return dependee;
    }

    private Vector getInventoryPlatform() {
        return this.m_vInvPlat;
    }

    public void setUseCompIdPool(boolean value) {
        this.m_bUseCompIdPool = value;
    }

    private class OiiiPSPatchElementHandler
    extends OixsElementHandler {
        private Vector m_patches;
        OiiiPatchInstallID m_pid;

        public OiiiPSPatchElementHandler() {
            super("PS_PATCH");
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            OiiiVersion version = new OiiiVersion(atts.getValue("VER"));
            OiiiVersion baseVersion = new OiiiVersion(atts.getValue("BASE_VER"));
            int nHomeType = OiiiCompsXMLHandler.this.m_nCompHomeType;
            String sNOH = atts.getValue("NOH");
            if (sNOH != null && sNOH.equals("T")) {
                nHomeType = 0;
            }
            OiiiCompInstallID cid = new OiiiCompInstallID(sName, baseVersion, OiiiCompsXMLHandler.this.getInventoryPlatform());
            cid.setHomeType(nHomeType);
            if (OiiiCompsXMLHandler.this.m_bUseCompIdPool) {
                cid = OiiiCompIDPool.getInstance().get(cid);
            }
            this.m_pid = new OiiiPatchInstallID(cid, version, OiiiCompsXMLHandler.this.getInventoryPlatform());
            this.m_patches.addElement(this.m_pid);
        }

        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                this.m_pid.setUnknownXMLElement(element);
            }
        }

        void setPatchesVect(Vector patches) {
            this.m_patches = patches;
        }
    }

    private class OiiiInstallPatchSetElementHandler
    extends OiiiInstallCompElementHandler {
        private Vector m_patches;
        private OiiiPSPatchElementHandler m_handlerPSPatch;

        public OiiiInstallPatchSetElementHandler() {
            super("PATCHSET");
            this.m_handlerPSPatch = new OiiiPSPatchElementHandler();
            this.addChildHandler("PS_PATCH", this.m_handlerPSPatch);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_patches = new Vector();
            this.m_handlerPSPatch.setPatchesVect(this.m_patches);
        }

        public void onEnd(String name) {
            OiiiPatchSetInstallID psid = new OiiiPatchSetInstallID(this.getCompName(), this.getVersion());
            if (OiiiCompsXMLHandler.this.m_bUseCompIdPool) {
                psid = (OiiiPatchSetInstallID)OiiiCompIDPool.getInstance().get(psid);
            }
            OiiiInstallPatchSetInvEntry invEntry = new OiiiInstallPatchSetInvEntry(psid, this.getLocationInInventory());
            invEntry.setPatches(this.m_patches);
            invEntry.setTopLevel(true);
            super.updateCommonProperties(invEntry);
            Hashtable xmlElementsTable = this.getXMLElementsTable();
            invEntry.setUnknownXMLElementsTable(xmlElementsTable);
            OiiiCompsXMLHandler.this.m_comps.addElement(invEntry);
        }
    }

    private class OiiiInstallPatchElementHandler
    extends OiiiInstallCompElementHandler {
        private OiiiVersion m_baseVersion;

        public OiiiInstallPatchElementHandler() {
            super("PATCH");
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            this.m_baseVersion = new OiiiVersion(atts.getValue("BASE_VER"));
        }

        public void onEnd(String name) {
            OiiiCompInstallID base_cid = new OiiiCompInstallID(this.getCompName(), this.m_baseVersion, OiiiCompsXMLHandler.this.getInventoryPlatform());
            base_cid.setHomeType(OiiiCompsXMLHandler.this.m_nCompHomeType);
            if (OiiiCompsXMLHandler.this.m_bUseCompIdPool) {
                base_cid = OiiiCompIDPool.getInstance().get(base_cid);
            }
            OiiiPatchInstallID pid = new OiiiPatchInstallID(base_cid, this.getVersion(), OiiiCompsXMLHandler.this.getInventoryPlatform());
            OiiiInstallPatchInvEntry invEntry = new OiiiInstallPatchInvEntry(pid, this.getLocationInInventory(), this.getLanguages(), this.getDependees(), this.getInstallLocation());
            invEntry.setBaseID(base_cid);
            super.updateCommonProperties(invEntry);
            Hashtable xmlElementsTable = this.getXMLElementsTable();
            invEntry.setUnknownXMLElementsTable(xmlElementsTable);
            OiiiCompsXMLHandler.this.m_comps.addElement(invEntry);
        }
    }

    private class OiiiRefElementHandler
    extends OixsElementHandler {
        private Vector m_referencers;
        private OiiiCompIdOhPair m_referencer;

        public OiiiRefElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            this.m_referencer = OiiiCompsXMLHandler.this.createCompIdOhPair(atts);
            this.m_referencers.addElement(this.m_referencer);
        }

        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                this.m_referencer.setUnknownXMLElement(element);
            }
        }

        void setReferencersVect(Vector referencers) {
            this.m_referencers = referencers;
        }
    }

    private class OiiiDepElementHandler
    extends OixsElementHandler {
        private Vector m_dependees;
        private OiiiCompIdOhPair m_dependee;

        public OiiiDepElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            this.m_dependee = OiiiCompsXMLHandler.this.createCompIdOhPair(atts);
            this.m_dependees.addElement(this.m_dependee);
        }

        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                this.m_dependee.setUnknownXMLElement(element);
            }
        }

        void setDependeesVect(Vector dependees) {
            this.m_dependees = dependees;
        }
    }

    private class OiiiDepGrpDepElementHandler
    extends OixsElementHandler {
        private List m_dependees;

        OiiiDepGrpDepElementHandler() {
            super("DEP");
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlat = atts.getValue("PLAT");
            if (sVer != null && sName != null) {
                OiiiVersion oVer = new OiiiVersion(sVer);
                Vector vPlats = null;
                vPlats = sPlat != null ? OiilXMLHelper.platCommonNames2IntVector(sPlat, " ", null) : OiiiCompsXMLHandler.this.getInventoryPlatform();
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
                if (OiiiCompsXMLHandler.this.m_bUseCompIdPool) {
                    cid = OiiiCompIDPool.getInstance().get(cid);
                }
                this.m_dependees.add(cid);
            }
        }

        void setDependees(List dependees) {
            this.m_dependees = dependees;
        }
    }

    private class OiiiDepGrpElementHandler
    extends OixsElementHandler {
        private Hashtable m_depGrps;
        private OiisDeps m_oDeps;
        private OiiiDepGrpDepElementHandler m_handlerDepGrpDep;

        public OiiiDepGrpElementHandler(String sName) {
            super(sName);
            OixsElementHandler handlerDepList = new OixsElementHandler("DEP_LIST");
            this.m_handlerDepGrpDep = new OiiiDepGrpDepElementHandler();
            this.addChildHandler(handlerDepList.getName(), handlerDepList);
            handlerDepList.addChildHandler(this.m_handlerDepGrpDep.getName(), this.m_handlerDepGrpDep);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sDepGrpName = atts.getValue("NAME");
            String sDepGrpType = atts.getValue("TYPE");
            int nType = 0;
            if (sDepGrpType != null) {
                nType = OiisDepRule.getTypeFromString(sDepGrpType);
            }
            OiisDepRule depRule = new OiisDepRule(sDepGrpName, nType, sDepGrpName, new Vector());
            this.m_oDeps.getDepRules().add(depRule);
            this.m_depGrps.put(sDepGrpName.toLowerCase(), sDepGrpType);
            this.m_handlerDepGrpDep.setDependees(depRule.getDepCompIds());
        }

        void setDepGroupsTable(Hashtable depGroups) {
            this.m_depGrps = depGroups;
        }

        void setDeps(OiisDeps oDeps) {
            this.m_oDeps = oDeps;
        }
    }

    private class OiiiFileSizeElementHandler
    extends OixsElementHandler {
        private Hashtable m_oDestSz;

        public OiiiFileSizeElementHandler(String sName) {
            super(sName);
        }

        public void onStart(String name, AttributeList atts) {
            String sVolume = atts.getValue("VOLUME");
            String sSz = atts.getValue("SPACE_REQ");
            this.m_oDestSz.put(sVolume, new Long(sSz));
        }

        void setDestSizes(Hashtable destMap) {
            this.m_oDestSz = destMap;
        }
    }

    private class OiiiInstallCompElementHandler
    extends OiiiCompBaseElementHandler {
        private OiiiVersion m_instVersion;
        private OiiiVersion m_deinstVersion;
        private Date m_installTime;
        private String m_instLoc;
        private Hashtable m_depGroups;
        private OiisPlatIndexMapping m_oPlatIndexMap;
        private OiisLangIndexMapping m_oLangIndexMap;
        private OiisDestinationIndexMapping m_oDestIndexMap;
        private Hashtable m_oDestSizes;
        private String m_sXMLLoc;
        private OiisDeps m_oDeps;
        private Vector m_dependees;
        private Vector m_referencers;
        private boolean m_bSOH;
        private boolean m_bClonable;
        private OiiiDepGrpElementHandler m_handlerDepGrp;
        private OiiiDepElementHandler m_handlerDep;
        private OiiiRefElementHandler m_handlerRef;
        private OixsElementHandler m_handlerDepGrpList;
        private OixsElementHandler m_handlerDepList;
        private OixsElementHandler m_handlerRefList;
        private OiiiFileSizeElementHandler m_handlerDestSizes;
        private OixsElementHandler m_handlerFileSizeList;
        private OiiiCommonXMLHandlers.OiiiLocInfoElementHandler m_handlerLocInfo;
        private OiiiCommonXMLHandlers.OiiiCompJarInfoElementHandler m_handlerCompJarInfo;
        private OiiiCommonXMLHandlers.OiiiBookElementHandler m_handlerBook;
        private OiiiCommonXMLHandlers.OiiiPreReqElementHandler m_handlerPreReq;
        private OiiiCommonXMLHandlers.OiiiProdHomeElementHandler m_handlerProdHome;
        private OiiiCommonXMLHandlers.OiiiLangIndexMapElementHandler m_handlerLangIndexMap;
        private OiiiCommonXMLHandlers.OiiiPlatIndexMapElementHandler m_handlerPlatIndexMap;
        private OiiiCommonXMLHandlers.OiiiDestIndexMapElementHandler m_handlerDestIndexMap;
        private OiiiCommonXMLHandlers.OiiiInstTypeElementHandler m_handlerInstType;
        private OiiiCommonXMLHandlers.OiiiStageInfoElementHandler m_handlerStageInfo;

        public OiiiInstallCompElementHandler(String sName) {
            super(sName);
            this.m_handlerDepGrpList = new OixsElementHandler("DEP_GRP_LIST");
            this.m_handlerDepGrp = new OiiiDepGrpElementHandler("DEP_GRP");
            this.m_handlerDepList = new OixsElementHandler("DEP_LIST");
            this.m_handlerDep = new OiiiDepElementHandler("DEP");
            this.m_handlerRefList = new OixsElementHandler("REF_LIST");
            this.m_handlerRef = new OiiiRefElementHandler("REF");
            this.m_handlerDepGrpList.addChildHandler("DEP_GRP", this.m_handlerDepGrp);
            this.m_handlerDepList.addChildHandler("DEP", this.m_handlerDep);
            this.m_handlerRefList.addChildHandler("REF", this.m_handlerRef);
            this.addChildHandler("DEP_GRP_LIST", this.m_handlerDepGrpList);
            this.addChildHandler("DEP_LIST", this.m_handlerDepList);
            this.addChildHandler("REF_LIST", this.m_handlerRefList);
            this.m_handlerBook = new OiiiCommonXMLHandlers.OiiiBookElementHandler();
            this.addChildHandler(this.m_handlerBook.getName(), this.m_handlerBook);
            this.m_handlerStageInfo = new OiiiCommonXMLHandlers.OiiiStageInfoElementHandler();
            this.addChildHandler(this.m_handlerStageInfo.getName(), this.m_handlerStageInfo);
            this.m_handlerLocInfo = new OiiiCommonXMLHandlers.OiiiLocInfoElementHandler();
            this.addChildHandler("LOC_INFO", this.m_handlerLocInfo);
            this.m_handlerPreReq = new OiiiCommonXMLHandlers.OiiiPreReqElementHandler();
            this.addChildHandler(this.m_handlerPreReq.getName(), this.m_handlerPreReq);
            this.m_handlerProdHome = new OiiiCommonXMLHandlers.OiiiProdHomeElementHandler();
            this.addChildHandler(this.m_handlerProdHome.getName(), this.m_handlerProdHome);
            this.m_handlerCompJarInfo = new OiiiCommonXMLHandlers.OiiiCompJarInfoElementHandler();
            this.addChildHandler("CMP_JAR_INFO", this.m_handlerCompJarInfo);
            this.m_handlerLangIndexMap = new OiiiCommonXMLHandlers.OiiiLangIndexMapElementHandler();
            this.addChildHandler(this.m_handlerLangIndexMap.getName(), this.m_handlerLangIndexMap);
            this.m_handlerPlatIndexMap = new OiiiCommonXMLHandlers.OiiiPlatIndexMapElementHandler();
            this.addChildHandler(this.m_handlerPlatIndexMap.getName(), this.m_handlerPlatIndexMap);
            this.m_handlerDestIndexMap = new OiiiCommonXMLHandlers.OiiiDestIndexMapElementHandler();
            this.addChildHandler(this.m_handlerDestIndexMap.getName(), this.m_handlerDestIndexMap);
            this.m_handlerFileSizeList = new OixsElementHandler("FILESIZEINFO");
            this.m_handlerDestSizes = new OiiiFileSizeElementHandler("DEST");
            this.m_handlerFileSizeList.addChildHandler("DEST", this.m_handlerDestSizes);
            this.addChildHandler("FILESIZEINFO", this.m_handlerFileSizeList);
            OixsElementHandler handlerInstTypeList = new OixsElementHandler("INST_TYPE_LIST");
            this.m_handlerInstType = new OiiiCommonXMLHandlers.OiiiInstTypeElementHandler();
            this.addChildHandler("INST_TYPE_LIST", handlerInstTypeList);
            handlerInstTypeList.addChildHandler(this.m_handlerInstType.getName(), this.m_handlerInstType);
        }

        public void onStart(String name, AttributeList atts) {
            String sClonable;
            String sSOH;
            super.onStart(name, atts);
            this.m_depGroups = new Hashtable();
            this.m_dependees = new Vector();
            this.m_referencers = new Vector();
            this.m_handlerDepGrp.setDepGroupsTable(this.m_depGroups);
            this.m_handlerDep.setDependeesVect(this.m_dependees);
            this.m_handlerRef.setReferencersVect(this.m_referencers);
            this.m_oDeps = new OiisDeps();
            this.m_handlerDepGrp.setDeps(this.m_oDeps);
            this.m_handlerInstType.setDeps(this.m_oDeps);
            this.m_oPlatIndexMap = new OiisPlatIndexMapping();
            this.m_handlerPlatIndexMap.setPlatIndexMapping(this.m_oPlatIndexMap);
            this.m_oLangIndexMap = new OiisLangIndexMapping();
            this.m_handlerLangIndexMap.setLangIndexMapping(this.m_oLangIndexMap);
            this.m_oDestIndexMap = new OiisDestinationIndexMapping();
            this.m_handlerDestIndexMap.setDestIndexMapping(this.m_oDestIndexMap);
            this.m_oDestSizes = new Hashtable(10);
            this.m_handlerDestSizes.setDestSizes(this.m_oDestSizes);
            this.m_bSOH = false;
            this.m_bClonable = true;
            this.m_instVersion = new OiiiVersion(atts.getValue("ACT_INST_VER"));
            String sDeinstVersion = atts.getValue("DEINST_VER");
            this.m_deinstVersion = sDeinstVersion != null ? new OiiiVersion(sDeinstVersion) : new OiiiVersion(atts.getValue("ACT_INST_VER"));
            String sInstallTime = atts.getValue("INSTALL_TIME");
            if (sInstallTime != null && sInstallTime.length() > 0) {
                try {
                    this.m_installTime = new SimpleDateFormat("yyyy.MMM.dd HH:mm:ss zzz", OiixLanguage.ENGLISH).parse(sInstallTime);
                }
                catch (ParseException e) {
                    System.err.println("sInstallTime = >" + sInstallTime + "<");
                    e.printStackTrace();
                }
            }
            if ((sSOH = atts.getValue("SOH")) != null && sSOH.equals("T")) {
                this.m_bSOH = true;
            }
            if ((sClonable = atts.getValue("CLONABLE")) != null) {
                if (sClonable.equals("F")) {
                    this.m_bClonable = false;
                }
            } else {
                OiiiVersion vClone = new OiiiVersion("2.3.0.0.0");
                if (vClone.laterThan(this.m_instVersion)) {
                    this.m_bClonable = false;
                }
            }
            this.m_instLoc = atts.getValue("INST_LOC");
            this.m_sXMLLoc = atts.getValue("XML_INV_LOC");
        }

        public void onEnd(String name) {
            OiiiCompInstallID cid = new OiiiCompInstallID(this.getCompName(), this.getVersion(), OiiiCompsXMLHandler.this.getInventoryPlatform(), this.getReplaceVersion(), 1, OiiiCompsXMLHandler.this.m_nCompHomeType, this.getReleaseLevel());
            if (this.m_bSOH) {
                cid.setHomeType(1);
            }
            if (OiiiCompsXMLHandler.this.m_bUseCompIdPool) {
                cid = OiiiCompIDPool.getInstance().get(cid);
            }
            this.updateDependeesWithDepGroupInfo(this.m_dependees, this.m_depGroups);
            OiiiInstallCompInvEntry invEntry = new OiiiInstallCompInvEntry(cid, this.getLocationInInventory(), this.getLanguages(), this.m_dependees, this.m_instLoc);
            invEntry.setTopLevel(OiiiCompsXMLHandler.this.m_bInTopLevelList);
            invEntry.setClonable(this.m_bClonable);
            this.updateCommonProperties(invEntry);
            Hashtable xmlElementsTable = this.getXMLElementsTable();
            invEntry.setUnknownXMLElementsTable(xmlElementsTable);
            OiiiCompsXMLHandler.this.m_comps.addElement(invEntry);
        }

        protected void updateCommonProperties(OiiiInstallCompInvEntry invEntry) {
            invEntry.setName(this.getExternalName());
            invEntry.setDescription(this.getDescription());
            invEntry.setDescResourceId(this.getDescriptionID());
            invEntry.setReferencers(this.m_referencers);
            invEntry.setInstallerVersion(this.m_instVersion);
            invEntry.setDeinstallVersion(this.m_deinstVersion);
            invEntry.setInstallTime(this.m_installTime);
            invEntry.setLocationInXMLInventory(this.m_sXMLLoc);
            invEntry.setJarName(this.m_handlerLocInfo.getJarName());
            invEntry.setInstallDefnLoc(this.m_handlerLocInfo.getJarLoc());
            invEntry.setCompProperties(new OiisCompProperties(invEntry.getCompInstallID()));
            invEntry.getCompProperties().setCompJarInfo(this.m_handlerCompJarInfo.getCompJarInfo());
            invEntry.getCompProperties().setHelpBookName(this.m_handlerBook.getBookName());
            invEntry.setNoPreReq(!this.m_handlerPreReq.isPreReqDefined());
            invEntry.getCompProperties().setNoPreReqAvailable(!this.m_handlerPreReq.isPreReqDefined());
            invEntry.setNoProdHome(!this.m_handlerProdHome.isProdHomeDefined());
            invEntry.getCompProperties().setNoProdHomeAvailable(!this.m_handlerProdHome.isProdHomeDefined());
            invEntry.setLangIndexMapping(this.m_handlerLangIndexMap.getLangIndexMapping());
            invEntry.setPlatIndexMapping(this.m_handlerPlatIndexMap.getPlatIndexMapping());
            invEntry.setDestIndexMapping(this.m_handlerDestIndexMap.getDestIndexMapping());
            invEntry.setDeps(this.m_oDeps);
            invEntry.setDepModeName(this.m_handlerInstType.getInstallTypeName());
            invEntry.setStageVersion(this.m_handlerStageInfo.getStageVersion());
            invEntry.setCreatedInThisSession(false);
            OiisFileSizeInfo fsi = this.getFileSizeInfo();
            invEntry.setFileSizeInfoEx(fsi);
            invEntry.setPlatIndexMapping(fsi.getPlatIndexMapping());
            invEntry.setLangIndexMapping(fsi.getLangIndexMapping());
            invEntry.setDestIndexMapping(fsi.getDestIndexMapping());
        }

        protected OiisFileSizeInfo getFileSizeInfo() {
            Enumeration en = this.m_oDestSizes.keys();
            while (en.hasMoreElements()) {
                String sDest = (String)en.nextElement();
                this.m_oDestIndexMap.addDestination(sDest);
            }
            this.m_oDestIndexMap.commitInserts();
            OiisFileSizeInfo fsi = new OiisFileSizeInfo(this.m_oPlatIndexMap, this.m_oLangIndexMap, this.m_oDestIndexMap);
            en = this.m_oDestSizes.keys();
            while (en.hasMoreElements()) {
                String sDest = (String)en.nextElement();
                Long sz = (Long)this.m_oDestSizes.get(sDest);
                fsi.updateSize(0, 0, sDest, (long)sz);
            }
            return fsi;
        }

        protected Hashtable getXMLElementsTable() {
            Hashtable<String, XMLElement> ht = new Hashtable<String, XMLElement>();
            XMLElement elThis = null;
            XMLElement elDepList = null;
            XMLElement elRefList = null;
            XMLElement elDepGrpList = null;
            elThis = this.getUnknownXMLElement();
            elDepList = this.m_handlerDepList.getUnknownXMLElement();
            elRefList = this.m_handlerRefList.getUnknownXMLElement();
            elDepGrpList = this.m_handlerDepGrpList.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(elThis)) {
                ht.put(this.getName(), elThis);
            }
            if (!OixsXMLOps.isEmpty(elDepList)) {
                ht.put("DEP_LIST", elDepList);
            }
            if (!OixsXMLOps.isEmpty(elRefList)) {
                ht.put("REF_LIST", elRefList);
            }
            if (!OixsXMLOps.isEmpty(elDepGrpList)) {
                ht.put("DEP_GRP_LIST", elDepGrpList);
            }
            return ht;
        }

        private void updateDependeesWithDepGroupInfo(Vector vDeps, Hashtable oDepGroupInfo) {
            int iDepType = 3;
            if (vDeps != null) {
                int iDeps = vDeps.size();
                for (int i = 0; i < iDeps; ++i) {
                    OiiiCompIdOhPair oComp = (OiiiCompIdOhPair)vDeps.elementAt(i);
                    String sDepGroup = oComp.getDepGroup();
                    if (sDepGroup == null) continue;
                    if (oDepGroupInfo.containsKey(sDepGroup = sDepGroup.toLowerCase())) {
                        String sDepGrpType = (String)oDepGroupInfo.get(sDepGroup);
                        iDepType = sDepGrpType.equalsIgnoreCase("O") ? 0 : (sDepGrpType.equalsIgnoreCase("M") ? 1 : 3);
                    }
                    oComp.setDepType(iDepType);
                }
            }
        }

        protected Vector getDependees() {
            return this.m_dependees;
        }

        protected Vector getReferencers() {
            return this.m_referencers;
        }

        protected String getInstallLocation() {
            return this.m_instLoc;
        }

        protected OiiiVersion getInstallerVersion() {
            return this.m_instVersion;
        }

        protected OiiiVersion getDeinstallVersion() {
            return this.m_deinstVersion;
        }

        protected Date getInstallTime() {
            return this.m_installTime;
        }

        protected String getLocationInXMLInventory() {
            return this.m_sXMLLoc;
        }
    }
}

