/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiConfigToolID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

class OiiiConfigXMLWriter {
    private static OiiiConfigXMLWriter m_writer;
    private static String CONFIG_INFO;

    private OiiiConfigXMLWriter() {
    }

    static OiiiConfigXMLWriter getWriter() {
        if (m_writer == null) {
            m_writer = new OiiiConfigXMLWriter();
        }
        return m_writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(Vector vComps, String sLocation) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        boolean bIsAttachHome = Boolean.getBoolean("oracle.installer.attachHome");
        boolean bIsDetachHome = Boolean.getBoolean("oracle.installer.detachHome");
        FileOutputStream fWriter = null;
        try {
            fWriter = new FileOutputStream(sLocation);
        }
        catch (IOException e) {
            if (bIsAttachHome || bIsDetachHome) {
                return;
            }
            throw e;
        }
        OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fWriter, "UTF-8");
        BufferedWriter bWriter = new BufferedWriter(oWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        try {
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            pWriter.println(CONFIG_INFO);
            XMLElement xmlConfigTools = new XMLElement("CONFIG_LIST");
            pWriter.println(OixsXMLOps.getStartTag(xmlConfigTools));
            for (int i = 0; i < vComps.size(); ++i) {
                XMLElement xmlcfg = this.getConfigToolsXML((OiiiCompInvEntry)vComps.elementAt(i));
                if (xmlcfg == null) continue;
                xmlcfg.print(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(xmlConfigTools));
            Object var15_14 = null;
            pWriter.close();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            pWriter.close();
            bWriter.close();
            oWriter.close();
            fWriter.close();
            throw throwable;
        }
        bWriter.close();
        oWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing config tools for Stage Inventory ", System.currentTimeMillis() - lTime);
        }
    }

    XMLElement getConfigToolsXML(OiiiCompInvEntry entry) {
        int i;
        OiisCompProperties props = entry.getCompProperties();
        if (props == null) {
            return null;
        }
        Vector vcfgDetails = props.getConfigToolDetails();
        Vector vSuppressCfgs = props.getConfigToolsToSuppress();
        if (vcfgDetails.isEmpty() && vSuppressCfgs.isEmpty()) {
            return null;
        }
        XMLElement xmlComp = this.getCompXMLElement(entry);
        for (i = 0; i < vcfgDetails.size(); ++i) {
            OiisConfigToolDetails cfg = (OiisConfigToolDetails)vcfgDetails.elementAt(i);
            XMLElement xmlCfg = new XMLElement("CT");
            xmlCfg.setAttribute("NAME", cfg.getConfigToolID().getInternalName());
            xmlCfg.setAttribute("NAME_ID", cfg.getExternalNameID());
            xmlCfg.setAttribute("DESC_ID", cfg.getDescriptionID());
            xmlCfg.setAttribute("LOC", cfg.getLocation());
            xmlCfg.setAttribute("AGGREGATE_NAME", cfg.getAggregateName());
            xmlCfg.setAttribute("CLS_NAME", cfg.getToolClassName());
            xmlCfg.setAttribute("PLAT", OiilXMLHelper.platArrToString(cfg.getPlatforms()));
            xmlComp.appendChild((Node)xmlCfg);
        }
        for (i = 0; i < vSuppressCfgs.size(); ++i) {
            OiiiConfigToolID cfgId = (OiiiConfigToolID)vSuppressCfgs.elementAt(i);
            XMLElement xmlSuppressCfg = new XMLElement("SUP_CT");
            xmlSuppressCfg.setAttribute("INT_NAME", cfgId.getInternalName());
            xmlSuppressCfg.setAttribute("CMP_NAME", cfgId.getCompID().getName());
            xmlSuppressCfg.setAttribute("VER", cfgId.getCompID().getVersion().getVerString());
            xmlSuppressCfg.setAttribute("PLAT", OiilXMLHelper.platVect2String(cfgId.getCompID().getPlatforms(), " "));
            xmlComp.appendChild((Node)xmlSuppressCfg);
        }
        return xmlComp;
    }

    private XMLElement getCompXMLElement(OiiiCompInvEntry entry) {
        XMLElement xmlComp;
        OiiiCompInstallID cid = entry.getCompInstallID();
        if (cid instanceof OiiiPatchInstallID) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            xmlComp = new XMLElement("PATCH");
            xmlComp.setAttribute("BASE_VER", pid.getBaseVersion().getVerString());
            xmlComp.setAttribute("BASE_PLAT", OiilXMLHelper.platVect2String(pid.getCompPlatforms(), " "));
        } else {
            xmlComp = new XMLElement("COMP");
        }
        xmlComp.setAttribute("NAME", cid.getName());
        xmlComp.setAttribute("VER", cid.getVersion().getVerString());
        xmlComp.setAttribute("PLAT", OiilXMLHelper.platVect2String(entry.getPlatforms(), " "));
        return xmlComp;
    }

    static {
        CONFIG_INFO = "<!-- Note: If there are any xml tools listed for suppression, the suppression shall be ignored and the xml tools shall be considered for execution during installation -->";
    }
}

