/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileMapDirComparator;
import oracle.sysman.oii.oiii.OiiiFileMapDirEntry;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixSearch;

public class OiiiFileMap {
    private String m_sFileMapRoot;
    private OiiiOracleHomeInfo m_homeInfo;
    private Vector m_homeDirs;
    private Vector m_otherDirs;
    private String m_sHomePath;
    private File m_fHomePath;
    public static final String FILEMAP_ROOT_DIR = "filemap";
    private static final int SAVE_THRESHOLD = 2;

    public OiiiFileMap(OiiiOracleHomeInfo homeInfo, String homeInventoryPath) {
        this.m_homeInfo = homeInfo;
        this.m_sHomePath = OiixPathOps.getStandardCanonicalPath(this.m_homeInfo.getLocation());
        if (!OiipgFileSystem.isCaseSensitive()) {
            this.m_sHomePath = this.m_sHomePath.toLowerCase();
        }
        this.m_fHomePath = new File(OiixPathOps.getNativeForm(this.m_sHomePath));
        this.m_sFileMapRoot = OiixPathOps.concatPath(OiixPathOps.getStandardForm(homeInventoryPath), FILEMAP_ROOT_DIR);
        this.m_homeDirs = new Vector(10);
        this.m_otherDirs = new Vector(10);
    }

    public String getFileMapRoot() {
        return this.m_sFileMapRoot;
    }

    String getHomePath() {
        return this.m_sHomePath;
    }

    public int getHomeType() {
        return this.m_homeInfo.getHomeType();
    }

    public String getHomeName() {
        return this.m_homeInfo.getName();
    }

    OiiiFileMapDirEntry getFileMapDir(String sParent) {
        return this.getFileMapDir(sParent, true);
    }

    OiiiFileMapDirEntry getFileMapDir(String sParent, boolean bInsert) {
        OiiiFileMapDirEntry oDir = null;
        if (OiipgFileSystem.isParentDirOf(this.m_fHomePath, new File(OiixPathOps.getNativeForm(sParent = OiixPathOps.directorify(OiixPathOps.getStandardForm(sParent)))))) {
            String sRelativePath = this.getRelativePathFromHome(sParent);
            OiiiFileMapDirEntry tmpDir = new OiiiFileMapDirEntry(null, sRelativePath);
            int index = OiixSearch.bSearch(tmpDir, this.m_homeDirs, OiiiFileMapDirComparator.getComparator());
            if (index != -1) {
                oDir = (OiiiFileMapDirEntry)this.m_homeDirs.elementAt(index);
            } else {
                oDir = new OiiiFileMapDirEntry(this, sRelativePath);
                if (bInsert) {
                    OiixSearch.bSearchAndInsert(oDir, this.m_homeDirs, OiiiFileMapDirComparator.getComparator());
                } else if (oDir.existsFileMap()) {
                    OiixSearch.bSearchAndInsert(oDir, this.m_homeDirs, OiiiFileMapDirComparator.getComparator());
                }
            }
        } else {
            String sRelPath = this.getRelativePathFromHome(sParent);
            OiiiFileMapDirEntry tmpDir = new OiiiFileMapDirEntry(null, sRelPath);
            int index = OiixSearch.bSearch(tmpDir, this.m_otherDirs, OiiiFileMapDirComparator.getComparator());
            if (index != -1) {
                oDir = (OiiiFileMapDirEntry)this.m_otherDirs.elementAt(index);
            } else {
                oDir = new OiiiFileMapDirEntry(this, sRelPath);
                if (bInsert) {
                    OiixSearch.bSearchAndInsert(oDir, this.m_otherDirs, OiiiFileMapDirComparator.getComparator());
                } else if (oDir.existsFileMap()) {
                    OiixSearch.bSearchAndInsert(oDir, this.m_otherDirs, OiiiFileMapDirComparator.getComparator());
                }
            }
        }
        return oDir;
    }

    public OiiiFileMapFileEntry addFileEntry(String filePath, OiiiCompInstallID compID) {
        String sParentFilePath = this.getParentDir(filePath);
        OiiiFileMapDirEntry oDir = this.getFileMapDir(sParentFilePath);
        OiiiFileMapFileEntry oFileEntry = null;
        String sHomePath = this.getHomePath();
        if (oDir != null) {
            oFileEntry = oDir.addFileEntry(filePath, compID);
        } else {
            String sDirPath = this.getParentDir(filePath);
            String sDirRelPath = this.getRelativePathFromHome(sDirPath);
            oDir = new OiiiFileMapDirEntry(this, sDirRelPath);
            oFileEntry = oDir.addFileEntry(filePath, compID);
            if (OiipgFileSystem.isParentDirOf(this.m_fHomePath, new File(OiixPathOps.getNativeForm(sDirPath)))) {
                OiixSearch.bSearchAndInsert(oDir, this.m_homeDirs, OiiiFileMapDirComparator.getComparator());
            } else {
                OiixSearch.bSearchAndInsert(oDir, this.m_otherDirs, OiiiFileMapDirComparator.getComparator());
            }
        }
        return oFileEntry;
    }

    public OiiiFileMapFileEntry addFileEntry(String filePath, OiiiOneoffInstallID oneoffId) throws OiiiOneoffException {
        String sParentFilePath = this.getParentDir(filePath);
        OiiiFileMapDirEntry oDir = this.getFileMapDir(sParentFilePath);
        OiiiFileMapFileEntry oFileEntry = null;
        if (oDir != null) {
            oFileEntry = oDir.addFileEntry(filePath, oneoffId);
        } else {
            String sDirPath = this.getParentDir(filePath);
            String sDirRelPath = this.getRelativePathFromHome(sDirPath);
            oDir = new OiiiFileMapDirEntry(this, sDirRelPath);
            oFileEntry = oDir.addFileEntry(filePath, oneoffId);
            if (OiipgFileSystem.isParentDirOf(this.m_fHomePath, new File(OiixPathOps.getNativeForm(sDirPath)))) {
                OiixSearch.bSearchAndInsert(oDir, this.m_homeDirs, OiiiFileMapDirComparator.getComparator());
            } else {
                OiixSearch.bSearchAndInsert(oDir, this.m_otherDirs, OiiiFileMapDirComparator.getComparator());
            }
        }
        return oFileEntry;
    }

    public OiiiFileMapFileEntry getFileEntry(String sFilePath) {
        OiiiFileMapFileEntry oFileEntry = null;
        String sParentFilePath = this.getParentDir(sFilePath);
        OiiiFileMapDirEntry oDir = this.getFileMapDir(sParentFilePath);
        oFileEntry = oDir.getFileEntry(sFilePath);
        return oFileEntry;
    }

    public void save() throws IOException {
        this.saveImpl(false);
    }

    public void saveLeastUsed() throws IOException {
        this.saveImpl(true);
    }

    private void saveImpl(boolean bUseThreshold) throws IOException {
        OiiiFileMapDirEntry oDir;
        Enumeration en = this.m_homeDirs.elements();
        while (en.hasMoreElements()) {
            oDir = (OiiiFileMapDirEntry)en.nextElement();
            if (bUseThreshold && oDir.getReferencerCount() >= 2) continue;
            oDir.save();
            oDir.dispose();
        }
        en = this.m_otherDirs.elements();
        while (en.hasMoreElements()) {
            oDir = (OiiiFileMapDirEntry)en.nextElement();
            if (bUseThreshold && oDir.getReferencerCount() >= 2) continue;
            oDir.save();
            oDir.dispose();
        }
    }

    public void removeFileEntry(String filePath) {
        String sParentFilePath = this.getParentDir(filePath);
        OiiiFileMapDirEntry oDir = this.getFileMapDir(sParentFilePath);
        if (oDir != null) {
            oDir.removeFileEntry(filePath);
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof String) {
            String sOtherPath = OiixPathOps.getStandardCanonicalPath((String)other);
            if (OiipgFileSystem.isCaseSensitive()) {
                return this.getHomePath().equals(sOtherPath);
            }
            return this.getHomePath().equalsIgnoreCase(sOtherPath);
        }
        return super.equals(other);
    }

    String getParentDir(String sFilePath) {
        String sPath = OiixPathOps.getStandardForm(sFilePath);
        return new File(OiixPathOps.getNativeForm(sFilePath)).getParent();
    }

    private String getRelativePathFromHome(String sDirPath) {
        String sDirStdPath = OiixPathOps.getStandardCanonicalPath(sDirPath);
        if (!OiipgFileSystem.isCaseSensitive()) {
            sDirStdPath = sDirStdPath.toLowerCase();
        }
        String sDirRelativePath = sDirStdPath;
        if (sDirStdPath.startsWith(this.m_sHomePath)) {
            sDirRelativePath = sDirStdPath.substring(this.m_sHomePath.length());
            if (sDirRelativePath.length() > 0 && sDirRelativePath.charAt(0) == '/') {
                sDirRelativePath = sDirRelativePath.substring(1);
            }
            if (sDirRelativePath.length() == 0) {
                sDirRelativePath = "./";
            }
        }
        return sDirRelativePath;
    }

    OiiiFileMapDirEntry loadFileMapDir(String sDir) {
        OiiiFileMapDirEntry oDir = this.getFileMapDir(sDir);
        try {
            oDir.loadFileMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oDir;
    }

    void loadFileMapDir(String sDir, String sChildFile) {
        String sCompositeFile = OiixPathOps.concatPath(sDir, sChildFile);
        OiiiFileMapFileEntry oEntry = this.getFileEntry(sCompositeFile);
        if (oEntry != null) {
            try {
                oEntry.loadFileMap();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    OiiiFileMapFileEntry getFileEntryInDir(String sFilePath) {
        OiiiFileMapDirEntry oDir = null;
        String sParentFilePath = this.getParentDir(sFilePath);
        oDir = this.getFileMapDir(sParentFilePath, false);
        OiiiFileMapFileEntry oFile = null;
        if (oDir != null) {
            oFile = oDir.getFileEntry(sFilePath);
        }
        return oFile;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("USAGE: OiiiFileMap <homePath>");
            System.exit(0);
        }
        String homePath = OiixPathOps.getStandardForm(args[0]);
        String homeInvPath = OiixPathOps.concatPath(homePath, "inventory");
        OiiiOracleHomeInfo homeInfo = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory().getHomeWithLocation(homePath);
        OiiiFileMap oFileMap = new OiiiFileMap(homeInfo, homeInvPath);
        OiiiCompInstallID id = new OiiiCompInstallID("oracle.server", new OiiiVersion("9.0.0.0.0"), OiixPlatform.getCurrentPlatformVector());
        for (int i = 0; i < 5; ++i) {
            String sFilePath = OiixPathOps.concatPath(homePath, "File" + i);
            oFileMap.addFileEntry(sFilePath, id);
        }
        try {
            oFileMap.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OiiiFileMapFileEntry oEntry = oFileMap.getFileEntry(OiixPathOps.concatPath(homePath, "File1"));
        if (oEntry != null) {
            System.out.println("entry found : " + ((Object)oEntry).toString());
        } else {
            System.out.println("entry not found");
        }
    }
}

