/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileEntryFormatException;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiFileMapEntryComparator;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oii.oiix.OiixVectorOps;

public abstract class OiiiFileMapEntry {
    private OiiiFileMap m_fileMap;
    private OiixSet m_fileEntries;
    private boolean m_bIsModified = false;
    private boolean m_bLoadedInMemory = false;
    private Vector m_referencerComps;
    private Vector m_referencerOneoffs;
    private String m_sPath;
    protected static final String MAP_FILE_NAME = "files.map";

    public OiiiFileMapEntry() {
    }

    public OiiiFileMapEntry(OiiiFileMap filemap, String sPath) {
        this.m_fileMap = filemap;
        this.m_sPath = sPath;
    }

    public OiiiFileMapFileEntry addFileEntry(String filePath, OiiiCompInstallID compId) {
        String sFileName = this.getRelativeFileLoc(filePath);
        this.loadFileMapIfNotLoaded();
        OiiiFileMapFileEntry oFileEntry = new OiiiFileMapFileEntry(this, sFileName, compId, this.m_fileMap);
        OiiiFileMapFileEntry oFileEntryFromFileMap = null;
        try {
            oFileEntryFromFileMap = (OiiiFileMapFileEntry)this.m_fileEntries.addElement(oFileEntry);
            if (oFileEntryFromFileMap != oFileEntry) {
                oFileEntryFromFileMap.addReferencer(compId);
            }
        }
        catch (OiixInvalidDataException ie) {
            ie.printStackTrace();
        }
        oFileEntryFromFileMap.setModified(true);
        this.setModified(true);
        return oFileEntryFromFileMap;
    }

    public OiiiFileMapFileEntry addFileEntry(String filePath, OiiiOneoffInstallID oneoffID) throws OiiiOneoffException {
        String sFileName = this.getRelativeFileLoc(filePath);
        this.loadFileMapIfNotLoaded();
        OiiiFileMapFileEntry oFileEntry = new OiiiFileMapFileEntry(this, sFileName, oneoffID, this.m_fileMap);
        OiiiFileMapFileEntry oFileEntryFromFileMap = null;
        try {
            oFileEntryFromFileMap = (OiiiFileMapFileEntry)this.m_fileEntries.addElement(oFileEntry);
            if (oFileEntryFromFileMap != oFileEntry) {
                oFileEntryFromFileMap.addReferencer(oneoffID);
            }
        }
        catch (OiixInvalidDataException ie) {
            ie.printStackTrace();
        }
        oFileEntryFromFileMap.setModified(true);
        this.setModified(true);
        return oFileEntryFromFileMap;
    }

    void addFileEntry(OiiiFileMapFileEntry fileEntry) {
        try {
            this.m_fileEntries.addElement(fileEntry);
            fileEntry.setModified(true);
            this.setModified(true);
        }
        catch (OiixInvalidDataException ie) {
            ie.printStackTrace();
        }
    }

    public void removeFileEntry(String filePath) {
        OiiiFileMapFileEntry oEntry = this.getFileEntry(filePath);
        if (oEntry != null) {
            this.m_fileEntries.removeElement(oEntry);
            this.setModified(true);
        }
    }

    public void removeFileEntry(String sFilePath, OiiiCompInstallID cid) {
        OiiiFileMapFileEntry oEntry = this.getFileEntry(sFilePath);
        if (oEntry != null) {
            oEntry.removeReferencer(cid);
            this.setModified(true);
            if (!oEntry.hasReferencers()) {
                this.removeFileEntry(sFilePath);
            }
        }
    }

    public void removeFileEntry(String sFilePath, OiiiOneoffInstallID oid) {
        OiiiFileMapFileEntry oEntry = this.getFileEntry(sFilePath);
        if (oEntry != null) {
            oEntry.removeReferencer(oid);
            this.setModified(true);
            if (!oEntry.hasReferencers()) {
                this.removeFileEntry(sFilePath);
            }
        }
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void setModified(boolean bModified) {
        this.m_bIsModified = bModified;
    }

    protected boolean isFileMapLoaded() {
        return this.m_bLoadedInMemory;
    }

    protected void setFileMapLoaded(boolean bLoaded) {
        this.m_bLoadedInMemory = bLoaded;
    }

    public Enumeration getEntries() {
        return this.m_fileEntries.elements();
    }

    public int getNumEntries() {
        int nEntries = 0;
        if (this.m_fileEntries != null) {
            nEntries = this.m_fileEntries.size();
        }
        return nEntries;
    }

    private void loadFileMapIfNotLoaded() {
        if (!this.isFileMapLoaded()) {
            try {
                this.loadFileMap();
            }
            catch (FileNotFoundException fe) {
                this.setModified(true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public OiiiFileMapFileEntry getFileEntry(String filePath) {
        if (!this.isFileMapLoaded()) {
            try {
                this.loadFileMap();
            }
            catch (FileNotFoundException fe) {
                this.setModified(true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        String sFileName = this.getRelativeFileLoc(filePath);
        OiiiFileMapFileEntry tmpEntry = new OiiiFileMapFileEntry(sFileName, this.m_fileMap);
        return (OiiiFileMapFileEntry)this.getFileEntries().getElementLike(tmpEntry);
    }

    public Vector getReferencerComponents() {
        return this.m_referencerComps;
    }

    public Vector getCompatReferencerComponents() {
        return this.getCompatCompsVect(this.m_referencerComps);
    }

    protected Vector getCompatCompsVect(Vector vComps) {
        if (vComps == null) {
            return null;
        }
        Vector vCompsClone = (Vector)vComps.clone();
        int nComps = vComps.size();
        Vector<OiiiCompInstallID> vCompatComps = new Vector<OiiiCompInstallID>(nComps);
        boolean flagCanReplace = false;
        for (int i = 0; i < nComps; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)vCompsClone.elementAt(i);
            if (cid == null) continue;
            flagCanReplace = false;
            for (int j = i + 1; j < nComps; ++j) {
                OiiiCompInstallID cid2 = (OiiiCompInstallID)vCompsClone.elementAt(j);
                if (cid2 == null) continue;
                if (cid2.canReplace(cid)) {
                    flagCanReplace = true;
                    break;
                }
                if (!cid.canReplace(cid2)) continue;
                vCompsClone.setElementAt(null, j);
            }
            if (flagCanReplace) continue;
            vCompatComps.addElement(cid);
        }
        return vCompatComps;
    }

    public Vector getReferencerOneoffs() {
        return this.m_referencerOneoffs;
    }

    public void addReferencer(OiiiCompInstallID compId) {
        if (this.m_referencerComps == null) {
            this.m_referencerComps = new Vector(5, 5);
        }
        if (OiixVectorOps.vectIndexOf(this.m_referencerComps, (Object)compId) == -1) {
            this.m_referencerComps.addElement(compId);
        }
        this.setModified(true);
    }

    protected void addReferencer(OiiiOneoffInstallID oneoffID) throws OiiiOneoffException {
        if (this.m_referencerOneoffs == null) {
            this.m_referencerOneoffs = new Vector(1, 1);
        }
        if (OiixVectorOps.vectIndexOf(this.m_referencerOneoffs, (Object)oneoffID) == -1) {
            this.m_referencerOneoffs.addElement(oneoffID);
        }
        this.setModified(true);
    }

    protected void updateReferencerComps(Vector vCompIDs) {
        for (int i = 0; i < vCompIDs.size(); ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)vCompIDs.elementAt(i);
            this.addReferencer(cid);
        }
    }

    protected void updateReferencerOneoffs(Vector vOneoffIDs) throws OiiiOneoffException {
        for (int i = 0; i < vOneoffIDs.size(); ++i) {
            OiiiOneoffInstallID oid = (OiiiOneoffInstallID)vOneoffIDs.elementAt(i);
            this.addReferencer(oid);
        }
    }

    public void removeReferencer(OiiiCompInstallID compId) {
        this.m_referencerComps.removeElement(compId);
        this.setModified(true);
    }

    public void removeReferencer(OiiiOneoffInstallID oneOffID) {
        this.m_referencerOneoffs.removeElement(oneOffID);
        this.setModified(true);
    }

    protected void setReferencerComponents(Vector vComps) {
        this.m_referencerComps = vComps;
    }

    protected void setReferencerOneoffs(Vector vOneoffs) {
        this.m_referencerOneoffs = vOneoffs;
    }

    public int getReferencerCount() {
        int nCount = 0;
        if (this.m_referencerComps != null) {
            nCount += this.m_referencerComps.size();
        }
        if (this.m_referencerOneoffs != null) {
            nCount += this.m_referencerOneoffs.size();
        }
        return nCount;
    }

    public void save() throws IOException {
        if (!this.isModified()) {
            return;
        }
        String sPath = this.getPath();
        if (sPath == null || sPath.length() == 0) {
            return;
        }
        String sFileMapDirPath = OiixPathOps.concatPath(this.getFileMap().getFileMapRoot(), OiipgFileSystem.getPathAsDirectory(this.getPath()));
        String sFilesMapPath = OiixPathOps.concatPath(sFileMapDirPath, MAP_FILE_NAME);
        sFilesMapPath = OiixPathOps.getNativeForm(sFilesMapPath);
        if (this.getNumEntries() < 1) {
            OiixFileOps.recdelete(new File(OiixPathOps.getNativeForm(sFileMapDirPath)));
            OiixFileOps.recdelete(this.getFileMap().getFileMapRoot(), sFilesMapPath);
        } else {
            File oFileMapDir = new File(OiixPathOps.getNativeForm(sFileMapDirPath));
            OiixFileOps.mkdirs(oFileMapDir);
            PrintWriter pw = null;
            boolean bSaveRequired = true;
            while (bSaveRequired) {
                pw = new PrintWriter(new BufferedWriter(new FileWriter(sFilesMapPath)));
                Enumeration en = this.m_fileEntries.elements();
                while (en.hasMoreElements()) {
                    OiiiFileMapFileEntry oEntry = (OiiiFileMapFileEntry)en.nextElement();
                    oEntry.setSavingDirFilesMap(!this.isFileEntry());
                    oEntry.save(pw);
                }
                if (pw.checkError()) {
                    if (!OiipgFileSystem.isSpaceAvailable(1024L, sFilesMapPath)) {
                        try {
                            OiixFileOps.validateDiskSpace(1024L, sFilesMapPath, false, true);
                        }
                        catch (OiifbCancelException e1) {
                            // empty catch block
                        }
                    }
                    bSaveRequired = true;
                } else {
                    bSaveRequired = false;
                }
                pw.close();
            }
        }
        this.setModified(false);
    }

    protected void dispose() {
        if (this.isModified()) {
            throw new IllegalStateException("Filemap entries being disposed before without committing them." + this.getPath());
        }
        if (this.m_fileEntries != null) {
            this.m_fileEntries.removeAllElements();
        }
        this.setFileMapLoaded(false);
    }

    protected String getPath() {
        return this.m_sPath;
    }

    protected String getRelativeFileLoc(String sFilePath) {
        String sRelativePath = new File(OiixPathOps.getNativeForm(sFilePath)).getName();
        return sRelativePath;
    }

    protected void setPath(String sPath) {
        this.m_sPath = sPath;
    }

    OiiiFileMap getFileMap() {
        return this.m_fileMap;
    }

    protected void setFileMap(OiiiFileMap filemap) {
        this.m_fileMap = filemap;
    }

    protected void setFileEntries(OiixSet fileEntries) {
        this.m_fileEntries = fileEntries;
    }

    protected OiixSet getFileEntries() {
        return this.m_fileEntries;
    }

    protected void initFileEntries() {
        try {
            this.m_fileEntries = new OiixSet("oracle.sysman.oii.oiii.OiiiFileMapEntry", OiiiFileMapEntryComparator.getComparator());
        }
        catch (OiixInvalidDataException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFileMap() throws IOException {
        if (this.isFileMapLoaded()) {
            return;
        }
        this.setFileMapLoaded(true);
        String filemapPath = OiixPathOps.concatPath(this.getFileMap().getFileMapRoot(), OiipgFileSystem.getPathAsDirectory(this.getPath()));
        filemapPath = OiixPathOps.concatPath(filemapPath, MAP_FILE_NAME);
        filemapPath = OiixPathOps.getNativeForm(filemapPath);
        FileReader fr = new FileReader(filemapPath);
        BufferedReader br = new BufferedReader(fr);
        String sFileEntry = "";
        try {
            while ((sFileEntry = br.readLine()) != null) {
                try {
                    OiiiFileMapFileEntry oEntry = OiiiFileMapFileEntry.createFileMapFileEntry(this, sFileEntry, this.m_fileMap);
                    try {
                        oEntry.loadFileMap();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.getFileEntries().addElement(oEntry);
                }
                catch (OiiiFileEntryFormatException fe) {
                    fe.printStackTrace();
                }
                catch (OiixInvalidDataException ie) {
                    ie.printStackTrace();
                }
            }
        }
        finally {
            br.close();
            fr.close();
        }
    }

    String getDirPath() {
        String sPath = "";
        sPath = OiiiFileMapEntry.pathStartsFromRoot(this.getPath()) ? OiixPathOps.getStandardCanonicalPath(this.getPath()) : OiixPathOps.getStandardCanonicalPath(OiixPathOps.concatPath(this.m_fileMap.getHomePath(), this.getPath()));
        File fEntry = new File(sPath);
        String sParentDir = fEntry.getParent();
        return OiixPathOps.directorify(OiixPathOps.getStandardForm(sParentDir));
    }

    static boolean pathStartsFromRoot(String sPath) {
        if (sPath.startsWith("/")) {
            return true;
        }
        return sPath.length() > 1 && sPath.charAt(1) == ':';
    }

    boolean isFileEntry() {
        return true;
    }

    boolean existsFileMap() {
        String filemapPath = OiixPathOps.concatPath(this.getFileMap().getFileMapRoot(), OiipgFileSystem.getPathAsDirectory(this.getPath()));
        filemapPath = OiixPathOps.concatPath(filemapPath, MAP_FILE_NAME);
        filemapPath = OiixPathOps.getNativeForm(filemapPath);
        File f = new File(filemapPath);
        return f.exists();
    }

    public static void main(String[] args) {
        try {
            String sFileEntry;
            FileReader fr = new FileReader(args[0]);
            BufferedReader br = new BufferedReader(fr);
            FileWriter fw = new FileWriter(args[1]);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter pw = new PrintWriter(bw);
            while ((sFileEntry = br.readLine()) != null) {
                OiiiFileMapFileEntry oFileEntry = OiiiFileMapFileEntry.createFileMapFileEntry(null, sFileEntry, null);
                System.out.println(oFileEntry.toString());
                oFileEntry.save(pw);
            }
            pw.close();
            bw.close();
            fw.close();
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

