/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileEntryFormatException;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiFileMapEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixSet;

public class OiiiFileMapFileEntry
extends OiiiFileMapEntry {
    private String m_sFileName;
    private OiiiFileMapEntry m_parent;
    private OiiiFileMapFileEntry m_owner;
    private String m_sOwnerFileName;
    private Hashtable m_unknownAttributesTable;
    private boolean m_bSavingDirFilesMap = true;
    private static final String ATTRIB_START = "{";
    private static final String ATTRIB_END = "}";
    private static final String FILENAME_DELIM = "::";
    private static final String QUOTE = "\"";
    private static final String COMMA = ",";
    private static final String REF_COMP = "component";
    private static final String REF_PATCH = "patch";
    private static final String REF_ONEOFF = "oneoff";
    private static final String OWNER = "owner";
    private static final String PARENTDIR = "parentdir";

    public OiiiFileMapFileEntry(OiiiFileMapEntry parent, String sFileName, OiiiCompInstallID compId, OiiiFileMap fileMap) {
        Vector<OiiiCompInstallID> vReferencerComps = new Vector<OiiiCompInstallID>();
        vReferencerComps.addElement(compId);
        this.setReferencerComponents(vReferencerComps);
        this.m_parent = parent;
        this.m_sFileName = sFileName;
        this.setFileMap(fileMap);
    }

    public OiiiFileMapFileEntry(OiiiFileMapEntry parent, String sFileName, OiiiOneoffInstallID oneOffID, OiiiFileMap fileMap) {
        Vector<OiiiOneoffInstallID> vReferencerOneoffs = new Vector<OiiiOneoffInstallID>();
        vReferencerOneoffs.addElement(oneOffID);
        this.setReferencerOneoffs(vReferencerOneoffs);
        this.m_parent = parent;
        this.m_sFileName = sFileName;
        this.setFileMap(fileMap);
    }

    public OiiiFileMapFileEntry(OiiiFileMapEntry parent, String sFileName, Vector referencerComps, Vector referencerOneoffs, OiiiFileMap fileMap) {
        this.m_parent = parent;
        this.m_sFileName = sFileName;
        this.setReferencerComponents(referencerComps);
        this.setReferencerOneoffs(referencerOneoffs);
        this.setFileMap(fileMap);
    }

    public OiiiFileMapFileEntry(String sOwnerFile, String sFileName) {
        this.m_sOwnerFileName = sOwnerFile;
        this.m_sFileName = sFileName;
    }

    public OiiiFileMapFileEntry(OiiiFileMap sFileMap, String sFileName, String sOwnerFile, String sPath, OiiiFileMapFileEntry sOwner) {
        super(sFileMap, null);
        sPath = sPath != null ? OiixPathOps.concatPath(sPath, sFileName) : sFileName;
        this.setPath(sPath);
        this.m_sOwnerFileName = sOwnerFile;
        this.m_sFileName = sFileName;
        this.m_owner = sOwner;
    }

    OiiiFileMapFileEntry(String sFileName, OiiiFileMap fileMap) {
        this.m_parent = null;
        this.m_sFileName = sFileName;
        this.setFileMap(fileMap);
    }

    public void addUnknownAttribute(String name, Vector values) {
        if (this.m_unknownAttributesTable == null) {
            this.m_unknownAttributesTable = new Hashtable();
        }
        this.m_unknownAttributesTable.put(name, values);
    }

    public String toString() {
        return this.formatFileEntry();
    }

    public String getPath() {
        if (super.getPath() == null) {
            String sPath = "";
            sPath = this.m_parent != null ? OiixPathOps.concatPath(this.m_parent.getPath(), this.m_sFileName) : this.m_sFileName;
            this.setPath(sPath);
        }
        return super.getPath();
    }

    protected OiiiFileMap getFileMap() {
        return super.getFileMap();
    }

    protected OiixSet getFileEntries() {
        OiixSet fileEntries = super.getFileEntries();
        if (fileEntries == null) {
            this.initFileEntries();
        }
        return super.getFileEntries();
    }

    protected String getRelativeFileLoc(String sFilePath) {
        return sFilePath;
    }

    String getFileName() {
        return this.m_sFileName;
    }

    protected void setModified(boolean bModified) {
        super.setModified(bModified);
        if (bModified && this.m_parent != null) {
            this.m_parent.setModified(true);
        }
        if (bModified && this.m_owner != null) {
            this.m_owner.setModified(true);
        }
    }

    private String formatFileEntry() {
        Enumeration<Object> en;
        Vector vReferencerOneoffs;
        String sFileEntry = this.m_sFileName + FILENAME_DELIM;
        String sOwner = "";
        if (this.getOwner() != null && this.m_parent != null) {
            String sFileToWrite = "";
            String sAttrib = "";
            if (this.isSavingDirFilesMap()) {
                sAttrib = OWNER;
                sFileToWrite = this.m_owner.getFilePath();
            } else {
                sAttrib = PARENTDIR;
                sFileToWrite = this.getDirPath();
            }
            sOwner = sOwner + ATTRIB_START + QUOTE + sAttrib + QUOTE + COMMA + QUOTE + sFileToWrite + QUOTE + ATTRIB_END + COMMA;
        }
        String sRefList = "";
        Vector vReferencerComps = this.getReferencerComponents();
        if (vReferencerComps != null) {
            Enumeration en2 = vReferencerComps.elements();
            while (en2.hasMoreElements()) {
                sRefList = sRefList + "{ \"component\",";
                OiiiCompInstallID compId = (OiiiCompInstallID)en2.nextElement();
                sRefList = sRefList + " \"" + compId.getName() + "\", \"" + compId.getVersion() + "\"}, ";
            }
        }
        if ((vReferencerOneoffs = this.getReferencerOneoffs()) != null) {
            en = vReferencerOneoffs.elements();
            while (en.hasMoreElements()) {
                sRefList = sRefList + "{ \"oneoff\",";
                OiiiOneoffInstallID oneoffID = (OiiiOneoffInstallID)en.nextElement();
                sRefList = sRefList + " \"" + oneoffID.getID() + "\"},";
            }
        }
        if (this.m_unknownAttributesTable != null) {
            en = this.m_unknownAttributesTable.keys();
            while (en.hasMoreElements()) {
                String attribName = (String)en.nextElement();
                Vector values = (Vector)this.m_unknownAttributesTable.get(attribName);
                String unknownAttrib = this.formatUnknownAttribute(attribName, values);
                sRefList = sRefList + unknownAttrib + COMMA;
            }
        }
        sFileEntry = sFileEntry + sOwner + sRefList;
        return sFileEntry;
    }

    private void writeFormatattedFileEntry(PrintWriter pw) {
        Enumeration<Object> en;
        Vector vReferencerOneoffs;
        Vector vReferencerComps;
        if (this.m_sFileName == null || this.m_sFileName.length() == 0) {
            return;
        }
        pw.print(this.m_sFileName);
        pw.print(FILENAME_DELIM);
        if (this.getOwner() != null && this.m_parent != null) {
            pw.print(ATTRIB_START);
            pw.print(QUOTE);
            if (this.isSavingDirFilesMap()) {
                pw.print(OWNER);
                pw.print(QUOTE);
                pw.print(COMMA);
                pw.print(QUOTE);
                pw.print(this.m_owner.getFilePath());
                pw.print(QUOTE);
            } else {
                pw.print(PARENTDIR);
                pw.print(QUOTE);
                pw.print(COMMA);
                pw.print(QUOTE);
                pw.print(this.getDirPath());
                pw.print(QUOTE);
            }
            pw.print(ATTRIB_END);
            pw.print(COMMA);
        }
        if ((vReferencerComps = this.getReferencerComponents()) != null) {
            Enumeration en2 = vReferencerComps.elements();
            while (en2.hasMoreElements()) {
                OiiiCompInstallID compId = (OiiiCompInstallID)en2.nextElement();
                pw.print(ATTRIB_START);
                pw.print(QUOTE);
                if (compId.getCompType() == 1) {
                    pw.print(REF_COMP);
                } else {
                    pw.print(REF_PATCH);
                }
                pw.print(QUOTE);
                pw.print(COMMA);
                pw.print(QUOTE);
                pw.print(compId.getName());
                pw.print(QUOTE);
                pw.print(COMMA);
                pw.print(QUOTE);
                pw.print(compId.getVersion());
                pw.print(QUOTE);
                pw.print(ATTRIB_END);
                pw.print(COMMA);
            }
        }
        if ((vReferencerOneoffs = this.getReferencerOneoffs()) != null) {
            en = vReferencerOneoffs.elements();
            while (en.hasMoreElements()) {
                pw.print(ATTRIB_START);
                pw.print(QUOTE);
                pw.print(REF_ONEOFF);
                pw.print(QUOTE);
                pw.print(COMMA);
                pw.print(QUOTE);
                OiiiOneoffInstallID oneoffID = (OiiiOneoffInstallID)en.nextElement();
                pw.print(oneoffID.getID());
                pw.print(QUOTE);
                pw.print(ATTRIB_END);
                pw.print(COMMA);
            }
        }
        if (this.m_unknownAttributesTable != null) {
            en = this.m_unknownAttributesTable.keys();
            while (en.hasMoreElements()) {
                String attribName = (String)en.nextElement();
                Vector values = (Vector)this.m_unknownAttributesTable.get(attribName);
                String unknownAttrib = this.formatUnknownAttribute(attribName, values);
                pw.print(unknownAttrib);
                pw.print(COMMA);
            }
        }
        pw.println();
    }

    public void save(PrintWriter printWriter) throws IOException {
        this.writeFormatattedFileEntry(printWriter);
        this.setModified(true);
        this.save();
    }

    public void addReferencer(OiiiOneoffInstallID oneoffID) throws OiiiOneoffException {
        Vector vReferencerOneoffs = this.getReferencerOneoffs();
        if (vReferencerOneoffs != null && vReferencerOneoffs.size() > 0) {
            OiiiOneoffInstallID oID = (OiiiOneoffInstallID)vReferencerOneoffs.elementAt(0);
            throw new OiiiOneoffException("S_ONEOFF_FILE_ALREADY_PATCHED", new Object[]{this.getPath(), oID});
        }
        super.addReferencer(oneoffID);
    }

    public boolean hasReferencers() {
        Vector vReferencerComps = this.getReferencerComponents();
        Vector vReferencerOneoffs = this.getReferencerOneoffs();
        boolean bHasReferencers = vReferencerComps != null && vReferencerComps.size() != 0 || vReferencerOneoffs != null && vReferencerOneoffs.size() != 0;
        return bHasReferencers;
    }

    public String getName() {
        return this.m_sFileName;
    }

    public String getFilePath() {
        if (!this.isChildFile()) {
            return this.getDirPath() + this.getName();
        }
        return this.getFileName();
    }

    public String getParentDirPath() {
        if (this.m_parent != null) {
            return this.m_parent.getPath();
        }
        return null;
    }

    public String getOwnerFilePath() {
        if (this.getOwner() != null) {
            return this.m_owner.getFilePath();
        }
        return null;
    }

    public OiiiFileMapFileEntry getOwnerFileEntry() {
        if (this.getOwner() != null) {
            return this.m_owner;
        }
        return null;
    }

    String getOwnerFileName() {
        return this.m_sOwnerFileName;
    }

    void setOwnerFileName(String sOwnerFileName) {
        this.m_sOwnerFileName = sOwnerFileName;
    }

    public boolean isCompositeFile() {
        return this.getNumEntries() > 0;
    }

    public boolean isChildFile() {
        return this.getOwner() != null;
    }

    boolean isFileEntry() {
        return true;
    }

    private String formatUnknownAttribute(String sAttribName, Vector values) {
        String sUnknownAttribute = "{\"" + sAttribName + "\",";
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            sUnknownAttribute = sUnknownAttribute + QUOTE + (String)values.elementAt(i) + "\",";
        }
        sUnknownAttribute = sUnknownAttribute + ATTRIB_END;
        return sUnknownAttribute;
    }

    private static String stripQuotes(String s) {
        if (s.startsWith(QUOTE) && s.endsWith(QUOTE)) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void processAttribute(String sAttribName, Vector values) throws OiiiFileEntryFormatException {
        int nCompHomeType = 2;
        switch (this.getFileMap().getHomeType()) {
            case 2: {
                nCompHomeType = 0;
                break;
            }
            case 1: {
                nCompHomeType = 3;
                break;
            }
            case 0: {
                nCompHomeType = 2;
            }
        }
        if (sAttribName.equalsIgnoreCase(REF_COMP)) {
            if (values.size() < 2) {
                throw new OiiiFileEntryFormatException();
            }
            String sCompName = (String)values.elementAt(0);
            String sVersion = (String)values.elementAt(1);
            OiiiCompInstallID compId = new OiiiCompInstallID(sCompName, new OiiiVersion(sVersion), OiixPlatform.getCurrentPlatformVector());
            compId.setHomeType(nCompHomeType);
            compId = OiiiCompIDPool.getInstance().get(compId);
            this.addReferencer(compId);
        } else if (sAttribName.equalsIgnoreCase(REF_PATCH)) {
            if (values.size() < 2) {
                throw new OiiiFileEntryFormatException();
            }
            String sPatchName = (String)values.elementAt(0);
            OiiiVersion ver = new OiiiVersion((String)values.elementAt(1));
            OiiiCompInstallID compId = new OiiiCompInstallID(sPatchName, ver, OiixPlatform.getCurrentPlatformVector());
            compId.setCompType(2);
            compId.setHomeType(nCompHomeType);
            compId = OiiiCompIDPool.getInstance().get(compId);
            this.addReferencer(compId);
        } else if (sAttribName.equalsIgnoreCase(REF_ONEOFF)) {
            if (values.size() < 1) {
                throw new OiiiFileEntryFormatException();
            }
            String soneOffID = (String)values.elementAt(0);
            OiiiOneoffInstallID oneOffID = new OiiiOneoffInstallID(soneOffID);
            try {
                this.addReferencer(oneOffID);
                this.addEntryToOneoff(oneOffID);
            }
            catch (OiiiOneoffException e) {
                throw new OiiiFileEntryFormatException();
            }
        } else {
            this.addUnknownAttribute(sAttribName, values);
        }
    }

    private void addEntryToOneoff(OiiiOneoffInstallID oneoffID) {
        OiiiInstallInventory inventory = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
        OiiiInstallOneoffInvEntry oneoff = null;
        try {
            oneoff = inventory.getOneoffInvEntry(oneoffID.getID(), this.getFileMap().getHomeName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oneoff != null) {
            oneoff.addPatchedFileEntry(this);
        }
    }

    void setOwner(OiiiFileMapFileEntry owner) {
        this.m_owner = owner;
    }

    OiiiFileMapFileEntry getOwner() {
        if (this.m_owner == null && this.m_sOwnerFileName != null) {
            this.m_owner = this.getFileMap().getFileEntryInDir(this.m_sOwnerFileName);
        }
        return this.m_owner;
    }

    static OiiiFileMapFileEntry createFileMapFileEntry(OiiiFileMapEntry parent, String sFileEntry, OiiiFileMap fileMap) throws OiiiFileEntryFormatException {
        int delimIndex = sFileEntry.indexOf(FILENAME_DELIM);
        if (delimIndex == -1) {
            throw new OiiiFileEntryFormatException();
        }
        Vector<String> vAttribNames = new Vector<String>(5);
        Vector vAttribValues = new Vector(5);
        String sOwnerFile = null;
        String sParentDir = null;
        String sFileName = "";
        try {
            sFileName = sFileEntry.substring(0, delimIndex);
            String sAttList = sFileEntry.substring(delimIndex + 1);
            int start = 0;
            int attStartIndex = 0;
            int attEndIndex = 0;
            while ((attStartIndex = sAttList.indexOf(ATTRIB_START, start)) != -1) {
                attEndIndex = sAttList.indexOf(ATTRIB_END, attStartIndex);
                String sAttribute = sAttList.substring(attStartIndex + 1, attEndIndex);
                StringTokenizer st = new StringTokenizer(sAttribute, COMMA);
                String sAttribName = OiiiFileMapFileEntry.stripQuotes(st.nextToken().trim());
                Vector<String> values = new Vector<String>(2, 5);
                while (st.hasMoreTokens()) {
                    String sValue = OiiiFileMapFileEntry.stripQuotes(st.nextToken().trim());
                    values.addElement(sValue);
                }
                if (sAttribName.equalsIgnoreCase(OWNER)) {
                    sOwnerFile = (String)values.elementAt(0);
                } else if (sAttribName.equalsIgnoreCase(PARENTDIR)) {
                    sParentDir = (String)values.elementAt(0);
                } else {
                    vAttribNames.addElement(sAttribName);
                    vAttribValues.addElement(values);
                }
                start = attEndIndex + 1;
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new OiiiFileEntryFormatException();
        }
        catch (NoSuchElementException ne) {
            throw new OiiiFileEntryFormatException();
        }
        OiiiFileMapFileEntry retEntry = null;
        if (sOwnerFile != null || sParentDir != null) {
            if (!parent.isFileEntry()) {
                retEntry = new OiiiFileMapFileEntry(parent, sFileName, new Vector(5), new Vector(5), fileMap);
                OiiiFileMapFileEntry.processAttributes(retEntry, vAttribNames, vAttribValues);
                retEntry.setOwnerFileName(sOwnerFile);
            } else {
                String sFilePath = "";
                sFilePath = OiiiFileMapFileEntry.pathStartsFromRoot(sFileName) ? sFileName : OiixPathOps.directorify(OiixPathOps.getStandardCanonicalPath(sParentDir)) + sFileName;
                retEntry = fileMap.getFileEntryInDir(sFilePath);
            }
        } else {
            if (!parent.isFileEntry()) {
                retEntry = new OiiiFileMapFileEntry(parent, sFileName, new Vector(5), new Vector(5), fileMap);
            } else {
                retEntry = new OiiiFileMapFileEntry(null, sFileName, new Vector(5), new Vector(5), fileMap);
                retEntry.setOwner((OiiiFileMapFileEntry)parent);
            }
            OiiiFileMapFileEntry.processAttributes(retEntry, vAttribNames, vAttribValues);
        }
        return retEntry;
    }

    private static void processAttributes(OiiiFileMapFileEntry fileEntry, Vector vAttribNames, Vector vAttribValues) throws OiiiFileEntryFormatException {
        int iSize = vAttribNames.size();
        for (int i = 0; i < iSize; ++i) {
            String attName = (String)vAttribNames.elementAt(i);
            Vector vAttValues = (Vector)vAttribValues.elementAt(i);
            fileEntry.processAttribute(attName, vAttValues);
        }
    }

    void setSavingDirFilesMap(boolean bSavingDirFilesMap) {
        this.m_bSavingDirFilesMap = bSavingDirFilesMap;
    }

    boolean isSavingDirFilesMap() {
        return this.m_bSavingDirFilesMap;
    }
}

