/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

class OiiiHomeInvDetails {
    public static final String XML_VER = "XML_VER";
    public static final String S_COMPS_XML_FILE_NAME_KEY = "CompsXML";
    public static final String S_REL_NOTES_XML_FILE_NAME_KEY = "ReleaseNotesXML";
    public static final String S_CONFIG_XML_FILE_NAME_KEY = "configXML";
    public static final String S_LIB_XML_FILE_NAME_KEY = "LibsXML";
    public static final String S_OH_PROPERTIES_XML_FILE_NAME_KEY = "OHPropsXML";
    private Properties m_props;
    private static OiiiHomeInvDetails s_defaultInvDetails;

    OiiiHomeInvDetails() {
        this.m_props = new Properties();
        this.m_props.setProperty(XML_VER, "4.1");
        this.m_props.setProperty(S_COMPS_XML_FILE_NAME_KEY, "comps.xml");
        this.m_props.setProperty(S_REL_NOTES_XML_FILE_NAME_KEY, "releaseNotes.xml");
        this.m_props.setProperty(S_CONFIG_XML_FILE_NAME_KEY, "config.xml");
        this.m_props.setProperty(S_LIB_XML_FILE_NAME_KEY, "libs.xml");
        this.m_props.setProperty(S_OH_PROPERTIES_XML_FILE_NAME_KEY, "oraclehomeproperties.xml");
    }

    OiiiHomeInvDetails(Properties props) {
        if (props == null) {
            throw new NullPointerException();
        }
        this.m_props = props;
    }

    String getCompsFileName() {
        return this.m_props.getProperty(S_COMPS_XML_FILE_NAME_KEY, "comps.xml");
    }

    String getConfigToolsFileName() {
        return this.m_props.getProperty(S_CONFIG_XML_FILE_NAME_KEY);
    }

    String getReleaseNotesFileName() {
        return this.m_props.getProperty(S_REL_NOTES_XML_FILE_NAME_KEY, "releaseNotes.xml");
    }

    String getLibsFileName() {
        return this.m_props.getProperty(S_LIB_XML_FILE_NAME_KEY, "libs.xml");
    }

    String getOHPropsFileName() {
        return this.m_props.getProperty(S_OH_PROPERTIES_XML_FILE_NAME_KEY, "oraclehomeproperties.xml");
    }

    String getXMLVersion() {
        return this.m_props.getProperty(XML_VER, "4.1");
    }

    void write(OutputStream os) throws IOException {
        this.m_props.store(os, "invDetails.properties");
        os.flush();
    }

    static OiiiHomeInvDetails getDefault() {
        if (s_defaultInvDetails == null) {
            s_defaultInvDetails = new OiiiHomeInvDetails();
        }
        return s_defaultInvDetails;
    }

    static OiiiHomeInvDetails load(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return new OiiiHomeInvDetails(props);
    }
}

