/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompCloneVars;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompIdVerPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryHelper;
import oracle.sysman.oii.oiii.OiiiMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiiInstallCompInvEntry
extends OiiiCompInvEntry
implements Serializable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = 2831268292535437125L;
    private String m_prodHomeLoc;
    private OiiiVersion m_installerVersion;
    private OiiiVersion m_oDeinstallVersion;
    private String m_sXMLLoc;
    private OiiiCompCloneVars m_compCloneVars;
    private transient OiiiInstallPatchInvEntry m_patchInvEntry = null;
    private boolean m_notifRequested;
    protected transient Hashtable m_unknownXMLElementsTable;
    private int m_nOHIndex;
    private Date m_oInstallTime;
    private static final String S_PRODHOME_LOC = "prodHomeLoc";
    private static final String S_INSTALL_VERSION = "installVersion";
    private static final String S_MIN_DEINSTALL_VERSION = "minDeinstallVersion";
    private static final String S_NOTIF_REQUESTED = "notifRequested";
    private static final String S_INSTALL_TIME = "installTime";
    private transient Vector m_vOneoffs = new Vector();
    private transient Vector m_vMiniPatchsets = new Vector();
    private transient Vector m_vUpgradeLangs = new Vector();

    public OiiiInstallCompInvEntry(OiiiCompInstallID cid, String installLoc, Vector langVect, Vector dependees, String prodHomeLoc) {
        super(cid, installLoc, langVect);
        this.setDependees(dependees);
        this.m_prodHomeLoc = prodHomeLoc;
        this.setInstallDefnLoc(OiixPathOps.concatPath("../", "Scripts"));
    }

    public OiiiInstallCompInvEntry(OiiiCompInstallID cid, String installLoc, Vector langVect, Vector dependees) {
        this(cid, installLoc, langVect, dependees, null);
    }

    public OiiiInstallCompInvEntry(OiivVerIndObjectRep viObj) {
        super(viObj);
        this.m_prodHomeLoc = (String)viObj.getObjectForName(S_PRODHOME_LOC);
        this.m_installerVersion = (OiiiVersion)viObj.getObjectForName(S_INSTALL_VERSION);
        this.m_oDeinstallVersion = (OiiiVersion)viObj.getObjectForName(S_MIN_DEINSTALL_VERSION);
        this.m_oInstallTime = (Date)viObj.getObjectForName(S_INSTALL_TIME);
        Boolean notifReqBool = (Boolean)viObj.getObjectForName(S_NOTIF_REQUESTED);
        if (notifReqBool != null) {
            this.m_notifRequested = notifReqBool;
        }
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = super.getVerIndRep();
        retRep.addNVPair(S_PRODHOME_LOC, this.m_prodHomeLoc);
        retRep.addNVPair(S_INSTALL_VERSION, this.getInstallerVersion());
        retRep.addNVPair(S_MIN_DEINSTALL_VERSION, this.getDeinstallVersion());
        if (this.getInstallTime() == null) {
            this.setInstallTime(new Date(System.currentTimeMillis()));
        }
        retRep.addNVPair(S_INSTALL_TIME, this.m_oInstallTime);
        retRep.addNVPair(S_NOTIF_REQUESTED, OiixUtilityOps.booleanValueOf(this.m_notifRequested));
        return retRep;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(S_PRODHOME_LOC)) {
            return this.m_prodHomeLoc.equals(value);
        }
        if (key.equals(S_NOTIF_REQUESTED)) {
            return this.m_notifRequested == (Boolean)value;
        }
        return super.compareKeyValue(key, value);
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = super.mergeVerIndRep(vIndObj);
        retRep.setNVPair(S_PRODHOME_LOC, this.m_prodHomeLoc);
        retRep.setNVPair(S_INSTALL_VERSION, this.getInstallerVersion());
        retRep.setNVPair(S_MIN_DEINSTALL_VERSION, this.getDeinstallVersion());
        retRep.setNVPair(S_NOTIF_REQUESTED, OiixUtilityOps.booleanValueOf(this.m_notifRequested));
        retRep.setNVPair(S_INSTALL_TIME, this.m_oInstallTime);
        return retRep;
    }

    public String getProdHomeLoc() {
        return this.m_prodHomeLoc;
    }

    public void setProdHomeLoc(String prodHomeLoc) {
        this.m_prodHomeLoc = prodHomeLoc;
    }

    public void setDeinstallVersion(OiiiVersion sVersion) {
        this.m_oDeinstallVersion = sVersion;
    }

    public OiiiVersion getDeinstallVersion() {
        if (this.m_oDeinstallVersion == null) {
            this.m_oDeinstallVersion = this.getInstallerVersion();
        }
        return this.m_oDeinstallVersion;
    }

    public void setLocationInXMLInventory(String sLoc) {
        this.m_sXMLLoc = sLoc;
    }

    public String getLocationInXMLInventory() {
        return this.m_sXMLLoc;
    }

    public void setInstallerVersion(OiiiVersion sVersion) {
        this.m_installerVersion = sVersion;
    }

    public OiiiVersion getInstallerVersion() {
        if (this.m_installerVersion == null) {
            this.m_installerVersion = new OiiiVersion("1.7.0.0.0");
        }
        return this.m_installerVersion;
    }

    public Date getInstallTime() {
        return this.m_oInstallTime;
    }

    public void setInstallTime(Date oInstallTime) {
        this.m_oInstallTime = oInstallTime;
    }

    public void setOHIndex(int nOHIndex) {
        this.m_nOHIndex = nOHIndex;
    }

    public int getOHIndex() {
        return this.m_nOHIndex;
    }

    public OiiiCompCloneVars getCompCloneVars() {
        return this.m_compCloneVars;
    }

    public void setCompCloneVars(OiiiCompCloneVars compCloneVars) {
        this.m_compCloneVars = compCloneVars;
    }

    public void setPatchInvEntry(OiiiInstallPatchInvEntry patchInvEntry) {
        this.m_patchInvEntry = patchInvEntry;
    }

    public OiiiInstallPatchInvEntry getPatchInvEntry() {
        return this.m_patchInvEntry;
    }

    protected XMLElement buildDOMTree() {
        XMLElement elemDepList;
        XMLElement elemComp = super.buildDOMTree();
        elemComp.setAttribute("XML_INV_LOC", this.getLocationInXMLInventory());
        elemComp.setAttribute("ACT_INST_VER", this.getInstallerVersion().getVerString());
        elemComp.setAttribute("DEINST_VER", this.getDeinstallVersion().getVerString());
        if (this.m_oInstallTime != null) {
            elemComp.setAttribute("INSTALL_TIME", new SimpleDateFormat("yyyy.MMM.dd HH:mm:ss zzz", OiixLanguage.ENGLISH).format(this.m_oInstallTime));
        }
        elemComp.setAttribute("INST_LOC", this.getProdHomeLoc());
        if (this.getCompInstallID().getHomeType() == 1) {
            elemComp.setAttribute("SOH", "T");
        }
        XMLElement elemDepGrpList = this.getUnknownXMLElement("DEP_GRP_LIST");
        if (this.getDeps() != null) {
            elemDepGrpList = OiiiInventoryHelper.getDepGroupsXML(this.getDeps(), elemDepGrpList);
        }
        if (elemDepGrpList != null) {
            elemComp.appendChild((Node)elemDepGrpList);
        }
        elemDepList = (elemDepList = this.getUnknownXMLElement("DEP_LIST")) == null ? new XMLElement("DEP_LIST") : (XMLElement)elemDepList.cloneNode(true);
        Vector dependees = this.getDependees();
        for (int i = 0; i < dependees.size(); ++i) {
            OiiiCompIdOhPair dependee = (OiiiCompIdOhPair)dependees.elementAt(i);
            OiiiCompInstallID cid = dependee.getCompID();
            XMLElement elemDep = dependee.getXMLElement();
            elemDep = elemDep == null ? new XMLElement("DEP") : (XMLElement)elemDep.cloneNode(true);
            elemDep.setAttribute("NAME", cid.getName());
            elemDep.setAttribute("VER", cid.getVersion().getVerString());
            String sDepGroup = dependee.getDepGroup();
            if (sDepGroup != null) {
                elemDep.setAttribute("DEP_GRP_NAME", sDepGroup);
            }
            elemDep.setAttribute("HOME_IDX", String.valueOf(dependee.getOHIndex()));
            elemDepList.appendChild((Node)elemDep);
        }
        elemComp.appendChild((Node)elemDepList);
        XMLElement elemRefList = this.getUnknownXMLElement("REF_LIST");
        elemRefList = elemRefList == null ? new XMLElement("REF_LIST") : (XMLElement)elemRefList.cloneNode(true);
        Vector referencers = this.getReferencers();
        for (int i = 0; i < referencers.size(); ++i) {
            OiiiCompIdOhPair referencer = (OiiiCompIdOhPair)referencers.elementAt(i);
            OiiiCompInstallID cid = referencer.getCompID();
            XMLElement elemRef = referencer.getXMLElement();
            elemRef = elemRef == null ? new XMLElement("REF") : (XMLElement)elemRef.cloneNode(true);
            elemRef.setAttribute("NAME", cid.getName());
            elemRef.setAttribute("VER", cid.getVersion().getVerString());
            elemRef.setAttribute("HOME_IDX", "" + referencer.getOHIndex());
            elemRefList.appendChild((Node)elemRef);
        }
        elemComp.appendChild((Node)elemRefList);
        OiisDepInfo depInfo = this.getDepInfo();
        if (depInfo != null) {
            XMLElement elemInstallTypes = new XMLElement("INST_TYPE_LIST");
            OiisDepMode depMode = depInfo.getDepMode();
            if (depMode != null) {
                XMLElement elemInstallType = new XMLElement("INST_TYPE");
                elemInstallType.setAttribute("NAME", depMode.getInternalName());
                elemInstallType.setAttribute("NAME_ID", depMode.getNameID());
                elemInstallType.setAttribute("DESC_ID", depMode.getDescriptionID());
                elemInstallTypes.appendChild((Node)elemInstallType);
                elemComp.appendChild((Node)elemInstallTypes);
            }
        }
        XMLElement elemFileSizeList = new XMLElement("FILESIZEINFO");
        OiisFileSizeInfo fsi = this.getFileSizeInfoEx();
        if (fsi != null) {
            OiisDestinationIndexMapping destMapping = fsi.getDestIndexMapping();
            int szDestMap = destMapping.size();
            for (int i = 0; i < szDestMap; ++i) {
                String sDest = destMapping.getDestination(i);
                long sz = fsi.getSizeEx(null, null, sDest);
                XMLElement elemDest = new XMLElement("DEST");
                elemDest.setAttribute("VOLUME", sDest);
                elemDest.setAttribute("SPACE_REQ", new Long(sz).toString());
                elemFileSizeList.appendChild((Node)elemDest);
            }
            elemComp.appendChild((Node)elemFileSizeList);
        }
        return elemComp;
    }

    public void setLangsAfterLangUpgrade() {
        if (this.m_vUpgradeLangs.size() > 0) {
            this.updateLanguages(this.m_vUpgradeLangs);
        }
    }

    protected XMLElement createXMLElement() {
        XMLElement element = this.getUnknownXMLElement("COMP");
        element = element == null ? new XMLElement("COMP") : (XMLElement)element.cloneNode(true);
        return element;
    }

    void setUnknownXMLElementsTable(Hashtable elementsTable) {
        this.m_unknownXMLElementsTable = elementsTable;
    }

    Hashtable getUnknownXMLElementsTable() {
        return this.m_unknownXMLElementsTable;
    }

    XMLElement getUnknownXMLElement(String tag) {
        if (this.m_unknownXMLElementsTable != null) {
            return (XMLElement)this.m_unknownXMLElementsTable.get(tag);
        }
        return null;
    }

    public void setNotifRequested(boolean notifRequested) {
        this.m_notifRequested = notifRequested;
    }

    public boolean isNotifRequested() {
        return this.m_notifRequested;
    }

    public void addOneoff(OiiiOneoffInvEntry entry) {
        this.m_vOneoffs.addElement(entry);
    }

    public Vector getOneoffsVect() {
        return this.m_vOneoffs;
    }

    public void addMiniPatchset(OiiiMiniPatchsetInvEntry entry) {
        this.m_vMiniPatchsets.addElement(entry);
    }

    public List getMiniPatchsetsList() {
        return this.m_vMiniPatchsets;
    }

    public OiiiVersion getHighestCompVersion() {
        OiiiVersion highestVersion = this.getCompInstallID().getVersion();
        String compName = this.getCompInstallID().getName();
        int iSize = this.m_vMiniPatchsets != null ? this.m_vMiniPatchsets.size() : 0;
        block0: for (int idx = 0; idx < iSize; ++idx) {
            OiiiInstallMiniPatchsetInvEntry impIE = (OiiiInstallMiniPatchsetInvEntry)this.m_vMiniPatchsets.get(idx);
            Vector baseComps = impIE.getBaseComps();
            if (baseComps == null) continue;
            for (int compIndex = 0; compIndex < baseComps.size(); ++compIndex) {
                OiiiVersion currentVersion;
                OiiiCompIdVerPair cIdVerPair = (OiiiCompIdVerPair)baseComps.get(compIndex);
                OiiiCompInstallID cID = cIdVerPair.getCompIdOhPair().getCompID();
                if (!cID.getName().equalsIgnoreCase(compName) || !(currentVersion = cIdVerPair.getToVersion()).laterThan(highestVersion)) continue;
                highestVersion = currentVersion;
                continue block0;
            }
        }
        return highestVersion;
    }

    public void setUpgradeLangs(Vector vLangs) {
        this.m_vUpgradeLangs = vLangs;
    }

    public Vector getUpgradeLangs() {
        return this.m_vUpgradeLangs;
    }
}

