/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCloneInfo;
import oracle.sysman.oii.oiii.OiiiCloneXMLHandler;
import oracle.sysman.oii.oiii.OiiiClusterException;
import oracle.sysman.oii.oiii.OiiiCompCloneVars;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompIdVerPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiCompositeAreaControl;
import oracle.sysman.oii.oiii.OiiiCompositeHomeInventory;
import oracle.sysman.oii.oiii.OiiiConfigXMLWriter;
import oracle.sysman.oii.oiii.OiiiFileMapEntry;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiHomeInvDetails;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReader;
import oracle.sysman.oii.oiii.OiiiInstallInventoryStreamReader;
import oracle.sysman.oii.oiii.OiiiInstallInventoryWriter;
import oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallSerializedWriter;
import oracle.sysman.oii.oiii.OiiiInstallXMLReader;
import oracle.sysman.oii.oiii.OiiiInstallXMLWriter;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiInventoryHelper;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiLibraryUpdater;
import oracle.sysman.oii.oiii.OiiiMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiMultipleSOHException;
import oracle.sysman.oii.oiii.OiiiNoSuchHomeException;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffFile;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoWriter;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoXMLReader;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSessionCloneVars;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInvEntryNotFoundException;
import oracle.sysman.oii.oiii.OiiiStageInvLoader;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiTargetAreaMap;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiInstallInventory
extends OiiiAreaInventory
implements Serializable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = -3768606528773232507L;
    private static String EXT = "ext";
    private int m_nHomeType = 0;
    private Vector m_oracleHomes = new Vector();
    private Vector m_compositeOracleHomes = new Vector();
    private Vector m_removedHomes = new Vector();
    private Vector m_removedCompositeOracleHomes = new Vector();
    private Vector m_vORCAHomes = new Vector();
    private boolean m_bAutoLoad = true;
    private int m_nPlatform = OiixPlatform.getCurrentPlatform();
    private transient XMLElement m_xmlInvUnknownElement;
    private transient XMLElement m_xmlHLUnknownElement;
    public static final String INDEPENDENT_PRODUCTS = "Independent Products";
    private static final String CS_UTF8 = "UTF-8";
    private transient int m_nHighestHomeIndex;
    private transient OiiiSessionCloneVars m_oCurSessionCloneVars;
    private boolean m_bCRSHomeInfoChecked = false;
    private OiiiOracleHomeInfo m_CRSHomeInfo = null;
    public static final String DEFAULT_HOME_LOCATION = "OraPlaceHolderDummyHome";
    public static final String DEFAULT_HOME_NAME = "OUIPlaceHolderDummyHome";
    private static String s_execCmd = "chmod -R -f ug+rw,o-rwx ";
    private static String s_execCmdHPUX = "chmod -R ug+rw,o-rwx ";
    private static String s_execCmd_logs = "chmod -R -f u+rw,g+r-wx,o-rwx ";
    private static String s_execCmdHPUX_logs = "chmod -R u+rw,g+r-wx,o-rwx ";

    public OiiiInstallInventory() {
    }

    public OiiiInstallInventory(OiiiInstallAreaControl iac) {
        this.setAreaControl(iac);
    }

    public OiiiInstallInventory(OiivVerIndObjectRep viObj) {
        super(viObj);
        Vector oracleHomes = (Vector)viObj.getObjectForName("oracleHomes");
        Vector vHomes = OiivVerIndObjectRep.getVerDepFormOfVect(oracleHomes);
        this.updateHomeLists(vHomes);
    }

    public OiiiInstallInventory(OiivVerIndObjectRep viObj, OiiiTargetAreaControl tac) {
        Vector oracleHomes = new Vector();
        if (viObj != null) {
            oracleHomes = (Vector)viObj.getObjectForName("oracleHomes");
        }
        this.m_oracleHomes = OiivVerIndObjectRep.getVerDepFormOfVect(oracleHomes);
        this.setAreaControl(tac);
    }

    public OiiiInstallInventory(boolean bAutoLoad, int nPlatform) {
        this.m_bAutoLoad = bAutoLoad;
        this.m_nPlatform = nPlatform;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = super.getVerIndRep();
        Vector viOracleHomes = OiivVerIndObjectRep.getVerIndepFormOfVect(this.getAllOUIHomes());
        retRep.addNVPair("oracleHomes", viOracleHomes);
        return retRep;
    }

    private String getRunningCountForPath(String sPath, Vector vHomes) {
        OiiiOracleHomeInfo ohi;
        int count = 1;
        String homeLoc = null;
        while ((ohi = this.getHomeWithLocation(homeLoc = sPath + "_" + count, vHomes)) != null) {
            ++count;
        }
        return homeLoc;
    }

    private String getRunningCountForName(String sName, Vector vHomes) {
        OiiiOracleHomeInfo ohi;
        int count = 1;
        String homeName = null;
        while ((ohi = this.getHomeWithName(homeName = sName + count, vHomes)) != null) {
            ++count;
        }
        return homeName;
    }

    public boolean fillInventoryHoles(Vector vHomes) {
        int i;
        OiiiOracleHomeInfo ohi = null;
        this.m_nHighestHomeIndex = 0;
        boolean bAddedDummyHomes = false;
        int iSize = vHomes == null ? 0 : vHomes.size();
        for (i = 0; i < iSize; ++i) {
            ohi = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            int idx = ohi.getIndex();
            if (idx <= this.m_nHighestHomeIndex) continue;
            this.m_nHighestHomeIndex = idx;
        }
        for (i = 1; i <= this.m_nHighestHomeIndex; ++i) {
            boolean bIsHomePresent = this.IsHomePresent(i, vHomes);
            if (bIsHomePresent) continue;
            OiipgFileSystem fs = new OiipgFileSystem();
            String loc = fs.getDefHomeLocation(DEFAULT_HOME_LOCATION);
            loc = this.getRunningCountForPath(loc, vHomes);
            String name = DEFAULT_HOME_NAME;
            name = this.getRunningCountForName(name, vHomes);
            OiiiOracleHomeInfo newEntry = new OiiiOracleHomeInfo(i, loc, name, this.m_nHomeType, true);
            newEntry.setRemoved(true);
            newEntry.updateDirtyFlags(44587L);
            newEntry.setDummyHome(true);
            newEntry.setRemovedInThisSession(true);
            vHomes.addElement(newEntry);
            bAddedDummyHomes = true;
        }
        return bAddedDummyHomes;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        Vector vAllOUIHomes = this.getAllOUIHomes();
        OiivVerIndObjectRep retRep = super.mergeVerIndRep(vIndObj, vAllOUIHomes);
        Vector oracleHomes = (Vector)retRep.getObjectForName("oracleHomes");
        OiivVerIndObjectRep.mergeVDVectIntoVIVect(vAllOUIHomes, oracleHomes, "location");
        retRep.setNVPair("oracleHomes", oracleHomes);
        return retRep;
    }

    public void readHomes() throws IOException {
        OiiiInstallAreaControl iac = (OiiiInstallAreaControl)this.getAreaControl();
        OiiiInstallInventoryReader reader = iac.getReaderForOracleHomes();
        try {
            Vector vHomes = reader.readHomes();
            this.updateHomeLists(vHomes);
            this.updateOracleHomesProperties();
        }
        catch (OiiiInstallInventoryReadException e) {
            throw e;
        }
        catch (IOException e) {
            this.m_oracleHomes = new Vector();
            this.m_compositeOracleHomes = new Vector();
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_INV_READ_HOMELIST_ERROR"));
        }
    }

    private void updateOracleHomesProperties() {
        int size = this.m_oracleHomes != null ? this.m_oracleHomes.size() : 0;
        for (int i = 0; i < size; ++i) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)this.m_oracleHomes.get(i);
            this.updateOracleHomesProperties(home);
        }
    }

    private void updateOracleHomesProperties(OiiiOracleHomeInfo home) {
        OiiiOracleHomeInfoXMLReader OHInfoReader = OiiiOracleHomeInfoXMLReader.getOHInfoXMLReader();
        String sFileName = OiiiInstallAreaControl.getOHPropertiesFileLoc(home.getLocation());
        OHInfoReader.updateHomeProperties(home, sFileName);
        home.setDirtyFlags(0L);
    }

    public void updateCompositeHomeProperties() {
        int size = this.m_compositeOracleHomes != null ? this.m_compositeOracleHomes.size() : 0;
        for (int i = 0; i < size; ++i) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)this.m_compositeOracleHomes.get(i);
            this.updateCompositeHomeProperties(home);
        }
    }

    public void updateCompositeHomeProperties(OiiiOracleHomeInfo home) {
        OiiiOracleHomeInfoXMLReader OHInfoReader = OiiiOracleHomeInfoXMLReader.getOHInfoXMLReader();
        String sFileName = "";
        sFileName = home.getCHPropsXML();
        home.setAdditionalCompositeHomeProperty("COMPOSITE_HOME", home.getLocation());
        String sType = home.getCompositeHomeTypeName();
        if (sType != null) {
            home.setAdditionalCompositeHomeProperty("COMPOSITE_HOME_TYPE", sType);
        }
        OHInfoReader.updateHomeProperties(home, sFileName);
        home.setDirtyFlags(0L);
    }

    public void updateHomeLists(Vector vHomes) {
        this.m_oracleHomes.clear();
        this.m_compositeOracleHomes.clear();
        this.m_removedHomes.clear();
        this.m_removedCompositeOracleHomes.clear();
        this.m_nHighestHomeIndex = 0;
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            if (homeInfo.isRemoved()) {
                if (!homeInfo.isCompositeHome()) {
                    this.m_removedHomes.addElement(homeInfo);
                } else {
                    this.m_removedCompositeOracleHomes.addElement(homeInfo);
                }
            } else if (homeInfo.isCompositeHome()) {
                this.m_compositeOracleHomes.addElement(homeInfo);
            } else {
                this.m_oracleHomes.addElement(homeInfo);
            }
            int nHomeIndex = homeInfo.getIndex();
            if (nHomeIndex > this.m_nHighestHomeIndex) {
                this.m_nHighestHomeIndex = nHomeIndex;
            }
            if (homeInfo.isDummyHome()) continue;
            homeInfo.setDirtyFlags(0L);
        }
    }

    public void updateInventory(OiiiOracleHomeInfo oInfo, String sName, String sLoc, int nHomeType) {
        oInfo.setName(sName);
        oInfo.setLocation(sLoc);
        oInfo.setHomeType(nHomeType);
    }

    private OiiiOracleHomeInfo unsetOptionalOhProps(OiiiOracleHomeInfo ohi) {
        if (ohi != null) {
            ohi.setCRSHome(false);
            ohi.setNodeList(new String[0]);
            ohi.setLocalNode(null);
        }
        return ohi;
    }

    private boolean isCentralInvDirty() {
        boolean bDirty = false;
        Vector oAllOUIHomes = OiixVectorOps.concat(this.getAllOUIHomes(), this.getCompositeHomes());
        if (oAllOUIHomes != null) {
            int iHomes = oAllOUIHomes.size();
            for (int i = 0; i < iHomes && !bDirty; ++i) {
                OiiiOracleHomeInfo oHome = (OiiiOracleHomeInfo)oAllOUIHomes.get(i);
                bDirty = oHome.isHomeInCIDirty();
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                OiiolTextLogger.appendText("The flags set for home:" + oHome.getLocation() + ":" + oHome.getDirtyFlagsStr(), OiiolTextLogger.LOG_DETAILED);
            }
        }
        return bDirty;
    }

    public void saveInventory(OiivVerIndObjectRep installInv) throws IOException, OiifbCancelException {
        Vector oracleHomes = (Vector)installInv.getObjectForName("oracleHomes");
        if (this.isCentralInvDirty()) {
            boolean bSupportBinaryInv;
            boolean invBackup = Boolean.getBoolean("oracle.installer.backupInventory");
            if (invBackup) {
                this.backupCentralInventory();
            }
            if (bSupportBinaryInv = Boolean.getBoolean("oracle.installer.supportBinaryInventory")) {
                OiiiInstallInventoryWriter serializedInvWriter = OiiiInstallSerializedWriter.getWriter(installInv);
                serializedInvWriter.writeHomes();
            }
            OiiiInstallInventoryWriter xmlInvWriter = OiiiInstallXMLWriter.getWriter();
            xmlInvWriter.writeHomes();
            if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                OiiiInstallAreaControl areaControl = OiiiInstallAreaControl.getInstallAreaControl();
                String sInventoryFileLoc = areaControl.getAreaRoot();
                if (OiixPlatform.getCurrentPlatform() == 197 || OiixPlatform.getCurrentPlatform() == 2) {
                    s_execCmd = s_execCmdHPUX;
                }
                String execCmd = s_execCmd + sInventoryFileLoc;
                File invFile = new File(sInventoryFileLoc);
                if (invFile.exists()) {
                    try {
                        OiixSpawner oSpawn = new OiixSpawner();
                        oSpawn.beginExecute(execCmd);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (OiixPlatform.getCurrentPlatform() == 197 || OiixPlatform.getCurrentPlatform() == 2) {
                    s_execCmd_logs = s_execCmdHPUX_logs;
                }
                String location_logs = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sInventoryFileLoc, "logs"));
                String execCmd_logs = s_execCmd_logs + location_logs;
                File logFile = new File(location_logs);
                if (logFile.exists()) {
                    try {
                        OiixSpawner oSpawn = new OiixSpawner();
                        oSpawn.beginExecute(execCmd_logs);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        OiipuUnixOps.changePermission(location_logs, 504);
                    }
                    catch (OiilNativeException natEx) {
                        natEx.printStackTrace();
                    }
                }
            }
        }
        Vector inMemOracleHomes = OiixVectorOps.concat(this.getAllOUIHomes(), this.getCompositeHomes());
        Vector<Integer> dirtyHomesIndexes = new Vector<Integer>();
        Vector vdOracleHomes = OiivVerIndObjectRep.getVerDepFormOfVect(oracleHomes);
        int iSize = inMemOracleHomes != null ? inMemOracleHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            Integer oIndex;
            int nIdx;
            OiiiOracleHomeInfo oracleHomeInfo = (OiiiOracleHomeInfo)inMemOracleHomes.elementAt(i);
            OiiolTextLogger.appendText("The flags set for this home (" + oracleHomeInfo.getLocation() + ") are:" + oracleHomeInfo.getDirtyFlagsStr(), OiiolTextLogger.LOG_BASIC);
            if (oracleHomeInfo.isHomeInvDirty() || oracleHomeInfo.isDirty()) {
                int ohIndex = oracleHomeInfo.getIndex();
                dirtyHomesIndexes.addElement(new Integer(ohIndex));
            }
            if ((nIdx = OiixVectorOps.vectIndexOf(vdOracleHomes, (Object)(oIndex = new Integer(oracleHomeInfo.getIndex())))) != -1) {
                OiiiOracleHomeInfo ohInfo = (OiiiOracleHomeInfo)vdOracleHomes.elementAt(nIdx);
                if (oracleHomeInfo.isRemovedInThisSession()) {
                    ohInfo.setRemoved(true);
                    ohInfo.setRemovedInThisSession(true);
                    this.unsetOptionalOhProps(ohInfo);
                }
                ohInfo.setDirtyFlags(oracleHomeInfo.getDirtyFlags());
                ohInfo.setDirty(oracleHomeInfo.isDirty());
            }
            boolean bSaveOHPropXML = false;
            boolean isHomeComposite = oracleHomeInfo.isCompositeHome();
            bSaveOHPropXML = !isHomeComposite ? this.isOHPropXMLSaveRequired(oracleHomeInfo) : this.isCHPropXMLSaveRequired(oracleHomeInfo);
            if (nIdx == -1 && !isHomeComposite) {
                OiiiInstallAreaControl iac = this.getInstallAreaControl();
                String sPath = iac.genFileSysLoc("Contents");
                OiiolTextLogger.appendText("Home:" + oracleHomeInfo.getLocation() + " has conflicting information present in the inventory at " + sPath, OiiolTextLogger.LOG_WARNING);
                OiiolTextLogger.appendText("Please delete the " + sPath + " directory to avoid inventory update failures", OiiolTextLogger.LOG_WARNING);
            }
            if (bSaveOHPropXML) {
                try {
                    if (!oracleHomeInfo.isCompositeHome()) {
                        this.saveOHPropXML(oracleHomeInfo);
                        continue;
                    }
                    this.saveCHPropXML(oracleHomeInfo);
                }
                catch (IOException ie) {
                    String sMsg = "Problem in saving inventory.";
                    if (ie.getMessage() != null) {
                        sMsg = sMsg + ie.getMessage();
                    }
                    OiiolTextLogger.appendText(sMsg);
                }
                continue;
            }
            OiiolTextLogger.appendText("Home:" + oracleHomeInfo.getLocation() + " oraclehomeproperties.xml is not saved because the flags indicate no changes to this file.");
            if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
            OiiolTextLogger.appendText("The flags set for this home are:" + oracleHomeInfo.getDirtyFlagsStr(), OiiolTextLogger.LOG_DETAILED);
        }
        this.saveInventoryLocal(installInv, inMemOracleHomes, dirtyHomesIndexes);
    }

    public void saveInventory(OiivVerIndObjectRep installInv, String[] nodeList) throws IOException, OiifbCancelException {
        this.saveInventory(installInv);
    }

    private void saveInventoryLocal(OiivVerIndObjectRep installInv, Vector vdOracleHomes, Vector dirtyHomesIndexes) throws IOException, OiifbCancelException {
        int iCurrentPlatform;
        int index;
        OiiiOracleHomeInfo ohInfo;
        int i;
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventoryWriter xmlWriter = OiiiInstallXMLWriter.getWriter();
        boolean bSupportBinaryInv = Boolean.getBoolean("oracle.installer.supportBinaryInventory");
        int size = vdOracleHomes != null ? vdOracleHomes.size() : 0;
        boolean bIsAttachHome = Boolean.getBoolean("oracle.installer.attachHome");
        if (bSupportBinaryInv) {
            OiiiInstallInventoryWriter serializedWriter = OiiiInstallSerializedWriter.getWriter(installInv);
            for (i = 0; i < size; ++i) {
                ohInfo = (OiiiOracleHomeInfo)vdOracleHomes.elementAt(i);
                index = ohInfo.getIndex();
                if (!ohInfo.isDirty() || !ohInfo.isHomeInvDirty() && bIsAttachHome) continue;
                OiiolTextLogger.appendText("Saving serialized component list for " + ohInfo.getLocation(), OiiolTextLogger.LOG_BASIC);
                serializedWriter.writeComps(index);
            }
            serializedWriter.writeComps(0);
        }
        if ((iCurrentPlatform = OiixPlatform.getCurrentPlatform()) == 912 || iCurrentPlatform == 208 || iCurrentPlatform == 233) {
            this.synchClock();
        }
        OiiolTextLogger.appendText("Updating XML inventory.", OiiolTextLogger.LOG_BASIC);
        for (i = 0; i < size; ++i) {
            String sMsg;
            ohInfo = (OiiiOracleHomeInfo)vdOracleHomes.elementAt(i);
            index = ohInfo.getIndex();
            if (ohInfo.isRemovedInThisSession()) {
                try {
                    iac.cleanupHomeDir(ohInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String sMsg2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_CLEANUP_HOME", new String[]{ohInfo.getLocation(), e.getMessage()});
                    OiiolTextLogger.appendText(sMsg2);
                }
                continue;
            }
            if (!ohInfo.isDirty()) continue;
            OiiiInstallAreaControl.writeOHInvLoc(ohInfo.getLocation());
            if (!ohInfo.isHomeInvDirty() && bIsAttachHome) continue;
            boolean invBackup = Boolean.getBoolean("oracle.installer.backupInventory");
            if (invBackup) {
                this.backupHomeInventory(ohInfo);
            }
            OiiolTextLogger.appendText("Saving comps.xml for " + ohInfo.getLocation(), OiiolTextLogger.LOG_BASIC);
            if (ohInfo.isCompositeHome()) continue;
            String sCompsFileLoc = iac.getXMLCompsFileLoc(index);
            OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sCompsFileLoc)));
            try {
                this.saveHomeStageInventory(index);
            }
            catch (Exception e) {
                e.printStackTrace();
                OiiolTextLogger.appendText(e.getMessage());
                String sMsg3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_ERR_SAVE_HOME_STAGE");
                sMsg3 = MessageFormat.format(sMsg3, ohInfo.getLocation());
                OiiolTextLogger.appendText(sMsg3);
            }
            this.removeDuplicateEntries(index);
            boolean bIsDetachHome = Boolean.getBoolean("oracle.installer.detachHome");
            if (!bIsDetachHome) {
                xmlWriter.writeComps(index);
                xmlWriter.writeLibs(index);
            }
            try {
                this.saveConfigInfo(index);
            }
            catch (Throwable th) {
                th.printStackTrace();
                OiiolTextLogger.appendText(th.getMessage());
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_ERR_SAVE_CONFIG", new Object[]{ohInfo.getLocation()});
                OiiolTextLogger.appendText(sMsg);
            }
            try {
                if (iac.canSaveCloneXMLInfo()) {
                    this.saveCloneInfo(index);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                OiiolTextLogger.appendText(e.getMessage());
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_ERR_SAVE_CLONE_INFO", new Object[]{ohInfo.getLocation()});
                OiiolTextLogger.appendText(sMsg);
            }
            if (bIsDetachHome) continue;
            iac.writeInvDetails(index);
        }
        xmlWriter.writeComps(0);
        xmlWriter.writeLibs(0);
    }

    private void removeDuplicateBugListFromOneOffs(Vector vOneoffs) {
        if (vOneoffs == null) {
            return;
        }
        for (int i = 0; i < vOneoffs.size(); ++i) {
            OiiiOneoffInvEntry invEntry = (OiiiOneoffInvEntry)vOneoffs.elementAt(i);
            Vector bugList = invEntry.getBugs();
            this.createUniqueBugList(bugList);
            invEntry.setBugList(bugList);
        }
    }

    private void createUniqueBugList(Vector bugList) {
        Vector<String> tmp = new Vector<String>();
        if (bugList == null) {
            return;
        }
        for (int i = 0; i < bugList.size(); ++i) {
            String bugNo = (String)bugList.elementAt(i);
            if (tmp.indexOf(bugNo) == -1) {
                tmp.add(bugNo);
                continue;
            }
            bugList.remove(i);
            --i;
        }
    }

    private void removeDuplicateOneOffs(Vector vOneoffs) {
        if (vOneoffs == null) {
            return;
        }
        Vector<String> vNoDuplicateOneOffs = new Vector<String>();
        for (int i = 0; i < vOneoffs.size(); ++i) {
            String oneOffKey;
            OiiiOneoffInvEntry invEntry = (OiiiOneoffInvEntry)vOneoffs.elementAt(i);
            String oneOffId = invEntry.getID().getID();
            String uniqueID = invEntry.getUniqID();
            if (uniqueID == null) {
                uniqueID = "";
            }
            if (vNoDuplicateOneOffs.indexOf(oneOffKey = oneOffId + ":" + OiixLanguage.vectToStr(invEntry.getLangs()) + ":" + uniqueID) == -1) {
                vNoDuplicateOneOffs.add(oneOffKey);
                continue;
            }
            vOneoffs.remove(i);
            --i;
        }
    }

    private void removeDuplicateEntries(int ohIndex) {
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(ohIndex);
        Vector vComps = oihi.getCompsVect();
        int nCount = vComps.size();
        Vector<OiiiCompInstallID> vNoDuplicateComps = new Vector<OiiiCompInstallID>();
        for (int i = 0; i < vComps.size(); ++i) {
            OiiiCompInvEntry invEntry = (OiiiCompInvEntry)vComps.elementAt(i);
            OiiiCompInstallID cid = invEntry.getCompInstallID();
            if (vNoDuplicateComps.indexOf(cid) == -1) {
                vNoDuplicateComps.add(cid);
                continue;
            }
            vComps.remove(i);
            --i;
        }
        oihi.setCompsVect(vComps);
    }

    public void propagateInventoryToNodes(String oracleHome, String[] nodeList) throws OiiiClusterException {
        if (nodeList != null && nodeList.length > 0) {
            int iSize;
            Vector allHomes = this.getHomes();
            boolean bMatch = false;
            String homeLoc = null;
            int n = iSize = allHomes != null ? allHomes.size() : 0;
            if (iSize > 0) {
                OiipgDetectCluster detectCluster;
                Vector vNodeList;
                String[] remoteNodeListArr;
                for (int i = 0; i < iSize; ++i) {
                    OiiiOracleHomeInfo oHome = (OiiiOracleHomeInfo)allHomes.elementAt(i);
                    if (oHome == null || !(homeLoc = oHome.getLocation()).equalsIgnoreCase(oracleHome)) continue;
                    Vector vNodes = oHome.getNodeList();
                    bMatch = this.doNodeListsMatch(vNodes, nodeList);
                    if (bMatch) break;
                    String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_INVPROP_NODELIST_MSG");
                    throw new OiiiClusterException(sErr);
                }
                if ((remoteNodeListArr = OiixVectorOps.vect2StrArr(vNodeList = (detectCluster = OiipgDetectCluster.getDetectCluster()).getRemoteNodes(nodeList))) != null && remoteNodeListArr.length > 0) {
                    System.out.println("The length of remoteNodeListArr is " + remoteNodeListArr.length);
                    System.out.println("The remote nodes are:" + OiixFunctionOps.implodeList(remoteNodeListArr, ","));
                    OiiiInstallAreaControl iac = this.getInstallAreaControl();
                    try {
                        String sNativeCentralInvLoc;
                        String sNativeHomeLoc = OiixPathOps.getNativeForm(OiixPathOps.directorify(oracleHome));
                        OiipgCFSDriveCheck cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                        boolean bCFS = cfsDriveCheck.isDriveOnCFS(sNativeHomeLoc);
                        if (!bCFS) {
                            String invDir = iac.getOHInventoryLoc(sNativeHomeLoc);
                            OiipgClusterOps.transferDirToNodes(remoteNodeListArr, invDir, null);
                        }
                        if (!(bCFS = cfsDriveCheck.isDriveOnCFS(sNativeCentralInvLoc = OiixPathOps.getNativeForm(OiixPathOps.directorify(this.m_areaControl.getAreaRoot()))))) {
                            OiipgClusterOps.transferDirToNodes(remoteNodeListArr, sNativeCentralInvLoc, null);
                        }
                    }
                    catch (OiipgRemoteFileOperationException se) {
                        OiiolTextLogger.appendText(se.getErrorMessage());
                        se.printStackTrace();
                    }
                    catch (OiipgRemoteOpsException se) {
                        OiiolTextLogger.appendText(se.getErrorMessage());
                        se.printStackTrace();
                    }
                }
            }
        }
    }

    private boolean isOHPropXMLSaveRequired(OiiiOracleHomeInfo oHomeInfo) {
        boolean bOHPropXMLSaveReqd;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("The flags set for this home are:" + oHomeInfo.getDirtyFlagsStr(), OiiolTextLogger.LOG_DETAILED);
        }
        if (!oHomeInfo.isHomeInvDirty()) {
            return false;
        }
        boolean bl = bOHPropXMLSaveReqd = !oHomeInfo.isRemovedInThisSession() && oHomeInfo.isHomeInvDirty();
        if (!bOHPropXMLSaveReqd) {
            String sOHPropFileLoc = oHomeInfo.getLocation();
            sOHPropFileLoc = OiiiInstallAreaControl.getOHPropertiesFileLoc(sOHPropFileLoc);
            File oFile = new File(sOHPropFileLoc);
            boolean bl2 = bOHPropXMLSaveReqd = !oHomeInfo.isRemoved() && !oFile.exists();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("The oraclehomeproperties.xml exists:" + !bOHPropXMLSaveReqd, OiiolTextLogger.LOG_DETAILED);
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("The oraclehomeproperties.xml should be saved:" + bOHPropXMLSaveReqd, OiiolTextLogger.LOG_DETAILED);
        }
        return bOHPropXMLSaveReqd;
    }

    private boolean isCHPropXMLSaveRequired(OiiiOracleHomeInfo oHomeInfo) {
        boolean bCHPropXMLSaveReqd;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("The flags set for this home are:" + oHomeInfo.getDirtyFlagsStr(), OiiolTextLogger.LOG_DETAILED);
        }
        if (!oHomeInfo.isHomeInvDirty()) {
            return false;
        }
        boolean bl = bCHPropXMLSaveReqd = !oHomeInfo.isRemovedInThisSession() && oHomeInfo.isHomeInvDirty();
        if (!bCHPropXMLSaveReqd) {
            String sCHPropFileLoc = oHomeInfo.getCHPropsXML();
            File oFile = new File(sCHPropFileLoc);
            boolean bl2 = bCHPropXMLSaveReqd = !oHomeInfo.isRemoved() && !oFile.exists();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("The oraclehomeproperties.xml exists:" + !bCHPropXMLSaveReqd, OiiolTextLogger.LOG_DETAILED);
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("The oraclehomeproperties.xml should be saved:" + bCHPropXMLSaveReqd, OiiolTextLogger.LOG_DETAILED);
        }
        return bCHPropXMLSaveReqd;
    }

    private void saveOHPropXML(OiiiOracleHomeInfo newHome) throws IOException, OiifbCancelException {
        String sOHPropFileLoc = newHome.getLocation();
        sOHPropFileLoc = OiiiInstallAreaControl.getOHPropertiesFileLoc(sOHPropFileLoc);
        try {
            OiiiOracleHomeInfo inMemoryHome = this.getHomeWithLocation(newHome.getLocation(), this.getAllHomes());
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("GUID:In-memory home :" + inMemoryHome + "in-Memory Home GUID value :" + inMemoryHome.getGUID(), OiiolTextLogger.LOG_DETAILED);
            }
            newHome.setGUID(inMemoryHome.getGUID());
        }
        catch (Exception e) {
            // empty catch block
        }
        OiiiOracleHomeInfoWriter oOHInfoWriter = OiiiOracleHomeInfoWriter.getOracleHomeInfoWriter(newHome, sOHPropFileLoc);
        oOHInfoWriter.updateHomeProperties();
    }

    private void saveCHPropXML(OiiiOracleHomeInfo newHome) throws IOException, OiifbCancelException {
        String sCHPropFileLoc = newHome.getCHPropsXML();
        try {
            OiiiOracleHomeInfo inMemoryHome = this.getCompositeHomeWithLocation(newHome.getLocation(), this.getCompositeHomes());
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("GUID:In-memory home :" + inMemoryHome + "in-Memory Home GUID value :" + inMemoryHome.getGUID(), OiiolTextLogger.LOG_DETAILED);
            }
            newHome.setGUID(inMemoryHome.getGUID());
        }
        catch (Exception e) {
            // empty catch block
        }
        OiiiOracleHomeInfoWriter oOHInfoWriter = OiiiOracleHomeInfoWriter.getOracleHomeInfoWriter(newHome, sCHPropFileLoc);
        oOHInfoWriter.updateHomeProperties();
    }

    protected void setupRefsForVect(int ohIndex) {
        Vector entries = this.getAllCompsVect(ohIndex);
        int numEntries = entries != null ? entries.size() : 0;
        for (int i = 0; i < numEntries; ++i) {
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)entries.elementAt(i);
            if (icie instanceof OiiiInstallPatchInvEntry) {
                OiiiInstallPatchInvEntry ipie = (OiiiInstallPatchInvEntry)icie;
                OiiiCompInstallID baseID = ipie.getBaseID();
                OiiiInstallCompInvEntry bcie = (OiiiInstallCompInvEntry)this.getCompInvEntry(baseID, ohIndex);
                if (bcie == null) continue;
                ipie.setBaseInvEntry(bcie);
                bcie.setPatchInvEntry(ipie);
                continue;
            }
            if (!(icie instanceof OiiiInstallPatchSetInvEntry)) continue;
            OiiiInstallPatchSetInvEntry ipsie = (OiiiInstallPatchSetInvEntry)icie;
            Vector patches = ipsie.getPatches();
            int iSize = patches != null ? patches.size() : 0;
            for (int j = 0; j < iSize; ++j) {
                OiiiInstallPatchInvEntry patchEntry;
                OiiiPatchInstallID pid = (OiiiPatchInstallID)patches.elementAt(j);
                int patchHomeIndex = ohIndex;
                if (pid.isNOHComp()) {
                    patchHomeIndex = 0;
                }
                if ((patchEntry = (OiiiInstallPatchInvEntry)this.getCompInvEntry(pid, patchHomeIndex)) == null) continue;
                OiiiPatchSetInstallID psid = (OiiiPatchSetInstallID)ipsie.getCompInstallID();
                patchEntry.setPSetIDOH(psid, ohIndex);
            }
        }
        Vector vOneoffs = this.getAllOneoffInvEntries(ohIndex);
        int iSize = vOneoffs != null ? vOneoffs.size() : 0;
        for (int k = 0; k < iSize; ++k) {
            OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(k);
            Vector baseComps = ooEntry.getBaseComps();
            int bcSize = baseComps != null ? baseComps.size() : 0;
            for (int j = 0; j < bcSize; ++j) {
                OiiiCompIdOhPair oPair = (OiiiCompIdOhPair)baseComps.elementAt(j);
                oPair.setOHIndex(ohIndex);
                OiiiInstallCompInvEntry bcEntry = (OiiiInstallCompInvEntry)this.getCompatCompEntry(oPair.getCompID(), ohIndex);
                if (bcEntry == null) continue;
                bcEntry.addOneoff(ooEntry);
            }
        }
        Vector vMiniPatchsets = this.getAllMiniPatchsetInvEntries(ohIndex);
        iSize = vMiniPatchsets != null ? vMiniPatchsets.size() : 0;
        for (int k = 0; k < iSize; ++k) {
            OiiiInstallMiniPatchsetInvEntry ooEntry = (OiiiInstallMiniPatchsetInvEntry)vMiniPatchsets.elementAt(k);
            Vector baseComps = ooEntry.getBaseComps();
            int bcSize = baseComps != null ? baseComps.size() : 0;
            for (int j = 0; j < bcSize; ++j) {
                OiiiCompIdVerPair oVerPair = (OiiiCompIdVerPair)baseComps.elementAt(j);
                OiiiCompIdOhPair oPair = oVerPair.getCompIdOhPair();
                if (oPair == null) continue;
                oPair.setOHIndex(ohIndex);
                OiiiInstallCompInvEntry bcEntry = (OiiiInstallCompInvEntry)this.getCompatCompEntry(oPair.getCompID(), ohIndex);
                if (bcEntry == null) continue;
                bcEntry.addMiniPatchset(ooEntry);
            }
        }
    }

    protected Vector getCompOHListElement(int homeIndex) {
        Vector vComps = null;
        try {
            vComps = super.getCompOHListElement(homeIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (vComps == null && this.m_bAutoLoad) {
            try {
                OiiiInstallAreaControl iac = this.getInstallAreaControl();
                OiiiInstallInventoryReader reader = iac.getReaderForHome(homeIndex);
                OiiiInvHomeInfo oihi = reader.readComps(homeIndex);
                vComps = oihi.getCompsVect();
                this.setInvHomeInfo(homeIndex, oihi);
                this.setupRefsForVect(homeIndex);
                int size = vComps != null ? vComps.size() : 0;
                for (int i = 0; i < size; ++i) {
                    OiiiInstallCompInvEntry ice = (OiiiInstallCompInvEntry)vComps.elementAt(i);
                    ice.setAreaControl(iac);
                    ice.setOHIndex(homeIndex);
                }
                OiiiInstallXMLReader.getInstallXMLReader().readConfigTools(homeIndex);
                this.correctOneoffInventoryEntries(oihi);
            }
            catch (IOException e) {
                e.printStackTrace();
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_INV_READ_HOME_ERROR");
                Object[] objs = new Object[]{this.getHomeLocation(homeIndex)};
                sMsg = MessageFormat.format(sMsg, objs);
                OiiolTextLogger.appendText(sMsg, 0);
            }
        }
        return vComps;
    }

    private void correctOneoffInventoryEntries(OiiiInvHomeInfo oihi) {
        int size;
        Vector vOneoffs = oihi.getOneoffsVect();
        int n = size = vOneoffs != null ? vOneoffs.size() : 0;
        if (size == 0) {
            return;
        }
        Vector<OiiiOneoffFile> vOneoffFiles = new Vector<OiiiOneoffFile>(5, 5);
        int nHomeIndex = oihi.getHomeIndex();
        boolean bInstVerSpecified = false;
        for (int i = 0; i < size; ++i) {
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            OiiiVersion oVer = oEntry.getInstallerVersion();
            if (oVer == null) {
                Vector vFiles = oEntry.getInvFilesList();
                int iSize = vFiles != null ? vFiles.size() : 0;
                for (int j = 0; j < iSize; ++j) {
                    OiiiOneoffFile oFile = (OiiiOneoffFile)vFiles.elementAt(j);
                    if (vOneoffFiles.contains(oFile)) continue;
                    vOneoffFiles.addElement(oFile);
                }
            } else {
                bInstVerSpecified = true;
                break;
            }
            oEntry.setInvFilesList(new Vector());
        }
        if (bInstVerSpecified) {
            return;
        }
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        try {
            size = vOneoffFiles != null ? vOneoffFiles.size() : 0;
            for (int k = 0; k < size; ++k) {
                OiiiOneoffFile oFile = (OiiiOneoffFile)vOneoffFiles.elementAt(k);
                String sHomeLocation = null;
                sHomeLocation = nHomeIndex == 0 ? iac.getInventoryLocForHome(0) : this.getHomeLocation(nHomeIndex);
                String sParentPath = oFile.getParentPath();
                if (oFile.isCompositeFile()) {
                    iac.loadFiles(sHomeLocation, sParentPath, oFile.getChildFile());
                } else {
                    iac.loadFiles(sHomeLocation, sParentPath);
                }
                if (OiiiFileMapEntry.pathStartsFromRoot(sParentPath)) continue;
                sParentPath = OiixPathOps.concatPath(sHomeLocation, sParentPath);
                if (oFile.isCompositeFile()) {
                    iac.loadFiles(sHomeLocation, sParentPath, oFile.getChildFile());
                    continue;
                }
                iac.loadFiles(sHomeLocation, sParentPath);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        OiiiOracleHomeInfo oInfo = this.getHomeInfo(nHomeIndex);
        oInfo.setDirty(true);
        OiiiVersion instVer = OiicInstVersion.getInstallerVersion();
        size = vOneoffs != null ? vOneoffs.size() : 0;
        for (int m = 0; m < size; ++m) {
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(m);
            oEntry.setInstallerVersion(instVer);
            oEntry.setXmlInventoryLocation(iac.getXMLOneoffFullLoc(oEntry.getID(), nHomeIndex));
        }
    }

    public OiiiCompIdOhPair getCompatCompInvEntryInAnyHome(OiiiCompInstallID cid, int nPlatform, boolean bIgnoreRemovedHomes) {
        if (bIgnoreRemovedHomes) {
            int nSize = super.getCompOHsList().size();
            OiiiCompIdOhPair oOhId = null;
            for (int ohIndex = 0; ohIndex < nSize; ++ohIndex) {
                OiiiOracleHomeInfo ohi = this.getHomeInfo(ohIndex);
                if (ohi.isRemoved()) continue;
                Vector vComps = this.getReplaceCompEntries(cid, ohIndex, nPlatform);
                if (vComps.size() > 0) {
                    OiiiCompInvEntry inv = (OiiiCompInvEntry)vComps.elementAt(0);
                    oOhId = new OiiiCompIdOhPair(inv.getCompInstallID(), ohIndex);
                    break;
                }
                vComps = this.getCompatCompEntries2(cid, ohIndex);
                if (vComps.size() <= 0) continue;
                OiiiCompInvEntry inv = (OiiiCompInvEntry)vComps.elementAt(0);
                oOhId = new OiiiCompIdOhPair(inv.getCompInstallID(), ohIndex);
                break;
            }
            return oOhId;
        }
        return super.getCompatCompInvEntryInAnyHome(cid, nPlatform);
    }

    protected OiiiInvHomeInfo getCompOHListInfo(int ohIndex) {
        try {
            OiiiInvHomeInfo oihi = super.getCompOHListInfo(ohIndex);
            if (oihi == null) {
                this.getCompOHListElement(ohIndex);
                oihi = super.getCompOHListInfo(ohIndex);
                return oihi;
            }
            return oihi;
        }
        catch (Exception exception) {
            return null;
        }
    }

    OiiiStageInventory getHomeStageInventory(int homeIndex) {
        OiiiStageInventory homeStageInventory = null;
        OiiiInvHomeInfo invHomeInfo = this.getCompOHListInfo(homeIndex);
        if (invHomeInfo != null) {
            homeStageInventory = invHomeInfo.getHomeStageInventory();
        }
        if (homeStageInventory == null) {
            try {
                homeStageInventory = this.loadHomeStageInventory(homeIndex);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            invHomeInfo.setHomeStageInventory(homeStageInventory);
        }
        return homeStageInventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OiiiStageInventory loadHomeStageInventory(int homeIndex) throws IOException {
        OiiiStageInventory stageInv;
        block11: {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            String sStageFileLoc = iac.getStageInventoryFileLoc(homeIndex);
            OiiiStageInvLoader stgLdr = null;
            stageInv = null;
            try {
                try {
                    stgLdr = new OiiiStageInvLoader(sStageFileLoc);
                    stageInv = stgLdr.getStageInventory();
                }
                catch (IOException ioe) {
                    stageInv = new OiiiStageInventory();
                    Object var8_7 = null;
                    if (stgLdr != null) {
                        stgLdr.disposeLoader();
                    }
                    break block11;
                }
                catch (ClassNotFoundException ce) {
                    stageInv = null;
                    Object var8_8 = null;
                    if (stgLdr != null) {
                        stgLdr.disposeLoader();
                    }
                    break block11;
                }
                catch (Exception e) {
                    stageInv = new OiiiStageInventory();
                    Object var8_9 = null;
                    if (stgLdr != null) {
                        stgLdr.disposeLoader();
                    }
                }
                Object var8_6 = null;
                if (stgLdr != null) {
                    stgLdr.disposeLoader();
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (stgLdr != null) {
                    stgLdr.disposeLoader();
                }
                throw throwable;
            }
        }
        return stageInv;
    }

    private Vector updateHomeStageInventory(int homeIndex, OiiiStageInventory sourceStageInv, boolean bThrow) throws OiiiStageInvEntryNotFoundException {
        if (sourceStageInv == null) {
            sourceStageInv = this.getInstallAreaControl().getSourceStageInventory();
        }
        Vector vComps = this.getCompOHListElement(homeIndex);
        OiiiStageInventory homeStageInv = this.getHomeStageInventory(homeIndex);
        int nCompsSize = vComps != null ? vComps.size() : 0;
        Vector<OiiiStageCompInvEntry> vUpdatedStageIEs = new Vector<OiiiStageCompInvEntry>(nCompsSize);
        ArrayList<OiiiInstallCompInvEntry> alMissingIIEWithNoSIEs = new ArrayList<OiiiInstallCompInvEntry>();
        Vector<OiiiStageCompInvEntry> vNewStageIEs = new Vector<OiiiStageCompInvEntry>(nCompsSize);
        for (int i = 0; i < nCompsSize; ++i) {
            OiiiInstallCompInvEntry installIE = (OiiiInstallCompInvEntry)vComps.elementAt(i);
            OiiiCompInstallID cid = installIE.getCompInstallID();
            OiiiStageCompInvEntry stageIE = homeStageInv.getStageCompInvEntry(cid);
            if (stageIE == null) {
                stageIE = sourceStageInv.getStageCompInvEntry(cid);
                if (stageIE != null) {
                    vNewStageIEs.addElement(stageIE);
                } else {
                    alMissingIIEWithNoSIEs.add(installIE);
                    continue;
                }
            }
            vUpdatedStageIEs.addElement(stageIE);
        }
        int nCnt = alMissingIIEWithNoSIEs.size();
        if (nCnt > 0 && bThrow) {
            StringBuffer sMissingComps = new StringBuffer("");
            for (int i = 0; i < nCnt; ++i) {
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)alMissingIIEWithNoSIEs.get(i);
                sMissingComps.append(icie.getFullDisplayName());
                if (i + 1 >= nCnt) continue;
                sMissingComps.append(",\n");
            }
            throw new OiiiStageInvEntryNotFoundException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MISSING_INSTALL_SCRIPTS", new Object[]{sMissingComps.toString()}));
        }
        homeStageInv.setAllCompsVect(0, vUpdatedStageIEs);
        return vNewStageIEs;
    }

    private void saveHomeStageInventory(int homeIndex) throws IOException, OiifbCancelException, OiixJarModifyException {
        try {
            this.saveHomeStageInventory(homeIndex, this.getInstallAreaControl().getSourceStageInventory(), System.getProperty("oracle.installer.scratchPath"), false);
        }
        catch (OiiiStageInvEntryNotFoundException oiiiStageInvEntryNotFoundException) {
            // empty catch block
        }
    }

    public void saveHomeStageInventory(int homeIndex, OiiiStageInventory oSourceStage, String sJarLoc, boolean bThrow) throws IOException, OiifbCancelException, OiixJarModifyException, OiiiStageInvEntryNotFoundException {
        this.updateInstallDefinition(homeIndex, sJarLoc);
        this.copyInstallProperties(homeIndex);
        if (sJarLoc != null) {
            String sExecuteToolsAtCloneLoc;
            String sComputeAtCloneLoc = OiixPathOps.concatPath(sJarLoc, "computeAtCloneVars.txt");
            if (new File(sComputeAtCloneLoc).exists()) {
                String sDest = this.getInstallAreaControl().getComputeAtCloneFileLoc(homeIndex);
                try {
                    OiixFileOps.copyFile(sComputeAtCloneLoc, sDest, true, true, false, "0644", null, null, null, true);
                }
                catch (Exception e) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_COULD_NOT_COPY_FILE", new Object[]{sComputeAtCloneLoc, sDest, e.getMessage()}));
                }
            }
            if (new File(sExecuteToolsAtCloneLoc = OiixPathOps.concatPath(sJarLoc, "executeToolsAtClone.txt")).exists()) {
                String sDest = this.getInstallAreaControl().getExecuteToolsAtCloneFileLoc(homeIndex);
                try {
                    OiixFileOps.copyFile(sExecuteToolsAtCloneLoc, sDest, true, true, false, "0644", null, null, null, true);
                }
                catch (Exception e) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_COULD_NOT_COPY_FILE", new Object[]{sExecuteToolsAtCloneLoc, sDest, e.getMessage()}));
                }
            }
        }
        OiiiStageInventory homeStageInventory = this.getHomeStageInventory(homeIndex);
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        if (iac.isDeinstallMode()) {
            this.cleanupInstallDefnJars(homeIndex);
        }
    }

    private void copyInstallProperties(int homeIndex) {
        try {
            String sTempLoc = System.getProperty("oracle.installer.scratchPath");
            if (sTempLoc != null) {
                OiiiInstallAreaControl iac = this.getInstallAreaControl();
                String destdir = iac.getScriptsLoc(homeIndex);
                String filename = System.getProperty("oracle.installer.shprops");
                if (filename != null && filename.length() != 0) {
                    String destFile = OiixPathOps.getFileName(filename);
                    destFile = OiixPathOps.concatPath(destdir, destFile);
                    OiixFileOps.copyFile(filename, destFile, true, true);
                    OiiolTextLogger.appendText("copy " + filename + " to " + destFile, OiiolTextLogger.LOG_DETAILED);
                }
            }
        }
        catch (Exception err) {
            OiiolTextLogger.appendText(err.getMessage(), OiiolTextLogger.LOG_DETAILED);
        }
    }

    private void updateInstallDefinition(int homeIndex, String sJarLoc) throws IOException, OiifbCancelException {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        Hashtable<String, String> htJars = new Hashtable<String, String>();
        int startIndex = 1;
        Vector vCompIEs = this.getAllCompsVect(homeIndex);
        int nSize = vCompIEs != null ? vCompIEs.size() : 0;
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)vCompIEs.elementAt(i);
            if (!cie.wasCreatedInThisSession()) continue;
            String sJarName = cie.getJarName();
            String sJarHomeName = (String)htJars.get(sJarName);
            if (sJarHomeName == null) {
                String sJarTempLoc = sJarLoc;
                sJarTempLoc = OiixPathOps.concatPath(sJarTempLoc, sJarName);
                sJarTempLoc = OiixPathOps.getNativeForm(sJarTempLoc);
                sJarHomeName = iac.getAvailableInstallJarName(homeIndex, startIndex);
                String sJarHomeLoc = OiixPathOps.concatPath(iac.getScriptsLoc(homeIndex), sJarHomeName);
                sJarHomeLoc = OiixPathOps.getNativeForm(sJarHomeLoc);
                OiixFileOps.copyFile(sJarTempLoc, sJarHomeLoc, true, true);
                htJars.put(sJarName, sJarHomeName);
            }
            cie.setJarName(sJarHomeName);
        }
    }

    private void cleanupInstallDefnJars(int homeIndex) {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        OiiiTargetAreaMap areaMap = new OiiiTargetAreaMap();
        areaMap.setStageLoc(iac.getScriptsLoc(homeIndex));
        areaMap.buildInternalHomeStage(this.getAllCompsVect(homeIndex));
        areaMap.removeExtraInstallDefnJars();
    }

    public Hashtable getCompOHUnknownElementsTable(int ohIndex) {
        return super.getCompOHUnknownElementsTable(ohIndex);
    }

    public void setAllCompsUnknownElementsTable(int ohInd, Hashtable tagstable) {
        super.setAllCompsUnknownElementsTable(ohInd, tagstable);
    }

    public void setAllCompsUnknownLibElementsTable(int ohInd, Hashtable tagstable) {
        super.setAllCompsUnknownLibElementsTable(ohInd, tagstable);
    }

    public Hashtable getCompOHUnknownLibElementsTable(int ohIndex) {
        return super.getCompOHUnknownLibElementsTable(ohIndex);
    }

    OiiiLibrariesInfo getLibsInfo(int homeIndex) {
        OiiiLibrariesInfo libsInfo = null;
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(homeIndex);
        if (oihi != null) {
            libsInfo = oihi.getLibsInfo();
        }
        if (libsInfo == null) {
            libsInfo = this.loadLibsInfo(homeIndex);
        }
        return libsInfo;
    }

    private OiiiLibrariesInfo loadLibsInfo(int homeIndex) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventoryReader reader = iac.getReaderForHome(homeIndex);
        OiiiLibrariesInfo libsInfo = null;
        Vector[] libs = null;
        try {
            libs = reader.readLibs(homeIndex);
            libsInfo = new OiiiLibrariesInfo(libs);
        }
        catch (IOException i) {
            libsInfo = new OiiiLibrariesInfo();
        }
        this.setAllCompsLibsInfo(homeIndex, libsInfo);
        return libsInfo;
    }

    public OiiiLibInvEntry getCompatLibInvEntry(OiiiLibraryID lid, int libType, int homeIndex) {
        OiiiLibrariesInfo libsInfo = this.getLibsInfo(homeIndex);
        Vector vLibs = libsInfo.getLibrariesOfType(libType);
        OiiiLibInvEntry libEntry = this.getCompatibleLibEntry(vLibs, lid, OiicInstVersion.getInstallerVersion());
        return libEntry;
    }

    public ArrayList addLibrariesToHome(String sLibLoc, String sHomePath, boolean bRecurse) throws IOException {
        OiiiOracleHomeInfo ohi = this.getHomeWithLocation(sHomePath);
        if (ohi != null) {
            return this.addLibrariesToHome(sLibLoc, ohi.getIndex(), bRecurse);
        }
        throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INCORRECT_HOME_SPECIFIED_FOR_LIBS", new Object[]{sHomePath}));
    }

    public ArrayList addLibrariesToHome(String sLibLoc, int homeIndex, boolean bRecurse) throws IOException {
        OiiiLibraryUpdater oLibUpdater = new OiiiLibraryUpdater(this.getInstallAreaControl(), homeIndex);
        return oLibUpdater.addLibrariesToInv(new File(sLibLoc), bRecurse);
    }

    public void addLibInvEntry(OiiiLibInvEntry entry, int libType, int homeIndex) {
        OiiiOracleHomeInfo ohi;
        OiiiLibrariesInfo libsInfo = this.getLibsInfo(homeIndex);
        libsInfo.addLibInvEntry(entry, libType);
        if (homeIndex != 0 && (ohi = this.getHomeInfo(homeIndex)) != null) {
            ohi.setDirty(true);
        }
    }

    public void updateHomeListsFromCompositeHomes(Vector vHomes, String compHome, boolean markAsAddedInCI) {
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            homeInfo.addRefCompositeHome(compHome);
            if (homeInfo.isRemoved()) {
                if (!homeInfo.isCompositeHome()) {
                    if (!this.IsHomePresent(homeInfo.getIndex(), this.m_removedHomes) && !this.IsHomePresent(homeInfo.getIndex(), this.m_oracleHomes)) {
                        this.m_removedHomes.addElement(homeInfo);
                    }
                } else {
                    this.m_removedCompositeOracleHomes.addElement(homeInfo);
                }
            } else if (homeInfo.isCompositeHome()) {
                this.m_compositeOracleHomes.addElement(homeInfo);
            } else if (!this.IsHomePresent(homeInfo.getIndex(), this.m_oracleHomes)) {
                this.m_oracleHomes.addElement(homeInfo);
            }
            int nHomeIndex = homeInfo.getIndex();
            if (!markAsAddedInCI && nHomeIndex > this.m_nHighestHomeIndex) {
                this.m_nHighestHomeIndex = nHomeIndex;
            }
            if (markAsAddedInCI) {
                ++this.m_nHighestHomeIndex;
                homeInfo.setIndex(this.m_nHighestHomeIndex);
            }
            if (homeInfo.isDummyHome()) continue;
            if (markAsAddedInCI) {
                homeInfo.setDirtyFlags(2048L);
                homeInfo.setDirty(true);
                continue;
            }
            homeInfo.setDirtyFlags(0L);
        }
    }

    public int addNewHome(String location, int iType) throws IOException {
        return this.addHome("", location, iType).getIndex();
    }

    public OiiiOracleHomeInfo addHome(String name, String ohLoc, int iType) throws IOException {
        return this.addHome(name, ohLoc, iType, null, null);
    }

    public OiiiOracleHomeInfo addHome(String name, String ohLoc, int iType, String compositeHome, String compositeHomeType) throws IOException {
        OiiiOracleHomeInfo newHome;
        boolean force = Boolean.getBoolean("oracle.installer.force");
        Vector vAllHomes = this.getAllHomes();
        OiiiOracleHomeInfo sameLocHome = this.getHomeWithLocation(ohLoc, vAllHomes);
        if (sameLocHome != null && !sameLocHome.isRemoved()) {
            if (force) {
                return sameLocHome;
            }
            int iHomeType = sameLocHome.getHomeType();
            Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(iType), ohLoc, OiiiOracleHomeInfo.getHomeTypeString(iHomeType)};
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_HOME_EXISTS", sArgs);
            OiiolTextLogger.appendErrorText(sMsg);
            OiiolTextLogger.writeMessageToConsole(sMsg);
            throw new IOException(sMsg);
        }
        OiiiOracleHomeInfo sameNameHome = this.getHomeWithName(name, vAllHomes);
        if (sameNameHome != null && !sameNameHome.isRemoved()) {
            if (force) {
                name = this.getDefaultHomeName(name);
                sameNameHome = null;
                OiiolTextLogger.writeMessageToConsole("Given oracle home Name already exists, using default name: " + name);
            } else {
                int iHomeType = sameNameHome.getHomeType();
                Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(0), name, OiiiOracleHomeInfo.getHomeTypeString(iHomeType)};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_HOME_NAME_EXISTS", sArgs);
                OiiolTextLogger.appendErrorText(sMsg);
                OiiolTextLogger.writeMessageToConsole(sMsg);
                throw new IOException(sMsg);
            }
        }
        if (sameNameHome != null && sameLocHome != null && !sameNameHome.isRemoved() && !sameLocHome.isRemoved() && sameNameHome != sameLocHome) {
            Object[] args = new Object[]{name, ohLoc};
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_HOMES");
            sMsg = MessageFormat.format(sMsg, args);
            OiiolTextLogger.appendErrorText(sMsg);
            OiiolTextLogger.writeMessageToConsole(sMsg);
            throw new IOException(sMsg);
        }
        OiiiOracleHomeInfo oiiiOracleHomeInfo = newHome = sameLocHome != null ? sameLocHome : sameNameHome;
        if (newHome != null) {
            newHome.setName(name);
            newHome.setLocation(ohLoc);
            newHome.setHomeType(iType);
            if (newHome.isRemoved()) {
                newHome.setStoredInInv(false);
            }
            newHome.setRemoved(false);
            this.m_removedHomes.removeElement(newHome);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Reusing an already existing home : OiiiOracleHomeInfo:" + newHome.toString());
            }
            if (compositeHome != null) {
                newHome.addRefCompositeHome(compositeHome);
            }
        } else {
            ++this.m_nHighestHomeIndex;
            newHome = new OiiiOracleHomeInfo(this.m_nHighestHomeIndex, ohLoc, name, iType);
            if (compositeHome != null) {
                newHome.addRefCompositeHome(compositeHome);
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Create a new OiiiOracleHomeInfo object:" + newHome.toString());
            }
        }
        this.updateOracleHomesProperties(newHome);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Updated  OiiiOracleHomeInfo from oraclehomeproperties.xml:" + newHome.toString());
        }
        this.m_oracleHomes.addElement(newHome);
        newHome.updateDirtyFlags(2048L);
        if (compositeHome != null) {
            this.addCompositeHome(compositeHomeType, compositeHome);
        }
        return newHome;
    }

    public OiiiOracleHomeInfo addCompositeHome(String name, String chLoc) throws IOException {
        OiiiOracleHomeInfo newHome;
        int iType = 4;
        Vector vAllHomes = this.getAllHomes();
        OiiiOracleHomeInfo sameLocHome = this.getCompositeHomeWithLocation(chLoc, vAllHomes);
        OiiiOracleHomeInfo oiiiOracleHomeInfo = newHome = sameLocHome != null ? sameLocHome : null;
        if (newHome != null) {
            newHome.setName(name);
            newHome.setLocation(chLoc);
            newHome.setCompositeHomeTypeName(name);
            newHome.setHomeType(iType);
            if (newHome.isRemoved()) {
                newHome.setStoredInInv(false);
            }
            newHome.setRemoved(false);
            this.m_removedCompositeOracleHomes.removeElement(newHome);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Reusing an already existing home : OiiiOracleHomeInfo:" + newHome.toString());
            }
        } else {
            newHome = new OiiiOracleHomeInfo(-1, chLoc, name, iType);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Create a new OiiiOracleHomeInfo object:" + newHome.toString());
            }
        }
        this.updateCompositeHomeProperties(newHome);
        OiiiCompositeAreaControl.initAreaControl(OiixPathOps.concatPath(newHome.getLocation(), "inventory"));
        OiiiCompositeAreaControl cac = OiiiCompositeAreaControl.getInstallAreaControl();
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        OiiiInstallAreaControl.CompAreaControlList.add(cac);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Updated  OiiiOracleHomeInfo from oraclehomeproperties.xml:" + newHome.toString());
        }
        if (this.m_compositeOracleHomes.indexOf(newHome) == -1) {
            this.m_compositeOracleHomes.addElement(newHome);
        }
        iac.loadCompositeHomeInventory(chLoc);
        newHome.updateDirtyFlags(2048L);
        newHome.setDirty(true);
        newHome.updateDirtyFlags(16384L);
        return newHome;
    }

    private boolean removeHome(int homeIndex) {
        boolean bRemoved = false;
        int iSize = this.m_oracleHomes != null ? this.m_oracleHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(i);
            if (homeInfo.getIndex() != homeIndex) continue;
            this.m_oracleHomes.removeElementAt(i);
            bRemoved = true;
            break;
        }
        this.disposeCompsList(homeIndex);
        this.disposeLibsInfo(homeIndex);
        return bRemoved;
    }

    public Vector getOracleHomes() {
        return this.getHomes();
    }

    public Vector getHomes() {
        return this.m_oracleHomes;
    }

    public Vector getHomesInCentralInventory() {
        Vector oracleHomesInCI = new Vector();
        int iSize = this.m_oracleHomes != null ? this.m_oracleHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(i);
            if (homeInfo.getRefCompositeHome() != null) continue;
            oracleHomesInCI.add(this.m_oracleHomes.elementAt(i));
        }
        return oracleHomesInCI;
    }

    public Vector getCompositeHomes() {
        Vector vAllCompositeHomes = OiixVectorOps.concat(this.m_compositeOracleHomes, this.m_removedCompositeOracleHomes);
        return vAllCompositeHomes;
    }

    public OiiiOracleHomeInfo getCRSHomeInfo() {
        if (!this.m_bCRSHomeInfoChecked) {
            int iSize = this.m_oracleHomes != null ? this.m_oracleHomes.size() : 0;
            for (int i = 0; i < iSize; ++i) {
                this.m_CRSHomeInfo = (OiiiOracleHomeInfo)this.m_oracleHomes.get(i);
                if (this.m_CRSHomeInfo.isCRSHome()) break;
                this.m_CRSHomeInfo = null;
            }
            this.m_bCRSHomeInfoChecked = true;
        }
        return this.m_CRSHomeInfo;
    }

    Vector getRemovedHomes() {
        return this.m_removedHomes;
    }

    Vector getRemovedCompositeOracleHomes() {
        return this.m_removedCompositeOracleHomes;
    }

    Vector getAllOUIHomes() {
        Vector vAllOUIHomes = OiixVectorOps.concat(this.m_oracleHomes, this.m_removedHomes);
        return vAllOUIHomes;
    }

    Vector getAllHomes() {
        Vector vAllHomes = OiixVectorOps.concat(this.getAllOUIHomes(), this.m_vORCAHomes);
        vAllHomes = OiixVectorOps.concat(vAllHomes, this.getCompositeHomes());
        return vAllHomes;
    }

    public Vector getHomes(int iType) {
        int nHomeCnt = iType == 4 ? this.m_compositeOracleHomes.size() : this.m_oracleHomes.size();
        Vector<OiiiOracleHomeInfo> vHomes = new Vector<OiiiOracleHomeInfo>(nHomeCnt);
        Object[] aoHomes = new Object[nHomeCnt];
        if (iType == 4) {
            this.m_compositeOracleHomes.copyInto(aoHomes);
        } else {
            this.m_oracleHomes.copyInto(aoHomes);
        }
        for (int i = 0; i < nHomeCnt; ++i) {
            OiiiOracleHomeInfo oHomeInfo = (OiiiOracleHomeInfo)aoHomes[i];
            if (oHomeInfo.getHomeType() != iType) continue;
            vHomes.addElement(oHomeInfo);
        }
        return vHomes;
    }

    void setHomes(Vector homes) {
        this.m_oracleHomes = homes;
    }

    public void setLanguagesForComponents(Vector componentInventoryEntries, Vector langs, int ohIndex) throws OiixException {
        Locale[] supportedLanguages = OiixLanguage.getLanguages();
        int componentInventoryEntriesSize = componentInventoryEntries == null ? 0 : componentInventoryEntries.size();
        Vector supportedLangs = OiixVectorOps.arrayToVect(supportedLanguages);
        int langSize = langs == null ? 0 : langs.size();
        for (int i = 0; i < langSize; ++i) {
            Locale lang = (Locale)langs.elementAt(i);
            if (supportedLangs.indexOf(lang) != -1) continue;
            throw new OiixException("Language is not supported" + lang);
        }
        Vector compsInfo = this.getCompOHListElement(ohIndex);
        for (int i = 0; i < componentInventoryEntriesSize; ++i) {
            OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)componentInventoryEntries.elementAt(i);
            Vector langsPresent = cie.getLanguages();
            Vector newLanguageSet = OiixVectorOps.union(langsPresent, langs);
            cie.setLanguages(newLanguageSet);
            int nIndex = compsInfo.indexOf(cie);
            if (nIndex == -1) continue;
            compsInfo.setElementAt(cie, nIndex);
        }
        if (ohIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(ohIndex);
            oohi.setDirty(true);
        }
    }

    public void removeLanguagesForComponents(Vector componentInventoryEntries, Vector langs, int ohIndex) throws OiixException {
        Locale[] supportedLanguages = OiixLanguage.getLanguages();
        int componentInventoryEntriesSize = componentInventoryEntries == null ? 0 : componentInventoryEntries.size();
        Vector supportedLangs = OiixVectorOps.arrayToVect(supportedLanguages);
        Vector compsInfo = this.getCompOHListElement(ohIndex);
        for (int i = 0; i < componentInventoryEntriesSize; ++i) {
            OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)componentInventoryEntries.elementAt(i);
            Vector langsPresent = cie.getLanguages();
            boolean isLangRemovedSubset = OiixVectorOps.vectorSubset(langs, langsPresent);
            if (!isLangRemovedSubset) {
                Vector languagesNotPresent = OiixVectorOps.subtract(langs, langsPresent);
                throw new OiixException("Language is not supported" + OiixLanguage.vectToStr(languagesNotPresent));
            }
            Vector newLanguageSet = OiixVectorOps.subtract(langsPresent, langs);
            cie.setLanguages(newLanguageSet);
            int nIndex = compsInfo.indexOf(cie);
            if (nIndex == -1) continue;
            compsInfo.setElementAt(cie, nIndex);
        }
        if (ohIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(ohIndex);
            oohi.setDirty(true);
        }
    }

    void setCompositeHomes(Vector homes) {
        this.m_compositeOracleHomes = homes;
    }

    public String getOracleHomeLocation(int nOhIndex) {
        return this.getHomeLocation(nOhIndex);
    }

    public String getHomeLocation(int nOhIndex) {
        Integer oHomeIndex = new Integer(nOhIndex);
        int nIndex = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)oHomeIndex);
        if (nIndex != -1) {
            OiiiOracleHomeInfo ohinfo = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(nIndex);
            return ohinfo.getLocation();
        }
        nIndex = OiixVectorOps.vectIndexOf(this.m_removedHomes, (Object)oHomeIndex);
        if (nIndex != -1) {
            OiiiOracleHomeInfo ohinfo = (OiiiOracleHomeInfo)this.m_removedHomes.elementAt(nIndex);
            return ohinfo.getLocation();
        }
        return null;
    }

    public OiiiOracleHomeInfo getHomeInfo(int homeIndex) {
        return this.getHomeInfo(homeIndex, this.m_oracleHomes);
    }

    public boolean IsHomePresent(int homeIndex, Vector vHomes) {
        OiiiOracleHomeInfo homeInfo = null;
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            if (homeInfo.getIndex() != homeIndex) continue;
            return true;
        }
        return false;
    }

    public OiiiOracleHomeInfo getHomeInfo(int homeIndex, Vector vHomes) {
        OiiiOracleHomeInfo homeInfo = null;
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize && (homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i)).getIndex() != homeIndex; ++i) {
        }
        return homeInfo;
    }

    public OiiiInstallCompInvEntry getInstallCompInvEntry(OiiiCompInstallID cid, int ohIndex) {
        return (OiiiInstallCompInvEntry)this.getCompInvEntry(cid, ohIndex);
    }

    public OiiiInstallCompInvEntry getInstallCompInvEntry(OiiiCompInstallID cid) {
        return this.getInstallCompInvEntry(cid, 0);
    }

    public void setModifiedHomesDirty(OiiiInstallCompInvEntry icie, int deinstOhIndex) {
        OiiiCompInstallID deinstallID = icie.getCompInstallID();
        int nCompHomeIndex = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)new Integer(deinstOhIndex));
        if (nCompHomeIndex != -1) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(nCompHomeIndex);
            ohi.setDirty(true);
        }
        if (!deinstallID.isOracleHomeComp()) {
            Vector referencers = icie.getReferencers();
            Vector dependees = icie.getDependees();
            Vector[] vDirtyComps = new Vector[]{referencers, dependees};
            for (int j = 0; j < 2; ++j) {
                Vector vList = vDirtyComps[j];
                int iSize = vList != null ? vList.size() : 0;
                for (int i = 0; i < iSize; ++i) {
                    int idx;
                    OiiiCompIdOhPair refIdOh = (OiiiCompIdOhPair)vList.elementAt(i);
                    int ohIndex = refIdOh.getOHIndex();
                    if (ohIndex == deinstOhIndex || (idx = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)new Integer(ohIndex))) == -1) continue;
                    OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(idx);
                    ohi.setDirty(true);
                }
            }
        }
    }

    public void initPartialLoad(int nOhSize) {
        Vector compOHsList = this.getCompOHsList();
        compOHsList.removeAllElements();
        compOHsList.setSize(nOhSize + 1);
    }

    public int getPlatform() {
        return this.m_nPlatform;
    }

    public void reload() {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        this.dispose();
        OiiiInstallInventoryReader reader = iac.getReaderForOracleHomes();
        try {
            this.m_oracleHomes = reader.readHomes();
        }
        catch (IOException e) {
            this.m_oracleHomes = new Vector();
            e.printStackTrace();
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_INV_READ_HOMELIST_ERROR"));
        }
    }

    public void logInvToLogFile() {
        Vector OHs;
        int iSize;
        StringBuffer tmpBuff = new StringBuffer();
        String logStr = OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC);
        tmpBuff.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_CUR_INV"));
        Vector indProds = this.getAllCompsVect(0);
        int n = iSize = indProds != null ? indProds.size() : 0;
        if (iSize > 0) {
            tmpBuff.append(logStr + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_IND_PRODS"));
            for (int j = 0; j < iSize; ++j) {
                OiiiCompInvEntry currComp = (OiiiCompInvEntry)indProds.elementAt(j);
                tmpBuff.append(logStr + "\t\t" + currComp.getFullDisplayName());
            }
        }
        int iSize1 = (OHs = this.getHomes()) != null ? OHs.size() : 0;
        for (int i = 0; i < iSize1; ++i) {
            OiiiOracleHomeInfo currOH = (OiiiOracleHomeInfo)OHs.elementAt(i);
            String displayName = currOH.getName();
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = currOH.getLocation();
            }
            tmpBuff.append(logStr + "\t" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_OHOME") + displayName);
            if (!currOH.isDirty()) {
                tmpBuff.append(logStr + "\t\t" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_OH_NOT_CHANGED"));
                continue;
            }
            int ohIndex = currOH.getIndex();
            Vector comps = this.getAllCompsVect(ohIndex);
            int iSize2 = comps != null ? comps.size() : 0;
            for (int j = 0; j < iSize2; ++j) {
                OiiiCompInvEntry currComp = (OiiiCompInvEntry)comps.elementAt(j);
                tmpBuff.append(logStr + "\t\t" + currComp.getFullDisplayName());
            }
            try {
                Vector vOneoffs = this.getAllOneoffInvEntries(ohIndex);
                if (vOneoffs == null || vOneoffs.size() <= 0) continue;
                for (int k = 0; k < vOneoffs.size(); ++k) {
                    OiiiInstallOneoffInvEntry oOneoff = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(k);
                    tmpBuff.append(logStr + "\t\t" + oOneoff.getDisplayString());
                }
                continue;
            }
            catch (Exception oe) {
                // empty catch block
            }
        }
        tmpBuff.append(OiiolTextLogger.NEW_LINE);
        OiiolTextLogger.appendText(new String(tmpBuff), OiiolTextLogger.LOG_BASIC);
    }

    public void attachHome(String sName, String sLoc, int homeType, int[] depIdxs) throws OiiiMissingDependeeException, IOException {
        this.attachHome(sName, sLoc, homeType, depIdxs, null, false);
    }

    public void attachHome(String sName, String sLoc, int homeType, int[] depIdxs, String[] nodeList, boolean mbCRS) throws OiiiMissingDependeeException, IOException {
        OiiiOracleHomeInfo homeInfo = null;
        try {
            homeInfo = this.attachHomeEx(sName, sLoc, homeType, depIdxs, null, null);
            if (nodeList != null && nodeList.length > 0) {
                homeInfo.setNodeList(nodeList);
            }
            homeInfo.setCRSHome(mbCRS);
        }
        catch (OiiiMultipleSOHException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    public OiiiOracleHomeInfo attachHomeEx(String sName, String sLoc, int homeType, int[] depIdxs) throws OiiiMissingDependeeException, IOException, OiiiMultipleSOHException {
        return this.attachHomeEx(sName, sLoc, homeType, depIdxs, null, null);
    }

    public OiiiOracleHomeInfo attachHomeEx(String sName, String sLoc, int homeType, int[] depIdxs, String compositeHome, String compositeHomeType) throws OiiiMissingDependeeException, IOException, OiiiMultipleSOHException {
        if (!OiiiInventoryHelper.isValidHomeName(sName)) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BAD_HOME_NAME");
            String sHomeType = OiiiOracleHomeInfo.getHomeTypeString(0);
            sMsg = MessageFormat.format(sMsg, sHomeType);
            throw new IOException(sMsg);
        }
        OiiiOracleHomeInfo homeInfo = this.addHome(sName, sLoc, homeType, compositeHome, compositeHomeType);
        homeInfo.setDirty(true);
        int homeIndex = homeInfo.getIndex();
        this.disposeCompsList(homeIndex);
        Vector vComps = this.getAllCompsVect(homeIndex);
        int iSize = vComps != null ? vComps.size() : 0;
        int[] fullDepIdxs = new int[depIdxs.length + 1];
        fullDepIdxs[0] = homeIndex;
        System.arraycopy(depIdxs, 0, fullDepIdxs, 1, depIdxs.length);
        try {
            for (int i = 0; i < iSize; ++i) {
                OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)vComps.elementAt(i);
                this.updateCompDependencies(invEntry, homeIndex, fullDepIdxs);
            }
        }
        catch (OiiiMissingDependeeException e) {
            this.removeHome(homeIndex);
            for (int i = 0; i < depIdxs.length; ++i) {
                this.disposeCompsList(depIdxs[i]);
            }
            this.disposeCompsList(0);
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME_NOT_ATTACHED_DEPENDENCY_MISSING_ERROR");
            sMsg = MessageFormat.format(sMsg, sName);
            OiiolTextLogger.appendErrorText(sMsg);
            throw e;
        }
        try {
            this.checkSOHInstalls(homeInfo);
        }
        catch (OiiiMultipleSOHException e) {
            this.removeHome(homeIndex);
            for (int i = 0; i < depIdxs.length; ++i) {
                this.disposeCompsList(depIdxs[i]);
            }
            this.disposeCompsList(0);
            throw e;
        }
        return homeInfo;
    }

    public OiiiOracleHomeInfo attachCompositeHomeEx(String sType, String sLoc) throws OiiiMissingDependeeException, IOException, OiiiMultipleSOHException {
        int homeType = 4;
        if (sType != null && !OiiiInventoryHelper.isValidHomeName(sType)) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BAD_HOME_TYPE");
            String sHomeType = OiiiOracleHomeInfo.getHomeTypeString(4);
            sMsg = MessageFormat.format(sMsg, sHomeType);
            throw new IOException(sMsg);
        }
        OiiiOracleHomeInfo homeInfo = this.addCompositeHome(sType, sLoc);
        homeInfo.setDirty(true);
        return homeInfo;
    }

    public boolean isUpgradeOHScenario(String homeLoc) {
        boolean bReinstall = false;
        bReinstall = Boolean.getBoolean("oracle.installer.reinstallsession");
        if (bReinstall) {
            return true;
        }
        OiiiOracleHomeInfo ohi = this.getHomeWithLocation(homeLoc);
        if (ohi != null) {
            return !ohi.wasCreatedInThisSession();
        }
        return false;
    }

    private void checkSOHInstalls(OiiiOracleHomeInfo homeInfo) throws OiiiMultipleSOHException {
        int iPlat;
        if (homeInfo == null) {
            return;
        }
        int homeIndex = homeInfo.getIndex();
        Vector oTLComps = this.getTopLevelComps(homeIndex, iPlat = OiixPlatform.getCurrentPlatform());
        if (oTLComps == null) {
            return;
        }
        int nSize = oTLComps != null ? oTLComps.size() : 0;
        for (int i = 0; i < nSize; ++i) {
            int nOhIndex;
            OiiiCompIdOhPair oOhId;
            OiiiCompInstallID id = (OiiiCompInstallID)oTLComps.get(i);
            OiiiCompInvEntry cie = this.getCompInvEntry(id, homeIndex);
            if (id.getHomeType() != 1 || (oOhId = this.getCompatCompInvEntryInAnyHome(id, iPlat)) == null || (nOhIndex = oOhId.getOHIndex()) == homeIndex || nOhIndex == 0) continue;
            Object[] obj = new Object[]{cie.getFullDisplayName(), this.getHomeLocation(nOhIndex)};
            String sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-27005", obj);
            OiiolTextLogger.appendErrorText(sError);
            OiiolTextLogger.writeMessageToConsole(sError);
            throw new OiiiMultipleSOHException("OUI-27005", sError);
        }
    }

    private void updateCompDependencies(OiiiInstallCompInvEntry invEntry, int homeIndex, int[] depIdxs) throws OiiiMissingDependeeException {
        int iSize1;
        OiiiCompInstallID cid = invEntry.getCompInstallID();
        Vector vDependees = invEntry.getDependees();
        int iSize = vDependees != null ? vDependees.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)vDependees.elementAt(i);
            OiiiCompInstallID depcid = depIdOh.getCompID();
            OiiiInstallCompInvEntry depInvEntry = null;
            for (int j = 0; j < depIdxs.length; ++j) {
                depInvEntry = (OiiiInstallCompInvEntry)this.getCompatCompEntry(depcid, depIdxs[j]);
                if (depInvEntry == null) continue;
                OiiiCompIdOhPair refIdOh = new OiiiCompIdOhPair(cid, homeIndex);
                refIdOh.setDepType(depIdOh.getDepType());
                refIdOh.setDepGroup(depIdOh.getDepGroup());
                depInvEntry.addReferencer(refIdOh);
                if (depcid.isNOHComp()) {
                    depIdOh.setOHIndex(0);
                    break;
                }
                depIdOh.setOHIndex(depIdxs[j]);
                OiiiOracleHomeInfo homeInfo = this.getHomeInfo(depIdxs[j]);
                homeInfo.setDirty(true);
                break;
            }
            if (depInvEntry != null) continue;
            throw new OiiiMissingDependeeException(invEntry, depIdOh);
        }
        Vector vReferencers = invEntry.getReferencers();
        int n = iSize1 = vReferencers != null ? vReferencers.size() : 0;
        if (iSize1 <= 0) {
            return;
        }
        Vector vNewReferencers = new Vector(iSize1);
        invEntry.setReferencers(vNewReferencers);
        for (int i = 0; i < iSize1; ++i) {
            OiiiCompIdOhPair refIdOh = (OiiiCompIdOhPair)vReferencers.elementAt(i);
            OiiiCompInstallID refcid = refIdOh.getCompID();
            OiiiInstallCompInvEntry refInvEntry = (OiiiInstallCompInvEntry)this.getCompInvEntry(refcid, homeIndex);
            if (refInvEntry == null) continue;
            refIdOh.setOHIndex(homeIndex);
            invEntry.addReferencer(refIdOh);
        }
    }

    public void renameHome(OiiiOracleHomeInfo homeInfo, String sNewName) throws OiiiInventoryUpdateException {
        if (!OiiiInventoryHelper.isValidHomeName(sNewName)) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BAD_HOME_NAME");
            String sHomeType = OiiiOracleHomeInfo.getHomeTypeString(homeInfo.getHomeType());
            sMsg = MessageFormat.format(sMsg, sHomeType);
            throw new OiiiInventoryUpdateException(sMsg);
        }
        OiiiOracleHomeInfo sameNameHome = this.getHomeWithName(sNewName, this.getAllHomes());
        if (sameNameHome != null) {
            if (sameNameHome.isRemoved()) {
                String sNewRemovedName = this.generateRemovedHomeName(sNewName);
                sameNameHome.renameTo(sNewRemovedName);
            } else {
                Object[] args = new Object[]{OiiiOracleHomeInfo.getHomeTypeString(0), sNewName, OiiiOracleHomeInfo.getHomeTypeString(sameNameHome.getHomeType())};
                throw new OiiiInventoryUpdateException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_HOME_NAME_EXISTS", args));
            }
        }
        homeInfo.renameTo(sNewName);
    }

    public void moveHome(OiiiOracleHomeInfo homeInfo, String sNewLocation) throws OiiiInventoryUpdateException {
        OiiiOracleHomeInfo sameLocHome = this.getHomeWithLocation(sNewLocation, this.getAllHomes());
        if (sameLocHome != null) {
            String sMsg = null;
            String sSourceHomeType = OiiiOracleHomeInfo.getHomeTypeString(homeInfo.getHomeType());
            String sDestHomeType = OiiiOracleHomeInfo.getHomeTypeString(sameLocHome.getHomeType());
            Object[] sArgs = new String[]{sSourceHomeType, sNewLocation, sDestHomeType};
            sMsg = sameLocHome.isRemoved() ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_REMOVED_HOME_EXISTS", sArgs) : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_HOME_EXISTS", sArgs);
            throw new OiiiInventoryUpdateException(sMsg);
        }
        homeInfo.moveTo(sNewLocation);
    }

    public boolean removeHome(OiiiOracleHomeInfo homeInfo) throws OiiiInventoryUpdateException {
        return this.removeHomeForce(homeInfo, false);
    }

    public boolean removeHomeForce(OiiiOracleHomeInfo homeInfo, boolean force) throws OiiiInventoryUpdateException {
        Vector vComps;
        boolean bRet = false;
        if (!force && (vComps = this.getAllCompsVect(homeInfo.getIndex())).size() > 0) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_HOME_NOT_EMPTY");
            throw new OiiiInventoryUpdateException(sMsg);
        }
        OiiolTextLogger.appendText("Detaching the home");
        try {
            bRet = this.detachHome(homeInfo);
        }
        catch (IOException e) {
            OiiolTextLogger.appendText("Detach Home failed.Either home does not exist or has references");
        }
        homeInfo.setRemovedInThisSession(true);
        if (force) {
            OiiolTextLogger.appendText("Removed the home by force, so setting the Comps vector to empty , to ensure that the inventory is updated with correct information");
            this.setAllCompsVect(homeInfo.getIndex(), new Vector());
            homeInfo.setDirty(true);
        }
        return bRet;
    }

    public boolean detachHome(OiiiOracleHomeInfo homeInfo) throws IOException {
        int idx = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)homeInfo);
        if (idx != -1) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(idx);
            boolean allDepHomes = Boolean.getBoolean("oracle.installer.allDepHomes");
            if (allDepHomes) {
                this.removeRefHomes(ohi);
            } else if (ohi.getRefHomeList() != null && ohi.getRefHomeList().size() != 0) {
                throw new IOException("This home " + homeInfo.getLocation() + " cannot be detached or deinstalled as it contains references to other homes");
            }
            this.removeDepHomes(ohi);
            this.m_oracleHomes.removeElementAt(idx);
            String refCompositeHome = ohi.getRefCompositeHome();
            if (refCompositeHome != null) {
                int noOfHomes;
                Vector homesInCompHome = (Vector)this.getHomesInCompositeHome(refCompositeHome);
                int n = noOfHomes = homesInCompHome != null ? homesInCompHome.size() : 0;
                if (noOfHomes == 1) {
                    OiiiOracleHomeInfo compHomeInfo = this.getCompositeHomeWithLocation(refCompositeHome);
                    this.detachCompositeHome(compHomeInfo);
                }
            }
            this.m_removedHomes.addElement(ohi);
            ohi.setRemoved(true);
            ohi.updateDirtyFlags(1024L);
            this.unsetOptionalOhProps(ohi);
        }
        return idx != -1;
    }

    private void removeRefHomes(OiiiOracleHomeInfo ohi) {
        Vector refHomes = new Vector(ohi.getRefHomeList());
        if (refHomes != null) {
            for (int i = 0; i < refHomes.size(); ++i) {
                String refHomeLoc = (String)refHomes.elementAt(i);
                OiiiOracleHomeInfo refHome = this.getHomeWithLocation(refHomeLoc);
                ohi.removeRefHome(refHomeLoc);
                int idxDep = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)refHome);
                refHome = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(idxDep);
                refHome.removeDepHome(ohi.getLocation());
                this.m_oracleHomes.setElementAt(refHome, idxDep);
            }
        }
    }

    private void removeDepHomes(OiiiOracleHomeInfo ohi) {
        Vector depHomes = new Vector(ohi.getDepHomeList());
        if (depHomes != null) {
            for (int i = 0; i < depHomes.size(); ++i) {
                String depHomeLoc = (String)depHomes.elementAt(i);
                OiiiOracleHomeInfo depHome = this.getHomeWithLocation(depHomeLoc);
                ohi.removeDepHome(depHomeLoc);
                int idxDep = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)depHome);
                depHome = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(idxDep);
                depHome.removeRefHome(ohi.getLocation());
                this.m_oracleHomes.setElementAt(depHome, idxDep);
            }
        }
    }

    public boolean detachCompositeHome(OiiiOracleHomeInfo homeInfo) throws IOException {
        int idx = OiixVectorOps.vectIndexOf(this.m_compositeOracleHomes, (Object)homeInfo);
        if (idx != -1) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)this.m_compositeOracleHomes.elementAt(idx);
            this.m_compositeOracleHomes.removeElementAt(idx);
            this.m_removedCompositeOracleHomes.addElement(ohi);
            ohi.setRemoved(true);
            ohi.updateDirtyFlags(1024L);
            this.unsetOptionalOhProps(ohi);
        }
        return idx != -1;
    }

    public boolean updateHomeDeps(String refHome, String depHome) {
        OiiiOracleHomeInfo ohiRef = this.getHomeWithLocation(refHome);
        OiiiOracleHomeInfo ohiDep = this.getHomeWithLocation(depHome);
        int idxRef = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)ohiRef);
        int idxDep = OiixVectorOps.vectIndexOf(this.m_oracleHomes, (Object)ohiDep);
        if (idxRef != -1 && idxDep != -1) {
            ohiRef = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(idxRef);
            ohiDep = (OiiiOracleHomeInfo)this.m_oracleHomes.elementAt(idxDep);
            ohiRef.addDepHome(ohiDep.getLocation());
            ohiDep.addRefHome(ohiRef.getLocation());
            ohiRef.updateDirtyFlags(8192L);
            ohiDep.updateDirtyFlags(8192L);
            this.m_oracleHomes.setElementAt(ohiRef, idxRef);
            this.m_oracleHomes.setElementAt(ohiDep, idxDep);
        }
        return idxRef != -1 && idxDep != -1;
    }

    public Vector loadHomesFromStream(InputStream is, OiiiInstallInventoryStreamReader reader) throws IOException {
        this.m_oracleHomes = reader.readHomes(is);
        return this.m_oracleHomes;
    }

    public Vector loadCompsFromStream(int homeIndex, InputStream is, OiiiInstallInventoryStreamReader reader) throws IOException {
        int homeType = 2;
        if (homeIndex != 0) {
            OiiiOracleHomeInfo homeInfo = this.getHomeInfo(homeIndex);
            if (homeInfo == null) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_INDEX_NOT_FOUND", new Object[]{new Integer(homeIndex)});
                throw new OiiiInstallInventoryReadException(sMsg);
            }
            homeType = homeInfo.getHomeType();
        }
        OiiiInvHomeInfo oihi = reader.readComps(is, homeIndex, homeType, this.m_nPlatform);
        Vector vComps = oihi.getCompsVect();
        this.setInvHomeInfo(homeIndex, oihi);
        this.setupRefsForVect(homeIndex);
        int size = vComps != null ? vComps.size() : 0;
        for (int i = 0; i < size; ++i) {
            OiiiInstallCompInvEntry ice = (OiiiInstallCompInvEntry)vComps.elementAt(i);
            ice.setOHIndex(homeIndex);
        }
        this.correctOneoffInventoryEntries(oihi);
        return this.getAllCompsVect(homeIndex);
    }

    public OiiiLibrariesInfo loadLibsFromStream(int homeIndex, InputStream is, OiiiInstallInventoryStreamReader reader) throws IOException {
        OiiiOracleHomeInfo homeInfo;
        if (homeIndex != 0 && (homeInfo = this.getHomeInfo(homeIndex)) == null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_INDEX_NOT_FOUND", new Object[]{new Integer(homeIndex)});
            throw new OiiiInstallInventoryReadException(sMsg);
        }
        OiiiLibrariesInfo libsInfo = reader.readLibs(is, homeIndex, this.m_nPlatform);
        this.setAllCompsLibsInfo(homeIndex, libsInfo);
        return libsInfo;
    }

    public OiiiCompCloneVars getCompCloneVars(OiiiCompInstallID cid, int homeIndex) {
        List allCloneVars = this.getCompCloneVars(homeIndex);
        OiiiCompCloneVars compCloneVars = null;
        Iterator iter = allCloneVars.iterator();
        while (iter.hasNext()) {
            OiiiCompCloneVars currentCloneVars = (OiiiCompCloneVars)iter.next();
            if (!currentCloneVars.equals(cid)) continue;
            compCloneVars = currentCloneVars;
            break;
        }
        return compCloneVars;
    }

    public OiiiCompCloneVars addCompCloneVars(OiiiCompInstallID cid, int homeIndex) {
        OiiiCompCloneVars compCloneVars;
        List cloneVars = this.getCompCloneVars(homeIndex);
        if (!cloneVars.add(compCloneVars = new OiiiCompCloneVars(cid))) {
            compCloneVars = this.getCompCloneVars(cid, homeIndex);
        }
        return compCloneVars;
    }

    public boolean removeCompCloneVars(OiiiCompInstallID cid, int homeIndex) {
        List allCloneVars = this.getCompCloneVars(homeIndex);
        boolean bRemoved = false;
        Iterator iter = allCloneVars.iterator();
        while (iter.hasNext()) {
            OiiiCompCloneVars currentCloneVars = (OiiiCompCloneVars)iter.next();
            if (!currentCloneVars.equals(cid)) continue;
            iter.remove();
            bRemoved = true;
            break;
        }
        return bRemoved;
    }

    public List getCloneVars(String sHomeLoc) throws OiiiNoSuchHomeException {
        OiiiOracleHomeInfo homeInfo = this.getHomeWithLocation(sHomeLoc);
        if (homeInfo == null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_LOC_NOT_FOUND", new Object[]{sHomeLoc});
            throw new OiiiNoSuchHomeException(sMsg);
        }
        return this.getCompCloneVars(homeInfo.getIndex());
    }

    private List getCompCloneVars(int homeIndex) {
        OiiiCloneInfo cloneInfo = this.getCloneInfo(homeIndex);
        return cloneInfo != null ? cloneInfo.getCompVars() : null;
    }

    private OiiiSessionCloneVars getSessionCloneVars(int homeIndex) {
        OiiiCloneInfo cloneInfo = this.getCloneInfo(homeIndex);
        return cloneInfo != null ? cloneInfo.getSessionVars() : null;
    }

    public OiiiCloneInfo getCloneInfo(String sHomeLoc) throws OiiiNoSuchHomeException {
        OiiiOracleHomeInfo homeInfo = this.getHomeWithLocation(sHomeLoc);
        if (homeInfo == null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_LOC_NOT_FOUND", new Object[]{sHomeLoc});
            throw new OiiiNoSuchHomeException(sMsg);
        }
        return this.getCloneInfo(homeInfo.getIndex());
    }

    public OiiiCloneInfo getCloneInfo(int homeIndex) {
        OiiiInvHomeInfo invHomeInfo = this.getCompOHListInfo(homeIndex);
        OiiiCloneInfo cloneInfo = invHomeInfo.getCloneInfo();
        if (cloneInfo == null) {
            try {
                this.loadCloneVars(homeIndex);
                cloneInfo = invHomeInfo.getCloneInfo();
            }
            catch (OiiiInstallInventoryReadException e) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_ERR_LOAD_CLONE_INFO", new Object[]{this.getHomeLocation(homeIndex)});
                OiiolTextLogger.appendText(sMsg);
            }
        }
        return cloneInfo;
    }

    private void loadCloneVars(int homeIndex) throws OiiiInstallInventoryReadException {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        String sCloneFileLoc = iac.getCloneFileLoc(homeIndex);
        OiiiCloneInfo cloneInfo = this.loadCloneInfo(sCloneFileLoc);
        OiiiInvHomeInfo invHomeInfo = this.getCompOHListInfo(homeIndex);
        invHomeInfo.setCloneInfo(cloneInfo);
    }

    /*
     * Loose catch block
     */
    private OiiiCloneInfo loadCloneInfo(String sCloneFileLoc) throws OiiiInstallInventoryReadException {
        OiiiCloneInfo cloneInfo;
        block19: {
            cloneInfo = null;
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            Object oSessionCloneVars = null;
            fis = new FileInputStream(OiixPathOps.getNativeForm(sCloneFileLoc));
            isr = new InputStreamReader((InputStream)fis, CS_UTF8);
            br = new BufferedReader(isr);
            Parser parser = OixsXMLOps.createSAXParser();
            OiiiCloneXMLHandler handler = new OiiiCloneXMLHandler();
            parser.setDocumentHandler(handler);
            parser.parse(new InputSource(br));
            cloneInfo = handler.getCloneInfo();
            Object var10_12 = null;
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
                break block19;
            }
            catch (IOException e) {}
            break block19;
            {
                catch (SAXException se) {
                    se.printStackTrace();
                    throw new OiiiInstallInventoryReadException(se, se.getMessage());
                }
                catch (FileNotFoundException fe) {
                    cloneInfo = new OiiiCloneInfo(new ArrayList(), new ArrayList(), new OiiiSessionCloneVars());
                    Object var10_13 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        break block19;
                    }
                    catch (IOException e) {}
                    break block19;
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                    throw new OiiiInstallInventoryReadException(ie, ie.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return cloneInfo;
    }

    List getExternalDependees(int homeIndex) {
        Enumeration enumComps = this.getAllComps(homeIndex);
        ArrayList<OiiiCompIdOhPair> alExtDeps = new ArrayList<OiiiCompIdOhPair>();
        while (enumComps.hasMoreElements()) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)enumComps.nextElement();
            Vector vDeps = invEntry.getDependees();
            if (vDeps == null || vDeps.isEmpty()) continue;
            Enumeration enumDeps = vDeps.elements();
            while (enumDeps.hasMoreElements()) {
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)enumDeps.nextElement();
                int depOhIdx = depIdOh.getOHIndex();
                if (depOhIdx == homeIndex) continue;
                alExtDeps.add(depIdOh);
            }
        }
        return alExtDeps;
    }

    public boolean isPreCloneNeeded(String sHomeLoc) throws OiiiNoSuchHomeException, OiiiInstallInventoryReadException {
        File fHomeLoc = new File(sHomeLoc);
        if (!fHomeLoc.exists() || !fHomeLoc.isDirectory()) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_LOC_NOT_FOUND", new Object[]{sHomeLoc});
            throw new OiiiNoSuchHomeException(sMsg);
        }
        boolean bPreCloneNeeded = false;
        String sCloneFileLoc = this.getInstallAreaControl().getCloneFileLoc(sHomeLoc);
        OiiiCloneInfo cloneInfo = this.loadCloneInfo(sCloneFileLoc);
        List extDeps = cloneInfo.getExtDeps();
        Iterator iter = extDeps.iterator();
        while (iter.hasNext()) {
            OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)iter.next();
            OiiiInstallCompInvEntry invEntry = this.getInstallCompInvEntry(depIdOh.getCompID(), 0);
            if (invEntry != null) continue;
            bPreCloneNeeded = true;
            break;
        }
        return bPreCloneNeeded;
    }

    public long getTotalHomeSize(String sHomeLoc) throws OiiiNoSuchHomeException, OiiiInstallInventoryReadException {
        OiiiOracleHomeInfo homeInfo = this.getHomeWithLocation(sHomeLoc);
        File fHomeLoc = new File(sHomeLoc);
        if (!fHomeLoc.exists() || !fHomeLoc.isDirectory() || homeInfo == null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_LOC_NOT_FOUND", new Object[]{sHomeLoc});
            throw new OiiiNoSuchHomeException(sMsg);
        }
        long lSize = 0L;
        Enumeration enumComps = this.getAllComps(homeInfo.getIndex());
        while (enumComps.hasMoreElements()) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)enumComps.nextElement();
            lSize += invEntry.getFileSizeInfoEx().getSizeEx();
        }
        return lSize;
    }

    public long getSizeOfComponentsInHome(String sHomeLoc) throws OiiiNoSuchHomeException, OiiiInstallInventoryReadException {
        OiiiOracleHomeInfo homeInfo = this.getHomeWithLocation(sHomeLoc);
        File fHomeLoc = new File(sHomeLoc);
        if (!fHomeLoc.exists() || !fHomeLoc.isDirectory() || homeInfo == null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOME_LOC_NOT_FOUND", new Object[]{sHomeLoc});
            throw new OiiiNoSuchHomeException(sMsg);
        }
        long lSize = 0L;
        Enumeration enumComps = this.getAllComps(homeInfo.getIndex());
        while (enumComps.hasMoreElements()) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)enumComps.nextElement();
            if (invEntry.getCompInstallID().getCompType() != 1) continue;
            lSize += invEntry.getFileSizeInfoEx().getSizeEx();
        }
        return lSize;
    }

    public void disposeCompsList(int homeIndex) {
        this.setAllCompsVect(homeIndex, null);
    }

    private void disposeLibsInfo(int homeIndex) {
    }

    public OiiiOracleHomeInfo getHomeWithLocation(String sHomeLoc) {
        return this.getHomeWithLocation(sHomeLoc, this.m_oracleHomes);
    }

    public OiiiOracleHomeInfo getHomeWithLocation(String sHomeLoc, int iHomeType) {
        Vector vHomes = this.getHomes(iHomeType);
        return this.getHomeWithLocation(sHomeLoc, vHomes);
    }

    private OiiiOracleHomeInfo getHomeWithLocation(String sHomeLoc, Vector vHomes) {
        OiiiOracleHomeInfo homeInfo = null;
        int homeIndex = OiiiOracleHomeInfo.getOHIndex(vHomes, sHomeLoc);
        if (homeIndex != -1) {
            homeInfo = this.getHomeInfo(homeIndex, vHomes);
        }
        return homeInfo;
    }

    public OiiiOracleHomeInfo getCompositeHomeWithLocation(String sCompositeHomeLoc) {
        return this.getCompositeHomeWithLocation(sCompositeHomeLoc, this.m_compositeOracleHomes);
    }

    private OiiiOracleHomeInfo getCompositeHomeWithLocation(String sHomeLoc, Vector vHomes) {
        OiiiOracleHomeInfo homeInfo = null;
        int homeIndex = OiiiOracleHomeInfo.getCompOHIndex(vHomes, sHomeLoc);
        if (homeIndex != -1) {
            homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(homeIndex);
        }
        return homeInfo;
    }

    public OiiiCompositeAreaControl getCompositeAreaControl(String sCompHomeLoc) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        if (iac == null) {
            return null;
        }
        ArrayList compAreaControl = iac.getCompAreaControlList();
        for (int idx = 0; idx < compAreaControl.size(); ++idx) {
            OiiiCompositeAreaControl cac = (OiiiCompositeAreaControl)compAreaControl.get(idx);
            String compHomeLoc = OiixPathOps.getParentDir(cac.getAreaRoot());
            if (!OiipgFileSystem.equalPathStrs(compHomeLoc, sCompHomeLoc)) continue;
            return cac;
        }
        return null;
    }

    public List getHomesInCompositeHome(String sCompHomeLoc) {
        OiiiCompositeAreaControl cac = this.getCompositeAreaControl(sCompHomeLoc);
        if (cac == null) {
            return null;
        }
        OiiiCompositeHomeInventory cinv = cac.getInstallInventory();
        return cinv.getHomes();
    }

    public String getDefaultHomeName(String sHomeName) {
        String name = OiiiOracleHomeInfo.getDefHomeName(this, 0, sHomeName);
        int idx = 1;
        boolean bNameExists = true;
        while (bNameExists) {
            String sName = name + idx;
            bNameExists = this.getHomeWithName(sName) != null;
            if (!bNameExists) continue;
            ++idx;
        }
        return name + idx;
    }

    public OiiiOracleHomeInfo getHomeWithName(String sHomeName) {
        return this.getHomeWithName(sHomeName, this.m_oracleHomes);
    }

    private OiiiOracleHomeInfo getHomeWithName(String sHomeName, Vector vHomes) {
        OiiiOracleHomeInfo homeInfo = null;
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            if (sHomeName == null || !sHomeName.equalsIgnoreCase(ohi.getName())) continue;
            homeInfo = ohi;
            break;
        }
        return homeInfo;
    }

    public OiiiOracleHomeInfo getCompositeHomeWithTypeName(String sHomeTypeName) {
        return this.getCompositeHomeWithTypeName(sHomeTypeName, this.m_compositeOracleHomes);
    }

    private OiiiOracleHomeInfo getCompositeHomeWithTypeName(String sHomeTypeName, Vector vHomes) {
        OiiiOracleHomeInfo homeInfo = null;
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            if (sHomeTypeName == null || !sHomeTypeName.equalsIgnoreCase(ohi.getCompositeHomeTypeName())) continue;
            homeInfo = ohi;
            break;
        }
        return homeInfo;
    }

    OiiiHomeInvDetails getInvDetails(int homeIndex) {
        if (homeIndex == 0) {
            return OiiiHomeInvDetails.getDefault();
        }
        OiiiOracleHomeInfo homeInfo = this.getHomeInfo(homeIndex, this.getAllOUIHomes());
        OiiiHomeInvDetails invDetails = homeInfo.getInvDetails();
        if (invDetails == null) {
            try {
                OiiiInstallAreaControl iac = this.getInstallAreaControl();
                String sFileLoc = iac.getInvDetailsFileLoc(homeIndex);
                FileInputStream is = new FileInputStream(sFileLoc);
                Properties props = new Properties();
                props.load(is);
                invDetails = new OiiiHomeInvDetails(props);
            }
            catch (FileNotFoundException e) {
                invDetails = new OiiiHomeInvDetails();
            }
            catch (IOException e) {
                e.printStackTrace();
                invDetails = new OiiiHomeInvDetails();
            }
            homeInfo.setInvDetails(invDetails);
        }
        return invDetails;
    }

    void setXMLHLUnknownElement(XMLElement xmlHLUnknownElement) {
        this.m_xmlHLUnknownElement = xmlHLUnknownElement;
    }

    void setXMLInvUnknownElement(XMLElement xmlInvUnknownElement) {
        this.m_xmlInvUnknownElement = xmlInvUnknownElement;
    }

    XMLElement getXMLInvUnknownElement() {
        return this.m_xmlInvUnknownElement;
    }

    XMLElement getXMLHLUnknownElement() {
        return this.m_xmlHLUnknownElement;
    }

    private OiiiInstallAreaControl getInstallAreaControl() {
        return (OiiiInstallAreaControl)this.getAreaControl();
    }

    public OiiiInstallMiniPatchsetInvEntry createMiniPatchsetInvEntry(String id, Vector bugFixes, boolean bRollback, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        Vector filesToPatch = new Vector();
        return this.createMiniPatchsetInvEntry(id, bugFixes, filesToPatch, bRollback, homeIndex);
    }

    public OiiiInstallMiniPatchsetInvEntry createMiniPatchsetInvEntry(String id, Vector bugFixes, boolean bRollback, int homeIndex) throws OiiiOneoffException {
        return this.createMiniPatchsetInvEntry(id, bugFixes, new Vector(), bRollback, homeIndex);
    }

    public OiiiInstallOneoffInvEntry createOneoffInvEntry(String id, Vector bugFixes, boolean bRollback, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        Vector filesToPatch = new Vector();
        return this.createOneoffInvEntry(id, bugFixes, filesToPatch, bRollback, homeIndex);
    }

    public OiiiInstallOneoffInvEntry createOneoffInvEntry(String id, Vector bugFixes, boolean bRollback, int homeIndex) throws OiiiOneoffException {
        return this.createOneoffInvEntry(id, bugFixes, new Vector(), bRollback, homeIndex);
    }

    public OiiiInstallOneoffInvEntry createOneoffInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.createOneoffInvEntry(id, bugFixes, filesToPatch, bRollback, homeIndex);
    }

    public OiiiInstallOneoffInvEntry createOneoffInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, int homeIndex) throws OiiiOneoffException {
        return this.createOneoffInvEntry(id, bugFixes, filesToPatch, bRollback, new Vector(), homeIndex);
    }

    public OiiiInstallOneoffInvEntry createOneoffInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, Vector langs, int homeIndex) throws OiiiOneoffException {
        return this.createOneoffInvEntry(id, bugFixes, filesToPatch, bRollback, new Vector(), null, homeIndex);
    }

    public OiiiInstallOneoffInvEntry createOneoffInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, Vector langs, String uniqID, int homeIndex) throws OiiiOneoffException {
        OiiiInstallOneoffInvEntry retEntry = null;
        retEntry = this.getOneoffInvEntry(id, langs, uniqID, homeIndex);
        if (retEntry != null) {
            String homeName = homeIndex == 0 ? INDEPENDENT_PRODUCTS : this.getHomeInfo(homeIndex).getName();
            Object[] args = new Object[]{id, homeName};
            throw new OiiiOneoffException("S_ONEOFF_DUPLICATE_ENTRY_IN_HOME", args);
        }
        retEntry = new OiiiInstallOneoffInvEntry(id, bugFixes, filesToPatch, bRollback, homeIndex, "");
        retEntry.setLangs(langs);
        retEntry.setUniqID(uniqID);
        return retEntry;
    }

    public void addOneoffInvEntry(OiiiInstallOneoffInvEntry oneoffInvEntry, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        this.addOneoffInvEntry(oneoffInvEntry, homeIndex);
    }

    public void addOneoffInvEntry(OiiiInstallOneoffInvEntry oneoffInvEntry, int homeIndex) throws OiiiOneoffException {
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(homeIndex);
        String id = oneoffInvEntry.getID().getID();
        Vector langs = oneoffInvEntry.getLangs();
        String uniqID = oneoffInvEntry.getUniqID();
        String homeName = null;
        if (homeIndex == 0) {
            homeName = INDEPENDENT_PRODUCTS;
        } else {
            OiiiOracleHomeInfo oInfo = this.getHomeInfo(homeIndex);
            homeName = oInfo.getName();
        }
        OiiiInstallOneoffInvEntry oEntry = this.getOneoffInvEntry(id, langs, uniqID, homeIndex);
        if (oEntry != null) {
            Object[] args = new Object[]{id, homeName};
            throw new OiiiOneoffException("S_ONEOFF_DUPLICATE_ENTRY_IN_HOME", args);
        }
        Vector vOneoffs = oihi.getOneoffsVect();
        vOneoffs.addElement(oneoffInvEntry);
        Vector vSupersedeList = oneoffInvEntry.getSupersededOneOffsList();
        if (vSupersedeList != null && vSupersedeList.size() > 0) {
            for (int i = 0; i < vSupersedeList.size(); ++i) {
                String ssuniqid;
                Vector sslangs;
                OiiiInstallOneoffInvEntry ssOneOff = (OiiiInstallOneoffInvEntry)vSupersedeList.elementAt(i);
                String ssid = ssOneOff.getID().toString();
                OiiiInstallOneoffInvEntry ssEntry = this.getOneoffInvEntry(ssid, sslangs = ssOneOff.getLangs(), ssuniqid = ssOneOff.getUniqID(), homeIndex);
                if (null == ssEntry) {
                    Object[] args = new Object[]{ssid, id};
                    throw new OiiiOneoffException("S_ONEOFF_SUPERESEDED_PATCH_NOT_IN_INVENTORY");
                }
                if (null == ssEntry.getSupersededByOneOffsList()) {
                    ssEntry.setSupersededByOneOffsList(new Vector());
                    continue;
                }
                OiiiInstallOneoffInvEntry ie = this.isOneOffInvEntryPresent(ssEntry.getSupersededByOneOffsList(), oneoffInvEntry);
                if (ie != null) continue;
                ssEntry.getSupersededByOneOffsList().add(oneoffInvEntry);
            }
        }
        if (homeIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(homeIndex);
            oohi.setDirty(true);
        }
    }

    public OiiiInstallMiniPatchsetInvEntry createMiniPatchsetInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.createMiniPatchsetInvEntry(id, bugFixes, filesToPatch, bRollback, homeIndex);
    }

    public OiiiInstallMiniPatchsetInvEntry createMiniPatchsetInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, int homeIndex) throws OiiiOneoffException {
        return this.createMiniPatchsetInvEntry(id, bugFixes, filesToPatch, bRollback, new Vector(), homeIndex);
    }

    public OiiiInstallMiniPatchsetInvEntry createMiniPatchsetInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, Vector langs, int homeIndex) throws OiiiOneoffException {
        return this.createMiniPatchsetInvEntry(id, bugFixes, filesToPatch, bRollback, langs, null, homeIndex);
    }

    public OiiiInstallMiniPatchsetInvEntry createMiniPatchsetInvEntry(String id, Vector bugFixes, Vector filesToPatch, boolean bRollback, Vector langs, String uniqID, int homeIndex) throws OiiiOneoffException {
        OiiiInstallMiniPatchsetInvEntry retEntry = null;
        retEntry = this.getMiniPatchsetInvEntry(id, langs, uniqID, homeIndex);
        if (retEntry != null) {
            String homeName = homeIndex == 0 ? INDEPENDENT_PRODUCTS : this.getHomeInfo(homeIndex).getName();
            Object[] args = new Object[]{id, homeName};
            throw new OiiiOneoffException("S_MINIPATCHSET_DUPLICATE_ENTRY_IN_HOME", args);
        }
        retEntry = new OiiiInstallMiniPatchsetInvEntry(id, bugFixes, filesToPatch, bRollback, homeIndex, "");
        retEntry.setLangs(langs);
        retEntry.setUniqID(uniqID);
        return retEntry;
    }

    public OiiiInstallMiniPatchsetInvEntry addMiniPatchsetInvEntry(OiiiMiniPatchsetInvEntry MiniPatchsetInvEntry, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.addMiniPatchsetInvEntry(MiniPatchsetInvEntry, homeIndex);
    }

    public OiiiInstallMiniPatchsetInvEntry addMiniPatchsetInvEntry(OiiiMiniPatchsetInvEntry MiniPatchsetInvEntry, int homeIndex) throws OiiiOneoffException {
        Vector vSupersedeList;
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(homeIndex);
        String id = MiniPatchsetInvEntry.getID().getID();
        Vector langs = MiniPatchsetInvEntry.getLangs();
        String uniqID = MiniPatchsetInvEntry.getUniqID();
        String homeName = null;
        if (homeIndex == 0) {
            homeName = INDEPENDENT_PRODUCTS;
        } else {
            OiiiOracleHomeInfo oInfo = this.getHomeInfo(homeIndex);
            homeName = oInfo.getName();
        }
        OiiiInstallMiniPatchsetInvEntry oEntry = this.getMiniPatchsetInvEntry(id, langs, uniqID, homeIndex);
        if (oEntry != null) {
            Object[] args = new Object[]{id, homeName};
            throw new OiiiOneoffException("S_MINIPATCHSET_DUPLICATE_ENTRY_IN_HOME", args);
        }
        Vector compsVect = oihi.getCompsVect();
        if (compsVect != null) {
            int kSize = MiniPatchsetInvEntry.getBaseComps() != null ? MiniPatchsetInvEntry.getBaseComps().size() : 0;
            for (int k = 0; k < kSize; ++k) {
                OiiiCompIdVerPair cIdVerPair = (OiiiCompIdVerPair)MiniPatchsetInvEntry.getBaseComps().elementAt(k);
                String baseCompName = cIdVerPair.getCompIdOhPair().getCompID().getName();
                OiiiVersion baseCompVersion = cIdVerPair.getFromVersion();
                for (int i = 0; i < compsVect.size(); ++i) {
                    OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)compsVect.get(i);
                    OiiiCompInstallID cid = icie.getCompInstallID();
                    OiiiVersion compVer = cid.getVersion();
                    String compName = cid.getName();
                    if (!baseCompName.equals(compName) || !compVer.laterThan(baseCompVersion)) continue;
                    Object[] args = new Object[]{id, compName, compVer, homeName};
                    throw new OiiiOneoffException("S_MINIPATCHSET_HIGHER_VERSION_BASE_COMP_EXIST", args);
                }
            }
        }
        if ((vSupersedeList = MiniPatchsetInvEntry.getSupersededOneOffsList()) != null && vSupersedeList.size() > 0) {
            for (int i = 0; i < vSupersedeList.size(); ++i) {
                String ssuniqid;
                Vector sslangs;
                OiiiInstallMiniPatchsetInvEntry ssMiniPS = (OiiiInstallMiniPatchsetInvEntry)vSupersedeList.elementAt(i);
                String ssid = ssMiniPS.getID().toString();
                OiiiInstallMiniPatchsetInvEntry ssEntry = this.getMiniPatchsetInvEntry(ssid, sslangs = ssMiniPS.getLangs(), ssuniqid = ssMiniPS.getUniqID(), homeIndex);
                if (null == ssEntry) {
                    Object[] args = new Object[]{ssid, id};
                    throw new OiiiOneoffException("S_ONEOFF_SUPERESEDED_PATCH_NOT_IN_INVENTORY");
                }
                if (null == ssEntry.getSupersededByOneOffsList()) {
                    ssEntry.setSupersededByOneOffsList(new Vector());
                    continue;
                }
                OiiiInstallMiniPatchsetInvEntry ie = (OiiiInstallMiniPatchsetInvEntry)this.isMiniPatchsetInvEntryPresent(ssEntry.getSupersededByOneOffsList(), MiniPatchsetInvEntry);
                if (ie != null) continue;
                ssEntry.getSupersededByOneOffsList().add(MiniPatchsetInvEntry);
            }
        }
        Vector vMiniPatchsets = oihi.getMiniPatchsetsVect();
        vMiniPatchsets.addElement(MiniPatchsetInvEntry);
        if (homeIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(homeIndex);
            oohi.setDirty(true);
        }
        return oEntry;
    }

    public boolean updateCompVersion(String compName, OiiiVersion version, int homeIndex) {
        OiiiCompInvEntry ocie;
        boolean versionChanged = false;
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(homeIndex);
        String homeName = null;
        if (homeIndex == 0) {
            homeName = INDEPENDENT_PRODUCTS;
        } else {
            OiiiOracleHomeInfo oInfo = this.getHomeInfo(homeIndex);
            homeName = oInfo.getName();
        }
        Vector comps = this.getCompOHListElement(homeIndex);
        for (int i = 0; i < comps.size(); ++i) {
            ocie = (OiiiCompInvEntry)comps.get(i);
            OiiiCompInstallID cid = ocie.getCompInstallID();
            if (!cid.getName().equals(compName)) continue;
            cid.setVersion(version);
            versionChanged = true;
        }
        for (int k = 0; k < comps.size(); ++k) {
            ocie = (OiiiCompInvEntry)comps.get(k);
            OiisDeps deps = ocie.getDeps();
            if (deps == null) continue;
            Vector depRules = deps.getDepRules();
            for (int i = 0; i < depRules.size(); ++i) {
                OiisDepRule rule = (OiisDepRule)depRules.elementAt(i);
                Vector vDepComps = rule.getDepCompIds();
                for (int j = 0; j < vDepComps.size(); ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)vDepComps.elementAt(j);
                    if (!cid.getName().equals(compName)) continue;
                    cid.setVersion(version);
                    vDepComps.setElementAt(cid, j);
                }
            }
        }
        if (homeIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(homeIndex);
            oohi.setDirty(true);
        }
        return versionChanged;
    }

    public OiiiInstallMiniPatchsetInvEntry getMiniPatchsetInvEntry(String id) throws OiiiOneoffException {
        OiiiOracleHomeInfo oInfo;
        OiiiInstallMiniPatchsetInvEntry oEntry = null;
        Vector vHomes = this.getHomes();
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize && (oEntry = this.getMiniPatchsetInvEntry(id, (oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i)).getIndex())) == null; ++i) {
        }
        if (oEntry == null) {
            oEntry = this.getMiniPatchsetInvEntry(id, 0);
        }
        return oEntry;
    }

    public OiiiInstallOneoffInvEntry getOneoffInvEntry(String id) throws OiiiOneoffException {
        OiiiOracleHomeInfo oInfo;
        OiiiInstallOneoffInvEntry oEntry = null;
        Vector vHomes = this.getHomes();
        int iSize = vHomes != null ? vHomes.size() : 0;
        for (int i = 0; i < iSize && (oEntry = this.getOneoffInvEntry(id, (oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i)).getIndex())) == null; ++i) {
        }
        if (oEntry == null) {
            oEntry = this.getOneoffInvEntry(id, 0);
        }
        return oEntry;
    }

    public void removeMiniPatchsetInvEntry(OiiiInstallMiniPatchsetInvEntry MiniPatchsetInvEntry) throws OiiiOneoffException {
        OiiiOracleHomeInfo oInfo;
        if (MiniPatchsetInvEntry == null) {
            throw new OiiiOneoffException("S_MINIPATCHSET_ENTRY_NOT_PRESENT_IN_HOME");
        }
        int homeIndex = MiniPatchsetInvEntry.getHomeIndex();
        if (homeIndex != 0 && (oInfo = this.getHomeInfo(homeIndex)) == null) {
            Object[] args = new Object[]{MiniPatchsetInvEntry.getID().getID()};
            throw new OiiiOneoffException("S_MINIPATCHSET_ENTRY_WITH_INVALID_HOME", args);
        }
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(homeIndex);
        Vector vMiniPatchsets = oihi.getMiniPatchsetsVect();
        if (vMiniPatchsets == null || vMiniPatchsets.size() == 0) {
            Object[] args = new Object[]{MiniPatchsetInvEntry.getID().getID()};
            throw new OiiiOneoffException("S_MINIPATCHSET_ENTRY_NOT_PRESENT_IN_HOME", args);
        }
        if (!vMiniPatchsets.contains(MiniPatchsetInvEntry)) {
            Object[] args = new Object[]{MiniPatchsetInvEntry.getID().getID()};
            throw new OiiiOneoffException("S_MINIPATCHSET_ENTRY_NOT_PRESENT_IN_HOME", args);
        }
        Vector compsList = MiniPatchsetInvEntry.getBaseComps();
        int nBaseComps = compsList != null ? compsList.size() : 0;
        Vector vOneoffs = this.getAllOneoffInvEntries(homeIndex);
        int nOneoffs = vOneoffs != null ? vOneoffs.size() : 0;
        for (int k = 0; k < nBaseComps; ++k) {
            OiiiCompIdVerPair cIdVerPair = (OiiiCompIdVerPair)compsList.elementAt(k);
            OiiiCompInstallID cid = cIdVerPair.getCompIdOhPair().getCompID();
            for (int l = 0; l < nOneoffs; ++l) {
                OiiiInstallOneoffInvEntry oneOffInvEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(l);
                boolean isPatched = oneOffInvEntry.isComponentPatched(cid.getName(), cIdVerPair.getToVersion().toString());
                if (!isPatched || cIdVerPair.getToVersion().equals(cIdVerPair.getFromVersion())) continue;
                Object[] args = new Object[]{MiniPatchsetInvEntry.getID().getID(), oneOffInvEntry.getID()};
                throw new OiiiOneoffException("S_MINIPATCHSET_ENTRY_PATCHED", args);
            }
        }
        vMiniPatchsets.remove(MiniPatchsetInvEntry);
        Vector vSupersedeList = MiniPatchsetInvEntry.getSupersededOneOffsList();
        if (vSupersedeList != null && vSupersedeList.size() > 0) {
            for (int i = 0; i < vSupersedeList.size(); ++i) {
                OiiiInstallMiniPatchsetInvEntry ie;
                String ssuniqid;
                Vector sslangs;
                OiiiInstallMiniPatchsetInvEntry ssOneOff = (OiiiInstallMiniPatchsetInvEntry)vSupersedeList.elementAt(i);
                String ssid = ssOneOff.getID().toString();
                OiiiInstallMiniPatchsetInvEntry ssEntry = this.getMiniPatchsetInvEntry(ssid, sslangs = ssOneOff.getLangs(), ssuniqid = ssOneOff.getUniqID(), homeIndex);
                if (null == ssEntry) {
                    return;
                }
                if (null == ssEntry.getSupersededByOneOffsList() || (ie = (OiiiInstallMiniPatchsetInvEntry)this.isMiniPatchsetInvEntryPresent(ssEntry.getSupersededByOneOffsList(), MiniPatchsetInvEntry)) == null) continue;
                ssEntry.getSupersededByOneOffsList().remove(ie);
            }
        }
        if (homeIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(homeIndex);
            oohi.setDirty(true);
        }
    }

    public void removeOneoffInvEntry(OiiiInstallOneoffInvEntry oneoffInvEntry) throws OiiiOneoffException {
        OiiiOracleHomeInfo oInfo;
        int homeIndex = oneoffInvEntry.getHomeIndex();
        if (homeIndex != 0 && (oInfo = this.getHomeInfo(homeIndex)) == null) {
            Object[] args = new Object[]{oneoffInvEntry.getID().getID()};
            throw new OiiiOneoffException("S_ONEOFF_ENTRY_WITH_INVALID_HOME", args);
        }
        OiiiInvHomeInfo oihi = this.getCompOHListInfo(homeIndex);
        Vector vOneoffs = oihi.getOneoffsVect();
        if (vOneoffs == null || vOneoffs.size() == 0) {
            Object[] args = new Object[]{oneoffInvEntry.getID().getID()};
            throw new OiiiOneoffException("S_ONEOFF_ENTRY_NOT_PRESENT_IN_HOME", args);
        }
        if (!vOneoffs.contains(oneoffInvEntry)) {
            Object[] args = new Object[]{oneoffInvEntry.getID().getID()};
            throw new OiiiOneoffException("S_ONEOFF_ENTRY_NOT_PRESENT_IN_HOME", args);
        }
        vOneoffs.remove(oneoffInvEntry);
        Vector vSupersedeList = oneoffInvEntry.getSupersededOneOffsList();
        if (vSupersedeList != null && vSupersedeList.size() > 0) {
            for (int i = 0; i < vSupersedeList.size(); ++i) {
                OiiiInstallOneoffInvEntry ie;
                String ssuniqid;
                Vector sslangs;
                OiiiInstallOneoffInvEntry ssOneOff = (OiiiInstallOneoffInvEntry)vSupersedeList.elementAt(i);
                String ssid = ssOneOff.getID().toString();
                OiiiInstallOneoffInvEntry ssEntry = this.getOneoffInvEntry(ssid, sslangs = ssOneOff.getLangs(), ssuniqid = ssOneOff.getUniqID(), homeIndex);
                if (null == ssEntry) {
                    return;
                }
                if (null == ssEntry.getSupersededByOneOffsList() || (ie = this.isOneOffInvEntryPresent(ssEntry.getSupersededByOneOffsList(), oneoffInvEntry)) == null) continue;
                ssEntry.getSupersededByOneOffsList().remove(ie);
            }
        }
        if (homeIndex != 0) {
            OiiiOracleHomeInfo oohi = this.getHomeInfo(homeIndex);
            oohi.setDirty(true);
        }
    }

    public OiiiInstallOneoffInvEntry isOneOffInvEntryPresent(Vector oneoffs, OiiiInstallOneoffInvEntry ie) {
        if (oneoffs != null) {
            for (int i = 0; i < oneoffs.size(); ++i) {
                OiiiInstallOneoffInvEntry oneOffInvEntry = (OiiiInstallOneoffInvEntry)oneoffs.elementAt(i);
                if (!oneOffInvEntry.primaryKeyMatches(ie)) continue;
                return oneOffInvEntry;
            }
        }
        return null;
    }

    public OiiiMiniPatchsetInvEntry isMiniPatchsetInvEntryPresent(Vector minips, OiiiMiniPatchsetInvEntry ie) {
        if (minips != null) {
            for (int i = 0; i < minips.size(); ++i) {
                OiiiMiniPatchsetInvEntry minipsInvEntry = (OiiiMiniPatchsetInvEntry)minips.elementAt(i);
                if (!minipsInvEntry.primaryKeyMatches(ie)) continue;
                return minipsInvEntry;
            }
        }
        return null;
    }

    public Vector getAllMiniPatchsetInvEntries(String homeName) {
        int homeIndex = 0;
        try {
            homeIndex = this.getOneoffHomeIndex(homeName);
        }
        catch (Exception e) {
            return null;
        }
        return this.getAllMiniPatchsetInvEntries(homeIndex);
    }

    public Vector getAllOneoffInvEntries(String homeName) {
        int homeIndex = 0;
        try {
            homeIndex = this.getOneoffHomeIndex(homeName);
        }
        catch (Exception e) {
            return null;
        }
        return this.getAllOneoffInvEntries(homeIndex);
    }

    public Vector getAllMiniPatchsetInvEntries(OiiiOracleHomeInfo oohi) {
        if (oohi == null) {
            return null;
        }
        return this.getAllMiniPatchsetInvEntries(oohi.getIndex());
    }

    public Vector getAllOneoffInvEntries(OiiiOracleHomeInfo oohi) {
        if (oohi == null) {
            return null;
        }
        return this.getAllOneoffInvEntries(oohi.getIndex());
    }

    public Vector getAllMiniPatchsetInvEntries(int homeIndex) {
        return this.getAllMiniPatchsetInvEntries(homeIndex, true);
    }

    public Vector getAllMiniPatchsetInvEntries(int homeIndex, boolean bIgnoreSuperseded) {
        OiiiInvHomeInfo oihi;
        block6: {
            oihi = null;
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    return null;
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block6;
                return null;
            }
        }
        Vector vMiniPatchsets = oihi.getMiniPatchsetsVect();
        if (bIgnoreSuperseded) {
            Vector vMiniPatchsetsSS = (Vector)vMiniPatchsets.clone();
            int i = 0;
            while (i < vMiniPatchsetsSS.size()) {
                OiiiInstallMiniPatchsetInvEntry oOneoffEntry = (OiiiInstallMiniPatchsetInvEntry)vMiniPatchsetsSS.elementAt(i);
                Vector vSupersededList = oOneoffEntry.getSupersededByOneOffsList();
                if (vSupersededList != null && vSupersededList.size() > 0) {
                    vMiniPatchsetsSS.remove(i);
                    continue;
                }
                ++i;
            }
            return vMiniPatchsetsSS;
        }
        return vMiniPatchsets;
    }

    public Vector getAllOneoffInvEntries(int homeIndex) {
        return this.getAllOneoffInvEntries(homeIndex, true);
    }

    public Vector getAllOneoffInvEntries(int homeIndex, boolean bIgnoreSuperseded) {
        OiiiInvHomeInfo oihi;
        block6: {
            oihi = null;
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    return null;
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block6;
                return null;
            }
        }
        Vector vOneoffs = oihi.getOneoffsVect();
        if (bIgnoreSuperseded) {
            Vector vOneoffsSS = (Vector)vOneoffs.clone();
            int i = 0;
            while (i < vOneoffsSS.size()) {
                OiiiInstallOneoffInvEntry oOneoffEntry = (OiiiInstallOneoffInvEntry)vOneoffsSS.elementAt(i);
                Vector vSupersededList = oOneoffEntry.getSupersededByOneOffsList();
                if (vSupersededList != null && vSupersededList.size() > 0) {
                    vOneoffsSS.remove(i);
                    continue;
                }
                ++i;
            }
            return vOneoffsSS;
        }
        return vOneoffs;
    }

    public boolean isComponentInPatchSetUpdate(String compName, int oracleHomeIndex) {
        Vector rawInstalledProducts = this.getAllCompsVect(oracleHomeIndex);
        for (int i = 0; i < rawInstalledProducts.size(); ++i) {
            OiiiInstallCompInvEntry instCompInvEntry = (OiiiInstallCompInvEntry)rawInstalledProducts.get(i);
            if (!instCompInvEntry.getCompInstallID().getName().equals(compName) || instCompInvEntry.getPatchInvEntry() != null || instCompInvEntry.getMiniPatchsetsList().size() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean filesHaveConflicts(String homeName, Vector filesToPatch, Vector oneoffConflicts) {
        boolean bRet = false;
        int homeIndex = -1;
        try {
            homeIndex = this.getOneoffHomeIndex(homeName);
        }
        catch (Exception e) {
            return bRet;
        }
        String sHomePath = null;
        sHomePath = homeIndex == 0 ? this.getInstallAreaControl().getInventoryLocForHome(0) : this.getHomeLocation(homeIndex);
        int iSize = filesToPatch != null ? filesToPatch.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            int nSize;
            OiiiFileMapFileEntry oFileEntry = (OiiiFileMapFileEntry)filesToPatch.elementAt(i);
            String sOwnerFile = oFileEntry.getOwnerFileName();
            String sFile = oFileEntry.getFileName();
            OiiiFileMapEntry oOwnerEntry = null;
            OiiiFileMapFileEntry oEntry = null;
            if (sOwnerFile != null) {
                oOwnerEntry = this.getInstallAreaControl().getFileMapFileEntry(sHomePath, sOwnerFile);
            }
            if (oOwnerEntry != null) {
                oEntry = oOwnerEntry.getFileEntry(sFile);
                if (oEntry == null && OiiiFileMapEntry.pathStartsFromRoot(sFile)) {
                    oEntry = this.getInstallAreaControl().getFileMapFileEntry(sHomePath, sFile);
                }
            } else {
                oEntry = this.getInstallAreaControl().getFileMapFileEntry(sHomePath, sFile);
            }
            if (oEntry == null) continue;
            Vector vOneoffRefs = oEntry.getReferencerOneoffs();
            int n = nSize = vOneoffRefs != null ? vOneoffRefs.size() : 0;
            if (nSize <= 0) continue;
            bRet = true;
            for (int k = 0; k < nSize; ++k) {
                OiiiOneoffInstallID oneoffID = (OiiiOneoffInstallID)vOneoffRefs.elementAt(k);
                if (oneoffConflicts.contains(oneoffID)) continue;
                oneoffConflicts.addElement(oneoffID);
            }
        }
        return bRet;
    }

    public boolean anyBugsPatched(String homeName, Vector bugFixes, Vector oneoffConflicts) {
        boolean bRet = false;
        Vector vOneoffs = this.getAllOneoffInvEntries(homeName);
        int iSize = vOneoffs != null ? vOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            if (!oEntry.anyBugsPatched(bugFixes)) continue;
            bRet = true;
            if (oneoffConflicts.contains(oEntry.getID())) continue;
            oneoffConflicts.addElement(oEntry.getID());
        }
        return bRet;
    }

    public boolean isBugsSuperset(String homeName, Vector bugFixes, Vector oneoffSupersets) {
        boolean bRet = true;
        Vector vOneoffs = this.getAllOneoffInvEntries(homeName);
        int iSize = vOneoffs != null ? vOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            if (oEntry.isBugsSuperset(bugFixes)) continue;
            bRet = false;
            if (oneoffSupersets.contains(oEntry.getID())) continue;
            oneoffSupersets.addElement(oEntry.getID());
        }
        return bRet;
    }

    public boolean bugsHaveConflicts(String homeName, Vector bugFixes, Vector oneoffConflicts) {
        boolean bRet = false;
        Vector vOneoffs = this.getAllOneoffInvEntries(homeName);
        int iSize = vOneoffs != null ? vOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            if (!oEntry.bugsHaveConflicts(bugFixes)) continue;
            bRet = true;
            if (oneoffConflicts.contains(oEntry.getID())) continue;
            oneoffConflicts.addElement(oEntry.getID());
        }
        return bRet;
    }

    public OiiiInstallMiniPatchsetInvEntry getMiniPatchsetInvEntry(String id, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.getMiniPatchsetInvEntry(id, homeIndex);
    }

    public OiiiInstallMiniPatchsetInvEntry getMiniPatchsetInvEntry(String id, Vector langs, String uniqID, int homeIndex) throws OiiiOneoffException {
        Vector vMiniPatchsets;
        int iSize;
        OiiiInstallMiniPatchsetInvEntry retEntry;
        OiiiInvHomeInfo oihi;
        block6: {
            oihi = null;
            retEntry = null;
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MINIPATCHSET_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block6;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MINIPATCHSET_COMPS_NOT_LOADED"));
            }
        }
        int n = iSize = (vMiniPatchsets = oihi.getMiniPatchsetsVect()) != null ? vMiniPatchsets.size() : 0;
        if (uniqID == null) {
            uniqID = "";
        }
        String refMiniPSKey = OiixLanguage.vectToStr(langs) + ":" + uniqID;
        for (int i = 0; i < iSize; ++i) {
            String MiniPSKey;
            OiiiInstallMiniPatchsetInvEntry oEntry = (OiiiInstallMiniPatchsetInvEntry)vMiniPatchsets.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID())) continue;
            String uniqueID = oEntry.getUniqID();
            if (uniqueID == null) {
                uniqueID = "";
            }
            if (!(MiniPSKey = OiixLanguage.vectToStr(oEntry.getLangs()) + ":" + uniqueID).equals(refMiniPSKey)) continue;
            retEntry = oEntry;
            break;
        }
        return retEntry;
    }

    public OiiiInstallMiniPatchsetInvEntry getMiniPatchsetInvEntry(String id, int homeIndex) throws OiiiOneoffException {
        Vector vMiniPatchsets;
        OiiiInstallMiniPatchsetInvEntry retEntry;
        OiiiInvHomeInfo oihi;
        block5: {
            oihi = null;
            retEntry = null;
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MINIPATCHSET_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block5;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MINIPATCHSET_COMPS_NOT_LOADED"));
            }
        }
        int iSize = (vMiniPatchsets = oihi.getMiniPatchsetsVect()) != null ? vMiniPatchsets.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallMiniPatchsetInvEntry oEntry = (OiiiInstallMiniPatchsetInvEntry)vMiniPatchsets.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID())) continue;
            Vector languages = oEntry.getLangs();
            if (languages.size() == 0) {
                retEntry = oEntry;
                break;
            }
            String lang = OiixLanguage.vectToStr(oEntry.getLangs());
            if (lang.indexOf("en") == -1) continue;
            return retEntry;
        }
        return retEntry;
    }

    public OiiiInstallOneoffInvEntry getOneoffInvEntry(String id, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.getOneoffInvEntry(id, homeIndex);
    }

    public OiiiInstallOneoffInvEntry getOneoffInvEntry(String id, int homeIndex) throws OiiiOneoffException {
        Vector vOneoffs;
        OiiiInstallOneoffInvEntry retEntry;
        OiiiInvHomeInfo oihi;
        block5: {
            oihi = null;
            retEntry = null;
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block5;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
            }
        }
        int iSize = (vOneoffs = oihi.getOneoffsVect()) != null ? vOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID())) continue;
            Vector languages = oEntry.getLangs();
            if (languages.size() == 0) {
                retEntry = oEntry;
                break;
            }
            String lang = OiixLanguage.vectToStr(oEntry.getLangs());
            if (lang.indexOf("en") == -1) continue;
            return retEntry;
        }
        return retEntry;
    }

    public OiiiInstallOneoffInvEntry getOneoffInvEntry(String id, Vector langs, String uniqID, int homeIndex) throws OiiiOneoffException {
        Vector vOneoffs;
        int iSize;
        OiiiInstallOneoffInvEntry retEntry;
        OiiiInvHomeInfo oihi;
        block6: {
            oihi = null;
            retEntry = null;
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block6;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
            }
        }
        int n = iSize = (vOneoffs = oihi.getOneoffsVect()) != null ? vOneoffs.size() : 0;
        if (uniqID == null) {
            uniqID = "";
        }
        String refOneoffKey = OiixLanguage.vectToStr(langs) + ":" + uniqID;
        for (int i = 0; i < iSize; ++i) {
            String oneOffKey;
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID())) continue;
            String uniqueID = oEntry.getUniqID();
            if (uniqueID == null) {
                uniqueID = "";
            }
            if (!(oneOffKey = OiixLanguage.vectToStr(oEntry.getLangs()) + ":" + uniqueID).equals(refOneoffKey)) continue;
            retEntry = oEntry;
            break;
        }
        return retEntry;
    }

    public Vector getTranslationPatches(String id, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.getTranslationPatches(id, homeIndex);
    }

    public Vector getTranslationPatches(String id, int homeIndex) throws OiiiOneoffException {
        Vector vOneoffs;
        HashMap<String, String> oneOffKeys;
        Vector<OiiiInstallOneoffInvEntry> vTranslationPatches;
        OiiiInvHomeInfo oihi;
        block4: {
            oihi = null;
            vTranslationPatches = new Vector<OiiiInstallOneoffInvEntry>();
            oneOffKeys = new HashMap<String, String>();
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block4;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
            }
        }
        int iSize = (vOneoffs = oihi.getOneoffsVect()) != null ? vOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            String oneOffKey;
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID()) || oneOffKeys.get(oneOffKey = id.toString() + ":" + OiixLanguage.vectToStr(oEntry.getLangs())) != null) continue;
            vTranslationPatches.add(oEntry);
            oneOffKeys.put(oneOffKey, id);
        }
        return vTranslationPatches;
    }

    public Vector getRereleasePatches(String id, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.getRereleasePatches(id, homeIndex);
    }

    public Vector getRereleasePatches(String id, int homeIndex) throws OiiiOneoffException {
        Vector vOneoffs;
        HashMap<String, String> oneOffKeys;
        Vector<OiiiInstallOneoffInvEntry> vRereleasePatches;
        OiiiInvHomeInfo oihi;
        block5: {
            oihi = null;
            vRereleasePatches = new Vector<OiiiInstallOneoffInvEntry>();
            oneOffKeys = new HashMap<String, String>();
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block5;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
            }
        }
        int iSize = (vOneoffs = oihi.getOneoffsVect()) != null ? vOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            String oneOffKey;
            OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID())) continue;
            String uniqID = oEntry.getUniqID();
            if (uniqID == null) {
                uniqID = "";
            }
            if (oneOffKeys.get(oneOffKey = id.toString() + ":" + uniqID) != null) continue;
            vRereleasePatches.add(oEntry);
            oneOffKeys.put(oneOffKey, id);
        }
        return vRereleasePatches;
    }

    public Vector getTranslationMiniPatchsets(String id, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.getTranslationMiniPatchsets(id, homeIndex);
    }

    public Vector getTranslationMiniPatchsets(String id, int homeIndex) throws OiiiOneoffException {
        Vector vMiniPatchsets;
        HashMap<String, String> MiniPSKeys;
        Vector<OiiiInstallMiniPatchsetInvEntry> vTranslationPatches;
        OiiiInvHomeInfo oihi;
        block4: {
            oihi = null;
            vTranslationPatches = new Vector<OiiiInstallMiniPatchsetInvEntry>();
            MiniPSKeys = new HashMap<String, String>();
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block4;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
            }
        }
        int iSize = (vMiniPatchsets = oihi.getMiniPatchsetsVect()) != null ? vMiniPatchsets.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            String MiniPSKey;
            OiiiInstallMiniPatchsetInvEntry oEntry = (OiiiInstallMiniPatchsetInvEntry)vMiniPatchsets.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID()) || MiniPSKeys.get(MiniPSKey = id.toString() + ":" + OiixLanguage.vectToStr(oEntry.getLangs())) != null) continue;
            vTranslationPatches.add(oEntry);
            MiniPSKeys.put(MiniPSKey, id);
        }
        return vTranslationPatches;
    }

    public Vector getRereleaseMiniPatchsets(String id, String homeName) throws OiiiOneoffException {
        int homeIndex = this.getOneoffHomeIndex(homeName);
        return this.getRereleaseMiniPatchsets(id, homeIndex);
    }

    public Vector getRereleaseMiniPatchsets(String id, int homeIndex) throws OiiiOneoffException {
        Vector vMiniPatchsets;
        HashMap<String, String> MiniPSKeys;
        Vector<OiiiInstallMiniPatchsetInvEntry> vRereleasePatches;
        OiiiInvHomeInfo oihi;
        block5: {
            oihi = null;
            vRereleasePatches = new Vector<OiiiInstallMiniPatchsetInvEntry>();
            MiniPSKeys = new HashMap<String, String>();
            try {
                oihi = this.getCompOHListInfo(homeIndex);
                if (oihi == null) {
                    throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
                }
            }
            catch (Exception e) {
                String sMsg = e.getMessage();
                if (oihi != null) break block5;
                throw new OiiiOneoffException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_COMPS_NOT_LOADED"));
            }
        }
        int iSize = (vMiniPatchsets = oihi.getMiniPatchsetsVect()) != null ? vMiniPatchsets.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            String MiniPSKey;
            OiiiInstallMiniPatchsetInvEntry oEntry = (OiiiInstallMiniPatchsetInvEntry)vMiniPatchsets.elementAt(i);
            OiiiOneoffInstallID oID = oEntry.getID();
            if (!id.equals(oID.getID())) continue;
            String uniqID = oEntry.getUniqID();
            if (uniqID == null) {
                uniqID = "";
            }
            if (MiniPSKeys.get(MiniPSKey = id.toString() + ":" + uniqID) != null) continue;
            vRereleasePatches.add(oEntry);
            MiniPSKeys.put(MiniPSKey, id);
        }
        return vRereleasePatches;
    }

    void writeMiniPatchsets(int homeIndex, PrintWriter pWriter, boolean bHeader) throws IOException {
        if (bHeader) {
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
        }
        Vector vMiniPatchsets = this.getCompOHListInfo(homeIndex).getMiniPatchsetsVect();
        Hashtable hTags = this.getCompOHUnknownElementsTable(homeIndex);
        XMLElement elMiniPatchsetList = (XMLElement)hTags.get("PATCHSET_UPDATE_LIST");
        if (elMiniPatchsetList == null) {
            elMiniPatchsetList = new XMLElement("PATCHSET_UPDATE_LIST");
        }
        String sCurrentTag = OixsXMLOps.getStartTag(elMiniPatchsetList);
        pWriter.println(sCurrentTag);
        NodeList nl = elMiniPatchsetList.getChildNodes();
        int len = nl != null ? nl.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XMLElement el = (XMLElement)nl.item(i);
            el.print(pWriter);
        }
        int nCount = vMiniPatchsets != null ? vMiniPatchsets.size() : 0;
        for (int i = 0; i < nCount; ++i) {
            OiiiMiniPatchsetInvEntry invEntry = (OiiiMiniPatchsetInvEntry)vMiniPatchsets.elementAt(i);
            OixsXMLizable comp = (OixsXMLizable)vMiniPatchsets.elementAt(i);
            comp.writeXML(pWriter);
        }
        pWriter.println("</PATCHSET_UPDATE_LIST>");
    }

    void writeOneoffs(int homeIndex, PrintWriter pWriter, boolean bHeader) throws IOException {
        if (bHeader) {
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
        }
        Vector vOneoffs = this.getCompOHListInfo(homeIndex).getOneoffsVect();
        Hashtable hTags = this.getCompOHUnknownElementsTable(homeIndex);
        XMLElement elOneoffList = (XMLElement)hTags.get("ONEOFF_LIST");
        if (elOneoffList == null) {
            elOneoffList = new XMLElement("ONEOFF_LIST");
        }
        String sCurrentTag = OixsXMLOps.getStartTag(elOneoffList);
        pWriter.println(sCurrentTag);
        NodeList nl = elOneoffList.getChildNodes();
        int len = nl != null ? nl.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XMLElement el = (XMLElement)nl.item(i);
            el.print(pWriter);
        }
        this.removeDuplicateOneOffs(vOneoffs);
        this.removeDuplicateBugListFromOneOffs(vOneoffs);
        int nCount = vOneoffs != null ? vOneoffs.size() : 0;
        for (int i = 0; i < nCount; ++i) {
            OiiiOneoffInvEntry invEntry = (OiiiOneoffInvEntry)vOneoffs.elementAt(i);
            OixsXMLizable comp = (OixsXMLizable)vOneoffs.elementAt(i);
            comp.writeXML(pWriter);
        }
        pWriter.println("</ONEOFF_LIST>");
    }

    private int getOneoffHomeIndex(String homeName) throws OiiiOneoffException {
        int homeIndex = -1;
        if (homeName.equalsIgnoreCase(INDEPENDENT_PRODUCTS)) {
            homeIndex = 0;
        } else {
            OiiiOracleHomeInfo oohi = this.getHomeWithName(homeName);
            if (oohi != null) {
                homeIndex = oohi.getIndex();
            }
        }
        if (homeIndex == -1) {
            Object[] args = new Object[]{homeName};
            throw new OiiiOneoffException("S_ONEOFF_INVALID_HOME", args);
        }
        return homeIndex;
    }

    private void synchClock() {
        long tick = 2000L;
        long lCurrentTime = System.currentTimeMillis();
        long lRemainder = lCurrentTime % tick;
        try {
            Thread.currentThread();
            Thread.sleep(tick - lRemainder + 100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private String generateRemovedHomeName(String sCurName) {
        Vector vOUIHomes = this.getAllOUIHomes();
        String sRemovedName = "REMOVED_" + sCurName;
        boolean bFound = false;
        int runningCount = 0;
        while (!bFound) {
            String sRunningCount = "_" + runningCount;
            int nRunningCountLen = sRunningCount.length();
            String sName = sRemovedName;
            if (sName.length() + nRunningCountLen > 128) {
                sName = sName.substring(0, 128 - nRunningCountLen);
            }
            if (this.getHomeWithName(sName = sName + sRunningCount, vOUIHomes) == null) {
                sRemovedName = sName;
                bFound = true;
                continue;
            }
            ++runningCount;
        }
        return sRemovedName;
    }

    public boolean checkHomeClonable(String sHomeLoc) {
        OiiiOracleHomeInfo homeInfo = this.getHomeWithLocation(sHomeLoc);
        OiiiInvHomeInfo invHomeInfo = this.getCompOHListInfo(homeInfo.getIndex());
        return invHomeInfo.checkHomeClonable();
    }

    private void saveCloneInfo(int homeIndex) throws IOException {
        boolean isClone = Boolean.getBoolean("oracle.installer.clone");
        if (isClone) {
            this.updateSessionCloneVars(homeIndex);
        }
        this.updateCloneVars(homeIndex);
        this.writeCloneInfo(homeIndex);
    }

    private void updateSessionCloneVars(int homeIndex) {
        OiiiCloneInfo cloneInfo = this.getCloneInfo(homeIndex);
        Iterator iterVars = cloneInfo.getSessionVars().getSessionCloneVars().iterator();
        boolean i = false;
        while (iterVars.hasNext()) {
            OiisVariable oVar = (OiisVariable)iterVars.next();
            boolean bFoundInCurrentVars = false;
            Iterator currVars = this.m_oCurSessionCloneVars.iterator();
            while (currVars.hasNext()) {
                OiisVariable oCurrVar = (OiisVariable)currVars.next();
                if (oCurrVar == null || oVar == null || !oCurrVar.getName().equalsIgnoreCase(oVar.getName())) continue;
                bFoundInCurrentVars = true;
                break;
            }
            if (bFoundInCurrentVars) continue;
            this.m_oCurSessionCloneVars.addVariable(oVar);
        }
    }

    private void updateCloneVars(int homeIndex) {
        List cloneVars = this.getCompCloneVars(homeIndex);
        Iterator iterComps = this.getAllCompsVect(homeIndex).iterator();
        while (iterComps.hasNext()) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)iterComps.next();
            OiiiCompCloneVars compCloneVars = invEntry.getCompCloneVars();
            if (compCloneVars == null) continue;
            cloneVars.remove(compCloneVars);
            cloneVars.add(compCloneVars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCloneInfo(int homeIndex) throws IOException {
        OutputStreamWriter osw;
        FileOutputStream fos;
        block13: {
            OiiiInstallAreaControl iac = this.getInstallAreaControl();
            String sCloneFileLoc = iac.getCloneFileLoc(homeIndex);
            OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sCloneFileLoc)));
            fos = null;
            osw = null;
            BufferedWriter bw = null;
            PrintWriter pw = null;
            try {
                fos = new FileOutputStream(sCloneFileLoc);
                osw = new OutputStreamWriter((OutputStream)fos, CS_UTF8);
                bw = new BufferedWriter(osw);
                pw = new PrintWriter(bw);
                pw.println(OixsXMLOps.createXMLDirective(true));
                pw.println(OixsXMLOps.getStandardHeader());
                XMLElement elemCloneInfo = new XMLElement("CLONE_INFO");
                pw.println(OixsXMLOps.getStartTag(elemCloneInfo));
                List cloneVars = this.getCompCloneVars(homeIndex);
                if (this.m_oCurSessionCloneVars != null && !this.m_oCurSessionCloneVars.isEmpty()) {
                    OiiiSessionCloneVars xmlizable = this.m_oCurSessionCloneVars;
                    xmlizable.writeXML(pw);
                } else {
                    XMLElement elemSessionVarInfo = new XMLElement("SESSION_VARS_INFO");
                    elemSessionVarInfo.print(pw);
                }
                XMLElement elemCompVarInfo = new XMLElement("COMP_VAR_INFO");
                pw.println(OixsXMLOps.getStartTag(elemCompVarInfo));
                Iterator iter = cloneVars.iterator();
                while (iter.hasNext()) {
                    OixsXMLizable xmlizable = (OixsXMLizable)iter.next();
                    xmlizable.writeXML(pw);
                }
                pw.println(OixsXMLOps.getEndTag(elemCompVarInfo));
                XMLElement elemExtDepInfo = new XMLElement("EXT_DEP_INFO");
                List alExtDeps = this.getExternalDependees(homeIndex);
                Iterator iter2 = alExtDeps.iterator();
                while (iter2.hasNext()) {
                    OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)iter2.next();
                    XMLElement elemDep = new XMLElement("DEP");
                    elemDep.setAttribute("NAME", depIdOh.getCompID().getName());
                    elemDep.setAttribute("VER", depIdOh.getCompID().getVersion().getVerString());
                    elemDep.setAttribute("HOME_IDX", new Integer(depIdOh.getOHIndex()).toString());
                    elemExtDepInfo.appendChild((Node)elemDep);
                }
                elemExtDepInfo.print(pw);
                pw.println(OixsXMLOps.getEndTag(elemCloneInfo));
                Object var17_16 = null;
                if (pw != null) {
                    pw.close();
                }
                if (bw == null) break block13;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (pw != null) {
                    pw.close();
                }
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
            bw.close();
        }
        if (osw != null) {
            osw.close();
        }
        if (fos != null) {
            fos.close();
        }
    }

    public OiiiSessionCloneVars getCurSessionCloneVars() {
        if (this.m_oCurSessionCloneVars == null) {
            this.m_oCurSessionCloneVars = new OiiiSessionCloneVars();
        }
        return this.m_oCurSessionCloneVars;
    }

    private void saveConfigInfo(int homeIndex) throws IOException {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        String sFileLoc = iac.getXMLConfigFileLoc(homeIndex);
        OiiiConfigXMLWriter writer = OiiiConfigXMLWriter.getWriter();
        writer.writeXML(this.getAllCompsVect(homeIndex), sFileLoc);
    }

    public String getFullHostName(int nHomeIndex) {
        OiiiSessionCloneVars sessionCloneVars = this.getSessionCloneVars(nHomeIndex);
        if (sessionCloneVars == null) {
            return null;
        }
        String sHostName = (String)sessionCloneVars.getVariableValue("ORACLE_HOSTNAME");
        return sHostName;
    }

    private boolean doNodeListsMatch(Vector vNodes, String[] nodeList) {
        int iNodesVSize;
        boolean bMatch = false;
        int n = iNodesVSize = vNodes != null ? vNodes.size() : 0;
        if (iNodesVSize > 0 && nodeList.length > 0 && iNodesVSize >= nodeList.length) {
            Vector vNodeList = OiixVectorOps.strArr2Vect(nodeList);
            bMatch = OiixVectorOps.vectorSubset(vNodeList, vNodes);
        }
        return bMatch;
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage : OiiiInstallInventory <inv file>");
            } else {
                String fileLoc = args[0];
                FileInputStream fis = new FileInputStream(fileLoc);
                ObjectInputStream ois = new ObjectInputStream(fis);
                OiiiInstallInventory instInv = (OiiiInstallInventory)ois.readObject();
                System.out.println(instInv.toString());
                ois.close();
                fis.close();
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " occurred");
            e.printStackTrace();
        }
    }

    public void saveExtFiles(int homeIndex) {
        if (OiixOraparam.ifExtPathSet()) {
            String sJarTempLoc = System.getProperty("oracle.installer.scratchPath");
            sJarTempLoc = OiixPathOps.concatPath(sJarTempLoc, EXT);
            sJarTempLoc = OiixPathOps.getNativeForm(sJarTempLoc);
            OiiiInstallAreaControl iac = this.getInstallAreaControl();
            File jarDir = new File(sJarTempLoc);
            if (jarDir.exists()) {
                String sJarHomeLoc = OiixPathOps.concatPath(iac.getScriptsLoc(homeIndex), EXT);
                File extDir = new File(sJarTempLoc);
                File[] childDir = extDir.listFiles();
                for (int i = 0; i < childDir.length; ++i) {
                    File[] childDirFiles = childDir[i].listFiles();
                    if (!childDir[i].exists() || childDirFiles.length <= 0) continue;
                    try {
                        OiixFileOps.createDirForDest(childDir[i].getAbsolutePath());
                        OiixFileOps.copyDir(new File(childDir[i].getAbsolutePath()), new File(OiixPathOps.concatPath(sJarHomeLoc, childDir[i].getName())));
                        continue;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    public void setOHProperties(OiiiOracleHomeInfo homeInfo) {
        int nOhIndex = homeInfo.getIndex();
        Properties homeProperties = new Properties();
        String dir = ((OiiiInstallAreaControl)this.getAreaControl()).getScriptsLoc(nOhIndex);
        if (dir != null) {
            Vector files = OiixFileOps.searchFiles(dir, ".properties");
            int nPropFiles = files.size();
            Vector compIdsVect = this.getTopLevelComps(nOhIndex);
            int nTLComps = compIdsVect.size();
            String filename = null;
            for (int k = 0; k < nPropFiles; ++k) {
                filename = (String)files.elementAt(k);
                for (int l = 0; l < nTLComps; ++l) {
                    OiiiCompInstallID ci = (OiiiCompInstallID)compIdsVect.elementAt(l);
                    String sTLName = ci.getName();
                    if (filename.indexOf(sTLName) != 0) continue;
                    filename = OiixPathOps.getNativeForm(OiixPathOps.concatPath(OiixPathOps.getStandardForm(dir), filename));
                    Properties tmpProps = new Properties();
                    try {
                        FileInputStream fs = new FileInputStream(filename);
                        tmpProps.load(fs);
                        fs.close();
                    }
                    catch (IOException error) {
                        OiiolTextLogger.appendText(error.toString(), OiiolTextLogger.LOG_DETAILED);
                    }
                    Enumeration<?> propNames = tmpProps.propertyNames();
                    while (propNames.hasMoreElements()) {
                        String propName = (String)propNames.nextElement();
                        homeProperties.put(propName, tmpProps.get(propName));
                    }
                }
            }
            homeInfo.setHomeProperties(homeProperties);
        }
    }

    public boolean allowCompsDeinstall(OiiiOracleHomeInfo homeInfo, boolean bCanSetOHProp) {
        String val;
        Properties homeProps;
        boolean compsDeinstall = Boolean.getBoolean("oracle.installer.compsdeinstall");
        if (bCanSetOHProp && (homeProps = homeInfo.getHomeProperties()) != null && (val = homeProps.getProperty("oracle.installer.compsdeinstall")) != null) {
            compsDeinstall = val.equalsIgnoreCase("true");
        }
        return compsDeinstall;
    }

    public OiiiCompIdOhPair getCompatCompInvEntryInAnyHome(OiiiCompInstallID cid, int nPlatform) {
        Vector vCompOHsList = this.getCompOHsList();
        int nSize = vCompOHsList.size();
        OiiiCompIdOhPair oOhId = null;
        for (int ohIndex = 0; ohIndex < nSize; ++ohIndex) {
            String sLocation = this.getHomeLocation(ohIndex);
            if (sLocation == null) continue;
            Vector vComps = this.getReplaceCompEntries(cid, ohIndex, nPlatform);
            if (vComps.size() > 0) {
                OiiiCompInvEntry inv = (OiiiCompInvEntry)vComps.elementAt(0);
                oOhId = new OiiiCompIdOhPair(inv.getCompInstallID(), ohIndex);
                break;
            }
            vComps = this.getCompatCompEntries2(cid, ohIndex);
            if (vComps.size() <= 0) continue;
            OiiiCompInvEntry inv = (OiiiCompInvEntry)vComps.elementAt(0);
            oOhId = new OiiiCompIdOhPair(inv.getCompInstallID(), ohIndex);
            break;
        }
        return oOhId;
    }

    public OiiiCompInvEntry getInstalledInvEntry(String name, OiiiVersion startVer, OiiiVersion endVer, boolean bCompatible, int idx) {
        Vector compEntries;
        OiiiCompInvEntry oCompInvEntry = null;
        Object oVersion = null;
        if (idx != -1 && (compEntries = this.getCompInvEntries(name, idx)).size() > 0) {
            int nSize = compEntries.size();
            boolean nComps = false;
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInvEntry cie = (OiiiCompInvEntry)compEntries.get(i);
                OiiiCompInstallID id = cie.getCompInstallID();
                if (id.getCompType() != 1 && id.getCompType() != 2) continue;
                OiiiVersion cieVersion = cie.getVersion();
                OiiiVersion cieReplVer = cie.getCompInstallID().getReplaceVersion();
                if (startVer != null && !cieVersion.equals(startVer) && !cieVersion.laterThan(startVer) || endVer != null && (!bCompatible || !endVer.equals(cieReplVer) && !endVer.laterThan(cieReplVer)) && (bCompatible || !endVer.equals(cieVersion) && !endVer.laterThan(cieVersion)) || oCompInvEntry != null && !cieVersion.equals(oCompInvEntry.getVersion()) && !cieVersion.laterThan(oCompInvEntry.getVersion())) continue;
                oCompInvEntry = cie;
            }
        }
        return oCompInvEntry;
    }

    public OiiiCompInvEntry getInstalledInvEntry(String name, OiiiVersion startVer, OiiiVersion endVer, boolean bCompatible, String sOhLoc) {
        OiiiOracleHomeInfo ohi = this.getHomeWithLocation(sOhLoc);
        return ohi == null ? null : this.getInstalledInvEntry(name, startVer, endVer, bCompatible, ohi.getIndex());
    }

    private void backupCentralInventory() {
        try {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            String sInventoryFileLoc = iac.getInventoryFileLoc();
            String sContentsXMLDir = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sInventoryFileLoc));
            File source = new File(sContentsXMLDir);
            String sInventoryDir = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sContentsXMLDir));
            String backupDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sInventoryDir, "backup"));
            String backupTimestampDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupDir, OiixUtilityOps.getSessionTimeStamp()));
            String backupTimestampContentsXMLDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupTimestampDir, "ContentsXML"));
            File destination = new File(backupTimestampContentsXMLDir);
            if (source.exists()) {
                OiiolTextLogger.appendText("Saving a backup of central inventory.", OiiolTextLogger.LOG_BASIC);
                OiixFileOps.copyDir(source, destination);
                if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                    if (OiixPlatform.getCurrentPlatform() == 197 || OiixPlatform.getCurrentPlatform() == 2) {
                        s_execCmd = s_execCmdHPUX;
                    }
                    String execCmd = s_execCmd + backupDir;
                    File invFile = new File(backupDir);
                    if (invFile.exists()) {
                        try {
                            OiixSpawner oSpawn = new OiixSpawner();
                            oSpawn.beginExecute(execCmd);
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendText("Error while taking backup of central inventory: " + e.getMessage());
        }
    }

    private void backupHomeInventory(OiiiOracleHomeInfo ohInfo) {
        try {
            OiiolTextLogger.appendText("Saving a backup of inventory for home:" + ohInfo.getLocation(), OiiolTextLogger.LOG_BASIC);
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            String ohInvContentsXMLDir = iac.getContentsDir(ohInfo.getIndex());
            File source = new File(ohInvContentsXMLDir);
            String ohInvLoc = iac.getInventoryLocForHome(ohInfo.getIndex());
            String backupDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(ohInvLoc, "backup"));
            String backupTimestampDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupDir, OiixUtilityOps.getSessionTimeStamp()));
            String backupTimestampContentsXMLDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupTimestampDir, "ContentsXML"));
            File destination = new File(backupTimestampContentsXMLDir);
            if (source.exists()) {
                OiixFileOps.copyDir(source, destination);
                if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                    if (OiixPlatform.getCurrentPlatform() == 197 || OiixPlatform.getCurrentPlatform() == 2) {
                        s_execCmd = s_execCmdHPUX;
                    }
                    String execCmd = s_execCmd + backupDir;
                    File invFile = new File(backupDir);
                    if (invFile.exists()) {
                        try {
                            OiixSpawner oSpawn = new OiixSpawner();
                            oSpawn.beginExecute(execCmd);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            String scriptsLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(ohInvLoc, "Scripts"));
            source = new File(scriptsLoc);
            String backupTimestampScriptsDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupTimestampDir, "Scripts"));
            destination = new File(backupTimestampScriptsDir);
            if (source.exists()) {
                OiixFileOps.copyDir(source, destination);
            }
            String cloneLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(ohInvLoc, "Clone"));
            source = new File(cloneLoc);
            String backupTimestampCloneDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupTimestampDir, "Clone"));
            destination = new File(backupTimestampCloneDir);
            if (source.exists()) {
                OiixFileOps.copyDir(source, destination);
            }
            String invDetailsLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(ohInvLoc, "invDetails.properties"));
            String backupTimestampinvDetailsLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(backupTimestampDir, "invDetails.properties"));
            if (new File(invDetailsLoc).exists()) {
                OiixFileOps.copyFile(invDetailsLoc, backupTimestampinvDetailsLoc, true);
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendText("Error while taking backup of home inventory: " + ohInfo.getLocation() + ": " + e.getMessage());
        }
    }

    public Vector getAllCompsVect(int homeIndex, boolean bAddon) {
        return null;
    }

    public Vector getAllCompsVect(String homeLocation, boolean bAddon) {
        return null;
    }

    public Vector getAllCompsVect(OiiiOracleHomeInfo oohi, boolean bAddon) {
        return null;
    }

    public List getHomesInCompositeHome(String compositehome, boolean bAddOn) {
        return null;
    }
}

