/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolInstallLog;
import oracle.sysman.oii.oiio.oiiol.OiiolLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLInstallLog;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiiiInstallLogManipulator {
    private static final int[] PHASES = new int[]{1, 2, 8};
    OiiiCompIdOhPair m_IdOh = null;
    OiiiInstallCompInvEntry m_icie = null;
    private boolean m_bInstall = true;

    public OiiiInstallLogManipulator(OiiiInstallCompInvEntry icie, OiiiCompIdOhPair IdOh, boolean bInstall) {
        this.m_IdOh = IdOh;
        this.m_icie = icie;
        this.m_bInstall = bInstall;
    }

    public static int[] getPhases(boolean bInstall) {
        int[] iaPhases = bInstall ? new int[]{1, 2, 8} : new int[]{8, 2, 1, 16};
        return iaPhases;
    }

    public static OiiiVersion getSinglePhaseVersion() {
        return new OiiiVersion("2.3.0.2.0");
    }

    public Vector getInstallLogManipulators() {
        Vector logManips = null;
        OiiiVersion v21 = new OiiiVersion("2.1.0.0.0");
        OiiiVersion v23 = new OiiiVersion("2.3.0.2.0");
        Object sLogLoc = null;
        boolean bXML = true;
        logManips = v23.laterThan(this.m_icie.getInstallerVersion()) ? this.getPre23InstallLogManipulators() : this.get23InstallLogManipulators();
        return logManips;
    }

    public Vector getInstallLogManipulator(int phase) {
        Vector<OiiolLogManipulator> logManips = new Vector<OiiolLogManipulator>();
        String sLogLoc = null;
        boolean bXML = true;
        OiiiVersion v21 = new OiiiVersion("2.1.0.0.0");
        OiiiVersion v23 = new OiiiVersion("2.3.0.2.0");
        if (v21.laterThan(this.m_icie.getInstallerVersion())) {
            sLogLoc = this.getPre21LogLoc(this.m_icie.getLocation());
            bXML = false;
        } else if (v23.laterThan(this.m_icie.getInstallerVersion())) {
            sLogLoc = this.getPre23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory());
        } else {
            if (phase == 16 && !this.m_bInstall) {
                String[] langAddonLogFiles = null;
                OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
                langAddonLogFiles = iac.getLangAddonXMLLogLocationsForDeinstall(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory());
                if (langAddonLogFiles != null) {
                    logManips.removeAllElements();
                    for (int i = 0; i < langAddonLogFiles.length; ++i) {
                        try {
                            logManips.addElement(this.getInstallLogManipulator(langAddonLogFiles[i], bXML));
                            continue;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                return logManips;
            }
            sLogLoc = this.get23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory(), phase);
        }
        try {
            if (sLogLoc != null) {
                logManips.addElement(this.getInstallLogManipulator(sLogLoc, bXML));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return logManips;
    }

    public Vector getPre23InstallLogManipulators() {
        Vector<OiiolLogManipulator> logManips = null;
        OiiiVersion v21 = new OiiiVersion("2.1.0.0.0");
        String sLogLoc = null;
        boolean bXML = true;
        logManips = new Vector<OiiolLogManipulator>(1);
        if (v21.laterThan(this.m_icie.getInstallerVersion())) {
            sLogLoc = this.getPre21LogLoc(this.m_icie.getLocation());
            bXML = false;
        } else {
            sLogLoc = this.getPre23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory());
            bXML = true;
        }
        try {
            logManips.addElement(this.getInstallLogManipulator(sLogLoc, bXML));
        }
        catch (IOException e) {
            // empty catch block
        }
        return logManips;
    }

    public Vector get23InstallLogManipulators() {
        OiiiInstallAreaControl iac;
        Vector<OiiolLogManipulator> logManips = new Vector<OiiolLogManipulator>(PHASES.length);
        OiiiVersion v21 = new OiiiVersion("2.1.0.0.0");
        String sLogLoc = null;
        boolean bXML = true;
        boolean phaseInd = false;
        int j = 0;
        for (int i = PHASES.length - 1; j < PHASES.length && i >= 0; ++j, --i) {
            if (this.m_bInstall ? (sLogLoc = this.get23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory(), PHASES[j])) == null : (sLogLoc = this.get23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory(), PHASES[i])) == null) continue;
            try {
                logManips.addElement(this.getInstallLogManipulator(sLogLoc, bXML));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String[] langAddonLogFiles = null;
        if (!this.m_bInstall && (langAddonLogFiles = (iac = OiiiInstallAreaControl.getInstallAreaControl()).getLangAddonXMLLogLocationsForDeinstall(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory())) != null) {
            int i;
            Vector normalLogManips = (Vector)logManips.clone();
            logManips.removeAllElements();
            for (i = 0; i < langAddonLogFiles.length; ++i) {
                try {
                    logManips.addElement(this.getInstallLogManipulator(langAddonLogFiles[i], bXML));
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < normalLogManips.size(); ++i) {
                logManips.addElement((OiiolLogManipulator)normalLogManips.elementAt(i));
            }
        }
        return logManips;
    }

    public OiiolLogManipulator getInstallLogManipulator(String logLoc, boolean bXML) throws IOException {
        OiiolLogManipulator logManipulator = null;
        logManipulator = bXML ? new OiiolXMLInstallLog(logLoc) : new OiiolInstallLog(logLoc);
        return logManipulator;
    }

    private String getPre21LogLoc(String location) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLogLoc = iac.getBinaryLogLoc(location);
        return sLogLoc;
    }

    private String getPre23LogLoc(int index, String location) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLogLoc = iac.getXMLLogLoc(index, location);
        return sLogLoc;
    }

    private String get23LogLoc(int index, String location, int phase) {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -3 && phase == PHASES[1]) {
            return null;
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLogLoc = iac.getXMLLogLoc(index, location, phase);
        return sLogLoc;
    }
}

