/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiFileMapEntry;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffFile;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffPatchActions;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiiInstallOneoffInvEntry
extends OiiiOneoffInvEntry
implements OixsXMLizable {
    private Date m_dInstallTime;
    private String m_sXmlInvLocation;
    private Vector m_invFileEntries;
    private Vector m_filesPatched;
    private boolean m_bFilesLoaded;
    private int m_nHomeIndex;
    private XMLElement m_unknownXMLElement;
    private Hashtable m_hXMLElements;
    private OiiiInstallAreaControl m_iac;
    private OiiiVersion m_installerVersion;

    public OiiiInstallOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, int homeIndex, String sDescription) throws OiiiOneoffException {
        this(oneoffId, bugList, bRollback, homeIndex, sDescription, new Vector());
    }

    public OiiiInstallOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, int homeIndex, String sDescription, Vector prereqList) throws OiiiOneoffException {
        this(oneoffId, bugList, bRollback, homeIndex, sDescription, prereqList, new Vector());
    }

    public OiiiInstallOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, int homeIndex, String sDescription, Vector prereqList, Vector langs) throws OiiiOneoffException {
        this(oneoffId, bugList, bRollback, homeIndex, sDescription, prereqList, new Vector(), null);
    }

    public OiiiInstallOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, int homeIndex, String sDescription, Vector prereqList, Vector langs, String uniqID) throws OiiiOneoffException {
        super(oneoffId, bugList, bRollback, sDescription, prereqList, langs, uniqID);
        this.m_nHomeIndex = homeIndex;
        this.m_hXMLElements = new Hashtable(3);
        this.m_iac = OiiiInstallAreaControl.getInstallAreaControl();
        if (this.m_iac != null) {
            this.m_sXmlInvLocation = this.m_iac.getXMLOneoffFullLoc(this.getID(), homeIndex);
        }
        this.m_invFileEntries = new Vector(5);
        this.m_filesPatched = new Vector(5);
    }

    public OiiiInstallOneoffInvEntry(String oneoffId, Vector bugList, Vector filesToPatch, boolean bRollback, int homeIndex, String sDescription) throws OiiiOneoffException {
        this(oneoffId, bugList, filesToPatch, bRollback, homeIndex, sDescription, new Vector());
    }

    public OiiiInstallOneoffInvEntry(String oneoffId, Vector bugList, Vector filesToPatch, boolean bRollback, int homeIndex, String sDescription, Vector prereqList) throws OiiiOneoffException {
        this(oneoffId, bugList, bRollback, homeIndex, sDescription, prereqList);
        this.registerFiles(filesToPatch);
    }

    public void registerFiles(Vector files) throws OiiiOneoffException {
        String sHomePath = this.getHomeLocation();
        int iFiles = files.size();
        for (int i = 0; i < iFiles; ++i) {
            String sFilePath = (String)files.elementAt(i);
            boolean bPatched = false;
            OiiiFileMapFileEntry fEntry = this.m_iac.getFileMapFileEntry(sHomePath, sFilePath);
            Vector vRefOneoffs = null;
            if (fEntry != null) {
                vRefOneoffs = fEntry.getReferencerOneoffs();
            }
            bPatched = this.checkIfPatched(vRefOneoffs, sFilePath);
            OiiiFileMapFileEntry oFileEntry = null;
            oFileEntry = bPatched ? fEntry : this.m_iac.registerFile(sHomePath, sFilePath, this.getID());
            Vector vBaseComps = oFileEntry.getCompatReferencerComponents();
            if (vBaseComps != null) {
                int iBaseComps = vBaseComps.size();
                for (int j = 0; j < iBaseComps; ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)vBaseComps.elementAt(j);
                    this.addBaseComp(new OiiiCompIdOhPair(cid, this.m_nHomeIndex));
                }
            }
            this.m_filesPatched.addElement(oFileEntry);
            this.addInvFileEntry(oFileEntry.getDirPath(), null);
        }
        this.m_bFilesLoaded = true;
    }

    public void registerFiles(String sParentFilePath, Vector files) throws OiiiOneoffException {
        int i;
        String sHomePath = this.getHomeLocation();
        OiiiFileMapFileEntry parentEntry = this.m_iac.getFileMapFileEntry(sHomePath, sParentFilePath);
        Vector vBaseComps = parentEntry.getCompatReferencerComponents();
        if (vBaseComps != null) {
            int iBaseComps = vBaseComps.size();
            for (i = 0; i < iBaseComps; ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)vBaseComps.elementAt(i);
                this.addBaseComp(new OiiiCompIdOhPair(cid, this.m_nHomeIndex));
            }
        }
        int iFiles = files.size();
        for (i = 0; i < iFiles; ++i) {
            String sFilePath = (String)files.elementAt(i);
            OiiiFileMapFileEntry oFileEntry = parentEntry.getFileEntry(sFilePath);
            Vector vChildFileRefOneoffs = null;
            if (oFileEntry != null) {
                vChildFileRefOneoffs = oFileEntry.getReferencerOneoffs();
                boolean bPatched = false;
                bPatched = this.checkIfPatched(vChildFileRefOneoffs, sFilePath);
                if (!bPatched) {
                    oFileEntry.addReferencer(this.getID());
                }
            } else {
                OiiiFileMap ofm = parentEntry.getFileMap();
                oFileEntry = ofm.getFileEntryInDir(sFilePath);
                if (oFileEntry != null) {
                    oFileEntry.setOwner(parentEntry);
                    parentEntry.addFileEntry(oFileEntry);
                    oFileEntry.addReferencer(this.getID());
                } else {
                    oFileEntry = new OiiiFileMapFileEntry(null, sFilePath, this.getID(), ofm);
                    oFileEntry.setOwner(parentEntry);
                    parentEntry.addFileEntry(oFileEntry);
                }
            }
            vBaseComps = oFileEntry.getCompatReferencerComponents();
            if (vBaseComps != null) {
                int iBaseComps = vBaseComps.size();
                for (int j = 0; j < iBaseComps; ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)vBaseComps.elementAt(j);
                    this.addBaseComp(new OiiiCompIdOhPair(cid, this.m_nHomeIndex));
                }
            }
            this.m_filesPatched.addElement(oFileEntry);
        }
        this.addInvFileEntry(parentEntry.getDirPath(), parentEntry.getFileName());
        this.m_bFilesLoaded = true;
    }

    public void deregisterFiles(Vector files) throws OiiiOneoffException {
        String sHomePath = this.getHomeLocation();
        for (int i = 0; i < files.size(); ++i) {
            String sFilePath = (String)files.elementAt(i);
            this.m_iac.deregisterFile(sHomePath, sFilePath, this.getID());
        }
    }

    public void deregisterFiles(String sParentFilePath, Vector files) throws OiiiOneoffException {
        String sHomePath = this.getHomeLocation();
        for (int i = 0; i < files.size(); ++i) {
            String sChildFilePath = (String)files.elementAt(i);
            this.m_iac.deregisterFile(sHomePath, sParentFilePath, sChildFilePath, this.getID());
        }
    }

    public Date getTimestamp() {
        return this.m_dInstallTime;
    }

    public void setTimestamp(Date dInstallTime) {
        this.m_dInstallTime = dInstallTime;
    }

    public String getXMLInvLocation() {
        return this.m_sXmlInvLocation;
    }

    public int getHomeIndex() {
        return this.m_nHomeIndex;
    }

    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    public void writeXML(PrintWriter out) throws IOException {
        XMLElement element = this.buildDOMTree();
        element.print(out);
    }

    private XMLElement buildDOMTree() {
        Vector vSupersededByList;
        Vector vSupersedesList;
        Vector langs;
        XMLElement element = this.m_unknownXMLElement;
        element = this.m_unknownXMLElement == null ? new XMLElement("ONEOFF") : (XMLElement)element.cloneNode(true);
        element.setAttribute("REF_ID", this.getID().getID());
        String uniqID = this.getUniqID();
        if (uniqID != null) {
            element.setAttribute("UNIQ_ID", uniqID);
        }
        if ((langs = this.getLangs()).size() > 0) {
            element.setAttribute("LANGS", OiixLanguage.vectToStr(langs));
        }
        element.setAttribute("ROLLBACK", this.isRollbackable() ? "T" : "F");
        element.setAttribute("XML_INV_LOC", this.m_sXmlInvLocation);
        if (this.m_installerVersion != null) {
            element.setAttribute("ACT_INST_VER", this.m_installerVersion.toString());
        } else {
            element.setAttribute("ACT_INST_VER", OiicInstVersion.getInstallerVersion().toString());
        }
        if (this.m_dInstallTime == null) {
            this.m_dInstallTime = new Date();
        }
        element.setAttribute("INSTALL_TIME", new SimpleDateFormat("yyyy.MMM.dd HH:mm:ss zzz", OiixLanguage.ENGLISH).format(this.m_dInstallTime));
        XMLElement desc = new XMLElement("DESC");
        desc.addText(this.getDescription());
        element.appendChild((Node)desc);
        XMLElement elemRefList = (XMLElement)this.m_hXMLElements.get("REF_LIST");
        elemRefList = elemRefList == null ? new XMLElement("REF_LIST") : (XMLElement)elemRefList.cloneNode(true);
        Vector baseComps = this.getBaseComps();
        int iRefsSize = baseComps.size();
        for (int i = 0; i < iRefsSize; ++i) {
            OiiiCompIdOhPair baseComp = (OiiiCompIdOhPair)baseComps.elementAt(i);
            OiiiCompInstallID cid = baseComp.getCompID();
            XMLElement elemRef = baseComp.getXMLElement();
            elemRef = elemRef == null ? new XMLElement("REF") : (XMLElement)elemRef.cloneNode(true);
            elemRef.setAttribute("NAME", cid.getName());
            elemRef.setAttribute("VER", cid.getVersion().getVerString());
            elemRef.setAttribute("HOME_IDX", "" + baseComp.getOHIndex());
            elemRefList.appendChild((Node)elemRef);
        }
        XMLElement elemBugList = (XMLElement)this.m_hXMLElements.get("BUG_LIST");
        elemBugList = elemBugList == null ? new XMLElement("BUG_LIST") : (XMLElement)elemBugList.cloneNode(true);
        Vector vBugList = this.getBugs();
        int iBugsSize = vBugList.size();
        for (int j = 0; j < iBugsSize; ++j) {
            String bugId = (String)vBugList.elementAt(j);
            XMLElement elemBug = (XMLElement)this.m_hXMLElements.get(bugId);
            elemBug = elemBug == null ? new XMLElement("BUG") : (XMLElement)elemBug.cloneNode(true);
            elemBug.addText(bugId);
            elemBugList.appendChild((Node)elemBug);
        }
        XMLElement elemPrereqList = (XMLElement)this.m_hXMLElements.get("PREREQID_LIST");
        elemPrereqList = elemPrereqList == null ? new XMLElement("PREREQID_LIST") : (XMLElement)elemPrereqList.cloneNode(true);
        Vector vPrereqList = this.getPrereqs();
        int iPrereqsSize = vPrereqList.size();
        for (int j = 0; j < iPrereqsSize; ++j) {
            String prereqId = (String)vPrereqList.elementAt(j);
            XMLElement elemPrereq = (XMLElement)this.m_hXMLElements.get(prereqId);
            elemPrereq = elemPrereq == null ? new XMLElement("PREREQID") : (XMLElement)elemPrereq.cloneNode(true);
            elemPrereq.addText(prereqId);
            elemPrereqList.appendChild((Node)elemPrereq);
        }
        XMLElement elemFileList = (XMLElement)this.m_hXMLElements.get("FILE_LIST");
        elemFileList = elemFileList == null ? new XMLElement("FILE_LIST") : (XMLElement)elemFileList.cloneNode(true);
        int iFilesSize = this.m_invFileEntries.size();
        for (int k = 0; k < iFilesSize; ++k) {
            OiiiOneoffFile oFile = (OiiiOneoffFile)this.m_invFileEntries.elementAt(k);
            elemFileList.appendChild((Node)oFile.toXML());
        }
        XMLElement elemPropertyList = (XMLElement)this.m_hXMLElements.get("PROPERTY_LIST");
        elemPropertyList = elemPropertyList == null ? new XMLElement("PROPERTY_LIST") : (XMLElement)elemPropertyList.cloneNode(true);
        Properties PropertyList = this.getAdditionalProperties();
        if (PropertyList != null) {
            Enumeration<?> propNames = PropertyList.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = PropertyList.getProperty(propName);
                XMLElement elemProperty = (XMLElement)this.m_hXMLElements.get("");
                elemProperty = elemProperty == null ? new XMLElement("PROPERTY") : (XMLElement)elemProperty.cloneNode(true);
                elemProperty.setAttribute("NAME", propName);
                elemProperty.setAttribute("VAL", propValue);
                elemPropertyList.appendChild((Node)elemProperty);
            }
        }
        element.appendChild((Node)elemRefList);
        element.appendChild((Node)elemBugList);
        if (iPrereqsSize > 0) {
            element.appendChild((Node)elemPrereqList);
        }
        element.appendChild((Node)elemFileList);
        if (PropertyList != null) {
            element.appendChild((Node)elemPropertyList);
        }
        if (null != (vSupersedesList = this.getSupersededOneOffsList()) && vSupersedesList.size() != 0) {
            XMLElement elemSupersedesList = (XMLElement)this.m_hXMLElements.get("SUPERSEDES");
            elemSupersedesList = elemSupersedesList == null ? new XMLElement("SUPERSEDES") : (XMLElement)elemSupersedesList.cloneNode(true);
            for (int j = 0; j < vSupersedesList.size(); ++j) {
                OiiiInstallOneoffInvEntry oneoffEntry = (OiiiInstallOneoffInvEntry)vSupersedesList.elementAt(j);
                XMLElement elemOneoff = (XMLElement)this.m_hXMLElements.get(oneoffEntry);
                elemOneoff = elemOneoff == null ? new XMLElement("REF_ID") : (XMLElement)elemOneoff.cloneNode(true);
                String oneOffID = oneoffEntry.getID().toString();
                String uniqIDForOneoff = oneoffEntry.getUniqID();
                Vector langsForOneoff = oneoffEntry.getLangs();
                elemOneoff.setAttribute("REF_ID", oneOffID);
                if (uniqIDForOneoff != null) {
                    elemOneoff.setAttribute("UNIQ_ID", uniqIDForOneoff);
                }
                if (langsForOneoff != null && langsForOneoff.size() > 0) {
                    elemOneoff.setAttribute("LANGS", OiixLanguage.vectToStr(langsForOneoff));
                }
                elemSupersedesList.appendChild((Node)elemOneoff);
            }
            element.appendChild((Node)elemSupersedesList);
        }
        if (null != (vSupersededByList = this.getSupersededByOneOffsList()) && vSupersededByList.size() != 0) {
            XMLElement elemSupersededByList = (XMLElement)this.m_hXMLElements.get("SUPERSEDED_BY");
            elemSupersededByList = elemSupersededByList == null ? new XMLElement("SUPERSEDED_BY") : (XMLElement)elemSupersededByList.cloneNode(true);
            for (int j = 0; j < vSupersededByList.size(); ++j) {
                OiiiInstallOneoffInvEntry oneoffEntry = (OiiiInstallOneoffInvEntry)vSupersededByList.elementAt(j);
                XMLElement elemOneoff = (XMLElement)this.m_hXMLElements.get(oneoffEntry);
                elemOneoff = elemOneoff == null ? new XMLElement("REF_ID") : (XMLElement)elemOneoff.cloneNode(true);
                String oneOffID = oneoffEntry.getID().toString();
                String uniqIDForOneoff = oneoffEntry.getUniqID();
                Vector langsForOneoff = oneoffEntry.getLangs();
                elemOneoff.setAttribute("REF_ID", oneOffID);
                if (uniqIDForOneoff != null) {
                    elemOneoff.setAttribute("UNIQ_ID", uniqIDForOneoff);
                }
                if (langsForOneoff != null && langsForOneoff.size() > 0) {
                    elemOneoff.setAttribute("LANGS", OiixLanguage.vectToStr(langsForOneoff));
                }
                elemSupersededByList.appendChild((Node)elemOneoff);
            }
            element.appendChild((Node)elemSupersededByList);
        }
        return element;
    }

    public void setHomeIndex(int homeIndex) {
        this.m_nHomeIndex = homeIndex;
    }

    public void setXmlInventoryLocation(String location) {
        this.m_sXmlInvLocation = location;
    }

    void setUnknownXMLElement(XMLElement el) {
        this.m_unknownXMLElement = el;
    }

    void setUnknownXMLElementTable(Hashtable ht) {
        this.m_hXMLElements = ht;
    }

    public OiiiOneoffIdOhPair getOneoffIdOhPair() {
        return new OiiiOneoffIdOhPair(this.getID(), this.m_nHomeIndex);
    }

    public Object clone() {
        OiiiInstallOneoffInvEntry oClone = null;
        oClone = (OiiiInstallOneoffInvEntry)super.clone();
        oClone.setHomeIndex(this.m_nHomeIndex);
        oClone.setXmlInventoryLocation(new String(this.m_sXmlInvLocation));
        oClone.setUnknownXMLElementTable((Hashtable)this.m_hXMLElements.clone());
        oClone.m_dInstallTime = (Date)this.m_dInstallTime.clone();
        return oClone;
    }

    public boolean equals(OiiiInstallOneoffInvEntry invEntry) {
        boolean retVal = true;
        retVal = super.equals(invEntry);
        if (!retVal) {
            return false;
        }
        if (this.m_nHomeIndex != invEntry.getHomeIndex()) {
            return false;
        }
        if (!this.m_sXmlInvLocation.equals(invEntry.getXMLInvLocation())) {
            return false;
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OiiiInstallOneoffInvEntry) {
            return this.equals((OiiiInstallOneoffInvEntry)obj);
        }
        return false;
    }

    private String getHomeLocation() {
        String sHomeLocation = "";
        sHomeLocation = this.m_nHomeIndex == 0 ? this.m_iac.getInventoryLocForHome(0) : this.m_iac.getInstallInventory().getHomeLocation(this.m_nHomeIndex);
        return sHomeLocation;
    }

    public String getDisplayString() {
        return this.getID().getDisplayString();
    }

    void setFilesLoaded(boolean bFilesLoaded) {
        this.m_bFilesLoaded = true;
    }

    void setInvFilesList(Vector invFileEntries) {
        this.m_invFileEntries = invFileEntries;
    }

    Vector getInvFilesList() {
        return this.m_invFileEntries;
    }

    private boolean checkIfPatched(Vector vRefOneoffs, String sFilePath) throws OiiiOneoffException {
        boolean bPatched = false;
        if (vRefOneoffs != null && vRefOneoffs.size() > 0) {
            Vector<OiiiOneoffInstallID> vOneoffConflicts = new Vector<OiiiOneoffInstallID>(5);
            int iRefOneoffs = vRefOneoffs.size();
            for (int k = 0; k < iRefOneoffs; ++k) {
                OiiiOneoffInstallID oID = (OiiiOneoffInstallID)vRefOneoffs.elementAt(k);
                if (this.getID().equals(oID)) {
                    bPatched = true;
                    continue;
                }
                vOneoffConflicts.addElement(oID);
            }
            if (vOneoffConflicts.size() > 0) {
                OiiiOneoffException oe = new OiiiOneoffException("S_ONEOFF_FILE_ALREADY_PATCHED", new Object[]{sFilePath, vOneoffConflicts.elementAt(0)});
                oe.setOneoffConflicts(vOneoffConflicts);
                throw oe;
            }
        }
        return bPatched;
    }

    private void loadPatchedFileList() {
        if (this.m_invFileEntries != null) {
            int iSize = this.m_invFileEntries.size();
            for (int i = 0; i < iSize; ++i) {
                OiiiOneoffFile oFile = (OiiiOneoffFile)this.m_invFileEntries.elementAt(i);
                String sParentPath = this.getCompletePath(oFile.getParentPath());
                if (oFile.isCompositeFile()) {
                    this.m_iac.loadFiles(this.getHomeLocation(), sParentPath, oFile.getChildFile());
                    continue;
                }
                this.m_iac.loadFiles(this.getHomeLocation(), sParentPath);
            }
        }
    }

    private void addInvFileEntry(String sFilePath, String sChildFile) {
        OiiiOneoffFile oFile = null;
        sFilePath = this.getRelativePathFromHome(sFilePath);
        oFile = sChildFile != null && !sChildFile.equals("") ? new OiiiOneoffFile(sFilePath, sChildFile) : new OiiiOneoffFile(sFilePath);
        if (!this.m_invFileEntries.contains(oFile)) {
            this.m_invFileEntries.addElement(oFile);
        }
    }

    private void addInvFileEntry(OiiiFileMapFileEntry oEntry) {
        OiiiFileMapFileEntry oOwner = oEntry.getOwnerFileEntry();
        if (oOwner != null) {
            this.addInvFileEntry(oOwner.getDirPath(), oOwner.getFileName());
        } else {
            this.addInvFileEntry(oEntry.getDirPath(), null);
        }
    }

    void addPatchedFileEntry(OiiiFileMapFileEntry oEntry) {
        if (!this.m_filesPatched.contains(oEntry)) {
            this.m_filesPatched.addElement(oEntry);
            if (this.m_installerVersion == null) {
                this.addInvFileEntry(oEntry);
            }
        }
    }

    public Vector getFilesPatched() {
        if (!this.m_bFilesLoaded) {
            this.loadPatchedFileList();
            this.m_bFilesLoaded = true;
        }
        if (this.m_filesPatched == null || this.m_filesPatched.size() == 0) {
            try {
                OiiiOneoffPatchActions oneoffActions = new OiiiOneoffPatchActions(this.m_iac.getInstallInventory().getHomeInfo(this.m_nHomeIndex), this.getHomeLocation(), this.getID().getID());
                this.m_filesPatched = oneoffActions.getFilesPatched();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_filesPatched;
    }

    public OiiiVersion getInstallerVersion() {
        return this.m_installerVersion;
    }

    public void setInstallerVersion(OiiiVersion oVersion) {
        this.m_installerVersion = oVersion;
    }

    private String getCompletePath(String sPath) {
        if (!OiiiFileMapEntry.pathStartsFromRoot(sPath)) {
            return OiixPathOps.concatPath(this.getHomeLocation(), sPath);
        }
        return sPath;
    }

    private String getRelativePathFromHome(String sPath) {
        String sHomePath = OiixPathOps.getStandardCanonicalPath(this.getHomeLocation());
        if (!OiipgFileSystem.isCaseSensitive()) {
            sPath = sPath.toLowerCase();
        }
        if ((sPath = OiixPathOps.getStandardCanonicalPath(sPath)).startsWith(sHomePath)) {
            if ((sPath = sPath.substring(sHomePath.length())).length() > 0 && sPath.charAt(0) == '/') {
                sPath = sPath.substring(1);
            }
            if (sPath.length() == 0) {
                sPath = "./";
            }
        }
        return sPath;
    }
}

