/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiiInstallPatchSetInvEntry
extends OiiiInstallCompInvEntry
implements OiivVerIndMergeCapable {
    private static final int ID_POS = 0;
    private static final int MORE_INFO_POS = 1;
    private static final int TOTAL_FIELDS = 2;
    private Vector m_patches = null;

    public OiiiInstallPatchSetInvEntry(OiiiPatchSetInstallID psid, String installLoc) {
        super(psid, installLoc, new Vector(), new Vector(), null);
        Integer curPlat = new Integer(OiixPlatform.getCurrentPlatform());
        Vector<Integer> v = new Vector<Integer>(1);
        v.addElement(curPlat);
        this.setPlatforms(v);
        this.m_patches = new Vector();
    }

    public OiiiInstallPatchSetInvEntry(OiivVerIndObjectRep viObj) {
        super(viObj);
        Vector vStoredInfo = (Vector)viObj.getObjectForName("patches");
        this.m_patches = this.getPatchInfo(vStoredInfo);
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = super.getVerIndRep();
        retRep.setClassName("oracle.sysman.oii.oiii.OiiiInstallCompInvEntry");
        retRep.addNVPair("patches", this.getVerIndPatches());
        return retRep;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals("patches")) {
            return OiixVectorOps.vectorsEqual(this.m_patches, this.getPatchInfo((Vector)value));
        }
        return super.compareKeyValue(key, value);
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = super.mergeVerIndRep(vIndObj);
        retRep.setNVPair("patches", this.getVerIndPatches());
        return retRep;
    }

    private Vector getPatchInfo(Vector vStoredInfo) {
        int nSize = vStoredInfo.size();
        Vector<OiiiCompInstallID> patches = new Vector<OiiiCompInstallID>(nSize);
        for (int i = 0; i < nSize; ++i) {
            if (vStoredInfo.elementAt(i) instanceof OiiiCompInstallID) {
                return vStoredInfo;
            }
            Vector vOneId = (Vector)vStoredInfo.elementAt(i);
            OiiiCompInstallID id = (OiiiCompInstallID)vOneId.elementAt(0);
            Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect((Vector)vOneId.elementAt(1));
            switch (id.getCompType()) {
                case 2: {
                    id = OiiiPatchInstallID.createInstallID(id, additionalInfo);
                    break;
                }
                case 4: {
                    id = OiiiPatchSetInstallID.createInstallID(id, additionalInfo);
                    break;
                }
            }
            patches.addElement(id);
        }
        return patches;
    }

    public Vector getVerIndPatches() {
        int nSize = this.m_patches.size();
        Vector vStoreInfo = new Vector(nSize);
        for (int i = 0; i < nSize; ++i) {
            OiiiPatchInstallID id = (OiiiPatchInstallID)this.m_patches.elementAt(i);
            OiiiCompInstallID compId = id.getIDAsCompID();
            Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(id.getAdditionalInfo());
            Vector<Serializable> vOneId = new Vector<Serializable>(2);
            vOneId.setSize(2);
            vOneId.setElementAt(compId, 0);
            vOneId.setElementAt(additionalInfo, 1);
            vStoreInfo.addElement(vOneId);
        }
        return vStoreInfo;
    }

    public Vector getPatches() {
        return this.m_patches;
    }

    public void setPatches(Vector patches) {
        this.m_patches = patches;
    }

    public void removePatch(OiiiPatchInstallID pid) {
        int pIndex = OiixVectorOps.vectIndexOf(this.m_patches, (Object)pid);
        if (pIndex != -1) {
            this.m_patches.removeElementAt(pIndex);
        }
    }

    public void addPatch(OiiiPatchInstallID pid) {
        int pIndex = OiixVectorOps.vectIndexOf(this.m_patches, (Object)pid);
        if (pIndex != -1) {
            this.m_patches.addElement(pid);
        }
    }

    public boolean hasNoPatches() {
        return this.m_patches.isEmpty();
    }

    protected XMLElement buildDOMTree() {
        XMLElement elemPS = super.buildDOMTree();
        elemPS.removeAttribute("LANGS");
        elemPS.removeAttribute("REP_VER");
        elemPS.removeAttribute("INST_LOC");
        for (int i = 0; i < this.m_patches.size(); ++i) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)this.m_patches.elementAt(i);
            XMLElement elemPSPatch = pid.getUnknownXMLElement();
            elemPSPatch = elemPSPatch == null ? new XMLElement("PS_PATCH") : (XMLElement)elemPSPatch.cloneNode(true);
            elemPSPatch.setAttribute("NAME", pid.getName());
            elemPSPatch.setAttribute("VER", pid.getVersion().getVerString());
            elemPSPatch.setAttribute("BASE_VER", pid.getBaseVersion().getVerString());
            if (pid.getHomeType() == 0) {
                elemPSPatch.setAttribute("NOH", "T");
            }
            elemPS.appendChild((Node)elemPSPatch);
        }
        return elemPS;
    }

    protected XMLElement createXMLElement() {
        XMLElement element = this.getUnknownXMLElement("PATCHSET");
        element = element == null ? new XMLElement("PATCHSET") : (XMLElement)element.cloneNode(true);
        return element;
    }

    public Vector getOneoffsVect() {
        return null;
    }
}

