/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompositeAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReader;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiOneoffXMLHandler;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

class OiiiInstallSerializedReader
implements OiiiInstallInventoryReader {
    private static OiiiInstallSerializedReader m_reader;
    private static final String COMPS_INFO = "compsInfo";
    private static final String ORACLE_HOMES = "oracleHomes";

    private OiiiInstallSerializedReader() {
    }

    public Vector readHomes() throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiivVerIndObjectRep viHomes = (OiivVerIndObjectRep)iac.loadObject("OracleHomesList");
        Vector viHomesVect = (Vector)viHomes.getObjectForName(ORACLE_HOMES);
        Vector oracleHomes = OiivVerIndObjectRep.getVerDepFormOfVect(viHomesVect);
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Serialized Reader, Read Homes ", System.currentTimeMillis() - lTime);
        }
        return oracleHomes;
    }

    public OiiiInvHomeInfo readComps(int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inventory = iac.getInstallInventory();
        OiivVerIndObjectRep compsInfoObj = (OiivVerIndObjectRep)iac.loadObject("CompsList" + homeIndex);
        Vector compsInfo = null;
        if (compsInfoObj != null) {
            Vector viCompsInfo = (Vector)compsInfoObj.getObjectForName(COMPS_INFO);
            compsInfo = OiivVerIndObjectRep.getVerDepFormOfVect(viCompsInfo);
        }
        if (compsInfo == null) {
            return new OiiiInvHomeInfo(homeIndex);
        }
        OiivVerIndObjectRep patchesInfoObj = (OiivVerIndObjectRep)iac.loadObject("PatchesList" + homeIndex);
        Vector patchesInfo = null;
        if (patchesInfoObj != null) {
            Vector viPatchesInfo = (Vector)patchesInfoObj.getObjectForName(COMPS_INFO);
            patchesInfo = OiivVerIndObjectRep.getVerDepFormOfVect(viPatchesInfo);
        }
        if (patchesInfo == null) {
            patchesInfo = new Vector();
        }
        compsInfo = inventory.getCorrectedInvList(compsInfo, patchesInfo);
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Serialized Reader, Read Comps for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
        OiiiInvHomeInfo oihi = new OiiiInvHomeInfo(homeIndex, compsInfo);
        String sOneoffLoc = iac.genFileInvLoc("oneoffs" + homeIndex + ".oo");
        oihi.setOneoffsVect(this.loadOneoffs(sOneoffLoc, homeIndex, inventory));
        return oihi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Vector loadOneoffs(String oneoffLoc, int homeIndex, OiiiInstallInventory inventory) {
        Vector vOneoffs;
        block20: {
            vOneoffs = new Vector(5);
            FileReader fReader = null;
            BufferedReader bReader = null;
            fReader = new FileReader(oneoffLoc);
            bReader = new BufferedReader(fReader);
            try {
                int homeType = 0;
                if (homeIndex == 0) {
                    homeType = 2;
                } else {
                    OiiiOracleHomeInfo oInfo = inventory.getHomeInfo(homeIndex);
                    homeType = oInfo.getHomeType();
                }
                OiiiOneoffXMLHandler oHandler = new OiiiOneoffXMLHandler(homeIndex, homeType, inventory.getPlatform());
                Parser parser = OixsXMLOps.createSAXParser();
                parser.setDocumentHandler(oHandler);
                parser.setErrorHandler(oHandler);
                try {
                    fReader = new FileReader(oneoffLoc);
                    bReader = new BufferedReader(fReader);
                    parser.parse(new InputSource(bReader));
                    vOneoffs = oHandler.getOneoffs();
                }
                catch (FileNotFoundException e) {}
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            Object var12_15 = null;
            try {
                if (bReader != null) {
                    bReader.close();
                }
                if (fReader != null) {
                    fReader.close();
                }
                break block20;
            }
            catch (Exception e2) {}
            break block20;
            {
                catch (Exception e) {
                    Object[] args = new String[]{oneoffLoc};
                    String logMesg = OiixResourceBundle.getString("S_ONEOFF_ERROR_INVALID_BINARY", args);
                    OiiolTextLogger.appendText(logMesg);
                    Object var12_16 = null;
                    try {
                        if (bReader != null) {
                            bReader.close();
                        }
                        if (fReader != null) {
                            fReader.close();
                        }
                        break block20;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                try {
                    if (bReader != null) {
                        bReader.close();
                    }
                    if (fReader != null) {
                        fReader.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return vOneoffs;
    }

    public Vector[] readLibs(int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        Vector[] libs = null;
        if (homeIndex != 0) {
            libs = new Vector[3];
            for (int i = 0; i < libs.length; ++i) {
                libs[i] = new Vector();
            }
        } else {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            libs = (Vector[])iac.loadObject("LibsList");
            if (libs != null) {
                for (int libType = 0; libType < 3; ++libType) {
                    Vector verDepLibsInfoForType;
                    Vector libsInfoForType = libs[libType];
                    libs[libType] = verDepLibsInfoForType = OiivVerIndObjectRep.getVerDepFormOfVect(libsInfoForType);
                }
            } else {
                libs = new Vector[3];
                for (int i = 0; i < libs.length; ++i) {
                    libs[i] = new Vector();
                }
            }
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Serialized Reader, Read Libs for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
        return libs;
    }

    public static OiiiInstallInventoryReader getReader() {
        if (m_reader == null) {
            m_reader = new OiiiInstallSerializedReader();
        }
        return m_reader;
    }

    public Vector readHomes(OiiiCompositeAreaControl cac) throws IOException {
        return null;
    }

    public OiiiInvHomeInfo readComps(OiiiCompositeAreaControl cac, int homeIndex) throws IOException {
        return null;
    }

    public Vector[] readLibs(OiiiCompositeAreaControl cac, int homeIndex) throws IOException {
        return null;
    }
}

