/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventoryWriter;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixDebug;

class OiiiInstallSerializedWriter
implements OiiiInstallInventoryWriter {
    private static OiiiInstallSerializedWriter m_writer;
    private OiivVerIndObjectRep m_inventory;

    private OiiiInstallSerializedWriter() {
    }

    public void writeHomes() throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        Vector oracleHomes = (Vector)this.m_inventory.getObjectForName("oracleHomes");
        OiivVerIndObjectRep homesRep = new OiivVerIndObjectRep();
        homesRep.setClassName(oracleHomes.getClass().getName());
        Vector viOracleHomes = OiivVerIndObjectRep.getVerIndepFormOfVect(oracleHomes);
        homesRep.addNVPair("oracleHomes", viOracleHomes);
        try {
            iac.writeObjToFile("OracleHomesList", homesRep);
        }
        catch (OiifbCancelException e) {
            throw new IOException(e.getMessage());
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Serialized Writer, Writing Homes ", System.currentTimeMillis() - lTime);
        }
    }

    public void writeComps(int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        Vector compOHsList = (Vector)this.m_inventory.getObjectForName("compOHsList");
        Vector compsInfo = (Vector)compOHsList.elementAt(homeIndex);
        try {
            String fileName = "CompsList" + homeIndex;
            iac.writeObjToFile(fileName, this.getCompsInfoIndObject(compsInfo));
            fileName = "PatchesList" + homeIndex;
            iac.writeObjToFile(fileName, this.getPatchesInfoIndObject(compsInfo));
            try {
                fileName = "oneoffs" + homeIndex + ".oo";
                fileName = iac.genFileInvLoc(fileName);
                FileWriter fWriter = new FileWriter(fileName);
                BufferedWriter bWriter = new BufferedWriter(fWriter);
                PrintWriter pWriter = new PrintWriter(bWriter);
                iac.getInstallInventory().writeOneoffs(homeIndex, pWriter, true);
                pWriter.close();
                bWriter.close();
                fWriter.close();
            }
            catch (Exception e) {}
        }
        catch (OiifbCancelException e) {
            throw new IOException(e.getMessage());
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Serialized Writer, Writing Comps for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
    }

    public void writeLibs(int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        Vector[] libsInfo = (Vector[])this.m_inventory.getObjectForName("libsInfo");
        try {
            iac.writeObjToFile("LibsList", libsInfo);
        }
        catch (OiifbCancelException e) {
            throw new IOException(e.getMessage());
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Serialized Writer, Writing Libs for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
    }

    public void writeAll() throws IOException {
    }

    public void writeDirty() throws IOException {
    }

    private void setInventory(OiivVerIndObjectRep inventory) {
        this.m_inventory = inventory;
    }

    private OiivVerIndObjectRep getCompsInfoIndObject(Vector compsInfo) {
        OiivVerIndObjectRep compsRep = new OiivVerIndObjectRep();
        compsRep.setClassName(compsInfo.getClass().getName());
        Vector viCompsInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(compsInfo);
        compsRep.addNVPair("compsInfo", viCompsInfo);
        return compsRep;
    }

    private OiivVerIndObjectRep getPatchesInfoIndObject(Vector compsInfo) {
        OiivVerIndObjectRep compsRep = new OiivVerIndObjectRep();
        compsRep.setClassName(compsInfo.getClass().getName());
        int nSize = compsInfo.size();
        Vector<OiivVerIndObjectRep> vPatches = new Vector<OiivVerIndObjectRep>();
        for (int i = 0; i < nSize; ++i) {
            OiivVerIndObjectRep oComp = (OiivVerIndObjectRep)compsInfo.elementAt(i);
            OiiiCompInstallID id = (OiiiCompInstallID)oComp.getObjectForName("cid");
            if (id.getCompType() != 2 && id.getCompType() != 4) continue;
            vPatches.addElement(oComp);
        }
        Vector viCompsInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(vPatches);
        compsRep.addNVPair("compsInfo", vPatches);
        return compsRep;
    }

    public static OiiiInstallInventoryWriter getWriter(OiivVerIndObjectRep inv) {
        if (m_writer == null) {
            m_writer = new OiiiInstallSerializedWriter();
        }
        m_writer.setInventory(inv);
        return m_writer;
    }
}

