/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiii.OiiiCompositeAreaControl;
import oracle.sysman.oii.oiii.OiiiCompsXMLHandler;
import oracle.sysman.oii.oiii.OiiiConfigXMLHandler;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReader;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiInventoryXMLHandler;
import oracle.sysman.oii.oiii.OiiiLibsXMLHandler;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

class OiiiInstallXMLReader
implements OiiiInstallInventoryReader {
    private static OiiiInstallXMLReader m_reader;

    private OiiiInstallXMLReader() {
    }

    public Vector readHomes() throws IOException {
        return this.readHomes(null);
    }

    public Vector readHomes(OiiiCompositeAreaControl cac) throws IOException {
        long lTime = 0L;
        String sFile = "";
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inventory = iac.getInstallInventory();
        sFile = iac.getInventoryFileLoc();
        if (cac != null) {
            inventory = cac.getInstallInventory();
            sFile = cac.getInventoryFileLoc();
        }
        try {
            FileReader fReader = new FileReader(sFile);
            BufferedReader bReader = new BufferedReader(fReader);
            Parser parser = OixsXMLOps.createSAXParser();
            OiiiInventoryXMLHandler handler = null;
            try {
                handler = new OiiiInventoryXMLHandler();
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new OiiiInstallInventoryReadException(e, e.getMessage());
            }
            bReader.close();
            fReader.close();
            OiiiVersion minVer = handler.getMinOUIVersion();
            if (minVer.laterThan(OiicInstVersion.getInstallerVersion())) {
                String sMsg = OiixResourceBundle.getString("S_ERR_INVENTORY_VERSION");
                sMsg = MessageFormat.format(sMsg, minVer.getVerString());
                throw new OiiiInstallInventoryReadException(sMsg);
            }
            if (OiixDebug.PRINT_TIME) {
                OiixDebug.printTimeMsg("XML Reader, Read Homes", System.currentTimeMillis() - lTime);
            }
            inventory.setXMLInvUnknownElement(handler.getUnknownInventoryElement());
            inventory.setXMLHLUnknownElement(handler.getUnknownHomeListElement());
            return handler.getHomes();
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_HOMELIST_ERROR"));
            return new Vector();
        }
    }

    public OiiiInvHomeInfo readComps(int homeIndex) throws IOException {
        return this.readComps(null, homeIndex);
    }

    public OiiiInvHomeInfo readComps(OiiiCompositeAreaControl cac, int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inventory = iac.getInstallInventory();
        if (cac != null) {
            inventory = cac.getInstallInventory();
        }
        int homeType = 2;
        if (homeIndex != 0) {
            OiiiOracleHomeInfo homeInfo = inventory.getHomeInfo(homeIndex, inventory.getAllOUIHomes());
            homeType = homeInfo.getHomeType();
        }
        OiiiCompsXMLHandler handler = null;
        FileReader fReader = null;
        BufferedReader bReader = null;
        try {
            String sFileLoc = iac.getXMLCompsFileLoc(homeIndex);
            Parser parser = OixsXMLOps.createSAXParser();
            handler = new OiiiCompsXMLHandler(homeIndex, homeType, inventory.getPlatform());
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileReader(sFileLoc);
                bReader = new BufferedReader(fReader);
            }
            catch (FileNotFoundException e) {
                Object[] sArgs = new String[]{sFileLoc};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
                File fComps = new File(sFileLoc);
                if (fComps.exists() && !fComps.canRead()) {
                    throw new IOException(e.getMessage());
                }
                return new OiiiInvHomeInfo(homeIndex);
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Read Comps for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
        return handler.getComps();
    }

    public Vector[] readLibs(int homeIndex) throws IOException {
        return this.readLibs(null, homeIndex);
    }

    public Vector[] readLibs(OiiiCompositeAreaControl cac, int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLibsFileLoc = iac.getXMLLibsFileLoc(homeIndex);
        OiiiLibsXMLHandler handler = null;
        FileReader fReader = null;
        BufferedReader bReader = null;
        OiiiInstallInventory inventory = iac.getInstallInventory();
        if (cac != null) {
            sLibsFileLoc = cac.getXMLLibsFileLoc(homeIndex);
            inventory = cac.getInstallInventory();
        }
        try {
            handler = new OiiiLibsXMLHandler(iac.getInstallInventory().getPlatform());
            Parser parser = OixsXMLOps.createSAXParser();
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileReader(sLibsFileLoc);
                bReader = new BufferedReader(fReader);
            }
            catch (FileNotFoundException e) {
                Vector[] vLibs = new Vector[]{new Vector(), new Vector(), new Vector()};
                return vLibs;
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Read Libs for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
        inventory.setAllCompsUnknownLibElementsTable(homeIndex, handler.getUnknownElementsTable());
        return handler.getLibraries();
    }

    void readConfigTools(int homeIndex) throws IOException {
        this.readConfigTools(null, homeIndex);
    }

    void readConfigTools(OiiiCompositeAreaControl cac, int homeIndex) throws IOException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sConfigFileLoc = iac.getXMLConfigFileLoc(homeIndex);
        if (cac != null) {
            sConfigFileLoc = cac.getXMLConfigFileLoc(homeIndex);
        }
        if (!new File(sConfigFileLoc).exists()) {
            return;
        }
        OiiiInstallInventory inventory = iac.getInstallInventory();
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiConfigXMLHandler handler = null;
        InputStreamReader fReader = null;
        BufferedReader bReader = null;
        try {
            try {
                Parser parser = OixsXMLOps.createSAXParser();
                handler = new OiiiConfigXMLHandler(inventory, homeIndex);
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                try {
                    fReader = new FileReader(sConfigFileLoc);
                    bReader = new BufferedReader(fReader);
                }
                catch (FileNotFoundException e) {
                    Object[] sArgs = new String[]{sConfigFileLoc};
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
                }
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            bReader.close();
            fReader.close();
            throw throwable;
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Relase notes for Stage Inventory ", System.currentTimeMillis() - lTime);
        }
    }

    public static OiiiInstallInventoryReader getReader() {
        if (m_reader == null) {
            m_reader = new OiiiInstallXMLReader();
        }
        return m_reader;
    }

    public static OiiiInstallXMLReader getInstallXMLReader() {
        return (OiiiInstallXMLReader)OiiiInstallXMLReader.getReader();
    }
}

