/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiii.OiiiCompsXMLHandler;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInstallInventoryStreamReader;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiInventoryXMLHandler;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiLibsXMLHandler;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiInstallXMLStreamReader
implements OiiiInstallInventoryStreamReader {
    private static OiiiInstallXMLStreamReader m_reader;

    public Vector readHomes(InputStream is) throws IOException {
        Parser parser = OixsXMLOps.createSAXParser();
        OiiiInventoryXMLHandler handler = null;
        try {
            handler = new OiiiInventoryXMLHandler();
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(is));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OiiiInstallInventoryReadException(e, e.getMessage());
        }
        OiiiVersion minVer = handler.getMinOUIVersion();
        if (minVer.laterThan(OiicInstVersion.getInstallerVersion())) {
            String sMsg = OiixResourceBundle.getString("S_ERR_INVENTORY_VERSION");
            sMsg = MessageFormat.format(sMsg, minVer.getVerString());
            throw new OiiiInstallInventoryReadException(sMsg);
        }
        return handler.getHomes();
    }

    public OiiiInvHomeInfo readComps(InputStream is, int homeIndex, int homeType, int nPlatform) throws IOException {
        OiiiCompsXMLHandler handler = null;
        try {
            Parser parser = OixsXMLOps.createSAXParser();
            handler = new OiiiCompsXMLHandler(homeIndex, homeType, nPlatform);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(is));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return handler.getComps();
    }

    public OiiiLibrariesInfo readLibs(InputStream is, int homeIndex, int nPlatform) throws IOException {
        OiiiLibsXMLHandler handler = null;
        try {
            handler = new OiiiLibsXMLHandler(nPlatform);
            Parser parser = OixsXMLOps.createSAXParser();
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(is));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        OiiiLibrariesInfo libsInfo = new OiiiLibrariesInfo(handler.getLibraries());
        return libsInfo;
    }

    public static OiiiInstallInventoryStreamReader getReader() {
        if (m_reader == null) {
            m_reader = new OiiiInstallXMLStreamReader();
        }
        return m_reader;
    }

    private OiiiInstallXMLStreamReader() {
    }
}

