/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiCompositeAreaControl;
import oracle.sysman.oii.oiii.OiiiCompositeHomeInventory;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallInventoryWriter;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class OiiiInstallXMLWriter
implements OiiiInstallInventoryWriter {
    private static OiiiInstallXMLWriter m_writer = null;

    private OiiiInstallXMLWriter() {
    }

    public static OiiiInstallInventoryWriter getWriter() {
        if (m_writer == null) {
            m_writer = new OiiiInstallXMLWriter();
        }
        return m_writer;
    }

    public void writeHomes() throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallInventory inventory = this.getInstallInventory();
        OiiiInstallAreaControl areaControl = OiiiInstallAreaControl.getInstallAreaControl();
        Vector homes = inventory.getAllOUIHomes();
        int highestValidHomeIndex = -1;
        for (int i = 0; i < homes.size(); ++i) {
            OiiiOracleHomeInfo oHome = (OiiiOracleHomeInfo)homes.elementAt(i);
            if (oHome.isRemoved() || oHome.getIndex() <= highestValidHomeIndex) continue;
            highestValidHomeIndex = oHome.getIndex();
        }
        String sInventoryFileLoc = areaControl.getInventoryFileLoc();
        OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sInventoryFileLoc)));
        FileWriter fWriter = new FileWriter(sInventoryFileLoc);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement elemInv = inventory.getXMLInvUnknownElement();
        elemInv = elemInv == null ? new XMLElement("INVENTORY") : (XMLElement)elemInv.cloneNode(true);
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elemInv, pWriter);
        XMLElement elemVerInfo = new XMLElement("VERSION_INFO");
        XMLElement elemSavedWith = new XMLElement("SAVED_WITH");
        XMLText textSavedWith = new XMLText(OiicInstVersion.getInstallerVersion().getVerString());
        elemVerInfo.appendChild((Node)elemSavedWith);
        elemSavedWith.appendChild((Node)textSavedWith);
        XMLElement elemMinOUIVersion = new XMLElement("MINIMUM_VER");
        XMLText textMinOUIVersion = new XMLText(OiicInstVersion.getInventoryMinInstVersion().getVerString());
        elemVerInfo.appendChild((Node)elemMinOUIVersion);
        elemMinOUIVersion.appendChild((Node)textMinOUIVersion);
        elemVerInfo.print(pWriter);
        XMLElement elemHL = inventory.getXMLHLUnknownElement();
        elemHL = elemHL == null ? new XMLElement("HOME_LIST") : (XMLElement)elemHL.cloneNode(true);
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elemHL, pWriter);
        for (int i = 0; i < homes.size(); ++i) {
            OiiiOracleHomeInfo oHome = (OiiiOracleHomeInfo)homes.elementAt(i);
            if (oHome.isRemoved() && oHome.getIndex() > highestValidHomeIndex || oHome.isRefCompositeHome()) continue;
            OixsXMLizable homeInfo = (OixsXMLizable)homes.elementAt(i);
            homeInfo.writeXML(pWriter);
        }
        pWriter.println("</HOME_LIST>");
        pWriter.println("<COMPOSITEHOME_LIST>");
        Vector compHomes = inventory.getCompositeHomes();
        for (int idx = 0; idx < compHomes.size(); ++idx) {
            OiiiOracleHomeInfo oHome = (OiiiOracleHomeInfo)compHomes.elementAt(idx);
            if (oHome.isRemoved() && oHome.getIndex() > highestValidHomeIndex) continue;
            OixsXMLizable homeInfo = (OixsXMLizable)compHomes.elementAt(idx);
            homeInfo.writeXML(pWriter);
            OiiiCompositeAreaControl cac = inventory.getCompositeAreaControl(oHome.getLocation());
            this.writeHomes(cac, homes, oHome.getLocation());
        }
        pWriter.println("</COMPOSITEHOME_LIST>");
        pWriter.println("</INVENTORY>");
        pWriter.close();
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Homes ", System.currentTimeMillis() - lTime);
        }
    }

    public void writeHomes(OiiiCompositeAreaControl cac, Vector homes, String compositeHome) throws IOException {
        OixsXMLizable homeInfo;
        OiiiOracleHomeInfo oHome;
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiCompositeHomeInventory inventory = cac.getInstallInventory();
        int highestValidHomeIndex = -1;
        for (int i = 0; i < homes.size(); ++i) {
            OiiiOracleHomeInfo oHome2 = (OiiiOracleHomeInfo)homes.elementAt(i);
            if (oHome2.isRemoved() || oHome2.getIndex() <= highestValidHomeIndex) continue;
            highestValidHomeIndex = oHome2.getIndex();
        }
        String sInventoryFileLoc = cac.getInventoryFileLoc();
        OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sInventoryFileLoc)));
        boolean bIsAttachHome = Boolean.getBoolean("oracle.installer.attachHome");
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(sInventoryFileLoc);
        }
        catch (IOException e) {
            if (bIsAttachHome) {
                return;
            }
            throw e;
        }
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement elemInv = ((OiiiInstallInventory)inventory).getXMLInvUnknownElement();
        elemInv = elemInv == null ? new XMLElement("INVENTORY") : (XMLElement)elemInv.cloneNode(true);
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elemInv, pWriter);
        XMLElement elemVerInfo = new XMLElement("VERSION_INFO");
        XMLElement elemSavedWith = new XMLElement("SAVED_WITH");
        XMLText textSavedWith = new XMLText(OiicInstVersion.getInstallerVersion().getVerString());
        elemVerInfo.appendChild((Node)elemSavedWith);
        elemSavedWith.appendChild((Node)textSavedWith);
        XMLElement elemMinOUIVersion = new XMLElement("MINIMUM_VER");
        XMLText textMinOUIVersion = new XMLText(OiicInstVersion.getInventoryMinInstVersion().getVerString());
        elemVerInfo.appendChild((Node)elemMinOUIVersion);
        elemMinOUIVersion.appendChild((Node)textMinOUIVersion);
        elemVerInfo.print(pWriter);
        XMLElement elemHL = ((OiiiInstallInventory)inventory).getXMLHLUnknownElement();
        elemHL = elemHL == null ? new XMLElement("HOME_LIST") : (XMLElement)elemHL.cloneNode(true);
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elemHL, pWriter);
        for (int i = 0; i < homes.size(); ++i) {
            oHome = (OiiiOracleHomeInfo)homes.elementAt(i);
            if (!OiipgFileSystem.equalPathStrs(compositeHome, oHome.getRefCompositeHome())) continue;
            homeInfo = (OixsXMLizable)homes.elementAt(i);
            homeInfo.writeXML(pWriter);
        }
        pWriter.println("</HOME_LIST>");
        pWriter.println("<COMPOSITEHOME_LIST>");
        for (int idx = 0; idx < homes.size(); ++idx) {
            oHome = (OiiiOracleHomeInfo)homes.elementAt(idx);
            if (!oHome.isCompositeHome() || oHome.isRemoved() && oHome.getIndex() > highestValidHomeIndex || !OiipgFileSystem.equalPathStrs(compositeHome, oHome.getRefCompositeHome())) continue;
            homeInfo = (OixsXMLizable)homes.elementAt(idx);
            homeInfo.writeXML(pWriter);
        }
        pWriter.println("</COMPOSITEHOME_LIST>");
        pWriter.println("</INVENTORY>");
        pWriter.close();
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Homes ", System.currentTimeMillis() - lTime);
        }
    }

    public void writeComps(int homeIndex) throws IOException {
        OixsXMLizable comp;
        OiiiCompInvEntry invEntry;
        int i;
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallInventory inventory = this.getInstallInventory();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sCompsFileLoc = iac.getXMLCompsFileLoc(homeIndex);
        OiiiInvHomeInfo oihi = inventory.getCompOHListInfo(homeIndex);
        Vector vComps = oihi.getCompsVect();
        Hashtable hTags = oihi.getUnknownCompElementsTable();
        XMLElement elPrdList = OiiiInstallXMLWriter.getElementFromTable("PRD_LIST", hTags);
        XMLElement elTLList = OiiiInstallXMLWriter.getElementFromTable("TL_LIST", hTags);
        XMLElement elCompList = OiiiInstallXMLWriter.getElementFromTable("COMP_LIST", hTags);
        OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sCompsFileLoc)));
        boolean bIsAttachHome = Boolean.getBoolean("oracle.installer.attachHome");
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(sCompsFileLoc);
        }
        catch (IOException e) {
            if (bIsAttachHome) {
                return;
            }
            throw e;
        }
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elPrdList, pWriter);
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elTLList, pWriter);
        int nCount = vComps.size();
        for (i = 0; i < nCount; ++i) {
            invEntry = (OiiiCompInvEntry)vComps.elementAt(i);
            if (!invEntry.isTopLevel()) continue;
            comp = (OixsXMLizable)vComps.elementAt(i);
            comp.writeXML(pWriter);
        }
        pWriter.println("</TL_LIST>");
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elCompList, pWriter);
        for (i = 0; i < nCount; ++i) {
            invEntry = (OiiiCompInvEntry)vComps.elementAt(i);
            if (invEntry.isTopLevel()) continue;
            comp = (OixsXMLizable)vComps.elementAt(i);
            comp.writeXML(pWriter);
        }
        pWriter.println("</COMP_LIST>");
        inventory.writeOneoffs(homeIndex, pWriter, false);
        inventory.writeMiniPatchsets(homeIndex, pWriter, false);
        pWriter.println("</PRD_LIST>");
        pWriter.close();
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Comps for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
    }

    static void writeOneoffs(OiiiInvHomeInfo oihi, PrintWriter pWriter) throws IOException {
        Vector vOneoffs = oihi.getOneoffsVect();
        Hashtable hTags = oihi.getUnknownCompElementsTable();
        XMLElement elOneoffList = OiiiInstallXMLWriter.getElementFromTable("ONEOFF_LIST", hTags);
        if (elOneoffList == null) {
            elOneoffList = new XMLElement("ONEOFF_LIST");
        }
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elOneoffList, pWriter);
        if (vOneoffs != null) {
            int nCount = vOneoffs.size();
            for (int i = 0; i < nCount; ++i) {
                OiiiOneoffInvEntry invEntry = (OiiiOneoffInvEntry)vOneoffs.elementAt(i);
                OixsXMLizable comp = (OixsXMLizable)vOneoffs.elementAt(i);
                comp.writeXML(pWriter);
            }
        }
        pWriter.println("</ONEOFF_LIST>");
    }

    static void writeMiniPatchsets(OiiiInvHomeInfo oihi, PrintWriter pWriter) throws IOException {
        Vector vMiniPatchsets = oihi.getMiniPatchsetsVect();
        Hashtable hTags = oihi.getUnknownCompElementsTable();
        XMLElement elMiniPatchsetList = OiiiInstallXMLWriter.getElementFromTable("PATCHSET_UPDATE_LIST", hTags);
        if (elMiniPatchsetList == null) {
            elMiniPatchsetList = new XMLElement("PATCHSET_UPDATE_LIST");
        }
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elMiniPatchsetList, pWriter);
        if (vMiniPatchsets != null) {
            int nCount = vMiniPatchsets.size();
            for (int i = 0; i < nCount; ++i) {
                OiiiMiniPatchsetInvEntry invEntry = (OiiiMiniPatchsetInvEntry)vMiniPatchsets.elementAt(i);
                OixsXMLizable comp = (OixsXMLizable)vMiniPatchsets.elementAt(i);
                comp.writeXML(pWriter);
            }
        }
        pWriter.println("</PATCHSET_UPDATE_LIST>");
    }

    public void writeLibs(int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiInstallInventory inventory = this.getInstallInventory();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLibsFileLoc = iac.getXMLLibsFileLoc(homeIndex);
        OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sLibsFileLoc)));
        OiiiLibrariesInfo libsInfo = inventory.getLibsInfo(homeIndex);
        boolean bIsAttachHome = Boolean.getBoolean("oracle.installer.attachHome");
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(sLibsFileLoc);
        }
        catch (IOException e) {
            if (bIsAttachHome) {
                return;
            }
            throw e;
        }
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        Hashtable hTags = inventory.getCompOHUnknownLibElementsTable(homeIndex);
        XMLElement elLibList = OiiiInstallXMLWriter.getElementFromTable("LIB_LIST", hTags);
        XMLElement elActionList = OiiiInstallXMLWriter.getElementFromTable("ACTION_LIST", hTags);
        XMLElement elDialogList = OiiiInstallXMLWriter.getElementFromTable("DIALOG_LIST", hTags);
        XMLElement elQueryList = OiiiInstallXMLWriter.getElementFromTable("QUERY_LIST", hTags);
        OiiiInstallXMLWriter.writeNodesWithoutEndTag(elLibList, pWriter);
        int[] libTypes = new int[]{1, 2, 0};
        XMLElement[] xmlelements = new XMLElement[]{elQueryList, elDialogList, elActionList};
        for (int i = 0; i < libTypes.length; ++i) {
            Vector vLibs = libsInfo.getLibrariesOfType(libTypes[i]);
            OiiiInstallXMLWriter.writeNodesWithoutEndTag(xmlelements[i], pWriter);
            for (int j = 0; j < vLibs.size(); ++j) {
                OixsXMLizable libEntry = (OixsXMLizable)vLibs.elementAt(j);
                libEntry.writeXML(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(xmlelements[i]));
        }
        pWriter.println("</LIB_LIST>");
        pWriter.close();
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Libs for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
    }

    public void writeAll() throws IOException {
    }

    public void writeDirty() throws IOException {
    }

    private OiiiInstallInventory getInstallInventory() {
        OiiiInstallInventory inventory = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
        return inventory;
    }

    private static XMLElement getElementFromTable(String name, Hashtable tagstable) {
        if (tagstable == null) {
            return new XMLElement(name);
        }
        XMLElement el = (XMLElement)tagstable.get(name);
        if (el == null) {
            el = new XMLElement(name);
        }
        return el;
    }

    private static void writeNodesWithoutEndTag(XMLElement element, PrintWriter pWriter) throws IOException {
        String sCurrentTag = OixsXMLOps.getStartTag(element);
        pWriter.println(sCurrentTag);
        NodeList nl = element.getChildNodes();
        if (nl != null) {
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                XMLElement el = (XMLElement)nl.item(i);
                el.print(pWriter);
            }
        }
    }
}

