/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLConfigLog;
import oracle.sysman.oii.oiip.oiipg.OiipgReadRGS;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiiInventoryHelper {
    public static final int MAX_HOMENAME_LEN = 128;

    public static boolean isValidHomeName(String sName) {
        if (sName.length() > 128) {
            return false;
        }
        int length = sName.length();
        for (int i = 0; i < length; ++i) {
            char thisChar = sName.charAt(i);
            if (Character.isLetterOrDigit(thisChar) || thisChar == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isORCAHome(String sLocation) {
        boolean bORCAHome = true;
        OiipgReadRGS readRgs = new OiipgReadRGS();
        try {
            readRgs.init(sLocation);
            readRgs.doReadRgs();
        }
        catch (Exception e) {
            bORCAHome = false;
        }
        return bORCAHome;
    }

    public static void writeXMLConfigLog(int homeIndex, OiisCompInstallation ci, OiiiInstallCompInvEntry invEntry) throws IOException {
        Vector lCTDetails = ci.getProperties().getConfigToolDetails();
        if (lCTDetails == null || lCTDetails.isEmpty()) {
            return;
        }
        boolean hasCfgTool = true;
        Iterator iter = lCTDetails.iterator();
        while (iter.hasNext()) {
            String toolClassName;
            OiisConfigToolDetails toolDetails = (OiisConfigToolDetails)iter.next();
            if (!toolDetails.isCurrentPlatSupported() || !(toolClassName = toolDetails.getToolClassName()).matches("")) continue;
            hasCfgTool = false;
            break;
        }
        if (!hasCfgTool) {
            OiiolTextLogger.appendText("component has plugIns in XML: no configlog.xml written");
            return;
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        ArrayList<OiisPostInstallTool> lPostInstallTools = new ArrayList<OiisPostInstallTool>(lCTDetails.size());
        Iterator iter2 = lCTDetails.iterator();
        while (iter2.hasNext()) {
            OiisConfigToolDetails toolDetails = (OiisConfigToolDetails)iter2.next();
            if (!toolDetails.isCurrentPlatSupported()) continue;
            OiisPostInstallTool pTool = null;
            try {
                String toolClassName = toolDetails.getToolClassName();
                if (toolClassName != null) {
                    pTool = ci.getCompJarLoader().loadConfigTool(toolClassName);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (pTool == null) continue;
            pTool.setCompContext(ci.getContext());
            pTool.init();
            if (!pTool.needDeinstallLog()) continue;
            pTool.setDeinstall(true);
            lPostInstallTools.add(pTool);
        }
        if (!lPostInstallTools.isEmpty()) {
            String sConfigLogLoc = iac.getXMLConfigLogLoc(homeIndex, invEntry.getLocationInXMLInventory());
            OiiolXMLConfigLog configLog = new OiiolXMLConfigLog(sConfigLogLoc);
            Iterator iter3 = lPostInstallTools.iterator();
            while (iter3.hasNext()) {
                OiisPostInstallTool pTool = (OiisPostInstallTool)iter3.next();
                configLog.addConfigToolForLog(pTool);
            }
            configLog.writeConfigLog();
        }
    }

    static XMLElement getLocationsInfoXML(OiiiCompInvEntry entry) {
        XMLElement locs = new XMLElement("LOC_INFO");
        locs.setAttribute("INST_DFN_LOC", entry.getInstallDefnLoc());
        locs.setAttribute("JAR_NAME", entry.getJarName());
        return locs;
    }

    static XMLElement getCompJarInfoXML(OiiiCompInvEntry entry) {
        XMLElement xmlcji = new XMLElement("CMP_JAR_INFO");
        OiisCompProperties compProps = entry.getCompProperties();
        if (compProps == null) {
            return xmlcji;
        }
        OiisCompJarInfo cji = compProps.getCompJarInfo();
        if (cji == null) {
            return xmlcji;
        }
        Properties props = cji.getProperties();
        Enumeration<Object> enum_1 = props.keys();
        while (enum_1.hasMoreElements()) {
            String key = (String)enum_1.nextElement();
            boolean bGenerate = true;
            OiiiVersion origVer = entry.getOriginalStageVersion();
            bGenerate = OiiiInventoryHelper.shouldGenerateCompJarInfo(key);
            if (!bGenerate) continue;
            String value = props.getProperty(key);
            XMLElement info = new XMLElement("INFO");
            info.setAttribute("NAME", key);
            info.setAttribute("VAL", value);
            xmlcji.appendChild((Node)info);
        }
        return xmlcji;
    }

    static XMLElement getBookNameXML(OiiiCompInvEntry entry) {
        XMLElement xmlBook = new XMLElement("BOOK");
        OiisCompProperties compProps = entry.getCompProperties();
        if (compProps != null) {
            xmlBook.setAttribute("NAME", compProps.getHelpBookName());
        }
        return xmlBook;
    }

    static XMLElement getPreReqXML(OiiiCompInvEntry entry) {
        XMLElement xmlPreReq = new XMLElement("PRE_REQ");
        OiisCompProperties compProps = entry.getCompProperties();
        if (compProps != null) {
            xmlPreReq.setAttribute("DEF", compProps.isNoPreReqAvailable() ? "F" : "T");
        }
        return xmlPreReq;
    }

    static XMLElement getProdHomeXML(OiiiCompInvEntry entry) {
        XMLElement xmlProdHome = new XMLElement("PROD_HOME");
        OiisCompProperties compProps = entry.getCompProperties();
        if (compProps != null) {
            xmlProdHome.setAttribute("DEF", compProps.isNoProdHomeAvailable() ? "F" : "T");
        }
        return xmlProdHome;
    }

    static XMLElement getLangIndexMapXML(OiiiCompInvEntry entry) {
        Vector langSets;
        XMLElement xmlLangIndexMap = new XMLElement("LANG_IDX_MAP");
        OiisLangIndexMapping langIndexMap = entry.getLangIndexMapping();
        if (langIndexMap == null) {
            OiisFileSizeInfo fsi = entry.getFileSizeInfoEx();
            if (fsi == null) {
                return xmlLangIndexMap;
            }
            langIndexMap = fsi.getLangIndexMapping();
            langSets = fsi.getLangSets();
        } else {
            langSets = langIndexMap.getLangSets();
        }
        Locale[] langArr = langIndexMap.getLangs();
        if (langArr == null || langSets == null) {
            return xmlLangIndexMap;
        }
        if (langSets == null && (langSets = entry.getFileSizeInfoEx().getLangSets()) == null) {
            return xmlLangIndexMap;
        }
        StringBuffer sbLangsArr = new StringBuffer();
        for (int i = 0; i < langArr.length; ++i) {
            if (i != 0) {
                sbLangsArr.append(" ");
            }
            sbLangsArr.append(langArr[i].toString());
        }
        XMLElement xmlLang = new XMLElement("LANG");
        xmlLang.setAttribute("LIST", sbLangsArr.toString());
        xmlLangIndexMap.appendChild((Node)xmlLang);
        for (int i = 1; i < langSets.size(); ++i) {
            Object objLangSet = langSets.elementAt(i);
            if (objLangSet == null) continue;
            XMLElement xmlLangSet = new XMLElement("LANGSET");
            xmlLangSet.setAttribute("IDX", new Integer(i).toString());
            xmlLangSet.setAttribute("BITSET", ((BitSet)objLangSet).toString());
            xmlLangIndexMap.appendChild((Node)xmlLangSet);
        }
        return xmlLangIndexMap;
    }

    static XMLElement getDestIndexMapXML(OiiiCompInvEntry entry) {
        int i;
        if (entry instanceof OiiiInstallPatchSetInvEntry) {
            return null;
        }
        XMLElement xmlDestIndexMap = new XMLElement("DST_IDX_MAP");
        OiisDestinationIndexMapping destIndexMapping = entry.getDestIndexMapping();
        if (destIndexMapping == null) {
            destIndexMapping = new OiisDestinationIndexMapping();
            String[] saDests = OiisFileSizeInfo.getDefaultDestVars();
            for (i = 0; i < saDests.length; ++i) {
                destIndexMapping.addDestination(saDests[i]);
            }
            entry.setDestIndexMapping(destIndexMapping);
            if (entry.getFileSizeInfoEx() != null) {
                entry.getFileSizeInfoEx().setDestIndexMapping(destIndexMapping);
            }
        }
        StringBuffer sbDestArr = new StringBuffer();
        for (i = 0; i < destIndexMapping.size(); ++i) {
            String sDest = destIndexMapping.getDestination(i);
            if (sDest == null) continue;
            if (i != 0) {
                sbDestArr.append(" ");
            }
            sbDestArr.append(sDest);
        }
        XMLElement xmlDest = new XMLElement("DST");
        xmlDest.setAttribute("LIST", sbDestArr.toString());
        xmlDestIndexMap.appendChild((Node)xmlDest);
        return xmlDestIndexMap;
    }

    static XMLElement getPlatIndexMapXML(OiiiCompInvEntry entry) {
        Vector platSets;
        XMLElement xmlPlatIndexMap = new XMLElement("PLAT_IDX_MAP");
        OiisPlatIndexMapping platIndexMap = entry.getPlatIndexMapping();
        if (platIndexMap == null) {
            OiisFileSizeInfo fsi = entry.getFileSizeInfoEx();
            if (fsi == null) {
                return xmlPlatIndexMap;
            }
            platIndexMap = fsi.getPlatIndexMapping();
            platSets = fsi.getPlatSets();
        } else {
            platSets = platIndexMap.getPlatSets();
        }
        int[] platArr = platIndexMap.getPlats();
        if (platArr == null) {
            return xmlPlatIndexMap;
        }
        if (platSets == null && (platSets = entry.getFileSizeInfoEx().getPlatSets()) == null) {
            return xmlPlatIndexMap;
        }
        StringBuffer sbPlatsArr = new StringBuffer();
        for (int i = 0; i < platArr.length; ++i) {
            if (i != 0) {
                sbPlatsArr.append(" ");
            }
            sbPlatsArr.append(platArr[i]);
        }
        XMLElement xmlPlat = new XMLElement("PLAT");
        xmlPlat.setAttribute("LIST", sbPlatsArr.toString());
        xmlPlatIndexMap.appendChild((Node)xmlPlat);
        for (int i = 0; platSets != null && i < platSets.size(); ++i) {
            Object objPlatSet = platSets.elementAt(i);
            if (objPlatSet == null) continue;
            XMLElement xmlPlatSet = new XMLElement("PLATSET");
            xmlPlatSet.setAttribute("IDX", new Integer(i).toString());
            xmlPlatSet.setAttribute("BITSET", ((BitSet)objPlatSet).toString());
            xmlPlatIndexMap.appendChild((Node)xmlPlatSet);
        }
        return xmlPlatIndexMap;
    }

    static XMLElement getDepGroupsXML(OiisDeps deps, XMLElement elemDepGroupList) {
        XMLElement xmlDepGroupList = elemDepGroupList;
        if (xmlDepGroupList == null) {
            xmlDepGroupList = new XMLElement("DEP_GRP_LIST");
        }
        Vector depRules = deps.getDepRules();
        for (int i = 0; i < depRules.size(); ++i) {
            OiisDepRule rule = (OiisDepRule)depRules.elementAt(i);
            XMLElement xmlDepGrp = new XMLElement("DEP_GRP");
            xmlDepGrp.setAttribute("NAME", rule.getInternalName());
            xmlDepGrp.setAttribute("EXT_NAME", rule.getName(false));
            xmlDepGrp.setAttribute("TYPE", rule.getTypeString());
            XMLElement xmlDepList = new XMLElement("DEP_LIST");
            Vector vDepComps = rule.getDepCompIds();
            for (int j = 0; j < vDepComps.size(); ++j) {
                OiiiCompInstallID cid = (OiiiCompInstallID)vDepComps.elementAt(j);
                XMLElement xmlDep = new XMLElement("DEP");
                xmlDep.setAttribute("NAME", cid.getName());
                xmlDep.setAttribute("VER", cid.getVersion().getVerString());
                xmlDep.setAttribute("PLAT", OiilXMLHelper.platVect2String(cid.getPlatforms(), " "));
                if (cid.isExtDep()) {
                    xmlDep.setAttribute("EXTERNAL_DEPENDEE", "T");
                    xmlDep.setAttribute("DEPENDENT_HOME", cid.getDepHome());
                }
                xmlDepList.appendChild((Node)xmlDep);
            }
            xmlDepGrp.appendChild((Node)xmlDepList);
            xmlDepGroupList.appendChild((Node)xmlDepGrp);
        }
        return xmlDepGroupList;
    }

    private static boolean shouldGenerateCompJarInfo(String key) {
        return !key.equals("preRequisiteClass") && !key.equals("prodHomeClass") && !key.equals("resourceBundle");
    }
}

