/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiInventoryXMLHandler
extends OixsDefaultHandler {
    private Vector m_homes;
    private Hashtable m_oHomeNames;
    private OixsTextElementHandler m_handlerMinOUIVersion;
    private OixsElementHandler m_handlerInventory;
    private OixsElementHandler m_handlerHomeList;
    private OixsElementHandler m_handlerCompositeHomeList;
    private OixsElementHandler m_handlerVersionInfo;
    private OixsElementHandler m_handlerHome;
    private OixsElementHandler m_handlerCompositeHome;
    private OixsElementHandler m_handlerNodeList;
    private OixsElementHandler m_handlerSuiteList;
    private OixsElementHandler m_handlerNode;
    private OixsElementHandler m_handlerSuite;
    private OixsElementHandler m_handlerDepHomeList;
    private OixsElementHandler m_handlerDepHome;
    private OixsElementHandler m_handlerRefHomeList;
    private OixsElementHandler m_handlerRefHome;

    public Vector getHomes() {
        return this.m_homes;
    }

    public OiiiVersion getMinOUIVersion() {
        OiiiVersion version = new OiiiVersion(this.m_handlerMinOUIVersion.getText());
        return version;
    }

    public void startDocument() throws SAXException {
        this.m_homes = new Vector();
        this.m_oHomeNames = new Hashtable();
    }

    protected OixsElementHandler createElementHandlers() {
        this.m_handlerInventory = new OixsElementHandler("INVENTORY");
        this.m_handlerHomeList = new OixsElementHandler("HOME_LIST");
        this.m_handlerCompositeHomeList = new OixsElementHandler("COMPOSITEHOME_LIST");
        OixsElementHandler handlerVersionInfo = new OixsElementHandler("VERSION_INFO");
        this.m_handlerMinOUIVersion = new OixsTextElementHandler("MINIMUM_VER");
        this.m_handlerHome = new OiiiHomeElementHandler("HOME");
        this.m_handlerCompositeHome = new OiiiCompositeHomeElementHandler("COMPOSITEHOME");
        this.m_handlerNodeList = new OixsElementHandler("NODE_LIST");
        this.m_handlerNode = new OiiiNodeElementHandler("NODE", this.m_handlerHome);
        this.m_handlerSuiteList = new OixsElementHandler("SUITE_LIST");
        this.m_handlerSuite = new OiiiSuiteElementHandler("SUITE", this.m_handlerHome);
        this.m_handlerDepHomeList = new OixsElementHandler("DEPHOMELIST");
        this.m_handlerDepHome = new OiiiDepElementHandler("DEPHOME", this.m_handlerHome);
        this.m_handlerRefHomeList = new OixsElementHandler("REFHOMELIST");
        this.m_handlerRefHome = new OiiiRefElementHandler("REFHOME", this.m_handlerHome);
        this.m_handlerInventory.addChildHandler("VERSION_INFO", handlerVersionInfo);
        handlerVersionInfo.addChildHandler("MINIMUM_VER", this.m_handlerMinOUIVersion);
        this.m_handlerInventory.addChildHandler("HOME_LIST", this.m_handlerHomeList);
        this.m_handlerHomeList.addChildHandler("HOME", this.m_handlerHome);
        this.m_handlerInventory.addChildHandler("COMPOSITEHOME_LIST", this.m_handlerCompositeHomeList);
        this.m_handlerCompositeHomeList.addChildHandler("COMPOSITEHOME", this.m_handlerCompositeHome);
        this.m_handlerHome.addChildHandler("NODE_LIST", this.m_handlerNodeList);
        this.m_handlerHome.addChildHandler("SUITE_LIST", this.m_handlerSuiteList);
        this.m_handlerHome.addChildHandler("DEPHOMELIST", this.m_handlerDepHomeList);
        this.m_handlerHome.addChildHandler("REFHOMELIST", this.m_handlerRefHomeList);
        this.m_handlerNodeList.addChildHandler("NODE", this.m_handlerNode);
        this.m_handlerSuiteList.addChildHandler("SUITE", this.m_handlerSuite);
        this.m_handlerDepHomeList.addChildHandler("DEPHOME", this.m_handlerDepHome);
        this.m_handlerRefHomeList.addChildHandler("REFHOME", this.m_handlerRefHome);
        return this.m_handlerInventory;
    }

    XMLElement getUnknownInventoryElement() {
        XMLElement element = this.m_handlerInventory.getUnknownXMLElement();
        if (!OixsXMLOps.isEmpty(element)) {
            return element;
        }
        return null;
    }

    XMLElement getUnknownHomeListElement() {
        XMLElement element = this.m_handlerHomeList.getUnknownXMLElement();
        if (!OixsXMLOps.isEmpty(element)) {
            return element;
        }
        return null;
    }

    private class OiiiSuiteElementHandler
    extends OixsElementHandler {
        OiiiHomeElementHandler m_homeElementHandler;

        public OiiiSuiteElementHandler(String name, OixsElementHandler homeElementHandler) {
            super(name);
            this.m_homeElementHandler = (OiiiHomeElementHandler)homeElementHandler;
        }

        public void onStart(String name, AttributeList atts) {
            String suite = atts.getValue("NAME");
            OiiiOracleHomeInfo curHome = this.m_homeElementHandler.getCurrentHome();
            curHome.addSuite(suite);
        }
    }

    private class OiiiRefElementHandler
    extends OixsElementHandler {
        OiiiHomeElementHandler m_homeElementHandler;

        public OiiiRefElementHandler(String name, OixsElementHandler homeElementHandler) {
            super(name);
            this.m_homeElementHandler = (OiiiHomeElementHandler)homeElementHandler;
        }

        public void onStart(String name, AttributeList atts) {
            String homeLoc = atts.getValue("LOC");
            OiiiOracleHomeInfo curHome = this.m_homeElementHandler.getCurrentHome();
            curHome.addRefHome(homeLoc);
        }
    }

    private class OiiiDepElementHandler
    extends OixsElementHandler {
        OiiiHomeElementHandler m_homeElementHandler;

        public OiiiDepElementHandler(String name, OixsElementHandler homeElementHandler) {
            super(name);
            this.m_homeElementHandler = (OiiiHomeElementHandler)homeElementHandler;
        }

        public void onStart(String name, AttributeList atts) {
            String homeLoc = atts.getValue("LOC");
            OiiiOracleHomeInfo curHome = this.m_homeElementHandler.getCurrentHome();
            curHome.addDepHome(homeLoc);
        }
    }

    private class OiiiNodeElementHandler
    extends OixsElementHandler {
        OiiiHomeElementHandler m_homeElementHandler;

        public OiiiNodeElementHandler(String name, OixsElementHandler homeElementHandler) {
            super(name);
            this.m_homeElementHandler = (OiiiHomeElementHandler)homeElementHandler;
        }

        public void onStart(String name, AttributeList atts) {
            String clusterNode = atts.getValue("NAME");
            OiiiOracleHomeInfo curHome = this.m_homeElementHandler.getCurrentHome();
            curHome.addNode(clusterNode);
        }
    }

    private class OiiiCompositeHomeElementHandler
    extends OixsElementHandler {
        OiiiOracleHomeInfo m_curHomeInfo;

        public OiiiCompositeHomeElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String sHomeLoc = atts.getValue("LOC");
            String sHomeTypeName = atts.getValue("TYPE");
            int nHomeType = 4;
            this.m_curHomeInfo = new OiiiOracleHomeInfo(-1, sHomeLoc, nHomeType);
            this.m_curHomeInfo.setName(sHomeTypeName);
            this.m_curHomeInfo.setCompositeHomeTypeName(sHomeTypeName);
            String sRemoved = atts.getValue("REMOVED");
            if (sRemoved != null && sRemoved.equalsIgnoreCase("T")) {
                this.m_curHomeInfo.setRemoved(true);
            }
            OiiiInventoryXMLHandler.this.m_homes.addElement(this.m_curHomeInfo);
            this.m_curHomeInfo.setStoredInInv(true);
            XMLElement xmlHomeElement = new XMLElement("COMPOSITEHOME");
        }

        public void onEnd(String name) {
            XMLElement el;
            if (this.m_curHomeInfo != null && !OixsXMLOps.isEmpty(el = this.getUnknownXMLElement())) {
                this.m_curHomeInfo.setUnknownXMLElement(el);
            }
        }

        public OiiiOracleHomeInfo getCurrentHome() {
            return this.m_curHomeInfo;
        }
    }

    private class OiiiHomeElementHandler
    extends OixsElementHandler {
        OiiiOracleHomeInfo m_curHomeInfo;

        public OiiiHomeElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String sPluginHome;
            String sHomeName = atts.getValue("NAME");
            String sHomeLoc = atts.getValue("LOC");
            String sHomeType = atts.getValue("TYPE");
            int nHomeType = 0;
            String sCRSHome = atts.getValue("CRS");
            if (sHomeType.equals("A")) {
                nHomeType = 1;
            } else if (sHomeType == "V") {
                nHomeType = 2;
            }
            String sHomeIndex = atts.getValue("IDX");
            int nHomeIndex = -1;
            try {
                nHomeIndex = Integer.parseInt(sHomeIndex);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            boolean clearNodes = true;
            this.m_curHomeInfo = new OiiiOracleHomeInfo(nHomeIndex, sHomeLoc, nHomeType, clearNodes);
            this.m_curHomeInfo.setName(sHomeName);
            if (System.getProperty("oracle.installer.bigCluster", "false").equalsIgnoreCase("true")) {
                this.m_curHomeInfo.setNodeListBigCluster(OiixVectorOps.vect2StrArr(this.m_curHomeInfo.getNodeListBigCluster()));
            }
            if (sCRSHome != null) {
                if (sCRSHome.equalsIgnoreCase("true")) {
                    this.m_curHomeInfo.setCRSHome(true);
                } else {
                    this.m_curHomeInfo.setCRSHome(false);
                }
            }
            String sHomeNameLowerCase = sHomeName.toLowerCase();
            if (OiiiInventoryXMLHandler.this.m_oHomeNames.containsKey(sHomeNameLowerCase)) {
                this.m_curHomeInfo.setDuplicateHomeName(true);
            } else {
                OiiiInventoryXMLHandler.this.m_oHomeNames.put(sHomeNameLowerCase, this.m_curHomeInfo);
            }
            String sRemoved = atts.getValue("REMOVED");
            if (sRemoved != null && sRemoved.equalsIgnoreCase("T")) {
                this.m_curHomeInfo.setRemoved(true);
            }
            if ((sPluginHome = atts.getValue("PLUGIN")) != null && sPluginHome.equalsIgnoreCase("T")) {
                this.m_curHomeInfo.setPluginHome(true);
            }
            OiiiInventoryXMLHandler.this.m_homes.addElement(this.m_curHomeInfo);
            this.m_curHomeInfo.setStoredInInv(true);
            XMLElement xmlHomeElement = new XMLElement("HOME");
        }

        public void onEnd(String name) {
            XMLElement el;
            if (this.m_curHomeInfo != null && !OixsXMLOps.isEmpty(el = this.getUnknownXMLElement())) {
                this.m_curHomeInfo.setUnknownXMLElement(el);
            }
        }

        public OiiiOracleHomeInfo getCurrentHome() {
            return this.m_curHomeInfo;
        }
    }
}

