/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryHelper;
import oracle.sysman.oii.oiii.OiiiInventoryWriter;
import oracle.sysman.oii.oiii.OiiiLibsXMLWriter;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixEnumException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;

abstract class OiiiInventoryXMLWriter41
implements OiiiInventoryWriter {
    protected OiiiAreaInventory m_inventory = null;
    protected String m_invLoc = null;

    OiiiInventoryXMLWriter41(String invLoc) {
        String loc = invLoc;
        if (!new File(invLoc).isDirectory()) {
            loc = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(invLoc));
        }
        this.m_invLoc = loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeComps(int nHomeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        XMLElement elPrdList = this.getPrdListXMLElement();
        XMLElement elTLList = new XMLElement("TL_LIST");
        XMLElement elCompList = new XMLElement("COMP_LIST");
        OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(this.m_invLoc)));
        String outFile = OiixPathOps.concatPath(this.m_invLoc, this.getCompsFileName());
        FileWriter fWriter = new FileWriter(outFile);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        try {
            OiiiCompInvEntry invEntry;
            int i;
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            pWriter.println(OixsXMLOps.getStartTag(elPrdList));
            pWriter.println(OixsXMLOps.getStartTag(elTLList));
            int idx = nHomeIndex;
            if (nHomeIndex == -1) {
                idx = 0;
            }
            Vector vComps = this.m_inventory.getAllCompsVect(idx);
            int nCount = vComps.size();
            for (i = 0; i < nCount; ++i) {
                invEntry = (OiiiCompInvEntry)vComps.elementAt(i);
                if (!invEntry.isTopLevel()) continue;
                XMLElement xmlTLComp = this.getCompXMLElement(invEntry);
                xmlTLComp.print(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(elTLList));
            pWriter.println(OixsXMLOps.getStartTag(elCompList));
            for (i = 0; i < nCount; ++i) {
                invEntry = (OiiiCompInvEntry)vComps.elementAt(i);
                if (invEntry.isTopLevel()) continue;
                XMLElement xmlNONTLComp = this.getCompXMLElement(invEntry);
                xmlNONTLComp.print(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(elCompList));
            this.writeOneoffs(nHomeIndex, pWriter, false);
            pWriter.println(OixsXMLOps.getEndTag(elPrdList));
            Object var18_16 = null;
            pWriter.close();
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            pWriter.close();
            bWriter.close();
            fWriter.close();
            throw throwable;
        }
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Comps for Inventory ", System.currentTimeMillis() - lTime);
        }
    }

    protected XMLElement getPrdListXMLElement() {
        XMLElement elPrdList = new XMLElement("PRD_LIST");
        elPrdList.setAttribute("XML_VER", "4.1");
        return elPrdList;
    }

    protected XMLElement getCompXMLElement(OiiiCompInvEntry entry) {
        OiiiCompInstallID cid = entry.getCompInstallID();
        if (cid == null) {
            return new XMLElement("COMP");
        }
        XMLElement elemComp = new XMLElement(this.getCompTypeString(cid));
        elemComp.setAttribute("NAME", cid.getName());
        elemComp.setAttribute("VER", cid.getVersion().getVerString());
        elemComp.setAttribute("BUILD_NUMBER", Integer.toString(cid.getVersion().getBuildNumber()));
        if (!this.isPatchset(entry)) {
            elemComp.setAttribute("REP_VER", cid.getReplaceVersion().getVerString());
            String sRelName = "";
            try {
                sRelName = OiiiReleaseLevels.getReleaseLevelName(cid.getReleaseLevel());
            }
            catch (OiixEnumException e) {
                // empty catch block
            }
            elemComp.setAttribute("RELEASE", sRelName);
            elemComp.setAttribute("INV_LOC", entry.getLocation());
            elemComp.setAttribute("LANGS", OiixLanguage.vectToStr(entry.getLanguages()));
            if (!entry.isClonable()) {
                elemComp.setAttribute("CLONABLE", "F");
            }
        }
        XMLElement elemExtName = new XMLElement("EXT_NAME");
        elemExtName.appendChild((Node)new XMLText(entry.getName(false)));
        XMLElement elemDescID = new XMLElement("DESCID");
        elemDescID.appendChild((Node)new XMLText(entry.getDescResourceId()));
        elemComp.appendChild((Node)elemExtName);
        elemComp.appendChild((Node)elemDescID);
        return elemComp;
    }

    protected XMLElement getCompJarInfoXML(OiiiCompInvEntry entry) {
        XMLElement xmlcji = OiiiInventoryHelper.getCompJarInfoXML(entry);
        return xmlcji;
    }

    protected XMLElement getPlatIndexMapXML(OiiiCompInvEntry entry) {
        XMLElement xmlPlatIndexMap = OiiiInventoryHelper.getPlatIndexMapXML(entry);
        return xmlPlatIndexMap;
    }

    protected XMLElement getLangIndexMapXML(OiiiCompInvEntry entry) {
        XMLElement xmlLangIndexMap = OiiiInventoryHelper.getLangIndexMapXML(entry);
        return xmlLangIndexMap;
    }

    protected XMLElement getDestIndexMapXML(OiiiCompInvEntry entry) {
        XMLElement xmlDestIndexMap = OiiiInventoryHelper.getDestIndexMapXML(entry);
        return xmlDestIndexMap;
    }

    protected XMLElement getPreReqXML(OiiiCompInvEntry entry) {
        XMLElement xmlPreReq = OiiiInventoryHelper.getPreReqXML(entry);
        return xmlPreReq;
    }

    protected XMLElement getProdHomeXML(OiiiCompInvEntry entry) {
        XMLElement xmlProdHome = OiiiInventoryHelper.getProdHomeXML(entry);
        return xmlProdHome;
    }

    protected XMLElement getBookNameXML(OiiiCompInvEntry entry) {
        XMLElement xmlBook = OiiiInventoryHelper.getBookNameXML(entry);
        return xmlBook;
    }

    protected XMLElement getLocationsInfoXML(OiiiCompInvEntry entry) {
        XMLElement locs = OiiiInventoryHelper.getLocationsInfoXML(entry);
        return locs;
    }

    private String getCompTypeString(OiiiCompInstallID id) {
        if (id.getCompType() == 4) {
            return "PATCHSET";
        }
        if (id.getCompType() == 2) {
            return "PATCH";
        }
        return "COMP";
    }

    protected boolean isPatch(OiiiCompInvEntry entry) {
        OiiiCompInstallID id = entry.getCompInstallID();
        if (id != null) {
            return id.getCompType() == 2;
        }
        return false;
    }

    protected boolean isPatchset(OiiiCompInvEntry entry) {
        OiiiCompInstallID id = entry.getCompInstallID();
        if (id != null) {
            return id.getCompType() == 4;
        }
        return false;
    }

    protected XMLElement getPatchSetPatchesXML(OiiiPatchInstallID pid) {
        XMLElement ps_patch = new XMLElement("PS_PAT");
        ps_patch.setAttribute("NAME", pid.getName());
        ps_patch.setAttribute("VER", pid.getVersion().getVerString());
        ps_patch.setAttribute("BASE_VER", pid.getBaseVersion().getVerString());
        return ps_patch;
    }

    public void writeLibs(int homeIndex) throws IOException {
        OiiiLibsXMLWriter lw = OiiiLibsXMLWriter.getWriter();
        String xmlFileName = OiixPathOps.concatPath(this.m_invLoc, "libs.xml");
        lw.writeLibs(this.m_inventory, xmlFileName, homeIndex);
    }

    public static XMLElement getElementFromTable(String name, Hashtable tagstable) {
        if (tagstable == null) {
            return new XMLElement(name);
        }
        XMLElement el = (XMLElement)tagstable.get(name);
        if (el == null) {
            el = new XMLElement(name);
        }
        return el;
    }

    void writeInvDetails() throws IOException {
        Properties prop = new Properties();
        prop.setProperty("XML_VER", "4.1");
        prop.setProperty("CompsXML", "products.xml");
        prop.setProperty("configXML", "config.xml");
        prop.setProperty("LibsXML", "libs.xml");
        prop.setProperty("SHPropsXML", "shiphomeproperties.xml");
        prop.setProperty("OUIConfigVarXML", "OuiConfigVariables.xml");
        String outFile = OiixPathOps.concatPath(this.m_invLoc, "invDetails.properties");
        FileOutputStream fos = new FileOutputStream(outFile);
        prop.save(fos, "invDetails.properties");
        fos.flush();
        fos.close();
    }

    abstract void writeOneoffs(int var1, PrintWriter var2, boolean var3);

    abstract String getJarContentsLoc(OiiiCompInvEntry var1);

    abstract String getCompsFileName();
}

