/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersioned;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.xml.parser.v2.XMLElement;

public class OiiiLibraryID
implements Serializable,
OiiiVersioned {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    static final long serialVersionUID = 5016176111182551360L;
    private String m_name;
    private OiiiVersion m_version;
    private OiiiVersion m_replaceVer;
    private Vector m_platforms;
    private OiiiVersion m_InstVer;
    private static transient boolean s_bShouldOptimize = false;

    public OiiiLibraryID() {
    }

    public OiiiLibraryID(String name, OiiiVersion version, Vector platforms, OiiiVersion replaceVer) {
        this.m_name = name;
        this.m_version = version;
        this.m_platforms = platforms;
        this.m_replaceVer = replaceVer;
    }

    public OiiiVersion getInstVer() {
        if (this.m_InstVer != null) {
            return this.m_InstVer;
        }
        return new OiiiVersion("1.5.0.0.0");
    }

    public void setInstVer(OiiiVersion instVer) {
        this.m_InstVer = instVer;
    }

    public void setInstVer(String instVer) {
        this.m_InstVer = new OiiiVersion(instVer);
    }

    public String getName() {
        return this.m_name;
    }

    public OiiiVersion getVersion() {
        return this.m_version;
    }

    public OiiiVersion getReplaceVersion() {
        return this.m_replaceVer;
    }

    public Vector getPlatforms() {
        return this.m_platforms;
    }

    public boolean forPlatform(String platform) {
        return this.m_platforms.contains(platform);
    }

    public boolean forPlatform(Integer platform) {
        return this.m_platforms.contains(platform);
    }

    public boolean forPlatform(int platform) {
        return this.forPlatform(new Integer(platform));
    }

    public boolean replaces(OiiiLibraryID lid) {
        if (lid != null) {
            return !this.equals(lid) && this.m_name.equals(lid.getName()) && !this.m_replaceVer.laterThan(lid.getVersion()) && !lid.getVersion().laterThan(this.m_version) && OiixVectorOps.vectorSubset(lid.getPlatforms(), this.m_platforms);
        }
        return false;
    }

    public boolean equals(OiiiLibraryID lid) {
        if (lid != null) {
            return this.m_name.equals(lid.getName()) && this.m_version.equals(lid.getVersion()) && this.m_replaceVer.equals(lid.getReplaceVersion()) && OiixVectorOps.vectorsEqual(this.m_platforms, lid.getPlatforms());
        }
        return false;
    }

    public boolean equalsWithMinInstallerVer(OiiiLibraryID lid) {
        if (lid != null) {
            return this.m_name.equals(lid.getName()) && this.m_version.equals(lid.getVersion()) && this.m_replaceVer.equals(lid.getReplaceVersion()) && this.m_InstVer.equals(lid.getInstVer()) && OiixVectorOps.vectorsEqual(this.m_platforms, lid.getPlatforms());
        }
        return false;
    }

    public boolean equalsWithMinPlatSet(OiiiLibraryID lid) {
        if (lid != null) {
            return this.m_name.equals(lid.getName()) && this.m_version.equals(lid.getVersion()) && this.m_replaceVer.equals(lid.getReplaceVersion()) && OiixVectorOps.vectorSubset(lid.getPlatforms(), this.m_platforms);
        }
        return false;
    }

    public boolean equals(String name) {
        return this.m_name.equals(name);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OiiiLibraryID) {
                return this.equals((OiiiLibraryID)obj);
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        StringBuffer platStr = new StringBuffer();
        Enumeration plats = this.m_platforms.elements();
        while (plats.hasMoreElements()) {
            platStr.append((Integer)plats.nextElement() + " ");
        }
        return this.m_name + ", " + this.m_version.toString() + ", >" + this.m_replaceVer.toString() + ", [ " + platStr + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isCompatible(OiiiLibraryID lid) {
        return this.equals(lid) || this.replaces(lid);
    }

    public void optimizePlatList() {
        if (s_bShouldOptimize) {
            this.m_platforms = OiixPlatform.getOptimizedPlatformVector(this.getPlatforms());
        }
    }

    public static void setShouldOptimize(boolean bShouldOptimize) {
        s_bShouldOptimize = bShouldOptimize;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.m_InstVer == null) {
            this.m_InstVer = new OiiiVersion("1.5.0.0.0");
        }
    }

    public XMLElement createXMLElement(String sLibType) {
        XMLElement xmlLid = new XMLElement("LIBRARY");
        xmlLid.setAttribute("NAME", this.m_name);
        xmlLid.setAttribute("XMLFORMAT_VER", "1.0");
        xmlLid.setAttribute("TYPE", sLibType);
        xmlLid.setAttribute("VER", this.getVersion().getVerString());
        xmlLid.setAttribute("REPL_VER", this.getReplaceVersion().getVerString());
        xmlLid.setAttribute("MIN_INST_VER", this.getInstVer().getVerString());
        int[] plats = OiixVectorOps.vect2IntArr(this.m_platforms);
        if (plats != null && !OiilXMLHelper.arePlatsSame(plats, OiixPlatform.getPlatforms()) && plats.length != 0) {
            xmlLid.setAttribute("PLAT", OiilXMLHelper.platArrToString(plats));
        }
        return xmlLid;
    }
}

