/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryXMLWriter41;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;

class OiiiLibsXMLWriter {
    private static OiiiLibsXMLWriter m_writer = null;

    private OiiiLibsXMLWriter() {
    }

    static OiiiLibsXMLWriter getWriter() {
        if (m_writer == null) {
            m_writer = new OiiiLibsXMLWriter();
        }
        return m_writer;
    }

    void writeLibs(OiiiAreaInventory inventory, String sLibsFileLoc, int homeIndex) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        FileWriter fWriter = new FileWriter(sLibsFileLoc);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        int idx = homeIndex;
        boolean bStageSession = false;
        if (homeIndex == -1) {
            bStageSession = true;
            idx = 0;
        }
        Hashtable hTags = inventory.getCompOHUnknownLibElementsTable(idx);
        XMLElement elLibList = OiiiInventoryXMLWriter41.getElementFromTable("LIB_LIST", hTags);
        XMLElement elActionList = OiiiInventoryXMLWriter41.getElementFromTable("ACTION_LIST", hTags);
        XMLElement elDialogList = OiiiInventoryXMLWriter41.getElementFromTable("DIALOG_LIST", hTags);
        XMLElement elQueryList = OiiiInventoryXMLWriter41.getElementFromTable("QUERY_LIST", hTags);
        pWriter.println(OixsXMLOps.getStartTag(elLibList));
        int[] libTypes = new int[]{1, 2, 0};
        XMLElement[] xmlelements = new XMLElement[]{elQueryList, elDialogList, elActionList};
        for (int i = 0; i < libTypes.length; ++i) {
            Vector vLibs;
            if (bStageSession) {
                vLibs = inventory.getAllLibsVect(libTypes[i]);
            } else {
                OiiiLibrariesInfo libsInfo = ((OiiiInstallInventory)inventory).getLibsInfo(homeIndex);
                vLibs = libsInfo.getLibrariesOfType(libTypes[i]);
            }
            pWriter.println(OixsXMLOps.getStartTag(xmlelements[i]));
            for (int j = 0; j < vLibs.size(); ++j) {
                OiiiLibInvEntry libEntry = (OiiiLibInvEntry)vLibs.elementAt(j);
                XMLElement xmlLibEntry = this.getLibEntryXML(libEntry, bStageSession);
                xmlLibEntry.print(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(xmlelements[i]));
        }
        pWriter.println(OixsXMLOps.getEndTag(elLibList));
        pWriter.close();
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Libs for Home " + homeIndex, System.currentTimeMillis() - lTime);
        }
    }

    private XMLElement getLibEntryXML(OiiiLibInvEntry libEntry, boolean bStageSession) {
        XMLElement elemLib = libEntry.getUnknownXMLElement();
        elemLib = elemLib == null || bStageSession ? new XMLElement("LIB") : (XMLElement)elemLib.cloneNode(true);
        OiiiLibraryID lid = libEntry.getLibraryID();
        elemLib.setAttribute("NAME", lid.getName());
        elemLib.setAttribute("VER", lid.getVersion().getVerString());
        elemLib.setAttribute("REP_VER", lid.getReplaceVersion().getVerString());
        elemLib.setAttribute("MIN_INST_VER", lid.getInstVer().getVerString());
        elemLib.setAttribute("INV_LOC", libEntry.getLocation());
        if (bStageSession) {
            elemLib.setAttribute("PLAT", OiilXMLHelper.platVect2String(lid.getPlatforms(), " "));
        }
        return elemLib;
    }
}

