/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;

public class OiiiOneoffFile
implements OixsXMLizable {
    private String m_parentPath;
    private String m_childFile;
    private boolean m_bComposite;
    private XMLElement m_unknownXMLElement;

    public OiiiOneoffFile(String sParentPath) {
        this.m_parentPath = sParentPath;
    }

    public OiiiOneoffFile(String sParentPath, String sChildFile) {
        this(sParentPath);
        this.m_childFile = sChildFile;
        if (this.m_childFile != null && !this.m_childFile.equals("")) {
            this.m_bComposite = true;
        }
    }

    public String getParentPath() {
        return this.m_parentPath;
    }

    public String getChildFile() {
        return this.m_childFile;
    }

    public boolean isCompositeFile() {
        return this.m_bComposite;
    }

    void setUnknownXMLElement(XMLElement unknownXMLElement) {
        this.m_unknownXMLElement = unknownXMLElement;
    }

    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    public void writeXML(PrintWriter out) throws IOException {
        XMLElement element = this.buildDOMTree();
        element.print(out);
    }

    private XMLElement buildDOMTree() {
        XMLElement element = this.m_unknownXMLElement;
        element = element == null ? new XMLElement("FILE") : (XMLElement)this.m_unknownXMLElement.cloneNode(true);
        element.setAttribute("PARENT_PATH", this.getParentPath());
        if (this.isCompositeFile()) {
            element.setAttribute("CHILD_PATH", this.getChildFile());
        }
        return element;
    }

    public boolean equals(OiiiOneoffFile oFile) {
        boolean bRet = false;
        String sParent = oFile.getParentPath();
        String sChild = oFile.getChildFile();
        if (sParent != null && this.m_parentPath != null && this.m_parentPath.equals(sParent)) {
            if (sChild == null || sChild.equals("")) {
                if (this.m_childFile == null || this.m_childFile.equals("")) {
                    bRet = true;
                }
            } else {
                bRet = this.m_childFile != null && this.m_childFile.equals(sChild);
            }
        }
        return bRet;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof OiiiOneoffFile) {
            return this.equals((OiiiOneoffFile)obj);
        }
        return false;
    }
}

