/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiOneoffInvEntry {
    private OiiiOneoffInstallID m_oId;
    private String m_sDescription;
    private Vector m_vBaseComps;
    private Vector m_vBugList;
    private Vector m_vPrereqList;
    private Properties additionalProperties = null;
    private Vector m_vSupersedesList;
    private Vector m_vSupersededByList;
    private boolean m_bRollback;
    private Vector m_vLangs;
    private String m_uniqID;

    public OiiiOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, String sDescription) {
        this(oneoffId, bugList, bRollback, sDescription, new Vector());
    }

    public OiiiOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, String sDescription, Vector preReqList) {
        this(oneoffId, bugList, bRollback, sDescription, preReqList, new Vector());
    }

    public OiiiOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, String sDescription, Vector preReqList, Vector langs) {
        this(oneoffId, bugList, bRollback, sDescription, preReqList, new Vector(), null);
    }

    public OiiiOneoffInvEntry(String oneoffId, Vector bugList, boolean bRollback, String sDescription, Vector preReqList, Vector langs, String uniqID) {
        this.m_oId = new OiiiOneoffInstallID(oneoffId);
        this.m_vBugList = bugList;
        this.m_bRollback = bRollback;
        this.m_vBaseComps = new Vector(2);
        this.m_sDescription = sDescription;
        this.m_vPrereqList = preReqList;
        this.m_vLangs = langs;
        this.m_uniqID = uniqID;
    }

    public Vector getLangs() {
        return this.m_vLangs;
    }

    public void setLangs(Vector langs) {
        this.m_vLangs = langs;
    }

    public String getUniqID() {
        return this.m_uniqID;
    }

    public void setUniqID(String uniqid) {
        this.m_uniqID = uniqid;
    }

    public Vector getBaseComps() {
        return this.m_vBaseComps;
    }

    public Vector getCompatBaseComps() {
        return this.getCompatCompOhVect(this.m_vBaseComps);
    }

    protected Vector getCompatCompOhVect(Vector vCompOhs) {
        if (vCompOhs == null) {
            return null;
        }
        Vector vCompOhsClone = (Vector)vCompOhs.clone();
        int nComps = vCompOhs.size();
        Vector<OiiiCompIdOhPair> vCompatCompOhs = new Vector<OiiiCompIdOhPair>(nComps);
        for (int i = 0; i < nComps; ++i) {
            OiiiCompIdOhPair ciop = (OiiiCompIdOhPair)vCompOhsClone.elementAt(i);
            if (ciop == null) continue;
            OiiiCompInstallID cid = ciop.getCompID();
            for (int j = i + 1; j < nComps; ++j) {
                OiiiCompIdOhPair ciop2 = (OiiiCompIdOhPair)vCompOhsClone.elementAt(j);
                if (ciop2 == null) continue;
                OiiiCompInstallID cid2 = ciop2.getCompID();
                if (cid2.canReplace(cid)) {
                    vCompOhsClone.setElementAt(null, j);
                    ciop = ciop2;
                    continue;
                }
                if (!cid.canReplace(cid2)) continue;
                vCompOhsClone.setElementAt(null, j);
            }
            vCompatCompOhs.addElement(ciop);
        }
        return vCompatCompOhs;
    }

    public Vector getBugs() {
        return this.m_vBugList;
    }

    public Vector getPrereqs() {
        return this.m_vPrereqList;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public OiiiOneoffInstallID getID() {
        return this.m_oId;
    }

    public boolean isRollbackable() {
        return this.m_bRollback;
    }

    public Vector getSupersededOneOffsList() {
        return this.m_vSupersedesList;
    }

    public Vector getSupersededByOneOffsList() {
        return this.m_vSupersededByList;
    }

    public boolean isComponentPatched(OiiiCompInstallID compID) {
        OiiiCompIdOhPair ocp;
        OiiiCompInstallID oid;
        if (this.m_vBaseComps == null || this.m_vBaseComps.size() == 0 || compID == null) {
            return false;
        }
        int iSize = this.m_vBaseComps.size();
        boolean bRetVal = false;
        for (int i = 0; i < iSize && !(bRetVal = (oid = (ocp = (OiiiCompIdOhPair)this.m_vBaseComps.elementAt(i)).getCompID()).equals(compID, true)); ++i) {
        }
        return bRetVal;
    }

    public boolean isComponentPatched(String compName, String compVersion) {
        if (this.m_vBaseComps == null || this.m_vBaseComps.size() == 0) {
            return false;
        }
        int iSize = this.m_vBaseComps.size();
        boolean bRetVal = false;
        for (int i = 0; i < iSize; ++i) {
            OiiiCompIdOhPair ocp = (OiiiCompIdOhPair)this.m_vBaseComps.elementAt(i);
            OiiiCompInstallID oid = ocp.getCompID();
            String sName = oid.getName();
            String sVersion = oid.getVersion().toString();
            boolean bl = bRetVal = sName.equals(compName) && sVersion.equals(compVersion);
            if (bRetVal) break;
        }
        return bRetVal;
    }

    public boolean anyBugsPatched(Vector bugFixes) {
        if (this.m_vBugList == null || this.m_vBugList.size() == 0 || bugFixes == null) {
            return false;
        }
        return OiixVectorOps.checkIntersection(this.m_vBugList, bugFixes);
    }

    public boolean isBugsSuperset(Vector bugFixes) {
        int iFixesSize;
        if (this.m_vBugList == null || this.m_vBugList.size() == 0) {
            return true;
        }
        if (bugFixes == null || bugFixes.size() == 0) {
            return false;
        }
        int iCurrentSize = this.m_vBugList.size();
        if (iCurrentSize >= (iFixesSize = bugFixes.size())) {
            return false;
        }
        return OiixVectorOps.vectorSubset(this.m_vBugList, bugFixes);
    }

    public boolean bugsHaveConflicts(Vector bugFixes) {
        boolean bHasConflicts = false;
        if (this.anyBugsPatched(bugFixes) && !this.isBugsSuperset(bugFixes)) {
            bHasConflicts = true;
        }
        return bHasConflicts;
    }

    public void setDescription(String description) {
        this.m_sDescription = description;
    }

    public void setBaseComps(Vector baseComps) {
        this.m_vBaseComps = baseComps;
    }

    public void addBaseComp(OiiiCompIdOhPair oPair) {
        int idx = OiixVectorOps.vectIndexOf(this.m_vBaseComps, (Object)oPair);
        if (idx == -1) {
            this.m_vBaseComps.addElement(oPair);
        }
    }

    public void setBugList(Vector bugList) {
        this.m_vBugList = bugList;
    }

    public void setPrereqList(Vector prereqList) {
        this.m_vPrereqList = prereqList;
    }

    public void setSupersededOneOffsList(Vector vList) {
        this.m_vSupersedesList = (Vector)vList.clone();
    }

    void setSupersededByOneOffsList(Vector vList) {
        this.m_vSupersededByList = vList;
    }

    private void setOneoffID(OiiiOneoffInstallID oId) {
        this.m_oId = oId;
    }

    private void setRollbackable(boolean bRollback) {
        this.m_bRollback = bRollback;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAdditionalProperty(String name) {
        if (this.additionalProperties != null) {
            return this.additionalProperties.getProperty(name);
        }
        return null;
    }

    public void setAdditionalProperty(String name, String value) {
        if (name != null && value != null) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new Properties();
            }
            this.additionalProperties.setProperty(name, value);
        }
    }

    public void setPropertyList(Properties addProps) {
        this.additionalProperties = addProps;
    }

    public Object clone() {
        OiiiOneoffInvEntry oClone = null;
        try {
            oClone = (OiiiOneoffInvEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        oClone.setOneoffID((OiiiOneoffInstallID)this.m_oId.clone());
        oClone.setBaseComps((Vector)this.m_vBaseComps.clone());
        oClone.setBugList((Vector)this.m_vBugList.clone());
        oClone.setDescription(this.getDescription());
        oClone.setRollbackable(this.isRollbackable());
        return oClone;
    }

    public boolean primaryKeyMatches(OiiiOneoffInvEntry invEntry) {
        if (!this.m_oId.equals(invEntry.getID())) {
            return false;
        }
        if (this.m_uniqID != null && !this.m_uniqID.equals(invEntry.getUniqID()) || this.m_uniqID == null && invEntry.getUniqID() != null) {
            return false;
        }
        return OiixVectorOps.vectorsEqual(this.m_vLangs, invEntry.getLangs());
    }

    public boolean equals(OiiiOneoffInvEntry invEntry) {
        if (super.equals(invEntry)) {
            return true;
        }
        if (!this.m_oId.equals(invEntry.getID())) {
            return false;
        }
        if (this.m_uniqID != null && !this.m_uniqID.equals(invEntry.getUniqID()) || this.m_uniqID == null && invEntry.getUniqID() != null) {
            return false;
        }
        if (!OiixVectorOps.vectorsEqual(this.m_vLangs, invEntry.getLangs())) {
            return false;
        }
        if (!OiixVectorOps.vectorsEqual(this.m_vBaseComps, invEntry.getBaseComps())) {
            return false;
        }
        if (!OiixVectorOps.vectorsEqual(this.m_vBugList, invEntry.getBugs())) {
            return false;
        }
        return OiixVectorOps.vectorsEqual(this.m_vPrereqList, invEntry.getPrereqs());
    }
}

