/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class OiiiOneoffPatchActions {
    private String m_sOracleHome;
    private String m_sOneoffPath;
    private OiiiOracleHomeInfo m_sHomeInfo;
    private static final String INVENTORY = "inventory";
    private static final String ONEOFFS = "oneoffs";
    private static final String COPY_ACTION = "copy";
    private static final String JAR_ACTION = "jar";
    private static final String ARCHIVE_ACTION = "archive";
    private static final String ACTION_NAME = "name";
    private static final String ACTION_PATH = "path";
    private static final String FILE_NAME = "file_name";
    private static final String CLASS_NAME = "class_name";
    private static final String OBJECT_NAME = "object_name";
    private static final String ETC = "etc";
    private static final String CONFIG = "config";
    private static final String ACTIONS_FILENAME = "actions.xml";

    public OiiiOneoffPatchActions(OiiiOracleHomeInfo homeInfo, String oracleHomePath, String oneoffID) {
        if (oracleHomePath != null && oracleHomePath != "") {
            this.m_sOracleHome = oracleHomePath;
            this.m_sOneoffPath = oracleHomePath + File.separator + INVENTORY + File.separator + ONEOFFS + File.separator + oneoffID;
            this.m_sHomeInfo = homeInfo;
        }
    }

    public Vector getFilesPatched() throws Exception, RuntimeException {
        if (this.m_sOneoffPath == null || this.m_sOneoffPath == "") {
            throw new RuntimeException("OneoffPath is empty, cannot locate 'actions' file.");
        }
        StringBuffer buff = new StringBuffer(this.m_sOneoffPath);
        buff.append(File.separator);
        buff.append(ETC);
        buff.append(File.separator);
        buff.append(CONFIG);
        buff.append(File.separator);
        String action = buff.toString() + ACTIONS_FILENAME;
        XMLDocument document = new XMLDocument();
        File xmlAction = new File(action);
        document = OiiiOneoffPatchActions.parseXMLFile(xmlAction);
        LinkedList fileList = OiiiOneoffPatchActions.getContentActions(document);
        ListIterator iter = fileList.listIterator(0);
        Vector<OiiiFileMapFileEntry> fileMapFileVect = new Vector<OiiiFileMapFileEntry>();
        OiiiFileMapFileEntry fileEntry = null;
        OiiiFileMapFileEntry ownerEntry = null;
        String sHomeInvLoc = OiixPathOps.concatPath(this.m_sOracleHome, INVENTORY);
        OiiiFileMap fileMap = new OiiiFileMap(this.m_sHomeInfo, sHomeInvLoc);
        while (iter.hasNext()) {
            String tmpFileName;
            String[] attrValues = (String[])iter.next();
            if (attrValues[0] == COPY_ACTION) {
                StringBuffer tmpPath = new StringBuffer(this.m_sOracleHome);
                tmpPath.append(File.separator);
                tmpPath.append(OiiiOneoffPatchActions.filterString(attrValues[2]));
                String tmpFileName2 = attrValues[1];
                fileEntry = new OiiiFileMapFileEntry(fileMap, tmpFileName2, null, tmpPath.toString(), null);
                fileMapFileVect.add(fileEntry);
                continue;
            }
            if (attrValues[0] == JAR_ACTION) {
                tmpFileName = attrValues[3];
                String jarName = attrValues[1];
                if (jarName.lastIndexOf(":") != -1) {
                    jarName = jarName.substring(jarName.lastIndexOf(":") + 1);
                }
                int index = tmpFileName.lastIndexOf(jarName);
                if ((index += jarName.length()) > -1) {
                    tmpFileName = tmpFileName.substring(index);
                }
                StringBuffer tmpPath = new StringBuffer(this.m_sOracleHome);
                tmpPath.append(File.separator);
                tmpPath.append(OiiiOneoffPatchActions.filterString(attrValues[2]));
                StringBuffer tmpOwnerName = new StringBuffer(attrValues[1]);
                ownerEntry = new OiiiFileMapFileEntry(fileMap, tmpOwnerName.toString(), null, tmpPath.toString(), null);
                fileEntry = new OiiiFileMapFileEntry(fileMap, tmpFileName, tmpOwnerName.toString(), null, ownerEntry);
                fileMapFileVect.add(fileEntry);
                continue;
            }
            if (attrValues[0] != ARCHIVE_ACTION) continue;
            tmpFileName = attrValues[3];
            int index = tmpFileName.lastIndexOf(File.separator);
            if (index > -1) {
                tmpFileName = tmpFileName.substring(index);
            }
            StringBuffer tmpPath = new StringBuffer(this.m_sOracleHome);
            tmpPath.append(File.separator);
            tmpPath.append(OiiiOneoffPatchActions.filterString(attrValues[2]));
            StringBuffer tmpOwnerName = new StringBuffer(attrValues[1]);
            ownerEntry = new OiiiFileMapFileEntry(fileMap, tmpOwnerName.toString(), null, tmpPath.toString(), null);
            fileEntry = new OiiiFileMapFileEntry(fileMap, tmpFileName, tmpOwnerName.toString(), null, ownerEntry);
            fileMapFileVect.add(fileEntry);
        }
        return fileMapFileVect;
    }

    private static LinkedList getContentActions(XMLDocument doc) throws Exception {
        LinkedList<String[]> fileList = new LinkedList<String[]>();
        Element root = doc.getDocumentElement();
        int whatToShow = -1;
        NodeFilter nodeFilter = null;
        boolean expandRef = false;
        DOMImplementation domImpl = doc.getImplementation();
        if (domImpl.hasFeature("Traversal", "2.0")) {
            XMLDocument traversal = doc;
            TreeWalker walker = traversal.createTreeWalker(root, whatToShow, nodeFilter, expandRef);
            Node thisNode = walker.nextNode();
            while (thisNode != null) {
                String[] attrValues = new String[4];
                String name = thisNode.getNodeName();
                if (name.equals(COPY_ACTION)) {
                    Element eCopy = (Element)thisNode;
                    attrValues[0] = COPY_ACTION;
                    attrValues[1] = eCopy.getAttribute(ACTION_NAME);
                    attrValues[2] = eCopy.getAttribute(ACTION_PATH);
                    attrValues[3] = eCopy.getAttribute(FILE_NAME);
                    fileList.add(attrValues);
                } else if (name.equals(JAR_ACTION)) {
                    Element eJar = (Element)thisNode;
                    attrValues[0] = JAR_ACTION;
                    attrValues[1] = eJar.getAttribute(ACTION_NAME);
                    attrValues[2] = eJar.getAttribute(ACTION_PATH);
                    attrValues[3] = eJar.getAttribute(CLASS_NAME);
                    fileList.add(attrValues);
                } else if (name.equals(ARCHIVE_ACTION)) {
                    Element eArchive = (Element)thisNode;
                    attrValues[0] = ARCHIVE_ACTION;
                    attrValues[1] = eArchive.getAttribute(ACTION_NAME);
                    attrValues[2] = eArchive.getAttribute(ACTION_PATH);
                    attrValues[3] = eArchive.getAttribute(OBJECT_NAME);
                    fileList.add(attrValues);
                }
                thisNode = walker.nextNode();
            }
        }
        return fileList;
    }

    private static XMLDocument parseXMLFile(File xmlFile) throws FileNotFoundException, SecurityException, IOException {
        XMLDocument doc = null;
        FileInputStream fis = null;
        DOMParser parser = OixsXMLOps.createDOMParser();
        try {
            fis = new FileInputStream(xmlFile);
        }
        catch (FileNotFoundException fnfEx) {
            throw new FileNotFoundException("file not found");
        }
        catch (SecurityException sEx) {
            throw new SecurityException("access denied");
        }
        catch (Exception ioEx) {
            throw new IOException("io exp");
        }
        if (parser != null) {
            parser.showWarnings(true);
            try {
                parser.parse((InputStream)fis);
            }
            catch (IOException e) {
                throw e;
            }
            catch (SAXException e) {
                IOException x = new IOException(e.getMessage());
                throw x;
            }
        }
        doc = parser.getDocument();
        return doc;
    }

    private static String filterString(String s) throws Exception {
        int beginIndex = 0;
        beginIndex = s.indexOf("%ORACLE_HOME%");
        if (beginIndex == -1) {
            return s;
        }
        beginIndex = s.indexOf("/");
        try {
            s = s.substring(beginIndex + 1);
            s = OiiiOneoffPatchActions.getPlatformDependentPath(s);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new Exception("Input string of filterString() is invalid", iobe.getCause());
        }
        catch (Exception e) {
            throw e;
        }
        return s;
    }

    private static String getPlatformDependentPath(String s) throws Exception {
        String tmp = "";
        String[] splitedStr = s.split("/");
        String seperate = File.separator;
        if (splitedStr == null) {
            throw new Exception("PatchObjectUtil::getPlatformDependentPath(): Input string is invalid");
        }
        for (int i = 0; i < splitedStr.length; ++i) {
            if (i == splitedStr.length - 1) {
                seperate = "";
            }
            tmp = tmp + splitedStr[i] + seperate;
        }
        return tmp;
    }
}

