/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiii.OiiiDocDetails;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiReleaseNotesInfo;
import oracle.sysman.oii.oiii.OiiiShipHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class OiiiOracleHomeInfoXMLHandler
extends OixsDefaultHandler {
    private OiiiOracleHomeInfo m_oOracleHomeInfo;
    private OiiiShipHomeInfo m_oShipHomeInfo;
    private OixsElementHandler m_handlerOracleHomeInfo;
    private OiiiReleaseNotesInfo m_oReleaseNotesInfo = null;
    private ArrayList m_vReadmeList = new ArrayList();
    private OiiiDocDetails m_oDocDetails = null;
    private ArrayList m_vDocList = new ArrayList();
    private boolean m_bisCompositeHome = false;

    public OiiiOracleHomeInfoXMLHandler(OiiiOracleHomeInfo oOracleHomeInfo) throws SAXException {
        this(oOracleHomeInfo, false);
    }

    public OiiiOracleHomeInfoXMLHandler(OiiiOracleHomeInfo oOracleHomeInfo, boolean isCompositeHome) throws SAXException {
        if (oOracleHomeInfo instanceof OiiiShipHomeInfo) {
            this.m_oShipHomeInfo = (OiiiShipHomeInfo)oOracleHomeInfo;
        } else {
            this.m_oOracleHomeInfo = oOracleHomeInfo;
        }
        this.m_bisCompositeHome = isCompositeHome;
    }

    protected OixsElementHandler createElementHandlers() {
        this.m_handlerOracleHomeInfo = this.m_bisCompositeHome ? new OixsElementHandler("COMPOSITEHOME_INFO") : new OixsElementHandler("ORACLEHOME_INFO");
        OiiiGUIDHandler handlerGUID = new OiiiGUIDHandler("GUID");
        this.m_handlerOracleHomeInfo.addChildHandler("GUID", handlerGUID);
        OiiiARUIDHandler handlerARUID = new OiiiARUIDHandler("ARU_PLATFORM_INFO");
        this.m_handlerOracleHomeInfo.addChildHandler("ARU_PLATFORM_INFO", handlerARUID);
        this.m_handlerOracleHomeInfo.addChildHandler("HOME", new OiiiHomeElementHandler("HOME"));
        OixsElementHandler handlerClusterInfo = new OixsElementHandler("CLUSTER_INFO");
        OiiiLocalNodeElementHandler handlerLocalNode = new OiiiLocalNodeElementHandler("LOCAL_NODE");
        handlerClusterInfo.addChildHandler("LOCAL_NODE", handlerLocalNode);
        OixsElementHandler handlerNodeList = new OixsElementHandler("NODE_LIST");
        handlerClusterInfo.addChildHandler("NODE_LIST", handlerNodeList);
        OiiiNodeElementHandler handlerNode = new OiiiNodeElementHandler("NODE");
        handlerNodeList.addChildHandler("NODE", handlerNode);
        this.m_handlerOracleHomeInfo.addChildHandler("CLUSTER_INFO", handlerClusterInfo);
        OixsElementHandler handlerPropertiesList = new OixsElementHandler("PROPERTY_LIST");
        this.m_handlerOracleHomeInfo.addChildHandler("PROPERTY_LIST", handlerPropertiesList);
        OiiiPropertyElementHandler handlerProperty = new OiiiPropertyElementHandler("PROPERTY");
        handlerPropertiesList.addChildHandler("PROPERTY", handlerProperty);
        OiiiDocInfoHandler handlerDocInfo = new OiiiDocInfoHandler("DOC_INFO");
        this.m_handlerOracleHomeInfo.addChildHandler("DOC_INFO", handlerDocInfo);
        return this.m_handlerOracleHomeInfo;
    }

    private class OiiiGUIDHandler
    extends OixsTextElementHandler {
        public OiiiGUIDHandler(String name) {
            super(name);
        }

        private String getGUID() {
            String sGUID;
            block3: {
                sGUID = "";
                try {
                    sGUID = this.getText();
                }
                catch (IllegalStateException ex) {
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-27006");
                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block3;
                    OiiolTextLogger.appendText("GUID:" + sMsg, OiiolTextLogger.LOG_DETAILED);
                }
            }
            if (sGUID != null) {
                sGUID = sGUID.trim();
            }
            return sGUID;
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
        }

        public void onEnd(String name) {
            super.onEnd(name);
            OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setGUID(this.getGUID());
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("GUID: setting GUID value to :" + this.getGUID(), OiiolTextLogger.LOG_DETAILED);
            }
        }
    }

    private class OiiiAccessHandler
    extends OixsElementHandler {
        OixsElementHandler m_handlerAccFile;

        public OiiiAccessHandler(String name) {
            super(name);
            this.m_handlerAccFile = new OixsElementHandler(){
                String sAccessFileName = "";
                String sAccessLoc = "";

                public void onStart(String name, AttributeList atts) {
                    this.sAccessFileName = atts.getValue("NAME");
                    this.sAccessLoc = atts.getValue("LOC");
                }

                public void onEnd(String name) {
                    OiicInstallSession oInstSession;
                    super.onEnd(name);
                    if (OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo != null) {
                        OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setAccessFileName(this.sAccessFileName);
                        OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setAccessLoc(this.sAccessLoc);
                    } else if (OiicSessionInterfaceManager.getInterfaceManager().getSession() instanceof OiicInstallSession && (oInstSession = (OiicInstallSession)OiicSessionInterfaceManager.getInterfaceManager().getSession()) != null) {
                        oInstSession.setAccessFullPath(this.sAccessLoc + File.separator + this.sAccessFileName);
                    }
                }
            };
            this.addChildHandler("FILE", this.m_handlerAccFile);
        }
    }

    private class OiiiDOCCompHandler
    extends OixsElementHandler {
        OixsElementHandler m_handlerInst;
        OixsElementHandler m_handlerDefDoc;
        HashMap m_hDocDetails;
        String sDocCmpName;
        String sDocLoc;

        public OiiiDOCCompHandler(String name) {
            super(name);
            this.m_hDocDetails = null;
            this.sDocCmpName = "";
            this.sDocLoc = "";
            this.m_handlerInst = new OixsElementHandler(){
                String sInstID = "";
                String sFolderName = "";

                public void onStart(String name, AttributeList atts) {
                    this.sInstID = atts.getValue("ID");
                    this.sFolderName = atts.getValue("FOLDERNAME");
                    OiiiDOCCompHandler.this.m_hDocDetails.put(this.sInstID, this.sFolderName);
                }

                public void onEnd(String name) {
                    super.onEnd(name);
                }
            };
            this.addChildHandler("INSTALL_TYPE", this.m_handlerInst);
            this.m_handlerDefDoc = new OixsTextElementHandler();
            this.addChildHandler("DEFAULT", this.m_handlerDefDoc);
        }

        public void onStart(String name, AttributeList atts) {
            this.sDocCmpName = atts.getValue("NAME");
            this.sDocLoc = atts.getValue("LOC");
            OiiiOracleHomeInfoXMLHandler.this.m_oDocDetails = new OiiiDocDetails(this.sDocCmpName, this.sDocLoc);
            this.m_hDocDetails = new HashMap();
        }

        public void onEnd(String name) {
            super.onEnd(name);
            OiiiOracleHomeInfoXMLHandler.this.m_oDocDetails.setDocDetails(this.m_hDocDetails);
            OiiiOracleHomeInfoXMLHandler.this.m_oDocDetails.setDefaultDoc(this.getDefaultDoc());
            OiiiOracleHomeInfoXMLHandler.this.m_vDocList.add(OiiiOracleHomeInfoXMLHandler.this.m_oDocDetails);
        }

        private String getDefaultDoc() {
            String sDefaultDoc = "";
            OixsTextElementHandler handlerDefDoc = (OixsTextElementHandler)this.getChildHandler("DEFAULT");
            try {
                sDefaultDoc = handlerDefDoc.getText();
            }
            catch (IllegalStateException ex) {
                return null;
            }
            return sDefaultDoc;
        }
    }

    private class OiiiDOCHandler
    extends OixsElementHandler {
        public OiiiDOCHandler(String name) {
            super(name);
            OiiiDOCCompHandler m_handlerComp = new OiiiDOCCompHandler("TOPLEVEL_COMP");
            this.addChildHandler("TOPLEVEL_COMP", m_handlerComp);
        }
    }

    private class OiiiReleaseNotesCompHandler
    extends OixsElementHandler {
        OixsElementHandler m_handlerInst;
        OixsElementHandler m_handlerDefReadme;
        HashMap m_hReleaseNotesDetails;
        String sRelCmpName;
        String sRelLoc;

        public OiiiReleaseNotesCompHandler(String name) {
            super(name);
            this.m_hReleaseNotesDetails = null;
            this.sRelCmpName = "";
            this.sRelLoc = "";
            this.m_handlerInst = new OixsElementHandler(){
                String sInstID = "";
                String sFileName = "";

                public void onStart(String name, AttributeList atts) {
                    this.sInstID = atts.getValue("ID");
                    this.sFileName = atts.getValue("FILENAME");
                    OiiiReleaseNotesCompHandler.this.m_hReleaseNotesDetails.put(this.sInstID, this.sFileName);
                }

                public void onEnd(String name) {
                    super.onEnd(name);
                }
            };
            this.addChildHandler("INSTALL_TYPE", this.m_handlerInst);
            this.m_handlerDefReadme = new OixsTextElementHandler();
            this.addChildHandler("DEFAULT", this.m_handlerDefReadme);
        }

        public void onStart(String name, AttributeList atts) {
            this.sRelCmpName = atts.getValue("NAME");
            this.sRelLoc = atts.getValue("LOC");
            OiiiOracleHomeInfoXMLHandler.this.m_oReleaseNotesInfo = new OiiiReleaseNotesInfo(this.sRelCmpName, this.sRelLoc);
            this.m_hReleaseNotesDetails = new HashMap();
        }

        public void onEnd(String name) {
            super.onEnd(name);
            OiiiOracleHomeInfoXMLHandler.this.m_oReleaseNotesInfo.setReadmeDetails(this.m_hReleaseNotesDetails);
            OiiiOracleHomeInfoXMLHandler.this.m_oReleaseNotesInfo.setDefaultReadme(this.getDefaultReadme());
            OiiiOracleHomeInfoXMLHandler.this.m_vReadmeList.add(OiiiOracleHomeInfoXMLHandler.this.m_oReleaseNotesInfo);
        }

        private String getDefaultReadme() {
            String sDefaultReadme = "";
            OixsTextElementHandler handlerDefReadme = (OixsTextElementHandler)this.getChildHandler("DEFAULT");
            try {
                sDefaultReadme = handlerDefReadme.getText();
            }
            catch (IllegalStateException ex) {
                return null;
            }
            return sDefaultReadme;
        }
    }

    private class OiiiReleaseNotesHandler
    extends OixsElementHandler {
        public OiiiReleaseNotesHandler(String name) {
            super(name);
            OiiiReleaseNotesCompHandler m_handlerComp = new OiiiReleaseNotesCompHandler("TOPLEVEL_COMP");
            this.addChildHandler("TOPLEVEL_COMP", m_handlerComp);
        }
    }

    private class OiiiDocInfoHandler
    extends OixsElementHandler {
        public OiiiDocInfoHandler(String name) {
            super(name);
            OiiiReleaseNotesHandler handlerReleaseNotes = new OiiiReleaseNotesHandler("RELEASENOTES");
            OiiiDOCHandler handlerDoc = new OiiiDOCHandler("DOC");
            OiiiAccessHandler handlerAccess = new OiiiAccessHandler("ACCESS");
            this.addChildHandler("RELEASENOTES", handlerReleaseNotes);
            this.addChildHandler("DOC", handlerDoc);
            this.addChildHandler("ACCESS", handlerAccess);
        }

        public void onEnd(String name) {
            super.onEnd(name);
            if (OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setReadmeInfoOfTLcomps(OiiiOracleHomeInfoXMLHandler.this.m_vReadmeList);
                OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setDocInfoOfTLComps(OiiiOracleHomeInfoXMLHandler.this.m_vDocList);
            }
        }
    }

    private class OiiiPropertyElementHandler
    extends OixsElementHandler {
        public OiiiPropertyElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String propName = atts.getValue("NAME");
            String propValue = atts.getValue("VAL");
            if (OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setAdditionalOracleHomeProperty(propName, propValue);
            } else if (OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setAdditionalOracleHomeProperty(propName, propValue);
            }
        }
    }

    private class OiiiNodeElementHandler
    extends OixsElementHandler {
        public OiiiNodeElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String clusterNode = atts.getValue("NAME");
            if (OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.addNode(clusterNode);
            }
        }
    }

    private class OiiiLocalNodeElementHandler
    extends OixsElementHandler {
        public OiiiLocalNodeElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String sLocalNode = atts.getValue("NAME");
            if (OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setLocalNode(sLocalNode);
            }
        }
    }

    private class OiiiHomeElementHandler
    extends OixsElementHandler {
        boolean m_bCRSHome;

        public OiiiHomeElementHandler(String name) {
            super(name);
            this.m_bCRSHome = false;
        }

        public void onStart(String name, AttributeList atts) {
            String sCRSHome = atts.getValue("CRS");
            if (sCRSHome != null && OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setCRSHome(sCRSHome.equalsIgnoreCase("T"));
            }
            if (OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setStoredInInv(true);
            }
        }
    }

    private class OiiiARUIDHandler
    extends OixsElementHandler {
        public OiiiARUIDHandler(String name) {
            super(name);
            OixsTextElementHandler handlerARUID = new OixsTextElementHandler();
            OixsTextElementHandler handlerARUIDDesc = new OixsTextElementHandler();
            this.addChildHandler("ARU_ID", handlerARUID);
            this.addChildHandler("ARU_ID_DESCRIPTION", handlerARUIDDesc);
        }

        private int getARUID() {
            int iARUID = 0;
            String sARUID = null;
            OixsTextElementHandler handlerARUID = (OixsTextElementHandler)this.getChildHandler("ARU_ID");
            try {
                sARUID = handlerARUID.getText();
            }
            catch (IllegalStateException ex) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-6000");
                OiiolTextLogger.appendText(sMsg);
            }
            if (sARUID != null && (sARUID = sARUID.trim()).length() > 0) {
                iARUID = Integer.parseInt(sARUID);
            }
            return iARUID;
        }

        private String getARUIDDesc() {
            String sARUDesc = "";
            OixsTextElementHandler handlerARUIDDesc = (OixsTextElementHandler)this.getChildHandler("ARU_ID_DESCRIPTION");
            try {
                sARUDesc = handlerARUIDDesc.getText();
            }
            catch (IllegalStateException ex) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-6001");
                OiiolTextLogger.appendText(sMsg);
            }
            return sARUDesc;
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
        }

        public void onEnd(String name) {
            super.onEnd(name);
            if (OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setARUID(this.getARUID());
                OiiiOracleHomeInfoXMLHandler.this.m_oOracleHomeInfo.setARUIDDescription(this.getARUIDDesc());
            } else if (OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo != null) {
                OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setARUID(this.getARUID());
                OiiiOracleHomeInfoXMLHandler.this.m_oShipHomeInfo.setARUIDDescription(this.getARUIDDesc());
            }
        }
    }
}

