/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoXMLHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiOracleHomeInfoXMLReader {
    private static OiiiOracleHomeInfoXMLReader s_oReader;

    private OiiiOracleHomeInfoXMLReader() {
    }

    public void updateHomeProperties(OiiiOracleHomeInfo home, String sFileName) {
        block5: {
            OiiiOracleHomeInfoXMLHandler handler = null;
            FileInputStream fReader = null;
            InputStreamReader oReader = null;
            BufferedReader bReader = null;
            try {
                Parser parser = OixsXMLOps.createSAXParser();
                fReader = new FileInputStream(sFileName);
                oReader = new InputStreamReader((InputStream)fReader, "UTF-8");
                bReader = new BufferedReader(oReader);
                try {
                    boolean isCompositeHome = false;
                    if (home != null) {
                        isCompositeHome = home.isCompositeHome();
                    }
                    handler = new OiiiOracleHomeInfoXMLHandler(home, isCompositeHome);
                    parser.setDocumentHandler(handler);
                    parser.setErrorHandler(handler);
                    parser.parse(new InputSource(bReader));
                }
                catch (SAXException e) {
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-6003", new Object[]{sFileName});
                    OiiolTextLogger.appendText(sMsg);
                }
                bReader.close();
                oReader.close();
                fReader.close();
            }
            catch (IOException ex) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block5;
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-6002", new Object[]{home.getName()});
                OiiolTextLogger.appendText(sMsg);
            }
        }
    }

    public static OiiiOracleHomeInfoXMLReader getOHInfoXMLReader() {
        if (s_oReader == null) {
            s_oReader = new OiiiOracleHomeInfoXMLReader();
        }
        return s_oReader;
    }
}

