/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoWriter;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class OiiiOracleHomeInfoXMLWriter
extends OiiiOracleHomeInfoWriter {
    private OiiiOracleHomeInfo m_oOracleHomeInfo = null;
    private String m_sOracleHomePropertiesLoc = null;
    private static final String BAK = ".bak";

    OiiiOracleHomeInfoXMLWriter(OiiiOracleHomeInfo ohi, String sPath) {
        this.m_oOracleHomeInfo = ohi;
        this.m_sOracleHomePropertiesLoc = sPath;
    }

    void updateHomeProperties() throws IOException {
        File oInputFile = new File(this.m_sOracleHomePropertiesLoc);
        if (oInputFile.exists()) {
            String sBackupFile = this.m_sOracleHomePropertiesLoc + BAK;
            oInputFile.renameTo(new File(sBackupFile));
            this.updateHomeProperties(sBackupFile, this.m_oOracleHomeInfo, this.m_sOracleHomePropertiesLoc);
            new File(sBackupFile).delete();
        } else {
            this.writeHomeProperties(this.m_oOracleHomeInfo, this.m_sOracleHomePropertiesLoc);
        }
    }

    private void writeHomeProperties(OiiiOracleHomeInfo oOracleHomeInfo, String sDestn) throws IOException {
        File oOutputFile = new File(sDestn);
        File oOutputDir = oOutputFile.getParentFile();
        if (!oOutputDir.exists()) {
            OiixFileOps.mkdirs(oOutputDir);
        }
        FileOutputStream fWriter = new FileOutputStream(sDestn);
        OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fWriter, "UTF-8");
        BufferedWriter bWriter = new BufferedWriter(oWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement elemOracleHomeInfo = this.getHomeInfoDOM(oOracleHomeInfo);
        elemOracleHomeInfo.print(pWriter);
        try {
            pWriter.close();
            bWriter.close();
            oWriter.close();
            fWriter.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private XMLElement getHomeInfoDOM(OiiiOracleHomeInfo oOracleHomeInfo) {
        int nSize;
        String infoText = oOracleHomeInfo.isCompositeHome() ? "COMPOSITEHOME_INFO" : "ORACLEHOME_INFO";
        XMLElement elemOracleHomeInfo = new XMLElement(infoText);
        XMLElement GUIDElement = new XMLElement("GUID");
        String GUIDTextNodeName = "GUIDTextNode";
        XMLText textGUIDDesc = new XMLText(GUIDTextNodeName);
        String GUIDTextValue = oOracleHomeInfo.getGUID();
        textGUIDDesc.setNodeValue(GUIDTextValue);
        GUIDElement.appendChild((Node)textGUIDDesc);
        elemOracleHomeInfo.appendChild((Node)GUIDElement);
        XMLElement homeElement = new XMLElement("HOME");
        if (oOracleHomeInfo.isCRSHome()) {
            homeElement.setAttribute("CRS", "T");
        }
        elemOracleHomeInfo.appendChild((Node)homeElement);
        if (oOracleHomeInfo.getARUID() != 0) {
            XMLElement elemARUPlatformInfo = new XMLElement("ARU_PLATFORM_INFO");
            XMLElement elemARUID = new XMLElement("ARU_ID");
            XMLText textARUID = new XMLText(Integer.toString(oOracleHomeInfo.getARUID()));
            elemARUID.appendChild((Node)textARUID);
            elemARUPlatformInfo.appendChild((Node)elemARUID);
            String sARUIDDesc = oOracleHomeInfo.getARUIDDescription();
            if (sARUIDDesc != null) {
                XMLElement elemARUIDDesc = new XMLElement("ARU_ID_DESCRIPTION");
                XMLText textARUIDDesc = new XMLText(sARUIDDesc);
                elemARUIDDesc.appendChild((Node)textARUIDDesc);
                elemARUPlatformInfo.appendChild((Node)elemARUIDDesc);
            }
            elemOracleHomeInfo.appendChild((Node)elemARUPlatformInfo);
        }
        Vector oClusterNodes = null;
        oClusterNodes = System.getProperty("oracle.installer.bigCluster", "false").equalsIgnoreCase("true") ? oOracleHomeInfo.getNodeListBigCluster() : oOracleHomeInfo.getNodeList();
        if (oClusterNodes != null && (nSize = oClusterNodes.size()) > 0) {
            XMLElement elemClusterInfo = new XMLElement("CLUSTER_INFO");
            String sLocalNode = oOracleHomeInfo.getLocalNode();
            if (sLocalNode != null) {
                XMLElement elemLocalNode = new XMLElement("LOCAL_NODE");
                elemLocalNode.setAttribute("NAME", sLocalNode);
                elemClusterInfo.appendChild((Node)elemLocalNode);
            }
            XMLElement elemNodeList = new XMLElement("NODE_LIST");
            for (int i = 0; i < nSize; ++i) {
                XMLElement elemNode = new XMLElement("NODE");
                elemNode.setAttribute("NAME", (String)oClusterNodes.get(i));
                elemNodeList.appendChild((Node)elemNode);
            }
            elemClusterInfo.appendChild((Node)elemNodeList);
            elemOracleHomeInfo.appendChild((Node)elemClusterInfo);
        }
        Properties props = oOracleHomeInfo.getAdditionalOracleHomeProperties();
        if (oOracleHomeInfo.isCompositeHome()) {
            props = oOracleHomeInfo.getAdditionalCompositeHomeProperties();
        }
        if (props != null && props.size() > 0) {
            XMLElement propertyList = new XMLElement("PROPERTY_LIST");
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                XMLElement property = new XMLElement("PROPERTY");
                property.setAttribute("NAME", propName);
                property.setAttribute("VAL", propValue);
                propertyList.appendChild((Node)property);
            }
            elemOracleHomeInfo.appendChild((Node)propertyList);
        }
        return elemOracleHomeInfo;
    }

    private void updateHomeInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oOracleHomeNode) {
        NodeList oGUIDNodeList = oOracleHomeNode.getElementsByTagName("GUID");
        Element oGUIDNode = null;
        if (oGUIDNodeList == null || oGUIDNodeList.getLength() == 0) {
            oGUIDNode = oDoc.createElement("GUID");
            String GUIDTextNodeName = "GUIDTextNode";
            Text textGUIDDesc = oDoc.createTextNode(GUIDTextNodeName);
            String GUIDTextValue = oOracleHomeInfo.getGUID();
            textGUIDDesc.setNodeValue(GUIDTextValue);
            oGUIDNode.appendChild(textGUIDDesc);
            oOracleHomeNode.appendChild(oGUIDNode);
        } else {
            Node GUIDChildNode;
            Node gNode = oGUIDNodeList.item(0);
            if (gNode.getNodeType() == 1) {
                oGUIDNode = (Element)gNode;
            }
            if ((GUIDChildNode = oGUIDNode.getFirstChild()) != null) {
                if (GUIDChildNode.getNodeType() == 3) {
                    Text GUIDTextNode = (Text)GUIDChildNode;
                    GUIDTextNode.setNodeValue(oOracleHomeInfo.getGUID());
                }
            } else {
                String GUIDTextNodeName = "GUIDTextNode";
                Text textGUIDDesc = oDoc.createTextNode(GUIDTextNodeName);
                String GUIDTextValue = oOracleHomeInfo.getGUID();
                textGUIDDesc.setNodeValue(GUIDTextValue);
                oGUIDNode.appendChild(textGUIDDesc);
            }
        }
        NodeList oHomeNodeList = oOracleHomeNode.getElementsByTagName("HOME");
        Element oHomeNode = null;
        if (oHomeNodeList == null || oHomeNodeList.getLength() == 0) {
            oHomeNode = oDoc.createElement("HOME");
            oOracleHomeNode.appendChild(oHomeNode);
        } else {
            Node oNode = oHomeNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oHomeNode = (Element)oNode;
            }
        }
        NamedNodeMap oAttribs = oHomeNode.getAttributes();
        Node oAttrib = null;
        if (oAttribs != null) {
            oAttrib = oAttribs.getNamedItem("CRS");
        }
        if (oOracleHomeInfo.isCRSHome()) {
            if (oAttrib != null) {
                oAttrib.setNodeValue("T");
            } else {
                oHomeNode.setAttribute("CRS", "T");
            }
        } else if (oAttrib != null) {
            oHomeNode.removeAttribute("CRS");
        }
    }

    private void updateClusterInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oOracleHomeNode) {
        boolean bClusterInstall;
        NodeList oClusterInfoNodeList = oOracleHomeNode.getElementsByTagName("CLUSTER_INFO");
        Element oClusterInfoNode = null;
        Vector oInstalledNodes = oOracleHomeInfo.getNodeList();
        boolean bl = bClusterInstall = oInstalledNodes != null && oInstalledNodes.size() > 0;
        if (oClusterInfoNodeList == null || oClusterInfoNodeList.getLength() == 0) {
            if (bClusterInstall) {
                oClusterInfoNode = oDoc.createElement("CLUSTER_INFO");
                oOracleHomeNode.appendChild(oClusterInfoNode);
            }
        } else {
            Node oNode = oClusterInfoNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oClusterInfoNode = (Element)oNode;
            }
        }
        if (bClusterInstall) {
            this.updateLocalNodeInfo(oOracleHomeInfo, oDoc, oClusterInfoNode);
            this.updateNodeListInfo(oOracleHomeInfo, oDoc, oClusterInfoNode);
        } else if (oClusterInfoNode != null) {
            oClusterInfoNode.getParentNode().removeChild(oClusterInfoNode);
        }
    }

    private void updateLocalNodeInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oClusterInfoNode) {
        NodeList oLocalNodeNodeList = oClusterInfoNode.getElementsByTagName("LOCAL_NODE");
        Element oLocalNodeNode = null;
        String sLocalNode = oOracleHomeInfo.getLocalNode();
        if (oLocalNodeNodeList == null || oLocalNodeNodeList.getLength() == 0) {
            if (sLocalNode != null) {
                oLocalNodeNode = oDoc.createElement("LOCAL_NODE");
                oLocalNodeNode.setAttribute("NAME", sLocalNode);
                oClusterInfoNode.appendChild(oLocalNodeNode);
            }
        } else {
            Node oNode = oLocalNodeNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oLocalNodeNode = (Element)oNode;
            }
            if (sLocalNode == null) {
                oLocalNodeNode.getParentNode().removeChild(oLocalNodeNode);
            } else {
                oLocalNodeNode.setAttribute("NAME", sLocalNode);
            }
        }
    }

    private void updateNodeListInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oClusterInfoNode) {
        int nNodes;
        Node oNode;
        int i;
        NodeList oClusterNodesNodeList = oClusterInfoNode.getElementsByTagName("NODE_LIST");
        Element oNodesListNode = null;
        Vector oClusterNodes = oOracleHomeInfo.getNodeList();
        if (oClusterNodesNodeList != null) {
            int nSize = oClusterNodesNodeList.getLength();
            for (i = 0; i < nSize; ++i) {
                oNode = oClusterNodesNodeList.item(i);
                oNode.getParentNode().removeChild(oNode);
            }
        }
        if (oClusterNodes != null && (nNodes = oClusterNodes.size()) > 0) {
            oNodesListNode = oDoc.createElement("NODE_LIST");
            for (i = 0; i < nNodes; ++i) {
                oNode = oDoc.createElement("NODE");
                oNode.setAttribute("NAME", (String)oClusterNodes.get(i));
                oNodesListNode.appendChild(oNode);
            }
            oClusterInfoNode.appendChild(oNodesListNode);
        }
    }

    private void updateHomeProperties(String sSrc, OiiiOracleHomeInfo oOracleHomeInfo, String sDestn) throws IOException {
        File oOutputDir;
        File oOutputFile = new File(OiixPathOps.getNativeForm(sDestn));
        if (oOutputFile.exists()) {
            oOutputFile.delete();
        }
        if (!(oOutputDir = oOutputFile.getParentFile()).exists()) {
            OiixFileOps.mkdirs(oOutputDir);
        }
        try {
            FileInputStream in = new FileInputStream(sSrc);
            Document oOracleHomePropsDoc = OixdDOMReader.getDocument(in);
            Element oOracleHomePropsNode = oOracleHomePropsDoc.getDocumentElement();
            this.updateHomeInfo(oOracleHomeInfo, oOracleHomePropsDoc, oOracleHomePropsNode);
            this.updateAruInfo(oOracleHomeInfo, oOracleHomePropsDoc, oOracleHomePropsNode);
            this.updateClusterInfo(oOracleHomeInfo, oOracleHomePropsDoc, oOracleHomePropsNode);
            this.updateAdditionalProperties(oOracleHomeInfo, oOracleHomePropsDoc, oOracleHomePropsNode);
            DOMSource source = new DOMSource(oOracleHomePropsDoc);
            File out = new File(sDestn);
            FileOutputStream outStream = new FileOutputStream(sDestn);
            OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            in.close();
            oWriter.close();
            outStream.close();
        }
        catch (TransformerConfigurationException tcEx) {
            throw new IOException(tcEx.getMessage());
        }
        catch (TransformerException tEx) {
            throw new IOException(tEx.getMessage());
        }
        catch (SAXException se) {
            throw new IOException(se.getMessage());
        }
        catch (ParserConfigurationException pe) {
            throw new IOException(pe.getMessage());
        }
    }

    private void updateAdditionalProperties(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oOracleHomeNode) {
        boolean bAdditionalProperties;
        NodeList oAdditionalPropertiesNodeList = oOracleHomeNode.getElementsByTagName("PROPERTY_LIST");
        Element oAdditionalPropertiesNode = null;
        Properties props = oOracleHomeInfo.getAdditionalOracleHomeProperties();
        if (oOracleHomeInfo.isCompositeHome()) {
            props = oOracleHomeInfo.getAdditionalCompositeHomeProperties();
        }
        boolean bl = bAdditionalProperties = props != null && props.size() > 0;
        if (oAdditionalPropertiesNodeList == null || oAdditionalPropertiesNodeList.getLength() == 0) {
            if (bAdditionalProperties) {
                oAdditionalPropertiesNode = oDoc.createElement("PROPERTY_LIST");
                oOracleHomeNode.appendChild(oAdditionalPropertiesNode);
            }
        } else {
            Node oNode = oAdditionalPropertiesNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oAdditionalPropertiesNode = (Element)oNode;
            }
        }
        if (bAdditionalProperties) {
            this.updateProperties(oOracleHomeInfo, oDoc, oAdditionalPropertiesNode);
        } else if (oAdditionalPropertiesNode != null) {
            oAdditionalPropertiesNode.getParentNode().removeChild(oAdditionalPropertiesNode);
        }
    }

    private void updateProperties(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oAdditionalPropertiesNode) {
        String propValue;
        NodeList oPropertyList = oAdditionalPropertiesNode.getElementsByTagName("PROPERTY");
        Properties props = oOracleHomeInfo.getAdditionalOracleHomeProperties();
        if (oOracleHomeInfo.isCompositeHome()) {
            props = oOracleHomeInfo.getAdditionalCompositeHomeProperties();
        }
        Properties newProps = new Properties();
        if (oPropertyList != null) {
            int nSize = oPropertyList.getLength();
            for (int i = 0; i < nSize; ++i) {
                Node oNode = oPropertyList.item(i);
                NamedNodeMap oAttribs = oNode.getAttributes();
                Node oAttrib = null;
                if (oAttribs != null) {
                    oAttrib = oAttribs.getNamedItem("NAME");
                    String propName = null;
                    if (oAttrib != null) {
                        propName = oAttrib.getNodeValue();
                    }
                    oAttrib = oAttribs.getNamedItem("VAL");
                    String propValue2 = null;
                    if (oAttrib != null) {
                        propValue2 = oAttrib.getNodeValue();
                    }
                    if (propName != null && propValue2 != null) {
                        newProps.setProperty(propName, propValue2);
                    }
                }
                oNode.getParentNode().removeChild(oNode);
            }
        }
        if (props != null && props.size() > 0) {
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                propValue = props.getProperty(propName);
                if (propName == null || propValue == null) continue;
                newProps.setProperty(propName, propValue);
            }
        }
        if (newProps != null && newProps.size() > 0) {
            Enumeration<?> newPropNames = newProps.propertyNames();
            while (newPropNames.hasMoreElements()) {
                String propName = (String)newPropNames.nextElement();
                propValue = newProps.getProperty(propName);
                XMLElement property = new XMLElement("PROPERTY");
                property.setAttribute("NAME", propName);
                property.setAttribute("VAL", propValue);
                oAdditionalPropertiesNode.appendChild((Node)property);
            }
        }
    }

    private void updateAruInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oOracleHomeNode) {
        boolean bAruUpdate;
        NodeList oAruInfoNodeList = oOracleHomeNode.getElementsByTagName("ARU_PLATFORM_INFO");
        Element oAruInfoNode = null;
        int aruId = oOracleHomeInfo.getARUID();
        String aruIdDesc = oOracleHomeInfo.getARUIDDescription();
        boolean bl = bAruUpdate = aruId != 0 || aruIdDesc != null && aruIdDesc != "";
        if (oAruInfoNodeList == null || oAruInfoNodeList.getLength() == 0) {
            if (bAruUpdate) {
                oAruInfoNode = oDoc.createElement("ARU_PLATFORM_INFO");
                oOracleHomeNode.appendChild(oAruInfoNode);
            }
        } else {
            Node oNode = oAruInfoNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oAruInfoNode = (Element)oNode;
            }
        }
        if (bAruUpdate) {
            this.updateAruIdInfo(oOracleHomeInfo, oDoc, oAruInfoNode);
            this.updateAruIdDescriptionInfo(oOracleHomeInfo, oDoc, oAruInfoNode);
        }
    }

    private void updateAruIdInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oAruInfoNode) {
        NodeList oAruIdNodeList = oAruInfoNode.getElementsByTagName("ARU_ID");
        Element oAruIdNode = null;
        int aruId = oOracleHomeInfo.getARUID();
        if (oAruIdNodeList == null || oAruIdNodeList.getLength() == 0) {
            if (aruId != 0) {
                oAruIdNode = oDoc.createElement("ARU_ID");
                Text textAruId = oDoc.createTextNode("ARU_ID");
                String ArudIdTextValue = new Integer(aruId).toString();
                textAruId.setNodeValue(ArudIdTextValue);
                oAruIdNode.appendChild(textAruId);
                oAruInfoNode.appendChild(oAruIdNode);
            }
        } else {
            Node oNode = oAruIdNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oAruIdNode = (Element)oNode;
            }
            if (aruId != 0) {
                Node AruIdChildNode = oAruIdNode.getFirstChild();
                if (AruIdChildNode != null) {
                    if (AruIdChildNode.getNodeType() == 3) {
                        Text AruIdTextNode = (Text)AruIdChildNode;
                        AruIdTextNode.setNodeValue(new Integer(aruId).toString());
                    }
                } else {
                    Text textAruId = oDoc.createTextNode("ARU_ID");
                    String aruIdTextValue = new Integer(aruId).toString();
                    textAruId.setNodeValue(aruIdTextValue);
                    oAruIdNode.appendChild(textAruId);
                    oAruInfoNode.appendChild(oAruIdNode);
                }
            }
        }
    }

    private void updateAruIdDescriptionInfo(OiiiOracleHomeInfo oOracleHomeInfo, Document oDoc, Element oAruInfoNode) {
        NodeList oAruIdDescriptionNodeList = oAruInfoNode.getElementsByTagName("ARU_ID_DESCRIPTION");
        Element oAruIdDescriptionNode = null;
        String aruIdDescription = oOracleHomeInfo.getARUIDDescription();
        if (oAruIdDescriptionNodeList == null || oAruIdDescriptionNodeList.getLength() == 0) {
            if (aruIdDescription != null) {
                oAruIdDescriptionNode = oDoc.createElement("ARU_ID_DESCRIPTION");
                Text textAruIdDescription = oDoc.createTextNode("ARU_ID_DESCRIPTION");
                textAruIdDescription.setNodeValue(aruIdDescription);
                oAruIdDescriptionNode.appendChild(textAruIdDescription);
                oAruInfoNode.appendChild(oAruIdDescriptionNode);
            }
        } else {
            Node oNode = oAruIdDescriptionNodeList.item(0);
            if (oNode.getNodeType() == 1) {
                oAruIdDescriptionNode = (Element)oNode;
            }
            if (aruIdDescription != null) {
                Node AruIdDescriptionChildNode = oAruIdDescriptionNode.getFirstChild();
                if (AruIdDescriptionChildNode != null) {
                    if (AruIdDescriptionChildNode.getNodeType() == 3) {
                        Text AruIdDescriptionTextNode = (Text)AruIdDescriptionChildNode;
                        AruIdDescriptionTextNode.setNodeValue(aruIdDescription);
                    }
                } else {
                    Text textAruIdDescription = oDoc.createTextNode("ARU_ID_DESCRIPTION");
                    textAruIdDescription.setNodeValue(aruIdDescription);
                    oAruIdDescriptionNode.appendChild(textAruIdDescription);
                    oAruInfoNode.appendChild(oAruIdDescriptionNode);
                }
            }
        }
    }
}

