/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchprereq.ConflictOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.sysman.oii.oiii.OiiiInstallUpdate;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiim.OiimARUAuthException;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiiiParseMetadata {
    private String m_sProductName;
    private String m_sRelease;
    private String m_sCPULocation;
    private String m_sMetadataLoc;
    private ArrayList m_ShipHomeUpdatesList;
    private ArrayList m_OneOffList = null;
    private ArrayList m_PatchSetList = null;
    private OiiiPatchMetadata m_ouiUpdate = null;
    private OiiiPatchMetadata m_opatchUpdate = null;
    private ArrayList m_TotalApplicableOneOffList;
    private boolean m_bRestart = false;
    private boolean m_bParsed = false;

    public OiiiParseMetadata() {
    }

    public OiiiParseMetadata(String loc) {
        this.m_sMetadataLoc = loc;
        this.m_sRelease = "";
        this.m_sProductName = "";
        this.m_ShipHomeUpdatesList = null;
    }

    public String getProductName() {
        return this.m_sProductName;
    }

    public String getProductRelease() {
        return this.m_sRelease;
    }

    public String getCPULocation() {
        return this.m_sCPULocation;
    }

    public ArrayList getInstallUpdates() {
        return this.m_ShipHomeUpdatesList;
    }

    public ArrayList getRestartUpdates() {
        if (this.m_ShipHomeUpdatesList == null) {
            return null;
        }
        ArrayList<OiiiPatchMetadata> restartList = new ArrayList<OiiiPatchMetadata>();
        for (int i = 0; i < this.m_ShipHomeUpdatesList.size(); ++i) {
            OiiiPatchMetadata pm = (OiiiPatchMetadata)this.m_ShipHomeUpdatesList.get(i);
            if (!pm.isRestart()) continue;
            restartList.add(pm);
        }
        if (restartList.size() == 0) {
            return null;
        }
        return restartList;
    }

    public boolean getRestartInstall() {
        return this.m_bRestart;
    }

    public OiiiPatchMetadata getOUIUpdate() {
        return this.m_ouiUpdate;
    }

    public OiiiPatchMetadata getOPatchUpdate() {
        return this.m_opatchUpdate;
    }

    public void setOUIUpdate(OiiiPatchMetadata ouiUpdate) {
        this.m_ouiUpdate = ouiUpdate;
    }

    public void setCPULoc(String cpuLoc) {
        this.m_sCPULocation = cpuLoc;
        OiiiInstallUpdate.setCPUUrl(this.m_sCPULocation);
    }

    public void setOneOffList(ArrayList oneofflist) {
        this.m_OneOffList = oneofflist;
    }

    public void setPatchSetList(ArrayList pslist) {
        this.m_PatchSetList = pslist;
    }

    public void setOPatchUpdate(OiiiPatchMetadata OPatchUpdate) {
        this.m_opatchUpdate = OPatchUpdate;
    }

    private void parsePatchList(NodeList patchList, int platform, boolean restart) {
        String homeTag = "";
        block0: for (int j = 0; j < patchList.getLength(); ++j) {
            NodeList propertyListTags;
            NodeList descTags;
            XMLElement child = (XMLElement)patchList.item(j);
            XMLElement parent = (XMLElement)child.getParentNode();
            homeTag = parent != null ? parent.getAttribute("name") : "";
            OiiiPatchMetadata metadata = new OiiiPatchMetadata(Integer.parseInt(child.getAttribute("bug").trim()), platform);
            if (!homeTag.equals("")) {
                metadata.setHomeTag(homeTag);
            }
            metadata.setType("shiphome");
            metadata.setVersion(child.getAttribute("release").trim());
            metadata.setApplicablePlatform(platform);
            metadata.setRestart(restart);
            String patchUpdate = child.getAttribute("updates");
            if (null != patchUpdate) {
                if ((patchUpdate = patchUpdate.trim()).equalsIgnoreCase("oui")) {
                    metadata.setType("oui");
                } else if (patchUpdate.equalsIgnoreCase("opatch")) {
                    metadata.setType("opatch");
                } else if (patchUpdate.equalsIgnoreCase("one_click")) {
                    metadata.setType("one_click");
                }
            }
            if ((descTags = child.getElementsByTagName("patchDetails")) != null && descTags.getLength() == 1) {
                XMLElement desc = (XMLElement)descTags.item(0);
                metadata.setmetalink_node_id(desc.getAttribute("metalink_node_id").trim());
                metadata.setDesc(desc.getAttribute("description").trim());
                if (desc.hasAttribute("requires_restart")) {
                    boolean localRestart = Boolean.valueOf(desc.getAttribute("requires_restart").trim());
                    metadata.setRestart(localRestart);
                }
            }
            if ((propertyListTags = child.getElementsByTagName("propertyList")) != null) {
                for (int k = 0; k < propertyListTags.getLength(); ++k) {
                    XMLElement property = (XMLElement)propertyListTags.item(k);
                    NodeList propertyList = property.getElementsByTagName("property");
                    Properties props = this.createPropertyList(propertyList);
                    metadata.setPropertyList(props);
                }
            }
            NodeList platforms = child.getElementsByTagName("platforms");
            for (int k = 0; k < platforms.getLength(); ++k) {
                XMLElement plat = (XMLElement)platforms.item(k);
                NodeList platList = plat.getElementsByTagName("platform");
                if (!this.checkPlatformInList(platList, platform)) continue;
                XMLElement fixesbugs = (XMLElement)plat.getElementsByTagName("fixesbugs").item(0);
                metadata.setBugList(this.getFixesBugInfo(fixesbugs, null));
                if (metadata.getType().equals("oui")) {
                    this.setOUIUpdate(metadata);
                }
                if (metadata.getType().equals("opatch")) {
                    this.setOPatchUpdate(metadata);
                }
                this.m_ShipHomeUpdatesList.add(metadata);
                continue block0;
            }
        }
    }

    public void parseMetadata(int platform) throws FileNotFoundException, IOException, SAXException {
        ArrayList<OiiiPatchMetadata> oneOffPatches = new ArrayList<OiiiPatchMetadata>();
        ArrayList<OiiiPatchMetadata> validPatchsets = new ArrayList<OiiiPatchMetadata>();
        Document theXMLDoc = null;
        try {
            theXMLDoc = OixdDOMReader.getDocument(this.m_sMetadataLoc);
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
        if (theXMLDoc.hasChildNodes()) {
            NodeList shipHomeUpdateList;
            NodeList cpulocList;
            NodeList prodList = theXMLDoc.getElementsByTagName("Product");
            XMLElement product = (XMLElement)prodList.item(0);
            if (product != null) {
                this.m_sProductName = product.getAttribute("id");
                this.m_sRelease = product.getAttribute("release");
            }
            if (null != (cpulocList = product.getElementsByTagName("CPU")) && cpulocList.getLength() == 1) {
                XMLElement loc = (XMLElement)cpulocList.item(0);
                this.setCPULoc(loc.getAttribute("loc"));
            }
            if (null != (shipHomeUpdateList = product.getElementsByTagName("install_updates")) && shipHomeUpdateList.getLength() == 1) {
                this.m_ShipHomeUpdatesList = new ArrayList();
                XMLElement update = (XMLElement)shipHomeUpdateList.item(0);
                this.m_bRestart = Boolean.valueOf(update.getAttribute("requires_restart").trim());
                NodeList patchList = update.getElementsByTagName("patch");
                this.parsePatchList(patchList, platform, this.m_bRestart);
            }
            NodeList patches = product.getElementsByTagName("patches");
            XMLElement patchNode = (XMLElement)patches.item(0);
            NodeList homeTagsNodes = patchNode.getElementsByTagName("home");
            for (int i = 0; i < homeTagsNodes.getLength(); ++i) {
                XMLElement rowNode = (XMLElement)homeTagsNodes.item(i);
                String homeTag = rowNode.getAttribute("name");
                NodeList patchList = rowNode.getElementsByTagName("patch");
                block5: for (int j = 0; j < patchList.getLength(); ++j) {
                    NodeList descTags;
                    XMLElement child = (XMLElement)patchList.item(j);
                    OiiiPatchMetadata metadata = new OiiiPatchMetadata(Integer.parseInt(child.getAttribute("bug").trim()), platform);
                    metadata.setHomeTag(homeTag);
                    metadata.setType("patch");
                    metadata.setVersion(child.getAttribute("release").trim());
                    metadata.setApplicablePlatform(platform);
                    NodeList propertyListTags = child.getElementsByTagName("propertyList");
                    if (propertyListTags != null) {
                        for (int k = 0; k < propertyListTags.getLength(); ++k) {
                            XMLElement property = (XMLElement)propertyListTags.item(k);
                            NodeList propertyList = property.getElementsByTagName("property");
                            Properties props = this.createPropertyList(propertyList);
                            metadata.setPropertyList(props);
                        }
                    }
                    if ((descTags = child.getElementsByTagName("patchDetails")) != null && descTags.getLength() == 1) {
                        XMLElement desc = (XMLElement)descTags.item(0);
                        metadata.setmetalink_node_id(desc.getAttribute("metalink_node_id").trim());
                        metadata.setDesc(desc.getAttribute("description").trim());
                    }
                    NodeList platforms = child.getElementsByTagName("platforms");
                    for (int k = 0; k < platforms.getLength(); ++k) {
                        XMLElement plat = (XMLElement)platforms.item(k);
                        NodeList platList = plat.getElementsByTagName("platform");
                        if (!this.checkPlatformInList(platList, platform)) continue;
                        XMLElement fixesbugs = (XMLElement)plat.getElementsByTagName("fixesbugs").item(0);
                        metadata.setBugList(this.getFixesBugInfo(fixesbugs, new ArrayList()));
                        try {
                            String readMe = OiimARUConnection.getReadMeContents(metadata);
                            metadata.setreadMe(readMe);
                        }
                        catch (OiimARUAuthException e) {
                            // empty catch block
                        }
                        oneOffPatches.add(metadata);
                        continue block5;
                    }
                }
            }
            NodeList patchsets = product.getElementsByTagName("patchsets");
            XMLElement patchsetNode = (XMLElement)patchsets.item(0);
            if (patchsetNode != null) {
                NodeList patchset_homeTagsNodes = patchsetNode.getElementsByTagName("home");
                for (int i = 0; i < patchset_homeTagsNodes.getLength(); ++i) {
                    XMLElement rowNode = (XMLElement)patchset_homeTagsNodes.item(i);
                    String homeTag = rowNode.getAttribute("name");
                    NodeList patchsetList = rowNode.getElementsByTagName("patchset");
                    block9: for (int j = 0; j < patchsetList.getLength(); ++j) {
                        XMLElement child = (XMLElement)patchsetList.item(j);
                        OiiiPatchMetadata metadata = new OiiiPatchMetadata(Integer.parseInt(child.getAttribute("bug").trim()), platform);
                        metadata.setHomeTag(homeTag);
                        metadata.setType("patchset");
                        metadata.setVersion(child.getAttribute("release").trim());
                        metadata.setApplicablePlatform(platform);
                        NodeList propertyListTags = child.getElementsByTagName("propertyList");
                        if (propertyListTags != null) {
                            for (int k = 0; k < propertyListTags.getLength(); ++k) {
                                XMLElement property = (XMLElement)propertyListTags.item(k);
                                NodeList propertyList = property.getElementsByTagName("property");
                                Properties props = this.createPropertyList(propertyList);
                            }
                        }
                        NodeList platforms = child.getElementsByTagName("platforms");
                        for (int k = 0; k < platforms.getLength(); ++k) {
                            XMLElement plat = (XMLElement)platforms.item(k);
                            NodeList platList = plat.getElementsByTagName("platform");
                            if (!this.checkPlatformInList(platList, platform)) continue;
                            XMLElement fixesbugs = (XMLElement)plat.getElementsByTagName("fixesbugs").item(0);
                            metadata.setBugList(this.getFixesBugInfo(fixesbugs, new ArrayList()));
                            validPatchsets.add(metadata);
                            continue block9;
                        }
                    }
                }
            }
        }
        this.setOneOffList(oneOffPatches);
        this.setPatchSetList(validPatchsets);
    }

    public ArrayList getApplicableOneoffList(String home) {
        ArrayList ret = this.getApplicableOneoffList();
        int sz = ret.size();
        ArrayList<OiiiPatchMetadata> oneoffsperhome = new ArrayList<OiiiPatchMetadata>(sz);
        for (int i = 0; i < sz; ++i) {
            OiiiPatchMetadata metadata = (OiiiPatchMetadata)ret.get(i);
            if (!metadata.getHomeTag().equalsIgnoreCase(home)) continue;
            oneoffsperhome.add(metadata);
        }
        return oneoffsperhome;
    }

    public ArrayList getInstallUpdates(String home) {
        ArrayList ret = this.getInstallUpdates();
        int sz = ret.size();
        ArrayList<OiiiPatchMetadata> updatesperhome = new ArrayList<OiiiPatchMetadata>(sz);
        for (int i = 0; i < sz; ++i) {
            OiiiPatchMetadata metadata = (OiiiPatchMetadata)ret.get(i);
            if (!metadata.getHomeTag().equalsIgnoreCase(home)) continue;
            updatesperhome.add(metadata);
        }
        return updatesperhome;
    }

    public ArrayList getApplicablePatchSetList(String home) {
        ArrayList ret = this.getApplicablePatchSetList();
        int sz = ret.size();
        ArrayList<OiiiPatchMetadata> psperhome = new ArrayList<OiiiPatchMetadata>(sz);
        for (int i = 0; i < sz; ++i) {
            OiiiPatchMetadata metadata = (OiiiPatchMetadata)ret.get(i);
            if (!metadata.getHomeTag().equalsIgnoreCase(home)) continue;
            psperhome.add(metadata);
        }
        return psperhome;
    }

    public ArrayList getApplicablePatchSetList(String home, String version) {
        ArrayList ret = this.getApplicablePatchSetList(home);
        int sz = ret.size();
        ArrayList<OiiiPatchMetadata> psperhomeversion = new ArrayList<OiiiPatchMetadata>(sz);
        for (int i = 0; i < sz; ++i) {
            OiiiVersion v2 = new OiiiVersion(version);
            OiiiPatchMetadata metadata = (OiiiPatchMetadata)ret.get(i);
            OiiiVersion v1 = new OiiiVersion(metadata.getVersion());
            if (!v2.laterThan(v1) && !v2.equals(v1)) continue;
            psperhomeversion.add(metadata);
        }
        return psperhomeversion;
    }

    public ArrayList getApplicableOneoffList() {
        return this.m_OneOffList;
    }

    public ArrayList getApplicablePatchSetList() {
        return this.m_PatchSetList;
    }

    private boolean checkPlatformInList(NodeList platforms, int platform) {
        XMLElement plat;
        int id;
        int k = 0;
        for (k = 0; k < platforms.getLength() && (id = Integer.parseInt((plat = (XMLElement)platforms.item(k)).getAttribute("id").trim())) != platform; ++k) {
        }
        return k != platforms.getLength();
    }

    private Properties createPropertyList(NodeList property) {
        Properties propList = new Properties();
        for (int k = 0; k < property.getLength(); ++k) {
            XMLElement prop = (XMLElement)property.item(k);
            String key = prop.getAttribute("key").trim();
            String value = prop.getAttribute("value").trim();
            propList.setProperty(key, value);
        }
        return propList;
    }

    private ArrayList getFixesBugInfo(XMLElement fixesbugs, ArrayList comps) {
        ArrayList<Integer> retBugList = new ArrayList<Integer>();
        NodeList bugsList = fixesbugs.getElementsByTagName("fixesbug");
        for (int k = 0; k < bugsList.getLength(); ++k) {
            XMLElement bug = (XMLElement)bugsList.item(k);
            Integer id = new Integer(bug.getAttribute("id").trim());
            NodeList compList = bug.getElementsByTagName("components");
            retBugList.add(id);
        }
        return retBugList;
    }

    public ArrayList checkConflictAmongPatches(String sOracleHome, ArrayList patches) {
        OneOffEntry[] oneoffEntries = new OneOffEntry[patches.size()];
        ArrayList<OneOffEntry> applicableOneOffs = new ArrayList<OneOffEntry>();
        PatchObject[] patchObjects = new PatchObject[1];
        OneOffEntry[] singleOneOffs = new OneOffEntry[1];
        new OiipgPropertyLoader();
        String ptrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        OPatchSDK.setOraInstLoc((String)ptrLoc);
        for (int i = 0; i < patches.size(); ++i) {
            OiiiPatchMetadata met = (OiiiPatchMetadata)patches.get(i);
            oneoffEntries[i] = OPatchSDK.getOneOffEntry((String)met.getDownloadLocation());
            try {
                patchObjects[0] = new PatchObject(oneoffEntries[i].getRelativePatchLocation());
            }
            catch (IllegalAccessException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean passed = false;
            PrereqResult res = PrereqAPI.checkApplicable((String)sOracleHome, (PatchObject[])patchObjects);
            if (res.getResult().equals(PrereqResult.ExecuteStatus.PASSED)) {
                singleOneOffs[0] = oneoffEntries[i];
                res = PrereqAPI.checkPatchApplyDependents((String)sOracleHome, (OneOffEntry[])singleOneOffs);
                if (res.getResult().equals(PrereqResult.ExecuteStatus.PASSED) && (res = PrereqAPI.checkPatchApplicableOnCurrentPlatform((String)sOracleHome, (PatchObject[])patchObjects)).getResult().equals(PrereqResult.ExecuteStatus.PASSED) && (res = PrereqAPI.checkActiveFilesAndExecutables((String)sOracleHome, (PatchObject)patchObjects[0])).getResult().equals(PrereqResult.ExecuteStatus.PASSED)) {
                    passed = true;
                    applicableOneOffs.add(oneoffEntries[i]);
                }
            }
            met.setPrereqResult(res);
        }
        OneOffEntry[] appl_oneOff = new OneOffEntry[applicableOneOffs.size()];
        for (int k = 0; k < applicableOneOffs.size(); ++k) {
            appl_oneOff[k] = (OneOffEntry)applicableOneOffs.get(k);
        }
        ConflictOutput conflictWithHome = PrereqAPI.checkConflictAgainstOH((String)sOracleHome, (OneOffEntry[])appl_oneOff);
        OneOffEntry[] conflictFreeOneOffs = conflictWithHome.getListOfPatchesThatCanGoNow();
        ArrayList conflictFreePatches = new ArrayList(conflictFreeOneOffs.length);
        for (int j = 0; j < conflictFreeOneOffs.length; ++j) {
            OneOffEntry oneOff = conflictFreeOneOffs[j];
            String bug = oneOff.getRelativePatchLocation();
            int idx = -1;
            idx = this.findInPatches(patches, bug);
            if (idx == -1) continue;
            conflictFreePatches.add(patches.get(idx));
        }
        return conflictFreePatches;
    }

    private int findInPatches(ArrayList patches, String bug) {
        for (int i = 0; i < patches.size(); ++i) {
            String dlo = ((OiiiPatchMetadata)patches.get(i)).getDownloadLocation();
            if (!dlo.equalsIgnoreCase(bug)) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
    }
}

