/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetBugListReader;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiPatchSetBugList {
    private String m_sLoc;
    private Vector m_BugList;
    private Vector patches = null;
    private Vector bug_interim = new Vector();

    public OiiiPatchSetBugList(String oLoc, Vector v) {
        this.patches = v;
        this.m_sLoc = oLoc;
    }

    public Vector getSelectedPatches() {
        return this.patches;
    }

    public String getPSXMLLocation() {
        String sLoc = OiixPathOps.getNativeForm(this.m_sLoc);
        return sLoc;
    }

    public Vector getBugList() {
        return this.m_BugList;
    }

    public Vector getBugInterim() {
        return this.bug_interim;
    }

    public void readPSXML() {
        try {
            OiiiPatchSetBugListReader ps_Reader = new OiiiPatchSetBugListReader(this.getPSXMLLocation());
            this.m_BugList = ps_Reader.parsePSXML(this.patches);
        }
        catch (IOException e) {
            String sMsg = e.getMessage();
            OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_TRACE);
        }
    }

    public String performChecks(Vector B, Vector oneOffID, int idx, OiiiInstallInventory installInv) {
        String msg = "";
        Vector<OiiiInstallOneoffInvEntry> vOneoffs = new Vector<OiiiInstallOneoffInvEntry>();
        int size = 0;
        if (oneOffID != null) {
            size = oneOffID.size();
        }
        try {
            for (int i = 0; i < size; ++i) {
                OiiiOneoffInstallID oid = (OiiiOneoffInstallID)oneOffID.elementAt(i);
                vOneoffs.addElement(installInv.getOneoffInvEntry(oid.getID(), idx));
            }
            int iSize = vOneoffs != null ? vOneoffs.size() : 0;
            for (int i = 0; i < iSize; ++i) {
                OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
                Vector S = oEntry.getBugs();
                Vector result = OiixVectorOps.intersect(B, S);
                if (OiixVectorOps.vectorsEqual(result, S)) continue;
                result = OiixVectorOps.subtract(S, B);
                int nsize = result != null ? result.size() : 0;
                for (int j = 0; j < nsize; ++j) {
                    String s = (String)result.elementAt(j);
                    String s_oneOffID = oEntry.getID().toString();
                    msg = msg + "\nbug <" + s + "> patched by interim <" + s_oneOffID + ">";
                    this.bug_interim.addElement(s + "," + s_oneOffID);
                }
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendErrorText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
        }
        if (msg.equals("")) {
            return null;
        }
        return msg;
    }
}

