/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiBugInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserCreationException;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;

public class OiiiPatchSetBugListReader
implements OixpIHandler {
    private static final String PRODUCTBUGINFO_TAG = "shbug:PRODUCTBUGINFO";
    private static final String COMMONBUGINFO_TAG = "shbug:COMMONBUGINFO";
    private static final String COMPINFO_TAG = "shbug:COMPINFO";
    private static final String BUG_TAG = "shbug:BUG";
    private static final String pstype = "PATCHSET";
    private static final String patype = "PATCHCOMPONENT";
    private static final String NAME = "NAME";
    private static final String VERSION = "VERSION";
    private static final String TYPE = "TYPE";
    private static final String ID = "ID";
    private boolean START_PARSE = false;
    private Vector m_BugListStructure;
    private Vector retList;
    private Vector patches = null;
    private String m_sLoc;

    public OiiiPatchSetBugListReader(String loc) {
        this.m_sLoc = loc;
        this.m_BugListStructure = new Vector();
    }

    public String getLoc() {
        return this.m_sLoc;
    }

    public Vector getRetList() {
        return this.retList;
    }

    public Vector parsePSXML(Vector h) throws IOException {
        this.patches = h;
        this.loadFromFile();
        return this.retList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile() throws IOException {
        FileInputStream fis;
        block7: {
            block6: {
                fis = null;
                try {
                    try {
                        OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
                        File f = new File(this.m_sLoc);
                        if (!f.exists()) {
                            Object var5_5 = null;
                            if (fis == null) return;
                            break block6;
                        }
                        fis = new FileInputStream(this.m_sLoc);
                        parser.setInputStream(fis);
                        parser.setHandler(this);
                        parser.readXML();
                        break block7;
                    }
                    catch (OixpXmlParserCreationException xpce) {
                        xpce.printStackTrace();
                        OiiolTextLogger.appendErrorText(xpce.getMessage(), OiiolTextLogger.LOG_TRACE);
                        throw new IOException(xpce.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
            }
            fis.close();
            return;
        }
        Object var5_6 = null;
        if (fis == null) return;
        fis.close();
    }

    public boolean findInContainedPatch(String key) {
        if (this.patches != null) {
            for (int i = 0; i < this.patches.size(); ++i) {
                OiiiPatchInstallID selID = (OiiiPatchInstallID)this.patches.elementAt(i);
                String val = selID.getName() + ":" + selID.getVersion().getVerString();
                if (!val.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doStartTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(PRODUCTBUGINFO_TAG)) {
            String name = el.getAttribValue(NAME);
            String version = el.getAttribValue(VERSION);
            String typ = el.getAttribValue(TYPE);
            if (this.patches != null && typ.equalsIgnoreCase(pstype)) {
                this.START_PARSE = true;
                this.m_BugListStructure.removeAllElements();
            }
        } else if (type.equalsIgnoreCase(BUG_TAG) && this.START_PARSE) {
            OixpIElement pel = el.getParent();
            String parent = pel.getType();
            if (parent.equalsIgnoreCase(COMPINFO_TAG)) {
                String name = pel.getAttribValue(NAME);
                String version = pel.getAttribValue(VERSION);
                String typ = pel.getAttribValue(TYPE);
                if (this.findInContainedPatch(name + ":" + version) && typ.equalsIgnoreCase(patype)) {
                    this.m_BugListStructure.add(el.getAttribValue(ID));
                }
            } else if (parent.equalsIgnoreCase(COMMONBUGINFO_TAG)) {
                this.m_BugListStructure.add(el.getAttribValue(ID));
            }
        }
        return false;
    }

    public boolean doText(OixpIElement el, String text) {
        return false;
    }

    public boolean doEndTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(PRODUCTBUGINFO_TAG)) {
            OiiiBugInfo bInfo = new OiiiBugInfo(el.getAttribValue(NAME), el.getAttribValue(VERSION), this.m_BugListStructure);
            this.retList = (Vector)this.m_BugListStructure.clone();
            this.m_BugListStructure.removeAllElements();
        }
        return false;
    }
}

