/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDCreator;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;

public class OiiiReadmeID
implements Serializable,
OiivVerIndMergeCapable {
    String m_internalName;
    OiiiCompInstallID m_cID;
    private static final String NAME = "name";
    private static final String CID = "cid";
    private static final String CIDMOREINFO = "cidMoreInfo";
    static final long serialVersionUID = 5408784907796402284L;
    private transient boolean m_storedInInv = false;

    public OiiiReadmeID(String internalName, OiiiCompInstallID id) {
        this.m_internalName = new String(internalName);
        this.m_cID = id;
    }

    public OiiiReadmeID(OiivVerIndObjectRep viObj) {
        this.m_storedInInv = true;
        this.m_internalName = (String)viObj.getObjectForName(NAME);
        this.m_cID = OiiiCompIDCreator.getInstallID(viObj, CID, CIDMOREINFO);
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        retRep.addNVPair(NAME, this.m_internalName);
        retRep.addNVPair(CID, this.m_cID.getIDAsCompID());
        Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_cID.getAdditionalInfo());
        retRep.addNVPair(CIDMOREINFO, additionalInfo);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(CID)) {
            return this.m_cID.equals(value);
        }
        if (key.equals(NAME)) {
            return this.m_internalName == null ? value == null : this.m_internalName.equals(value);
        }
        return false;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = vIndObj;
        retRep.addNVPair(NAME, this.m_internalName);
        retRep.setNVPair(CID, this.m_cID.getIDAsCompID());
        Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_cID.getAdditionalInfo());
        retRep.setNVPair(CIDMOREINFO, additionalInfo);
        return retRep;
    }

    public void setInternalName(String internalName) {
        this.m_internalName = new String(internalName);
    }

    public void setCompID(OiiiCompInstallID id) {
        this.m_cID = id;
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public OiiiCompInstallID getCompID() {
        return this.m_cID;
    }
}

