/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import oracle.sysman.oii.oiix.OiixEnumException;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiiReleaseLevels
implements Serializable {
    public static final int PRODUCTION = 0;
    public static final int BETA = 1;
    public static final int ALPHA = 2;
    public static final int DEVELOPMENT = 3;
    public static final int DEFAULT_RLEVEL = 0;
    private static final String S_RLEVEL_PRODUCTION_ID = "S_RLEVEL_PRODUCTION";
    private static final String S_RLEVEL_BETA_ID = "S_RLEVEL_BETA";
    private static final String S_RLEVEL_ALPHA_ID = "S_RLEVEL_ALPHA";
    private static final String S_RLEVEL_DEVELOPMENT_ID = "S_RLEVEL_DEVELOPMENT";
    public static final String S_RLEVEL_PRODUCTION = "Production";
    public static final String S_RLEVEL_BETA = "Beta";
    public static final String S_RLEVEL_ALPHA = "Alpha";
    public static final String S_RLEVEL_DEVELOPMENT = "Development";
    static final int[] s_SupportedReleaseLevels = new int[]{0, 1, 2, 3};
    public static final int RLEVEL_COUNT = s_SupportedReleaseLevels.length;

    public static int getReleaseLevelID(String sName) throws OiixEnumException {
        if (sName.length() == 0 || sName.equalsIgnoreCase(S_RLEVEL_PRODUCTION)) {
            return 0;
        }
        if (sName.equalsIgnoreCase(S_RLEVEL_BETA)) {
            return 1;
        }
        if (sName.equalsIgnoreCase(S_RLEVEL_ALPHA)) {
            return 2;
        }
        if (sName.equalsIgnoreCase(S_RLEVEL_DEVELOPMENT)) {
            return 3;
        }
        Object[] oArgs = new Object[]{sName};
        String sMsg = OiixResourceBundle.getString("S_RLEVEL_RANGE", oArgs);
        throw new OiixEnumException(sMsg);
    }

    public static String getReleaseLevelName(int ID) throws OiixEnumException {
        String key = S_RLEVEL_PRODUCTION;
        OiiiReleaseLevels.validateReleaseLevel(ID);
        switch (ID) {
            case 0: {
                key = S_RLEVEL_PRODUCTION;
                break;
            }
            case 1: {
                key = S_RLEVEL_BETA;
                break;
            }
            case 2: {
                key = S_RLEVEL_ALPHA;
                break;
            }
            case 3: {
                key = S_RLEVEL_DEVELOPMENT;
                break;
            }
        }
        return key;
    }

    public static String getReleaseLevelString(int ID) {
        String key = "";
        try {
            OiiiReleaseLevels.validateReleaseLevel(ID);
            switch (ID) {
                case 0: {
                    key = S_RLEVEL_PRODUCTION_ID;
                    break;
                }
                case 1: {
                    key = S_RLEVEL_BETA_ID;
                    break;
                }
                case 2: {
                    key = S_RLEVEL_ALPHA_ID;
                    break;
                }
                case 3: {
                    key = S_RLEVEL_DEVELOPMENT_ID;
                    break;
                }
            }
            return OiixResourceBundle.getString(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return key;
        }
    }

    public static void validateReleaseLevel(int nID) throws OiixEnumException {
        for (int i = 0; i < s_SupportedReleaseLevels.length; ++i) {
            if (nID != s_SupportedReleaseLevels[i]) continue;
            return;
        }
        Object[] oArgs = new Object[]{new Integer(nID)};
        String sMsg = OiixResourceBundle.getString("S_RLEVEL_RANGE", oArgs);
        throw new OiixEnumException(sMsg);
    }

    public static int DefaultReleaseLevel() {
        return 0;
    }

    public static boolean DisplayReleaseLevel(int nID) {
        return nID != 0;
    }

    public static int[] getReleaseLevels() {
        return s_SupportedReleaseLevels;
    }
}

