/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiReadmeID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisReadmeDetails;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiReleaseNotesXMLHandler
extends OixsDefaultHandler {
    OixsElementHandler m_handlerReadMes;
    OixsElementHandler m_handlerComp;
    OixsElementHandler m_handlerPatch;
    OiiiStageInventory m_stgInv;
    OiiiStageCompInvEntry m_curEntry;

    OiiiReleaseNotesXMLHandler(OiiiStageInventory inv) throws SAXException {
        this.m_stgInv = inv;
    }

    public OixsElementHandler createElementHandlers() {
        this.m_handlerReadMes = new OixsElementHandler("REL_NOTES");
        this.m_handlerComp = new OiiiCompHandler("COMP");
        this.m_handlerPatch = new OiiiPatchHandler("PATCH");
        this.m_handlerReadMes.addChildHandler("COMP", this.m_handlerComp);
        this.m_handlerReadMes.addChildHandler("PATCH", this.m_handlerPatch);
        return this.m_handlerReadMes;
    }

    private class OiiiSuppressReadMeHandler
    extends OixsElementHandler {
        OiiiSuppressReadMeHandler() {
            super("SUP_README");
        }

        public void onStart(String name, AttributeList atts) {
            if (OiiiReleaseNotesXMLHandler.this.m_curEntry != null) {
                String sIntName = atts.getValue("INT_NAME");
                String sCompName = atts.getValue("CMP_NAME");
                String sVer = atts.getValue("VER");
                String sPlats = atts.getValue("PLAT");
                if (sIntName != null && sCompName != null && sVer != null) {
                    OiiiVersion oVer = new OiiiVersion(sVer);
                    Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                    OiiiCompInstallID cid = new OiiiCompInstallID(sCompName, oVer, vPlats);
                    OiiiReadmeID rid = new OiiiReadmeID(sIntName, cid);
                    OiisCompProperties props = OiiiReleaseNotesXMLHandler.this.m_curEntry.getCompProperties();
                    if (props != null) {
                        props.addReadmeToSuppress(rid);
                    }
                }
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiReadMeHandler
    extends OixsElementHandler {
        OiiiReadMeHandler() {
            super("README");
        }

        public void onStart(String name, AttributeList atts) {
            if (OiiiReleaseNotesXMLHandler.this.m_curEntry != null) {
                String sName = atts.getValue("NAME");
                String sNameID = atts.getValue("NAME_ID");
                String sDescID = atts.getValue("DESC_ID");
                String sLoc = atts.getValue("LOC");
                String sPlat = atts.getValue("PLAT");
                String sType = atts.getValue("TYPE");
                String sDisplayTool = atts.getValue("DSP_TL");
                Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlat, " ", null);
                int iType = 0;
                try {
                    iType = Integer.valueOf(sType);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                OiiiReadmeID rid = new OiiiReadmeID(sName, OiiiReleaseNotesXMLHandler.this.m_curEntry.getCompInstallID());
                OiisReadmeDetails readmeDetails = new OiisReadmeDetails(rid, sNameID, sDescID, sLoc, iType, sDisplayTool);
                OiisCompProperties props = OiiiReleaseNotesXMLHandler.this.m_curEntry.getCompProperties();
                if (props != null) {
                    props.addReadmeDetails(readmeDetails);
                }
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiPatchHandler
    extends OiiiCompHandler {
        OiiiPatchHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlats = atts.getValue("PLAT");
            String sBaseVer = atts.getValue("BASE_VER");
            String sBasePlats = atts.getValue("BASE_PLAT");
            if (sName != null && sBaseVer != null) {
                OiiiVersion oBaseVer = new OiiiVersion(sBaseVer);
                Vector vBasePlats = OiilXMLHelper.platCommonNames2IntVector(sBasePlats, " ", null);
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, oBaseVer, vBasePlats);
                if (sVer != null) {
                    OiiiVersion oVer = new OiiiVersion(sVer);
                    Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                    OiiiPatchInstallID pid = new OiiiPatchInstallID(cid, oVer, vPlats);
                    OiiiReleaseNotesXMLHandler.this.m_curEntry = System.getProperty("osp.properties.file") != null ? OiiiReleaseNotesXMLHandler.this.m_stgInv.getStageCompInvEntry((OiiiCompInstallID)pid, vPlats) : OiiiReleaseNotesXMLHandler.this.m_stgInv.getStageCompInvEntry(pid);
                }
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiCompHandler
    extends OixsElementHandler {
        private OixsElementHandler m_handlerReadMe;
        private OixsElementHandler m_handlerSuppressReadMe;

        OiiiCompHandler(String name) {
            super(name);
            this.m_handlerReadMe = new OiiiReadMeHandler();
            this.m_handlerSuppressReadMe = new OiiiSuppressReadMeHandler();
            this.addChildHandler("README", this.m_handlerReadMe);
            this.addChildHandler("SUP_README", this.m_handlerSuppressReadMe);
        }

        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlats = atts.getValue("PLAT");
            if (sName != null && sVer != null) {
                OiiiVersion oVer = new OiiiVersion(sVer);
                Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
                OiiiReleaseNotesXMLHandler.this.m_curEntry = System.getProperty("osp.properties.file") != null ? OiiiReleaseNotesXMLHandler.this.m_stgInv.getStageCompInvEntry(cid, vPlats) : OiiiReleaseNotesXMLHandler.this.m_stgInv.getStageCompInvEntry(cid);
            }
        }

        public void onEnd(String name) {
        }
    }
}

