/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiReadmeID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisReadmeDetails;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

class OiiiReleaseNotesXMLWriter {
    private static OiiiReleaseNotesXMLWriter m_writer;

    private OiiiReleaseNotesXMLWriter() {
    }

    static OiiiReleaseNotesXMLWriter getWriter() {
        if (m_writer == null) {
            m_writer = new OiiiReleaseNotesXMLWriter();
        }
        return m_writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(Vector vStgCompInv, String sLocation) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        FileWriter fWriter = new FileWriter(OiixPathOps.concatPath(sLocation, "releaseNotes.xml"));
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        try {
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            XMLElement xmlRelNotes = new XMLElement("REL_NOTES");
            pWriter.println(OixsXMLOps.getStartTag(xmlRelNotes));
            for (int i = 0; i < vStgCompInv.size(); ++i) {
                XMLElement xmlrel = this.getReleaseNotesXML((OiiiStageCompInvEntry)vStgCompInv.elementAt(i));
                xmlrel.print(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(xmlRelNotes));
            Object var12_10 = null;
            pWriter.close();
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            pWriter.close();
            bWriter.close();
            fWriter.close();
            throw throwable;
        }
        bWriter.close();
        fWriter.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Comps for Stage Inventory ", System.currentTimeMillis() - lTime);
        }
    }

    private XMLElement getReleaseNotesXML(OiiiStageCompInvEntry entry) {
        XMLElement xmlComp = this.getCompXMLElement(entry);
        OiisCompProperties props = entry.getCompProperties();
        Vector vReadMeDetails = props.getReadmeDetails();
        for (int i = 0; i < vReadMeDetails.size(); ++i) {
            OiisReadmeDetails readme = (OiisReadmeDetails)vReadMeDetails.elementAt(i);
            XMLElement xmlReadMe = new XMLElement("README");
            xmlReadMe.setAttribute("NAME", readme.getReadmeID().getInternalName());
            xmlReadMe.setAttribute("NAME_ID", readme.getExternalNameID());
            xmlReadMe.setAttribute("DESC_ID", readme.getDescriptionID());
            xmlReadMe.setAttribute("LOC", readme.getLocation());
            xmlReadMe.setAttribute("PLAT", OiilXMLHelper.platArrToString(readme.getPlatforms()));
            xmlReadMe.setAttribute("TYPE", String.valueOf(readme.getType()));
            if (readme.getPreferredDisplayTool() != null) {
                xmlReadMe.setAttribute("DSP_TL", readme.getPreferredDisplayTool());
            }
            xmlComp.appendChild((Node)xmlReadMe);
        }
        Vector vSuppressReadMes = props.getReadmesToSuppress();
        for (int i = 0; i < vSuppressReadMes.size(); ++i) {
            OiiiReadmeID readmeId = (OiiiReadmeID)vSuppressReadMes.elementAt(i);
            XMLElement xmlSuppressReadme = new XMLElement("SUP_README");
            xmlSuppressReadme.setAttribute("INT_NAME", readmeId.getInternalName());
            xmlSuppressReadme.setAttribute("CMP_NAME", readmeId.getCompID().getName());
            xmlSuppressReadme.setAttribute("VER", readmeId.getCompID().getVersion().getVerString());
            xmlSuppressReadme.setAttribute("PLAT", OiilXMLHelper.platVect2String(readmeId.getCompID().getPlatforms(), " "));
            xmlComp.appendChild((Node)xmlSuppressReadme);
        }
        return xmlComp;
    }

    private XMLElement getCompXMLElement(OiiiStageCompInvEntry entry) {
        XMLElement xmlComp;
        OiiiCompInstallID cid = entry.getCompInstallID();
        if (entry instanceof OiiiStagePatchInvEntry) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            xmlComp = new XMLElement("PATCH");
            xmlComp.setAttribute("BASE_VER", pid.getBaseVersion().getVerString());
            xmlComp.setAttribute("BASE_PLAT", OiilXMLHelper.platVect2String(pid.getCompPlatforms(), " "));
        } else {
            xmlComp = new XMLElement("COMP");
        }
        xmlComp.setAttribute("NAME", cid.getName());
        xmlComp.setAttribute("VER", cid.getVersion().getVerString());
        xmlComp.setAttribute("PLAT", OiilXMLHelper.platVect2String(entry.getPlatforms(), " "));
        return xmlComp;
    }
}

