/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;

public class OiiiRemoteHome
extends OiiiOracleHomeInfo {
    private boolean m_bHomePropsRead = false;
    private boolean m_bCompsRead = false;
    private OiiiInvHomeInfo m_InvHomeInfo = null;
    private Vector m_vInvEntries = null;
    private Vector m_vComps = null;
    private Vector m_vTLComps = null;
    private Vector m_vPatches = null;
    private Vector m_vPatchSets = null;
    private Vector m_vOneOffs = null;

    public OiiiRemoteHome(String location) {
        super(-1, location, 0);
    }

    public boolean isHomePropsRead() {
        return this.m_bHomePropsRead;
    }

    public void setHomePropsRead(boolean isRead) {
        this.m_bHomePropsRead = isRead;
    }

    public boolean isCompsRead() {
        return this.m_bCompsRead;
    }

    public void setCompsRead(boolean isRead) {
        this.m_bCompsRead = isRead;
    }

    public void setInvInfo(OiiiInvHomeInfo invInfo) {
        this.m_InvHomeInfo = invInfo;
        this.setAllInvEntries();
    }

    private void setAllInvEntries() {
        if (this.m_InvHomeInfo != null) {
            this.m_vInvEntries = this.m_InvHomeInfo.getCompsVect();
            int size = this.m_vInvEntries != null ? this.m_vInvEntries.size() : 0;
            block5: for (int i = 0; i < size; ++i) {
                OiiiCompInstallID cid;
                OiiiCompInvEntry invEntry = (OiiiCompInvEntry)this.m_vInvEntries.elementAt(i);
                if (invEntry == null) continue;
                if (invEntry.isTopLevel()) {
                    if (this.m_vTLComps == null) {
                        this.m_vTLComps = new Vector();
                    }
                    this.m_vTLComps.add(invEntry);
                }
                if ((cid = invEntry.getCompInstallID()) == null) continue;
                switch (cid.getCompType()) {
                    case 1: {
                        if (this.m_vComps == null) {
                            this.m_vComps = new Vector();
                        }
                        this.m_vComps.add(invEntry);
                        continue block5;
                    }
                    case 2: {
                        if (this.m_vPatches == null) {
                            this.m_vPatches = new Vector();
                        }
                        this.m_vPatches.add(invEntry);
                        continue block5;
                    }
                    case 4: {
                        if (this.m_vPatchSets == null) {
                            this.m_vPatchSets = new Vector();
                        }
                        this.m_vPatchSets.add(invEntry);
                    }
                }
            }
            if (this.m_InvHomeInfo != null) {
                this.m_vOneOffs = this.m_InvHomeInfo.getOneoffsVect();
            }
        }
    }

    public List getAllInvEntries() {
        return this.m_vInvEntries;
    }

    public List getAllComps() {
        return this.m_vComps;
    }

    public List getAllOneOffs() {
        return this.m_vOneOffs;
    }

    public List getTopLevelComps() {
        return this.m_vTLComps;
    }

    public List getAllPatches() {
        return this.m_vPatches;
    }

    public List getAllPatchSets() {
        return this.m_vPatchSets;
    }
}

