/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiInventoryXMLHandler;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiRemoteInventoryXMLHandler
extends OiiiInventoryXMLHandler {
    private Vector m_oHomes = new Vector();
    private OixsTextElementHandler m_handlerMinOUIVersion;
    private OixsElementHandler m_handlerInventory;
    private OixsElementHandler m_handlerHomeList;
    private OixsElementHandler m_handlerVersionInfo;
    private OixsElementHandler m_handlerHome;
    private OixsElementHandler m_handlerNodeList;
    private OixsElementHandler m_handlerNode;

    public OiiiVersion getMinOUIVersion() {
        OiiiVersion version = new OiiiVersion(this.m_handlerMinOUIVersion.getText());
        return version;
    }

    public boolean isAttached() {
        return this.m_oHomes.size() > 0;
    }

    public Vector getAllHomes() {
        return this.m_oHomes;
    }

    protected OixsElementHandler createElementHandlers() {
        this.m_handlerInventory = new OixsElementHandler("INVENTORY");
        this.m_handlerHomeList = new OixsElementHandler("HOME_LIST");
        OixsElementHandler handlerVersionInfo = new OixsElementHandler("VERSION_INFO");
        this.m_handlerMinOUIVersion = new OixsTextElementHandler("MINIMUM_VER");
        this.m_handlerHome = new OiiiClusterHomeElementHandler("HOME");
        this.m_handlerNodeList = new OixsElementHandler("NODE_LIST");
        this.m_handlerNode = new OiiiNodeElementHandler("NODE", this.m_handlerHome);
        this.m_handlerInventory.addChildHandler("VERSION_INFO", handlerVersionInfo);
        handlerVersionInfo.addChildHandler("MINIMUM_VER", this.m_handlerMinOUIVersion);
        this.m_handlerInventory.addChildHandler("HOME_LIST", this.m_handlerHomeList);
        this.m_handlerHomeList.addChildHandler("HOME", this.m_handlerHome);
        this.m_handlerHome.addChildHandler("NODE_LIST", this.m_handlerNodeList);
        this.m_handlerNodeList.addChildHandler("NODE", this.m_handlerNode);
        return this.m_handlerInventory;
    }

    private class OiiiNodeElementHandler
    extends OixsElementHandler {
        OiiiClusterHomeElementHandler m_homeElementHandler;

        public OiiiNodeElementHandler(String name, OixsElementHandler homeElementHandler) {
            super(name);
            this.m_homeElementHandler = (OiiiClusterHomeElementHandler)homeElementHandler;
        }

        public void onStart(String name, AttributeList atts) {
            String clusterNode = atts.getValue("NAME");
            OiiiRemoteHome curHome = this.m_homeElementHandler.getCurrentHome();
            curHome.addNode(clusterNode);
        }
    }

    private class OiiiClusterHomeElementHandler
    extends OixsElementHandler {
        OiiiRemoteHome m_remoteHomeInfo;

        public OiiiClusterHomeElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            String sRemoved;
            String sPluginHome;
            String sHomeLoc = atts.getValue("LOC");
            String sHomeName = atts.getValue("NAME");
            String sCRSHome = atts.getValue("CRS");
            this.m_remoteHomeInfo = new OiiiRemoteHome(sHomeLoc);
            this.m_remoteHomeInfo.setName(sHomeName);
            if (sCRSHome != null) {
                if (sCRSHome.equalsIgnoreCase("true")) {
                    this.m_remoteHomeInfo.setCRSHome(true);
                } else {
                    this.m_remoteHomeInfo.setCRSHome(false);
                }
            }
            if ((sPluginHome = atts.getValue("PLUGIN")) != null && sPluginHome.equalsIgnoreCase("T")) {
                this.m_remoteHomeInfo.setPluginHome(true);
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("OiiiRemoteInventoryXMLHandler::onStart Location of oracle home is " + sHomeLoc, OiiolTextLogger.LOG_TRACE);
            }
            if ((sRemoved = atts.getValue("REMOVED")) == null || !sRemoved.equalsIgnoreCase("T")) {
                OiiiRemoteInventoryXMLHandler.this.m_oHomes.addElement(this.m_remoteHomeInfo);
            }
        }

        public OiiiRemoteHome getCurrentHome() {
            return this.m_remoteHomeInfo;
        }
    }
}

