/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInvModifier;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiiStageAreaControl
extends OiiiTargetAreaControl {
    private OiiiStageInvModifier m_stgModifier;

    public OiiiStageAreaControl(String stageJarLoc) throws IOException, OiitTargetLockNotAvailableException {
        this(stageJarLoc, null);
    }

    public OiiiStageAreaControl(String stageJarLoc, OiixProgressListener progressListener) throws IOException, OiitTargetLockNotAvailableException {
        super(OiixPathOps.getParentDir(OiixPathOps.getStandardForm(stageJarLoc)));
        IOException exp = null;
        OiiiProgressRun progRun = null;
        Thread progThread = null;
        this.grabWriterLock();
        if (progressListener != null) {
            progressListener.setStatus(OiixResourceBundle.getString("S_STGINV_PROG_MSG"));
            progressListener.setTotalBytes(100L);
            progRun = new OiiiProgressRun(progressListener);
            progThread = new Thread(progRun);
            progThread.start();
        }
        try {
            this.m_stgModifier = new OiiiStageInvModifier(stageJarLoc, this);
            this.setAreaInventory(this.m_stgModifier.getStageInventory());
        }
        catch (IOException e) {
            this.releaseWriterLock();
            this.releaseReaderLock();
            exp = e;
        }
        if (progressListener != null) {
            try {
                progRun.setUpdateProgress(false);
                progThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (exp != null) {
            if (exp instanceof IOException) {
                throw exp;
            }
            throw new IOException(exp.getMessage());
        }
    }

    public void updateInventory() throws IOException, OiixJarModifyException, OiifbCancelException {
        if (this.m_stgModifier != null) {
            this.m_stgModifier.saveStageInventory();
        }
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie) {
        return this.getResourceBundle(ie, null);
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie, Locale loc) {
        if (this.m_stgModifier != null) {
            return this.m_stgModifier.getResourceBundle(ie, loc);
        }
        return null;
    }

    public OiiiStageInventory getStageInventory() {
        if (this.m_stgModifier != null) {
            return this.m_stgModifier.getStageInventory();
        }
        return null;
    }

    public void dispose() {
        if (this.m_stgModifier != null) {
            this.m_stgModifier.dispose();
            this.m_stgModifier = null;
        }
        this.releaseReaderLock();
    }

    class OiiiProgressRun
    implements Runnable {
        private OiixProgressListener m_progressListener;
        private boolean m_bUpdate = true;
        private int m_nAddedBytes = 0;

        public OiiiProgressRun(OiixProgressListener l) {
            this.m_progressListener = l;
            this.m_nAddedBytes = 0;
        }

        public void run() {
            while (this.m_bUpdate) {
                if (this.m_nAddedBytes < 98) {
                    ++this.m_nAddedBytes;
                    this.m_progressListener.addBytes(1);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }

        public void setUpdateProgress(boolean bUpdate) {
            this.m_bUpdate = bUpdate;
        }

        public int getAddedBytes() {
            return this.m_nAddedBytes;
        }
    }
}

