/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiReaderFactory;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStageInventoryReader;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceVariants;

class OiiiStageInvLoader
extends OiiiTargetAreaControl {
    private OiiiStageInventory m_stgInv;
    private OiixJarClassLoader m_jcLoader;
    private OiixProgressListener m_progressListener;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private OiiiSourceAccess m_sourceAccess;

    public OiiiStageInvLoader(String jarLoc) throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        this(jarLoc, null);
    }

    public OiiiStageInvLoader(String invLoc, OiixProgressListener l) throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        super(invLoc);
        this.m_progressListener = l;
        if (new File(invLoc).exists()) {
            OiiiStageInventoryReader reader = OiiiReaderFactory.getStageInvReader(invLoc);
            this.m_stgInv = reader.readInventory(invLoc, this.m_progressListener, this);
        } else {
            this.m_stgInv = new OiiiStageInventory();
        }
        this.m_progressListener = null;
    }

    public OiiiStageInvLoader(String invLoc, OiixProgressListener l, OiiiSourceAccess srcAcc) throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        super(invLoc);
        this.m_sourceAccess = srcAcc;
        this.m_progressListener = l;
        if (new File(invLoc).exists()) {
            OiiiStageInventoryReader reader = OiiiReaderFactory.getStageInvReader(invLoc);
            this.m_stgInv = reader.readInventory(invLoc, this.m_progressListener, this);
        } else {
            this.m_stgInv = new OiiiStageInventory();
        }
        this.m_progressListener = null;
    }

    public void setSourceAccess(OiiiSourceAccess sa) {
        this.m_sourceAccess = sa;
    }

    public OiiiSourceAccess getSourceAccess() {
        return this.m_sourceAccess;
    }

    boolean isHomeStageMode() {
        return this.m_sourceAccess.isHomeStageMode();
    }

    public OiiiStageInventory getStageInventory() {
        return this.m_stgInv;
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie) {
        return this.getResourceBundle(ie, null);
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie, Locale loc) {
        ResourceBundle rb = null;
        if (ie instanceof OiiiStageCompInvEntry) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)ie;
            rb = scie.isMinInstVersionPreX("2.0") ? this.getCompIDResourceBundle(scie, loc) : this.getCompResourceBundle(scie, loc);
        }
        return rb;
    }

    public ResourceBundle getCompResourceBundle(OiiiStageCompInvEntry scie, Locale loc) {
        ResourceBundle rb = null;
        OiiiCompInstallID cid = scie.getCompInstallID();
        OiisCompProperties oCompProps = scie.getCompProperties();
        OiisCompJarInfo oCompJarInfo = oCompProps.getCompJarInfo();
        String resourceClassName = oCompJarInfo.getResourcesClass();
        String resourceBundleClassName = oCompJarInfo.getResourceBundleClass();
        try {
            if (this.m_sourceAccess != null) {
                OiixJarClassLoader oJarClassLoader = this.m_sourceAccess.getCompJarLoader(scie).getJarClassLoader();
                rb = OiixJarResourceBundle.extractLanguageBundle(oJarClassLoader, resourceBundleClassName, loc, resourceClassName);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (OiifbCancelException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return rb;
    }

    public ResourceBundle getCompIDResourceBundle(OiiiCompInvEntry ie, Locale loc) {
        PropertyResourceBundle rb = null;
        if (ie instanceof OiiiStageCompInvEntry) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)ie;
            String jarLoc = scie.getJarContentsLoc();
            String resourceBase = jarLoc + "resources/CompID";
            boolean foundResource = false;
            if (this.m_jcLoader == null) {
                try {
                    this.m_jcLoader = OiixJarClassLoader.createLoader(this.getAreaRoot(), false, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Enumeration vars = OiixResourceVariants.genResourceVariants(loc);
            while (vars.hasMoreElements()) {
                String resLoc = resourceBase + (String)vars.nextElement() + ".properties";
                InputStream is = this.m_jcLoader.getLocalResourceAsStream(resLoc);
                if (is != null) {
                    try {
                        foundResource = true;
                        rb = new PropertyResourceBundle(is);
                        is.close();
                    }
                    catch (Exception e) {
                        System.out.println("Unlabe to load resource for " + is);
                        e.printStackTrace();
                    }
                }
                if (!foundResource) continue;
                break;
            }
        }
        return rb;
    }

    public void dispose() {
        if (this.m_stgInv != null) {
            this.m_stgInv.dispose();
            this.m_stgInv = null;
        }
        this.disposeLoader();
    }

    public void disposeLoader() {
        this.m_stgInv = null;
        this.m_progressListener = null;
        this.m_sourceAccess = null;
        if (this.m_jcLoader != null) {
            this.m_jcLoader.closeJarFile();
        }
    }
}

